#!/usr/bin/perl -w
#
# Copyright 2001-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident   "@(#)quorum_config.pl 1.9     03/02/26 SMI"
#
# quorum_config.cgi -- Generate Sun Cluster quorum config page
#

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::RBAC;
use Cluster::Quorum;
use Sun::Solaris::Utils qw(gettext);

# Create the html query object
my $q = new Cluster::Cgi;

# Create the rbac object
my $rbac = new Cluster::RBAC;

# Create a quorum object
my $quorum = new Cluster::Quorum;

# Check if in cluster mode
if ($quorum->is_clustermode() != 0) {
        # not in cluster mode
        $quorum->print_nonclustermode_error($q);
        exit;
}

my $quorumdevice = $q->param('quorumdevice');
my $func = $q->param('func');
my $step = $q->param('step');

# Set the page title
my $title = gettext("Quorum");

# Get output of usefull cOMMAnds into tmp files
$quorum->get_commandoutput();

# Print the query header
print $q->header();

my $yoke_jscript;
if (defined($quorumdevice)) {
    $yoke_jscript = "q-$quorumdevice";
} else {
    $yoke_jscript = "q";
}

# Start the document
print $q->start_html({  STYLE  => { 'src' => '/css/clustmgr-style.css'},
			TITLE  => gettext("Configure Quorum Device"),
                        CLASS  => "default-body",
                        SCRIPT => $q->jump_menu_jscript() . $yoke_jscript
                });

# Check for quorum modify or admin authorization
if ((($func eq "Remove") &&
    !$rbac->check_auth($CL_AUTH_QUORUM_MODIFY)) ||
    (($func eq "Maintain" ||
      $func eq "Reset" ||
      $func eq "Clearinstallmode") &&
    !$rbac->check_auth($CL_AUTH_QUORUM_ADMIN))) {
	$rbac->auth_error($q, $title);
	exit;
}

SWITCH: {
	if ($func eq "Remove") {
		$quorum->config_remove($q, $step, $quorumdevice);
		last SWITCH;
	}
	if ($func eq "Maintain") {
		$quorum->config_changestate($q, $step, $func, $quorumdevice);
		last SWITCH;
	}
	if ($func eq "Reset") {
		$quorum->config_changestate($q, $step, $func, $quorumdevice);
		last SWITCH;
	}
	if ($func eq "Clearinstallmode") {
		my $cmd = "/usr/cluster/bin/scconf -c -q reset";
		$quorum->execute_cmd($q, $cmd, "Reset", "");
		last SWITCH;
	}
	print $quorum->print_error($q, $q->sprintfn(
	    gettext("Error: Don't know how to %1 %2!"),
	    $func, $quorumdevice));
}

# End the html document
$quorum->footer($q);
