#!/usr/perl5/bin/perl -w
#
# Copyright 2001-2002 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
# ident	"@(#)step5.pl	1.32	03/01/09 SMI"
#
# Installation page 5

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Install;
use Sun::Solaris::Utils qw(gettext);

# Set constants
use constant TRUE          => 0;
use constant FALSE         => 1;

# Set autoflush
$| = 1;

# Create the html query object
my $q = new Cluster::Cgi;

# Create a install object
my $install = new Cluster::Install;

# Get global values
my $cluster_name = $q->param('cluster_name');
my $run_sccheck = $q->param('run_sccheck');
my @nodelist = $install->get_nodelist($q);

# Set the javascript to launch the sccheck log viewer window
my $WIDTH = 650;
my $HEIGHT = 650;
my $XOFFSET = 25;
my $YOFFSET = 25;
my $log_link_jscript = 
	"var logWindow\n" .
	"function ShowReport(nodename) {\n" .
	"  winprops='width=$WIDTH,height=$HEIGHT,scrollbars,resizable," .
	"screenX=$XOFFSET,screenY=$YOFFSET,top=$YOFFSET,left=$XOFFSET'\n" .
	"  logWindow = window.open(\"/cgi-bin/installation/" .
	"showlog.pl?node=\" + nodename + \"&file=sccheck/sccheck-results.\"" .
	"+ nodename + \".txt\", 'LogWindow', winprops)\n" .
        "  if (parseInt(navigator.appVersion) >= 4) { \n" .
        "    logWindow.window.focus()\n" .
        "  }\n" .
	"  return false\n" .
	"}";

# Start the html document
$install->header($q, [gettext("Sun Cluster Installation"),
    "/cgi-bin/installation/step0.pl",
    gettext("Confirm Information (Step 8 of 8)")], undef, $log_link_jscript);
print $q->p({class => "action-window-normal-text"});

# Run sccheck to validate the cluster configuration
if ($run_sccheck ne "no") {

	# Note: on NS4, this line doesn't get printed out right away,
	# even though autoflush is set to true. So the user will see
	# the page loading indicator running, but nothing will yet be
	# on the screen. Adding <br> makes it show up, but then the
	# formatting of the progress dots ... gets messed up. This
	# isn't a problem on other browsers.
	print gettext("Validating the cluster configuration...");

	# Run sccheck_local.pl on all nodes
	foreach my $node (@nodelist) {
		my $sccheck = "/cgi-bin/installation/sccheck_local.pl";
		$install->syslog("Running sccheck on $node");
		my @output = $install->get_http($node,
						$install->get_http_port(),
						$sccheck);
	}

	# Wait for sccheck to finish on all nodes
	my $sccheck_complete = 0;
	while ($sccheck_complete == 0) {
		$sccheck_complete = 1;

		foreach my $node (@nodelist) {
			if ($install->get_install_state($node, 
						"DONE_SCCHECK") ne 'YES') {
				$install->syslog("sccheck has NOT finished " .
						 "on $node");
				$sccheck_complete = 0;
				last;
			} else {
				$install->syslog("sccheck has finished " .
						 "on $node");
			}
		}

		print ".";
		sleep(5);
	}

	print $q->br(), $q->br();

	# Read the return codes from sccheck on all nodes
	my %sccheck_retvals = ();
	foreach my $node (@nodelist) {
		my ($ret) = $install->readfile_node($node,
				     "/var/cluster/spm/done_sccheck");
		$sccheck_retvals{$node} = $ret;
	}

	# Check to see if there are any error for failures
	my $sccheck_errors = 0;
	my $sccheck_failures = 0;
	foreach my $node (@nodelist) {
		my $ret = $sccheck_retvals{$node};
		if ($ret >= 1 && $ret <= 4) {
			$sccheck_errors++;
		} elsif ($ret >= 100) {
			$sccheck_failures++;
		}
	}

	# Print links to the log files on each node which failed tests
	if ($sccheck_errors > 0) {
		print $q->p({CLASS => "action-window-normal-text"});
		print gettext("Configuration errors have been discovered " .
			      "on one or more nodes. Click on the " .
			      "following link(s) to view the reports:<br>\n");

		print $q->start_ul();

		foreach my $node (@nodelist) {
			my $ret = $sccheck_retvals{$node};

			# sccheck returns the highest serverity of its
			# failed tests, ranging from 1 to 4.
			if ($ret >= 1 && $ret <= 4) {
				my $url = "/cgi-bin/installation/" .
					"showlog.pl?node=$node&file=" .
					"sccheck/sccheck-results.$node.txt";
				my $title = sprintf(gettext("Click to " .
						    "access the report " .
						    "from %s"),
						    $node);
				print $q->li();
				print $q->start_a({ 
					TITLE   => $title,
					ALT     => $title,
					ONCLICK => "return ShowReport('$node')",
					HREF    => $url
					});
				print sprintf(gettext("View the report " .
						      "from %s"),
					      $node);
				print $q->end_a();
				print $q->br();
			}
		}

		print $q->end_ul();
	}

	# Print the nodes which failed to run sccheck
	if ($sccheck_failures > 0) {
		print $q->p({CLASS => "action-window-normal-text"});
		print $q->sprintfn(gettext("The %1 command was unable to " .
			      "run correctly on the following node(s). If " .
			      "certain required utilities are installed " .
			      "in non-standard places you may be able to " .
			      "provide their locations in %2."),
			      "sccheck(1M)", "/etc/default/sccheck");

		print $q->start_ul();

		foreach my $node (@nodelist) {
			my $ret = $sccheck_retvals{$node};

			# sccheck returns >=100 if it fails to run
			if ($ret >= 100) {
				print $q->li();
				print $node;
				print $q->br();
			}
		}

		print $q->end_ul();
	}
	
	# Write the URLs for retrying or continuing
	if ($sccheck_errors > 0 || $sccheck_failures > 0) {
		my $query_string = $q->get_cluster_query_string();
		my $retry_jscript = "self.location=\"step5.pl$query_string\"";
		my $continue_jscript = $retry_jscript . 
			" + \"&run_sccheck=no\"";

		print $q->p({class => "action-window-normal-text"});
		print gettext("Either fix the indicated problems and " .
			      "press the \"Retry Validation\" button or " .
			      "press the \"Next\" button to continue " .
			      "installing the cluster with the " .
			      "existing errors and/or warnings.");

		print $q->br(), $q->br();
		$install->start_button_table($q);

		print $q->start_form();
		print $q->button({ value   => gettext("  < Back  "),
				   onClick => "history.back()"
				   });
		print "&nbsp";
		print $q->button({ value => gettext("  Retry Validation  "),
				   onClick => $retry_jscript
				   });
		print "&nbsp";
		print $q->button({ value => gettext("  Next > "),
					   onClick => $continue_jscript
					   });

		$install->end_button_table($q, "Cancel");
		print $q->end_form();

		# End the html document
		$install->footer($q);

		# Exit gracefully
		exit(0);
	}
}

# Print general info
print gettext("Verify that the information that you have entered is " .
    "correct. If any changes need to be made, use the Back button to return " .
    "to previous pages. When you are finished, click Begin Installation to " .
    "install the cluster.");

# Print reminder to install patches, if user is manually adding patches.
if ( ! $q->param('patch_path') ) {
    print gettext("<br><br><b>Reminder:</b> You have chosen to manually add ".
	"all the needed patches.  Please consult the appropriate patch ".
	"documentation for more detailed instructions.  When you are finished ".
	"with patch installation, then click Begin Installation.");
}

# Get the last node of the cluster
my $clustersize = $q->param('cluster_size');
my $last_node = $q->param("node_$clustersize.name");
if ($install->get_hostdomain()) {
    $last_node .= "." . $install->get_hostdomain();
}
my $port = $install->get_http_port();

# Let the form action be the LOGIN handler. The redirect URL is constructed below.
my $action = "https://$last_node:$port/LOGIN";
print $q->start_form({ action => $action });
print $q->start_table({ BORDER => 0,
			CELLPADDING => 1,
			CELLSPACING => 0,
			CLASS => "action-table"});

# Print the cluster name
print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
print $q->start_td({ NOWRAP => undef});
print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("Cluster Name: "));

print $q->end_td();
print $q->start_td();

print $q->CGI::div({CLASS => "action-window-table-normal-text"},
    $q->param("cluster_name"));

print $q->end_td();
print $q->end_Tr();

# Print the cluster size
print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";

print $q->start_td({ NOWRAP => undef});
print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("Number of Nodes: "));

print $q->end_td();
print $q->start_td();

print $q->CGI::div({CLASS => "action-window-table-normal-text"},
    $q->param("cluster_size"));

print $q->end_td();
print $q->end_Tr();

# Print the Sun Cluster cdrom path
print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
print $q->start_td({ NOWRAP => undef});
print $q->CGI::div({CLASS => "action-window-label-text"},
    gettext("Sun Cluster Path: "));

print $q->end_td();
print $q->start_td();

print $q->CGI::div({CLASS => "action-window-table-normal-text"},
    $q->param("cdrom_path"));

print $q->end_td();
print $q->end_Tr();

# Print the Sun Cluster Data Services cdrom path, if needed.
if ($q->param("install_nfs") eq 'yes' || $q->param("install_apache") eq 'yes') {
	print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
	print $q->start_td({ NOWRAP => undef});
	print $q->CGI::div({CLASS => "action-window-label-text"},
	    gettext("Sun Cluster Agents Path: "));

	print $q->end_td();
	print $q->start_td();

	print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	    $q->param("ds_cdrom_path"));

	print $q->end_td();
	print $q->end_Tr();
}

# Print the patch path
if (defined $q->param("patch_path") && $q->param("patch_path") ne "") {
	print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
	print $q->start_td({ NOWRAP => undef});
	print $q->CGI::div({CLASS => "action-window-label-text"},
			   gettext("Patch Path: "));
	
	print $q->end_td();
	print $q->start_td();
	
	print $q->CGI::div({CLASS => "action-window-table-normal-text"},
			   $q->param("patch_path"));
	
	print $q->end_td();
	print $q->end_Tr();
}

print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
print $q->start_td({ colspan => 3 });
print '&nbsp;';
print $q->end_td();
print $q->end_Tr();

# Print the SDS Installation
print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
print $q->start_td({ NOWRAP => undef});

if ($install->is_solaris8() == TRUE) {
	print $q->CGI::div({CLASS => "action-window-label-text"},
			   gettext("Install Solstice DiskSuite: "));
} else {
	print $q->CGI::div({CLASS => "action-window-label-text"},
			   gettext("Configure mirrored disksets: "));
}

print $q->end_td();
print $q->start_td();

print $q->CGI::div({CLASS => "action-window-table-normal-text"},
    ($q->param("install_sds") eq "yes" ? gettext("Yes") : gettext("No")));

print $q->end_td();
print $q->end_Tr();

# Print only if we're installing SDS
if ($q->param("install_sds") eq "yes") {

	# Print the Solaris cdrom path for Solaris 8
	if ($install->is_solaris8() == TRUE) {
		print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
		print $q->start_td({ NOWRAP => undef});
		print $q->CGI::div({CLASS => "action-window-label-text"},
				   gettext("Solaris 8 Path: "));
    
		print $q->end_td();
		print $q->start_td();
		
		print $q->CGI::div({CLASS => "action-window-table-normal-text"},
				   $q->param("solaris_cdrom_path"));
		
		print $q->end_td();
		print $q->end_Tr();
		
		print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
		print $q->start_td({ colspan => 3 });
		print '&nbsp;';
		print $q->end_td();
		print $q->end_Tr();
	}

    # Print the Apache Installation
    print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
    print $q->start_td({ NOWRAP => undef});
    print $q->CGI::div({CLASS => "action-window-label-text"},
	gettext("Install Apache: "));
    
    print $q->end_td();
    print $q->start_td();
    
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	($q->param("install_apache") eq "yes" ? gettext("Yes") :
	gettext("No")));
    
    print $q->end_td();
    print $q->end_Tr();
    
    if ($q->param("install_apache") eq "yes") {

	# Print the Apache Address
	print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
	print $q->start_td({ NOWRAP => undef});
	print $q->CGI::div({CLASS => "action-window-label-text"},
	    gettext("Shared Address: "));
	
	print $q->end_td();
	print $q->start_td();
	
	print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	    $q->param("apache_address"));
	
	print $q->end_td();
	print $q->end_Tr();
    }

    print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
    print $q->start_td({ colspan => 3 });
    print '&nbsp;';
    print $q->end_td();
    print $q->end_Tr();

    # Print the NFS Installation
    print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
    print $q->start_td({ NOWRAP => undef});
    print $q->CGI::div({CLASS => "action-window-label-text"},
	gettext("Install NFS: "));
    
    print $q->end_td();
    print $q->start_td();
    
    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	($q->param("install_nfs") eq "yes" ? gettext("Yes") : gettext("No")));
    
    print $q->end_td();
    print $q->end_Tr();
    
    if ($q->param("install_nfs") eq "yes") {
	# Print the NFS Address
	print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
	print $q->start_td({ NOWRAP => undef});
	print $q->CGI::div({CLASS => "action-window-label-text"},
	    gettext("Logical Hostname: "));
	
	print $q->end_td();
	print $q->start_td();
	
	print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	    $q->param("nfs_address"));
	
	print $q->end_td();
	print $q->end_Tr();
    }
}

# Print out the name & transport selectors for each node
for (my $i=1; $i<=$q->param('cluster_size'); $i++) {
    print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
    print $q->start_td({ colspan => 3 });
    print '&nbsp;';
    print $q->end_td();
    print $q->end_Tr();

    print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
    print $q->start_td({ NOWRAP => undef});
    print $q->CGI::div({CLASS => "action-window-label-text"},
	sprintf(gettext("Node %s Name: "), $i));


    print $q->end_td();
    print $q->start_td();

    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	$q->param("node_$i.name"));

    print $q->end_td();
    print $q->end_Tr();

    print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
    print $q->start_td({ NOWRAP => undef});
    print $q->CGI::div({CLASS => "action-window-label-text"},
	gettext("Adapter 1"));

    print $q->end_td();
    print $q->start_td();

    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	$q->param("node_$i.transport_1"));

    print $q->end_td();
    print $q->end_Tr();

    print $q->start_Tr(), $q->td({NOWRAP => undef}, '&nbsp;'), "\n";
    print $q->start_td({ NOWRAP => undef});
    print $q->CGI::div({CLASS => "action-window-label-text"},
	gettext("Adapter 2"));

    print $q->end_td();
    print $q->start_td();

    print $q->CGI::div({CLASS => "action-window-table-normal-text"},
	$q->param("node_$i.transport_2"));

    print $q->end_td();
    print $q->end_Tr();
}

# End the table
print $q->end_table(); 

# Get hidden field values in order to login to the last node
my (@entry) = &Cluster::CookieStorage::get_cookie($ENV{"AuthCookie"});
my $cred_0 = $install->string_to_hex($entry[0]);
my $cred_1 = $install->string_to_hex($entry[1]);
my $destination = "/cgi-bin/installation/step6.pl" .
	$q->get_cluster_query_string();

print $q->hidden({ name => "cred_0",
		   default => $cred_0
		   });

print $q->hidden({ name => "cred_1",
		   default => $cred_1
		   });

print $q->hidden({ name => "destination",
		   default => $destination
		   });

# Print the back/submit buttons
$install->start_button_table($q);

print $q->button({ value   => gettext("  < Back  "),
		   onClick => "history.back()"
		   });


# Put spaces between the buttons
print '&nbsp;';

print $q->submit({ name  => 'submit_step_1',
		   value => gettext("  Begin Installation  ")
		   });
$install->end_button_table($q, "cancel");

# End the form
print $q->end_form();

# End the html document
$install->footer($q);
