#!/usr/perl5/bin/perl -w
#
# Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
# ident	"@(#)sccheck_local.pl	1.2	03/01/09 SMI"
#
# Run sccheck locally. Write the return code to the done_sccheck flag
# file.

require 5.005;
use strict;
use lib '/opt/SUNWscvw/lib/perl';
use Cluster::Cgi;
use Cluster::Install;

# Create the html query object
my $q = new Cluster::Cgi;
my $install = new Cluster::Install;

# Print the header
print $q->header();

# Fork so that we can exit to the parent immediately
if (fork()) {
    exit;
}

# Set the path to pfexec
my $PFEXEC = "/usr/bin/pfexec";

# Set the path to the flag file
my $DONE_SCCHECK = "/var/cluster/spm/done_sccheck";

# Remove the flag file before starting again
$install->remove_local_file($DONE_SCCHECK);

# Run sccheck on all nodes to validate the configuration
my $sccheck_cmd = "/usr/cluster/bin/sccheck -o /var/cluster/spm/sccheck";
$install->syslog("Running: $sccheck_cmd");	

# sccheck "Starting..." & "Finished." are sent straight to the
# console, so the redirection below won't get rid of them.
my @errors = `$PFEXEC $sccheck_cmd > /dev/null 2>&1`;
my $ret = $? / 256;
$install->syslog("sccheck returned $ret");

# Add the return code to the flag file to indicate we're done
$install->appendfile_local($DONE_SCCHECK, $ret);

# Exit completely
CORE::exit(0);
