/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Logger;
import com.sun.erase.checks.autochecks.erasCheckResults;
import com.sun.erase.checks.rengine.Notify;
import com.sun.erase.checks.rengine.ResultsWriters.IResultsWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class SeverityFilterTextResultsWriter
implements IResultsWriter {
    private int minSeverity = 0;
    private int maxSeverity = 0;
    private boolean brief = false;
    private PrintWriter out;
    private String[] explorers;
    private String resultfiles;
    private String checksfile;
    private String resulttime;
    private Logger logger = Logger.getLogger();
    private int Critical;
    private int High;
    private int Medium;
    private int Low;
    private int Passed;
    private int NotApplic;
    private int Total;
    private int Error;
    private int Filtered;
    private Vector critical = new Vector();
    private Vector high = new Vector();
    private Vector medium = new Vector();
    private Vector low = new Vector();

    public SeverityFilterTextResultsWriter(OutputStream outputStream) {
        this(outputStream, 0);
    }

    public SeverityFilterTextResultsWriter(OutputStream outputStream, int n) {
        this(outputStream, n, false);
    }

    public SeverityFilterTextResultsWriter(OutputStream outputStream, int n, boolean bl) {
        this.logger.info("SevTextRW() minSeverity: " + n);
        this.logger.info("SevTextRW() brief: " + bl);
        this.minSeverity = n;
        this.brief = bl;
        this.out = new PrintWriter(outputStream, true);
    }

    public SeverityFilterTextResultsWriter(OutputStream outputStream, boolean bl) {
        this(outputStream, 0, bl);
    }

    public void addResult(Notify notify) {
        erasCheckResults erasCheckResults2 = notify.getResult();
        Hashtable hashtable = notify.getCheck();
        StringBuffer stringBuffer = null;
        ++this.Total;
        int n = erasCheckResults2.getExitCode();
        String string = "";
        if (!erasCheckResults2.getError()) {
            if (!erasCheckResults2.getApplicable()) {
                ++this.NotApplic;
            } else {
                if (n == 99) {
                    try {
                        n = Integer.parseInt((String)hashtable.get("severity"));
                    }
                    catch (Exception exception) {}
                }
                string = erasCheckResults.exitCodeToSeverity((int)n);
                if (n < this.minSeverity) {
                    n = -1;
                }
                if (n > this.maxSeverity) {
                    this.maxSeverity = n;
                }
                switch (n) {
                    case -1: {
                        ++this.Filtered;
                        this.logger.info("SevTextRW.addResult() filtered: " + hashtable.get("id"));
                        break;
                    }
                    case 0: {
                        ++this.Passed;
                        break;
                    }
                    case 1: {
                        ++this.Low;
                        break;
                    }
                    case 2: {
                        ++this.Medium;
                        break;
                    }
                    case 3: {
                        ++this.High;
                        break;
                    }
                    case 4: {
                        ++this.Critical;
                        break;
                    }
                }
                if (!erasCheckResults2.getPassed() && n >= this.minSeverity) {
                    stringBuffer = this.brief ? this.generateContentBrief(hashtable, string) : this.generateContentFull(hashtable, string);
                }
            }
        } else {
            ++this.Error;
            this.logger.error("SevTextRW.addResult() error: " + hashtable.get("id"));
        }
        if (stringBuffer != null) {
            switch (n) {
                case 1: {
                    this.low.addElement(stringBuffer);
                    break;
                }
                case 2: {
                    this.medium.addElement(stringBuffer);
                    break;
                }
                case 3: {
                    this.high.addElement(stringBuffer);
                    break;
                }
                case 4: {
                    this.critical.addElement(stringBuffer);
                    break;
                }
            }
        }
    }

    private void analysisInformation() {
        this.out.println("========================");
        this.out.println("= ANALYSIS INFORMATION =");
        this.out.println("========================");
        this.out.println("");
        this.out.println(" DATE:");
        this.out.println("\t" + new Date());
        this.out.println("");
        this.out.println("EXPLORERS USED: ");
        int n = 0;
        while (n < this.explorers.length) {
            this.out.println("\t" + this.explorers[n]);
            ++n;
        }
        this.out.println("");
        if (this.minSeverity > 0) {
            this.out.println(" FILTERING:");
            this.out.println("\tNot showing failures below severity " + erasCheckResults.exitCodeToSeverity((int)this.minSeverity) + " (" + this.minSeverity + ")");
        }
        this.out.println("");
    }

    private void analysisSummary() {
        this.out.println("====================");
        this.out.println("= ANALYSIS SUMMARY =");
        this.out.println("====================");
        this.out.println("\n");
        this.out.println("FAILURES");
        this.out.println("========");
        this.out.println("Critical : " + String.valueOf(this.Critical));
        this.out.println("High     : " + String.valueOf(this.High));
        this.out.println("Moderate : " + String.valueOf(this.Medium));
        this.out.println("Low      : " + String.valueOf(this.Low));
        if (this.minSeverity > 0) {
            this.out.println("Filtered : " + String.valueOf(this.Filtered));
        }
        this.logger.info("SevTextRW.analysisSummary() Number of checks with ERRORs: " + String.valueOf(this.Error));
        this.out.println("");
        this.out.println("NON-FAILURES");
        this.out.println("============");
        this.out.println("Passed   : " + String.valueOf(this.Passed));
        this.out.println("N/A      : " + String.valueOf(this.NotApplic));
        this.out.println("---------");
        this.out.println("Total    : " + String.valueOf(this.Total));
        this.out.println("\n\n");
    }

    public void finishResult() {
        Enumeration enumeration = null;
        enumeration = this.critical.elements();
        while (enumeration.hasMoreElements()) {
            this.out.print((StringBuffer)enumeration.nextElement());
        }
        enumeration = this.high.elements();
        while (enumeration.hasMoreElements()) {
            this.out.print((StringBuffer)enumeration.nextElement());
        }
        enumeration = this.medium.elements();
        while (enumeration.hasMoreElements()) {
            this.out.print((StringBuffer)enumeration.nextElement());
        }
        enumeration = this.low.elements();
        while (enumeration.hasMoreElements()) {
            this.out.print((StringBuffer)enumeration.nextElement());
        }
        this.out.println("= END OF ANALYSIS DETAILS =");
        this.out.println("\n");
        this.analysisSummary();
        this.out.flush();
    }

    private StringBuffer generateContentBrief(Hashtable hashtable, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = (String)hashtable.get("problem");
        stringBuffer.append("CHECK ID : " + hashtable.get("id"));
        stringBuffer.append("\n");
        stringBuffer.append("SEVERITY : " + string);
        stringBuffer.append("\n");
        stringBuffer.append("FAILURE  : " + string2);
        stringBuffer.append("\n\n");
        return stringBuffer;
    }

    private StringBuffer generateContentFull(Hashtable hashtable, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = (String)hashtable.get("problem");
        String string3 = (String)hashtable.get("analysis");
        String string4 = (String)hashtable.get("recommendations");
        stringBuffer.append("------------------------------------");
        stringBuffer.append("\n");
        stringBuffer.append("CHECK ID : " + hashtable.get("id"));
        stringBuffer.append("\n");
        stringBuffer.append("SEVERITY : " + string);
        stringBuffer.append("\n");
        stringBuffer.append("FAILURE  : " + string2);
        stringBuffer.append("\n");
        stringBuffer.append("ANALYSIS : " + string3);
        stringBuffer.append("\n");
        stringBuffer.append("RECOMMEND: " + string4);
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        return stringBuffer;
    }

    public int getMaxSeverity() {
        this.logger.info("SevTextRW() getMaxSeverity: " + this.maxSeverity);
        return this.maxSeverity;
    }

    public void setChecksfileName(String string) {
        this.checksfile = string;
    }

    public void setResultTime(String string) {
        this.resulttime = string;
    }

    public void setResultsName(String string) {
        this.resultfiles = string;
    }

    public void startResult(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.explorers = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.explorers[n] = stringArray[n];
            ++n;
        }
        this.out.println("***************************************************");
        this.out.println("* Analysis Results *");
        this.out.println("***************************************************");
        this.out.println("\n");
        this.analysisInformation();
        this.out.println("===================================================");
        this.out.println("= ANALYSIS DETAILS =");
        this.out.println("===================================================");
        this.out.println("\n");
    }
}

