/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.Protocol;
import com.sun.cluster.sccheck.ProtocolException;
import com.sun.cluster.sccheck.Server;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;

public class ServerProtocol
extends Protocol {
    private Server parent;
    private Logger logger = Logger.getLogger();

    public ServerProtocol(Server server, Socket socket) throws ProtocolException {
        this.socket = socket;
        this.setSocketStreams(socket);
        this.parent = server;
        this.logger.trace("ServerProtocol() made sprot" + this.getID());
    }

    public int getCommonVersion(int n) throws ProtocolException {
        int n2;
        try {
            n2 = this.readInt();
            this.sendInt(n);
        }
        catch (IOException iOException) {
            this.logger.error("ServerProtocol(): getCommonVersion IOException" + iOException.getMessage());
            throw new ProtocolException(iOException.getMessage());
        }
        int n3 = n < n2 ? n : n2;
        this.logger.trace("ServerProtocol.getCommonVersion(): " + n3);
        return n3;
    }

    public void readAuthStr() throws IOException {
        String string = this.readString();
        this.logger.info("ServerProtocol.readAuthStr(): " + string);
        this.parent.setAuth(string);
    }

    public void readLocale() throws IOException {
        String string = this.readString();
        this.logger.info("ServerProtocol.readLocale() lang >" + string + "<");
        this.parent.setLocaleLang(string);
        string = this.readString();
        this.logger.info("ServerProtocol.readLocale() country >" + string + "<");
        this.parent.setLocaleCountry(string);
        string = this.readString();
        this.logger.info("ServerProtocol.readLocale() variant >" + string + "<");
        this.parent.setLocaleVariant(string);
    }

    public void sendErrBusy() throws IOException {
        this.sendBoolean(false);
    }

    public void sendErrPerm(String string) throws IOException {
        this.sendBoolean(false);
        this.sendString(string);
    }

    public void sendExecErrExit() throws IOException {
        this.sendInt(4);
    }

    public void sendExecErrRun(String string) throws IOException {
        this.sendInt(3);
        this.sendString(string);
    }

    public void sendExecExitOK() throws IOException {
        this.sendInt(2);
    }

    public void sendFile(String string) throws ProtocolException {
        this.logger.trace("ServerProtocol.sendFile() -- ENTER -- sprot" + this.getID() + "  " + string);
        try {
            long l;
            this.sendExecExitOK();
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            File file = new File(string);
            long l2 = l = file.length();
            long l3 = 0L;
            int n = 0;
            this.sendLong(l);
            this.logger.info("ServerProtocol.sendFile() fsize: " + l);
            while (l3 < l) {
                n = bufferedInputStream.read(this.buffer);
                if (n == -1) {
                    String string2 = I18n.getLocalized("UnexpectedEOF.OnFileRead");
                    this.logger.error("ServerProtocol.sendFile() unexpected EOF on file read.");
                    throw new ProtocolException(string2);
                }
                this.dOut.write(this.buffer, 0, n);
                this.dOut.flush();
                l3 += (long)n;
                l2 -= (long)n;
            }
            this.dOut.flush();
            bufferedInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.error("ServerProtocol.sendFile() FileNotFoundException: " + fileNotFoundException.getMessage());
            throw new ProtocolException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.logger.error("ServerProtocol.sendFile() in IOException: " + iOException.getMessage());
            throw new ProtocolException(iOException.getMessage());
        }
        this.logger.trace("ServerProtocol.sendFile() --EXIT-- ");
    }

    public void sendPermOK() throws IOException {
        this.logger.info("ServerProtocol.sendPermOK()");
        this.sendBoolean(true);
    }

    public void sendProgress(int n, String string) throws IOException {
        this.sendCode(1);
        this.sendCode(n);
        this.sendString(string);
        this.logger.info("ServerProtocol.sendProgress(v level: " + n + ") msg: " + string);
    }

    public void sendProgress(String string) throws IOException {
        this.sendProgress(2, string);
    }
}

