/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.ProgressListener;
import com.sun.cluster.sccheck.SeverityFilterTextResultsWriter;
import com.sun.cluster.sccheck.Utils;
import com.sun.cluster.sccheck.WrapperException;
import com.sun.eras.engine.rmi.EngineVersion;
import com.sun.erase.checks.rengine.ChecklistException;
import com.sun.erase.checks.rengine.ResultsWriterEngineClient;
import com.sun.erase.checks.rengine.ResultsWriters.XMLResultsWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class KEWrapper
implements Globals {
    private String reportNameBase;
    private Logger logger = Logger.getLogger();
    private String gunzipCmd = null;
    private String tarCmd = null;
    private String checklist;
    private String explorersUnpackDir;
    private String[] unpackedExplorers;
    private ProgressListener progresslistener;
    private Vector zippedExplorers;
    private int minSeverity = 0;
    private int maxSeverity = 0;
    private String genDate = null;
    private boolean brief = false;

    public KEWrapper(ProgressListener progressListener, String string, Vector vector, String string2, String string3, boolean bl, int n) throws WrapperException {
        this(progressListener, string, vector, string2, null, string3, bl, n);
    }

    public KEWrapper(ProgressListener progressListener, String string, Vector vector, String string2, String[] stringArray, String string3, boolean bl, int n) throws WrapperException {
        this.minSeverity = n;
        this.brief = bl;
        this.checklist = string3;
        this.gunzipCmd = System.getProperty("sccheck.gunzip");
        this.tarCmd = System.getProperty("sccheck.tar");
        this.logger.info("KEWrapper() gunzipCmd: " + this.gunzipCmd);
        this.logger.info("KEWrapper() tarCmd: " + this.tarCmd);
        this.logger.info("KEWrapper() reportNameBase: " + string);
        this.logger.info("KEWrapper() zippedExplorers: " + vector);
        this.logger.info("KEWrapper() explorersUnpackDir: " + string2);
        this.logger.info("KEWrapper() unpackedExplorers[]: " + Utils.dumpStringArray(stringArray));
        this.logger.info("KEWrapper() checklist: " + this.checklist);
        this.logger.info("KEWrapper() minSeverity: " + n);
        this.logger.info("KEWrapper() brief: " + bl);
        EngineVersion engineVersion = EngineVersion.getInstance();
        this.logger.info("KEWrapper() KE version: " + engineVersion.getFullVersion());
        this.reportNameBase = string;
        this.explorersUnpackDir = string2;
        this.progresslistener = progressListener;
        this.zippedExplorers = vector;
        this.unpackedExplorers = stringArray;
        this.minSeverity = n;
    }

    public KEWrapper(ProgressListener progressListener, String string, String[] stringArray, String string2, boolean bl, int n) throws WrapperException {
        this(progressListener, string, null, null, stringArray, string2, bl, n);
    }

    public String getGenDate() {
        return this.genDate;
    }

    public int getMaxSeverity() {
        return this.maxSeverity;
    }

    private byte[] loadChecks(String string) throws WrapperException {
        this.logger.trace("KEWrapper.loadChecks() --ENTER-- " + string);
        byte[] byArray = null;
        File file = new File(string);
        long l = 0L;
        try {
            l = file.length();
            byArray = new byte[(int)l];
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            dataInputStream = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.logger.error("KEWrapper.loadChecks() OutOfMemoryError: " + outOfMemoryError.getMessage());
            throw new WrapperException(outOfMemoryError.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.error("KEWrapper.loadChecks() FileNotFoundException: " + fileNotFoundException.getMessage());
            throw new WrapperException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.logger.error("KEWrapper.loadChecks() IOException: " + iOException.getMessage());
            throw new WrapperException(iOException.getMessage());
        }
        this.logger.trace("KEWrapper.loadChecks() --EXIT-- " + l + " bytes in checklist.");
        return byArray;
    }

    private String readGenDate(byte[] byArray) {
        this.logger.trace("KEWrapper.readGenDate() -- ENTER -- ");
        String string = new String(byArray, byArray.length - 500, 500);
        String string2 = null;
        String string3 = "<generation_date GMT='";
        try {
            int n = string.indexOf(string3);
            if (n > -1) {
                int n2 = n + string3.length();
                int n3 = string.indexOf("'>");
                if (n3 > -1 && n2 > -1 && n3 > n2) {
                    string2 = string.substring(n2, n3);
                }
            }
        }
        catch (Exception exception) {
            string2 = "Unable to read generation date" + exception.getMessage();
        }
        this.logger.trace("KEWrapper.readGenDate() -- EXIT: " + string2);
        return string2;
    }

    public void removeUnpackedExplorers() {
        Utils utils = new Utils();
        utils.rmrfDir(this.explorersUnpackDir);
        Utils.mkdir(this.explorersUnpackDir);
    }

    private void runEngine(String[] stringArray, Vector vector) throws WrapperException {
        this.logger.trace("KEWrapper.runEngine():-- ENTER --");
        String string = null;
        string = I18n.getLocalized("loadingChecks");
        this.progresslistener.postProgress(2, string);
        if (stringArray == null || stringArray.length == 0) {
            this.logger.error("KEWrapper.runEngine() null or 0 explorers -- EXIT--");
            string = I18n.getLocalized("noExplorerResultsToRead");
            throw new WrapperException(string);
        }
        try {
            byte[] byArray = this.loadChecks(this.checklist);
            this.logger.info("KEWrapper.runEngine() checklist size: " + byArray.length);
            this.genDate = this.readGenDate(byArray);
            string = I18n.getLocalized("runningChecks");
            this.progresslistener.postProgress(2, string);
            ResultsWriterEngineClient resultsWriterEngineClient = new ResultsWriterEngineClient(byArray, stringArray, (List)vector);
            int n = resultsWriterEngineClient.getStatus();
            while (n != 3 && n != 2 && n != 4) {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException interruptedException) {}
                n = resultsWriterEngineClient.getStatus();
                this.progresslistener.postProgress(2, resultsWriterEngineClient.getStatusString());
            }
            this.logger.trace("KEWrapper.runEngine(): status finished loop ***");
            if (n == 2) {
                this.logger.error("KEWrapper.runEngine(): status: ERROR");
                string = I18n.getLocalized("ResultsWriterEngineClientExitError");
                throw new WrapperException(string);
            }
            if (n == 4) {
                this.logger.error("KEWrapper.runEngine(): status: COMM_TIMEOUT");
                string = I18n.getLocalized("ResultsWriterEngineClientExitTimeout");
                throw new WrapperException(string);
            }
            if (n != 3) {
                this.logger.error("KEWrapper.runEngine(): status: other error");
                string = I18n.getLocalized("ResultsWriterEngineClientExitErrUnknown");
                throw new WrapperException(string);
            }
        }
        catch (RemoteException remoteException) {
            this.logger.error("KEWrapper.runEngine(): RemoteException on ResultsWriterEngineClient: " + remoteException.getMessage());
            throw new WrapperException(remoteException.getMessage());
        }
        catch (ChecklistException checklistException) {
            this.logger.error("KEWrapper.runEngine(): ChecklistException on ResultsWriterEngineClient: " + checklistException.getMessage());
            throw new WrapperException(checklistException.getMessage());
        }
        catch (Exception exception) {
            this.logger.error("KEWrapper.runEngine(): Exception on ResultsWriterEngineClient: " + exception.getMessage());
            throw new WrapperException(exception.getMessage());
        }
        this.logger.trace("KEWrapper.runEngine() -- EXIT -- ");
    }

    public void runKE() throws WrapperException {
        FileOutputStream fileOutputStream;
        FileOutputStream fileOutputStream2;
        this.logger.trace("KEWrapper.runKE() -- ENTER --");
        String[] stringArray = null;
        stringArray = this.zippedExplorers != null ? this.unpackExplorers(this.zippedExplorers) : this.unpackedExplorers;
        this.logger.info("KEWrapper.runKE(): " + Utils.dumpStringArray(stringArray));
        if (stringArray == null) {
            this.logger.error("KEWrapper.runKE(): no unzipped explorers");
            String string = I18n.getLocalized("noUnzippedExplorerResults");
            throw new WrapperException(string);
        }
        Vector<SeverityFilterTextResultsWriter> vector = new Vector<SeverityFilterTextResultsWriter>();
        SeverityFilterTextResultsWriter severityFilterTextResultsWriter = null;
        try {
            fileOutputStream2 = new FileOutputStream(String.valueOf(this.reportNameBase) + ".txt");
            severityFilterTextResultsWriter = new SeverityFilterTextResultsWriter(new PrintStream(fileOutputStream2), this.minSeverity, this.brief);
            vector.addElement(severityFilterTextResultsWriter);
            fileOutputStream = new FileOutputStream(String.valueOf(this.reportNameBase) + ".xml");
            vector.addElement((SeverityFilterTextResultsWriter)new XMLResultsWriter((OutputStream)fileOutputStream));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.error("KEWrapper.runKE(): FileNotFoundException: " + fileNotFoundException.getMessage());
            throw new WrapperException(fileNotFoundException.getMessage());
        }
        this.runEngine(stringArray, vector);
        this.maxSeverity = severityFilterTextResultsWriter.getMaxSeverity();
        this.logger.info("KEWrapper.runKE() sftrw.getMaxSeverity(): " + this.maxSeverity);
        try {
            fileOutputStream2.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.logger.error("KEWrapper.runKE(): IOException: " + iOException.getMessage());
            throw new WrapperException(iOException.getMessage());
        }
        this.logger.trace("KEWrapper.runKE() -- EXIT --");
    }

    private String[] unpackExplorers(Vector vector) throws WrapperException {
        this.logger.trace("KEWrapper.unpackExplorers() --ENTER--");
        String[] stringArray = new String[vector.size()];
        int n = 0;
        String string = I18n.getLocalized("unpackingChecks");
        this.progresslistener.postProgress(2, string);
        File file = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray;
            String string2 = (String)enumeration.nextElement();
            this.logger.info("KEWrapper.unpackExplorers() will unpack " + string2);
            file = new File(string2);
            if (file.length() == 0L) {
                this.logger.error("KEWrapper.unpackExplorers() file empty or non-existent: " + string2);
                objectArray = new Object[]{string2};
                string = I18n.getLocalized("explorerResultsEmptyOrNonExistent", objectArray);
                throw new WrapperException(string);
            }
            try {
                objectArray = this.unpackSingleExplorer(string2, this.explorersUnpackDir);
                stringArray[n++] = objectArray;
            }
            catch (WrapperException wrapperException) {
                this.logger.error("KEWrapper.unpackExplorers() in wex: " + wrapperException.getMessage());
                throw new WrapperException(wrapperException.getMessage());
            }
        }
        this.logger.trace("KEWrapper.unpackExplorers() --EXIT--");
        return stringArray;
    }

    private String unpackSingleExplorer(String string, String string2) throws WrapperException {
        this.logger.trace("KEWrapper.unpackSingleExplorer() -- ENTER -- " + string);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            String string6 = Integer.toHexString(new Long(System.currentTimeMillis()).intValue());
            String string7 = String.valueOf(string2) + File.separator + "sccheck_" + string6;
            Utils.mkdir(string7);
            File file = new File(string7);
            string3 = String.valueOf(this.gunzipCmd) + " -t " + string;
            this.logger.trace("KEWrapper.unpackSingleExplorer(): testing zipfile");
            Utils.runScript(string3);
            this.logger.trace("KEWrapper.unpackSingleExplorer(): unpacking");
            string3 = "cd " + string7 + "; " + this.gunzipCmd + " -dc " + string + " | " + this.tarCmd + " xif - ";
            Utils.runScript(string3);
            this.logger.trace("KEWrapper.unpackSingleExplorer(): getting result name");
            String[] stringArray = file.list();
            String string8 = null;
            int n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].startsWith(".")) {
                    string8 = stringArray[n];
                    break;
                }
                ++n;
            }
            if (string8 == null) {
                this.logger.info("KEWrapper.unpackSingleExplorer(): couldn't get resultDirName");
                string5 = I18n.getLocalized("unpackedExplorerResultsNotFound");
                throw new WrapperException(string5);
            }
            this.logger.info("KEWrapper.unpackSingleExplorer(): resultDirName: " + string8);
            string4 = String.valueOf(string2) + File.separator + string8;
            this.logger.trace("KEWrapper.unpackSingleExplorer(): pushing tmpDir to unpackDir");
            String string9 = String.valueOf(string2) + File.separator + string8;
            new Utils().rmrfDir(string9);
            string3 = "cd " + string7 + "; " + "/usr/bin/mv " + string8 + " " + string2;
            Utils.runScript(string3);
            new Utils().rmrfDir(string7);
        }
        catch (WrapperException wrapperException) {
            this.logger.error("KEWrapper.unpackSingleExplorer() in wex: " + wrapperException.getMessage());
            Object[] objectArray = new Object[]{string};
            string5 = I18n.getLocalized("unableToUnpackEplorerResults", objectArray);
            throw new WrapperException(String.valueOf(string5) + wrapperException.getMessage());
        }
        this.logger.trace("KEWrapper.unpackSingleExplorer() -- EXIT -- " + string4);
        return string4;
    }
}

