/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.wcrsmp;

import com.sun.wildcat.common.SecurityCredential;
import com.sun.wildcat.fabric_management.common.ClassFileServer;
import com.sun.wildcat.fabric_management.common.RegistryUtils;
import com.sun.wildcat.fabric_management.pmgrs.common.EnableInfo;
import com.sun.wildcat.fabric_management.pmgrs.common.InstallInfo;
import com.sun.wildcat.fabric_management.pmgrs.common.LinkData_kstat;
import com.sun.wildcat.fabric_management.pmgrs.common.RPApi;
import com.sun.wildcat.fabric_management.pmgrs.common.RouteData_kstat;
import com.sun.wildcat.fabric_management.pmgrs.common.RsmConfiguration;
import com.sun.wildcat.fabric_management.security.SecurityManagerIntf;
import com.sun.wildcat.fabric_management.security.SecurityManagerNative;
import com.sun.wildcat.fabric_management.wcrsmp.RMISSLClientSocketFactory;
import com.sun.wildcat.fabric_management.wcrsmp.RMISSLServerSocketFactory;
import com.sun.wildcat.fabric_management.wcrsmp.RPNative;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;

public class RP
extends UnicastRemoteObject
implements RPApi {
    private static final String APP_INIT_SWITCH = "-init";
    private static final String HOSTNAME_SWITCH = "-h";
    private static final String PORT_SWITCH = "-p";
    private static final String LOOKUP_SWITCH = "-l";
    private static final String SECURE = "-secure";
    private static final int START_HTTP_PORT = 6890;
    private static final int MAX_HTTP_STARTS = 1000;
    private static final String MAX_HTTP_SERVER_START_ERR = "Error Max number of HTTP server starts reached";
    private static final String CLASS_SERVER_INIT_MSG = "Class server started on port";
    private static final String KEY_STORE_PASSPHRASE = "KEY_STORE_PASSPHRASE";
    private static final String KEY_STORE_LOCATION = "KEY_STORE_LOCATION";
    private SecurityManagerIntf secMgr;
    ClassFileServer cfs;
    static RPNative native_if = null;

    public RP() throws RemoteException {
        native_if = new RPNative();
        this.secMgr = new SecurityManagerNative();
    }

    public RP(String passphrase, String keyStoreLocation) throws RemoteException {
        super(0, new RMISSLClientSocketFactory(), new RMISSLServerSocketFactory(passphrase, keyStoreLocation));
        native_if = new RPNative();
        this.secMgr = new SecurityManagerNative();
    }

    public void deleteRsmController(SecurityCredential cred, Integer controller_id) throws RemoteException {
        String local = "RP.deleteRsmController(Integer)\n";
        RP.logMessage(String.valueOf(local) + "called cid [" + controller_id + "]");
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        try {
            native_if.deleteRsmController(controller_id);
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call deleteRsmController";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
    }

    public void enableRsmController(SecurityCredential cred, Integer controller_id, EnableInfo info) throws RemoteException {
        String local = "RP.enableRsmController(Integer, EnableInfo)\n";
        RP.logMessage(String.valueOf(local) + "called cid [" + controller_id + "]");
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        try {
            native_if.enableRsmController(controller_id, info);
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call enableRsmController";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
    }

    public RsmConfiguration getConfigData(SecurityCredential cred, Integer controller_id) throws RemoteException {
        RsmConfiguration cfg_list;
        String local = "RP.getConfigData(Integer)\n";
        RP.logMessage(String.valueOf(local) + "called cid [" + controller_id + "]");
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        try {
            cfg_list = native_if.getConfigData(controller_id);
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call getConfigData";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
        return cfg_list;
    }

    public LinkData_kstat[] getLinks(SecurityCredential cred, Integer controller_id) throws RemoteException {
        String local = "RP.getLinks(Integer)\n";
        RP.logMessage(String.valueOf(local) + "called cid [" + controller_id + "]");
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        LinkData_kstat[] linkStats = null;
        try {
            linkStats = native_if.getLinks(-1, controller_id);
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call getLinks";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
        return linkStats;
    }

    public RouteData_kstat getRoute(SecurityCredential cred, String remoteHost, Integer controller_id) throws RemoteException {
        String local = "RP.getLinks(String, Integer)\n";
        RP.logMessage(String.valueOf(local) + "remote host[" + remoteHost + "]  cid[" + controller_id + "]");
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        RouteData_kstat routeKstat = null;
        try {
            routeKstat = native_if.getRoute(remoteHost, controller_id);
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call getRoute";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
        return routeKstat;
    }

    public LinkData_kstat[] getRouteLinks(SecurityCredential cred, String remoteHost, Integer controller_id) throws RemoteException {
        String local = "RP.getRouteLinks(String, Integer)\n";
        RP.logMessage(String.valueOf(local) + "remote host[" + remoteHost + "]  cid[" + controller_id + "]");
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        LinkData_kstat[] linkStats = null;
        try {
            linkStats = native_if.getRouteLinks(remoteHost, controller_id);
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call getRouteLinks";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
        return linkStats;
    }

    public int[] getRsmControllers(SecurityCredential cred) throws RemoteException {
        int[] clist;
        String local = "RP.getRsmControllers()\n";
        RP.logMessage(local);
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        try {
            clist = native_if.getRsmControllers();
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call getRsmControllers";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
        return clist;
    }

    public String getVersion(SecurityCredential cred) throws RemoteException {
        String local = "RP.getVersion()\n";
        RP.logMessage(local);
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        String version = null;
        try {
            version = native_if.version();
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call getVersion";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
        return version;
    }

    public void initialRsmController(SecurityCredential cred, Integer controller_id, RsmConfiguration config) throws RemoteException {
        String local = "RP.initialRsmController(Integer, RsmConfiguration)\n";
        RP.logMessage(String.valueOf(local) + "called cid [" + controller_id + "]");
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        try {
            native_if.initialRsmController(controller_id, config);
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call initialRsmController";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
    }

    private int initializeHTTPServer() {
        boolean keepLooking = true;
        int startPort = 6890;
        while (keepLooking) {
            try {
                this.cfs = new ClassFileServer(startPort);
                keepLooking = false;
            }
            catch (IOException iOException) {
                ++startPort;
            }
            if (startPort - 6890 < 1000) continue;
            System.err.println("Error Max number of HTTP server starts reached 1000");
            System.exit(1);
        }
        System.out.println("Class server started on port " + startPort);
        return startPort;
    }

    public void installRsmController(SecurityCredential cred, Integer controller_id, InstallInfo info) throws RemoteException {
        String local = "RP.installRsmController(Integer, InstallInfo)\n";
        RP.logMessage(String.valueOf(local) + "called cid [" + controller_id + "]");
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        try {
            native_if.installRsmController(controller_id, info);
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call installRsmController";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
    }

    public boolean isRSMConfigLocked(SecurityCredential cred) throws RemoteException {
        boolean isLocked = false;
        String local = "RP.isRSMConfigLocked()\n";
        RP.logMessage(local);
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        try {
            isLocked = native_if.RSMConfigLocked();
            RP.logMessage("RP: isRSMConfigLocked: " + isLocked);
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call RSMConfigLocked";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
        return isLocked;
    }

    private static void logMessage(String msg) {
        System.out.println(msg);
    }

    private void logTossException(String msg) throws RemoteException {
        RP.logMessage(String.valueOf(msg) + "Access Denied");
        throw new RemoteException("Access Denied");
    }

    public static void main(String[] args) {
        RP rp = null;
        String rp_host = null;
        String rp_port = null;
        Object registry_name = null;
        String securityFile = null;
        Registry localRegistry = null;
        int registry_port = 0;
        rp_host = "localhost";
        rp_port = "6789";
        String lookupName = "RP";
        boolean useSSL = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase(HOSTNAME_SWITCH)) {
                if (++i < args.length) {
                    rp_host = args[i];
                    RP.logMessage("RP: overriding default hostname with " + rp_host);
                } else {
                    RP.logMessage("RP: Specify a Hostname");
                    RP.usage();
                }
            } else if (args[i].equalsIgnoreCase(PORT_SWITCH)) {
                if (++i < args.length) {
                    rp_port = args[i];
                    RP.logMessage("RP: overriding default port with " + rp_port);
                } else {
                    RP.logMessage("RP: Specify a Port");
                    RP.usage();
                }
            } else if (args[i].equalsIgnoreCase(LOOKUP_SWITCH)) {
                if (++i < args.length) {
                    lookupName = args[i];
                    RP.logMessage("RP: overriding default lookupName with " + lookupName);
                } else {
                    RP.logMessage("RP: Specify a Lookup Name");
                    RP.usage();
                }
            } else if (args[i].equalsIgnoreCase(SECURE)) {
                if (++i < args.length) {
                    securityFile = args[i];
                    RP.logMessage("using security file " + securityFile);
                } else {
                    RP.logMessage("RP: Specify a security File ");
                    RP.usage();
                }
            } else {
                RP.logMessage("RP: Unknown Flag " + args[i]);
                RP.usage();
            }
            ++i;
        }
        try {
            System.setSecurityManager(new RMISecurityManager());
        }
        catch (SecurityException e) {
            RP.logMessage("RP: failed RMISecMgr: " + e.getMessage());
            System.exit(1);
        }
        try {
            String passphrase = null;
            String keyStoreLocation = null;
            RP.logMessage("file is : " + securityFile);
            if (securityFile != null) {
                try {
                    FileInputStream fis = new FileInputStream(securityFile);
                    Properties securityProps = new Properties();
                    securityProps.load(fis);
                    passphrase = securityProps.getProperty(KEY_STORE_PASSPHRASE);
                    keyStoreLocation = securityProps.getProperty(KEY_STORE_LOCATION);
                }
                catch (Exception exception) {
                    System.err.println("no security properties file:  using defaults");
                }
            }
            if (keyStoreLocation != null && passphrase != null) {
                RP.logMessage("using SSL \n");
                rp = new RP(passphrase, keyStoreLocation);
                int port = rp.initializeHTTPServer();
                RP.setCodeBaseProperties(port);
            } else {
                rp = new RP();
                int port = rp.initializeHTTPServer();
                RP.setCodeBaseProperties(port);
            }
            registry_port = Integer.parseInt(rp_port);
            localRegistry = RegistryUtils.getRunningRegistry(registry_port);
            if (localRegistry == null) {
                RP.logMessage("RP: Failed To Find Registry at port " + registry_port);
                RP.logMessage("RP: Creating Registry at port " + registry_port);
                localRegistry = LocateRegistry.createRegistry(registry_port);
            }
            RegistryUtils.bindObject(localRegistry, lookupName, rp);
        }
        catch (Exception e) {
            RP.logMessage("RP: Failed registry creation: " + registry_port + e.getMessage());
            System.exit(1);
        }
    }

    public void replaceRsmController(SecurityCredential cred, Integer controller_id, RsmConfiguration config) throws RemoteException {
        String local = "RP.replaceRsmController(Integer, RsmConfiguration)\n";
        RP.logMessage(String.valueOf(local) + "called cid [" + controller_id + "]");
        if (!this.secMgr.isValid(cred)) {
            this.logTossException(local);
        }
        try {
            native_if.replaceRsmController(controller_id, config);
        }
        catch (Exception exception) {
            String errorMessage = "Error in native call replaceRsmController";
            RP.logMessage("RP: " + errorMessage);
            throw new RemoteException(errorMessage);
        }
    }

    private static void setCodeBaseProperties(int port) {
        String hostname = null;
        hostname = System.getProperty("wrsm.nodename");
        if (hostname == null) {
            System.err.println("Unknown host");
            System.exit(1);
        }
        String codeBase = "http://" + hostname + ":" + port + "/";
        System.out.println("codebase = " + codeBase);
        System.setProperty("java.rmi.server.codebase", codeBase);
        System.setProperty("java.rmi.server", hostname);
    }

    private static void usage() {
        RP.logMessage("usage: java com.sun.wildcat.rp.imp.RP [-init] [-h hostname] [-p port] [-l lookup-name] -secure file");
        System.exit(0);
    }
}

