/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.security;

import com.sun.wildcat.common.SecurityCredential;
import com.sun.wildcat.fabric_management.security.SecurityManagerIntf;
import com.sun.wildcat.fabric_management.security.SecurityNative;

public class SecurityManagerNative
implements SecurityManagerIntf {
    private static final String GROUP = "sfladmin";
    private String password = null;
    static SecurityNative native_if = null;

    public SecurityManagerNative() {
        native_if = new SecurityNative();
    }

    private String[] getGroupUsers(String userName) {
        String[] users = null;
        try {
            users = native_if.retrieveGroupUsers(GROUP);
        }
        catch (Exception e) {
            System.out.println("Could not retrieve group user data for: sfladmin " + e.getMessage());
        }
        return users;
    }

    public boolean isValid(SecurityCredential cred) {
        boolean result = false;
        try {
            String userName = cred.getUsername();
            String[] userNames = this.getGroupUsers(GROUP);
            if (this.userValid(userName, userNames)) {
                result = true;
            }
            if (this.password != null && !this.password.equals(cred.getPasswd())) {
                result = false;
            }
        }
        catch (Exception e) {
            System.out.println("Could not validate credential. " + e.getMessage());
        }
        return result;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    private boolean userValid(String user, String[] groupUsers) {
        boolean result = false;
        if (groupUsers == null) {
            return result;
        }
        int i = 0;
        while (i < groupUsers.length) {
            if (user.equals(groupUsers[i])) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }
}

