/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.security;

import com.sun.wildcat.common.SecurityCredential;
import com.sun.wildcat.fabric_management.security.SecurityManagerIntf;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class SecurityManagerCL
implements SecurityManagerIntf {
    private static final String COMMAND = "groups";
    private static final String GROUP = "sfladmin";
    private String password = null;

    private String[] getGroups(String userName) {
        String cmd = "groups " + userName;
        String[] groups = null;
        String output = null;
        BufferedReader buf = null;
        try {
            try {
                Process proc = Runtime.getRuntime().exec(cmd);
                buf = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                int result = proc.waitFor();
                output = buf.readLine();
                groups = this.parseOutput(output);
            }
            catch (Exception e) {
                System.out.println("Could not retrieve group data for: " + userName + " " + e.getMessage());
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                buf.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            buf.close();
        }
        catch (Exception exception) {}
        return groups;
    }

    public boolean isValid(SecurityCredential cred) {
        boolean result = false;
        try {
            String userName = cred.getUsername();
            String[] groupNames = this.getGroups(userName);
            if (this.userValid(groupNames)) {
                result = true;
            }
            if (this.password != null && !this.password.equals(cred.getPasswd())) {
                result = false;
            }
        }
        catch (Exception e) {
            System.out.println("Could not validate credential. " + e.getMessage());
        }
        return result;
    }

    public static void main(String[] args) {
        SecurityManagerCL secMgr = new SecurityManagerCL();
        String[] groups = secMgr.getGroups(args[0]);
        int i = 0;
        while (i < groups.length) {
            System.out.print(groups[i]);
            if (i < groups.length - 1) {
                System.out.print(", ");
            }
            ++i;
        }
        System.out.println();
        System.out.println();
        SecurityCredential cred = new SecurityCredential();
        cred.setUsername("ackerley");
        System.out.println(String.valueOf(cred.getUsername()) + " is valid: " + secMgr.isValid(cred));
        cred.setUsername("crap");
        System.out.println(String.valueOf(cred.getUsername()) + " is valid: " + secMgr.isValid(cred));
        cred.setUsername("ryano");
        System.out.println(String.valueOf(cred.getUsername()) + " is valid: " + secMgr.isValid(cred));
        cred.setUsername("jjamberd");
        System.out.println(String.valueOf(cred.getUsername()) + " is valid: " + secMgr.isValid(cred));
        cred.setUsername("noonespecial");
        System.out.println(String.valueOf(cred.getUsername()) + " is valid: " + secMgr.isValid(cred));
    }

    private String[] parseOutput(String groupStr) {
        if (groupStr == null) {
            return new String[0];
        }
        StringTokenizer tokens = new StringTokenizer(groupStr);
        String[] groups = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            groups[i] = tokens.nextToken().trim();
            ++i;
        }
        return groups;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    private boolean userValid(String[] groupNames) {
        boolean result = false;
        if (groupNames == null) {
            return result;
        }
        int i = 0;
        while (i < groupNames.length) {
            if (GROUP.equals(groupNames[i])) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }
}

