/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import com.sun.wildcat.fabric_management.common.GraphNode;
import java.util.ArrayList;
import java.util.List;

public class WCIXConnectDB {
    public static final int SWITCH_NODE_TYPE = 2;
    public static final int COMPUTE_NODE_TYPE = 1;

    private int calculateNumWCIsPerNode(int stripeLevel, int numSwitchesPerPlane, int numStripePlane) {
        int result = stripeLevel / (numSwitchesPerPlane * numStripePlane);
        return result;
    }

    private GraphNode[][] createGraphNodes(int numSwitches, int numberNodes, int numWcisPerNode, int numPlanes) {
        int numGraphNodes = numberNodes * numWcisPerNode + numSwitches;
        GraphNode[][] result = new GraphNode[numGraphNodes][numPlanes];
        int node = 0;
        while (node < numGraphNodes) {
            int wci = 0;
            while (wci < numPlanes) {
                int id = node * numPlanes + wci;
                result[node][wci] = new GraphNode(id);
                result[node][wci].setApplicationData(new Integer(node));
                if (node < numSwitches) {
                    result[node][wci].setType(2);
                } else {
                    result[node][wci].setType(1);
                }
                ++wci;
            }
            ++node;
        }
        return result;
    }

    public List generateGraph(int numberNodes, int totalNumberSwitches, int stripeLevel, int numStarCats) {
        List result = null;
        if (numberNodes <= 0) {
            return result;
        }
        int numSwitchesPerPlane = 2;
        int numEdges = 0;
        if (totalNumberSwitches > 0) {
            numEdges = stripeLevel / totalNumberSwitches;
        }
        if (numEdges == 0) {
            numEdges = 1;
        }
        int numPlanes = 0;
        int numWcisPerNodePerPlane = 1;
        if (totalNumberSwitches == 1) {
            numSwitchesPerPlane = 1;
        }
        if (numEdges == 2) {
            numWcisPerNodePerPlane = 1;
            numPlanes = stripeLevel / numSwitchesPerPlane;
        } else {
            numPlanes = stripeLevel / numSwitchesPerPlane;
        }
        if (numPlanes == 0) {
            numPlanes = 1;
        }
        GraphNode[][] wcis = this.createGraphNodes(numSwitchesPerPlane, numberNodes, numWcisPerNodePerPlane, numPlanes);
        result = this.setAdjacencyLists(wcis, numberNodes, numSwitchesPerPlane, numWcisPerNodePerPlane, numPlanes, numStarCats);
        return result;
    }

    public static void main(String[] args) {
        int MAX_NUM_NODES = 2;
        WCIXConnectDB dcdb = new WCIXConnectDB();
        List result = null;
        int[] stripeLevels = new int[]{4, 2, 2, 4, 8};
        int[] numSwitches = new int[]{2, 2, 2, 4, 8};
        int index = 0;
        while (index < stripeLevels.length) {
            int numEdges = stripeLevels[index] / numSwitches[index];
            int nodes = 2;
            while (nodes <= 2) {
                result = dcdb.generateGraph(nodes, numSwitches[index], stripeLevels[index], 0);
                WCIXConnectDB.printGraph(result, numSwitches[index], nodes, stripeLevels[index]);
                ++nodes;
            }
            ++index;
        }
    }

    private static void printGraph(List graph, int numSwitches, int numNodes, int stripeLevel) {
        if (graph == null) {
            System.out.println("$$$$$$$$ NO BUILD Graph with " + numNodes + " nodes and a stripe level of " + stripeLevel);
            return;
        }
        int numWCIs = graph.size();
        GraphNode wci = null;
        System.out.println("$$$$$$$$ Graph with " + numNodes + " NumSwitches " + numSwitches + " nodes and a stripe level of " + stripeLevel);
        int i = 0;
        while (i < numWCIs) {
            wci = (GraphNode)graph.get(i);
            if (wci.getType() == 2) {
                System.out.print("a Switch Node");
            } else {
                System.out.print("a Compute Node");
            }
            System.out.println(wci);
            ++i;
        }
        System.out.println("\n\n");
    }

    private List setAdjacencyLists(GraphNode[][] graphNodes, int numberNodes, int numSwitchesPerPlane, int numWcisPerNodePerPlane, int numPlanes, int numStarcat) {
        GraphNode currentWCI = null;
        Object illegalWCI = null;
        Object adjacentWCI = null;
        int numGraphNodes = numberNodes * numWcisPerNodePerPlane + numSwitchesPerPlane;
        ArrayList<GraphNode> result = new ArrayList<GraphNode>(numGraphNodes * numPlanes);
        int node = 0;
        while (node < numGraphNodes) {
            int wci = 0;
            while (wci < numPlanes) {
                currentWCI = graphNodes[node][wci];
                result.add(currentWCI);
                GraphNode switchNode = graphNodes[node][wci];
                if (node >= numSwitchesPerPlane && wci == 0) {
                    int computeNodeIndex = node - numSwitchesPerPlane;
                    if ((computeNodeIndex /= numWcisPerNodePerPlane) < numStarcat && numPlanes > 1) {
                        GraphNode nextNode = graphNodes[node][1];
                        nextNode.setBuddy(switchNode);
                        switchNode.setBuddy(nextNode);
                    }
                }
                if (switchNode.getType() == 2) {
                    int j = node;
                    while (j < numGraphNodes) {
                        GraphNode currentNode = graphNodes[j][wci];
                        if (currentNode.getType() != 2) {
                            switchNode.addAdjacentNode(currentNode);
                            currentNode.addAdjacentNode(switchNode);
                        }
                        ++j;
                    }
                }
                ++wci;
            }
            ++node;
        }
        return result;
    }
}

