/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import com.sun.wildcat.fabric_management.common.MessageLog;
import com.sun.wildcat.fabric_management.common.ValuePairIntInt;
import com.sun.wildcat.fabric_management.pmgrs.common.LinkData;
import java.io.Serializable;

public class WCIData
implements Serializable {
    private static final String CLASS_NAME = "com.sun.wildcat.fabric_management.pmgrs.common.WCIData";
    public static final int CENTRAL = 0;
    public static final int DISTRIBUTED = 1;
    public static final int SAN = 2;
    private static final int DEFAULT_TOPOLOGY = 1;
    private static final String[] TOPOLOGIES = new String[]{"CENTRAL_SWITCH", "DISTRIBUTED_SWITCH", "SAN_SWITCH"};
    public static final int WRSM_MAX_WNODES = 16;
    public static final int WRSM_MAX_GNIDS = 16;
    public static final int WRSM_LINKS_PER_WCI = 3;
    public static final int UNMAPPED = 255;
    public static final int MAX_CNODES = 256;
    public int port;
    public int local_wnode = -1;
    public int local_gnid = -1;
    public boolean route_map_striping;
    public int topology_type;
    private int[] wnode_to_cnode;
    private int[] gnid_to_wnode;
    private boolean[] wnode_reachable;
    public LinkData[] links;
    public String wciKey;

    public WCIData() {
    }

    public WCIData(int port) {
        this.port = port;
    }

    public WCIData(int port, int local_wnode, int local_gnid, boolean route_map_striping, int topology_type, ValuePairIntInt[] wnode_to_cnode, ValuePairIntInt[] gnid_to_wnode_mapping, int[] wnode_reachable, LinkData[] links) {
        this.port = port;
        this.local_wnode = local_wnode;
        this.local_gnid = local_gnid;
        this.route_map_striping = route_map_striping;
        this.topology_type = topology_type;
        this.setLinks(links);
    }

    public WCIData(int port, int local_wnode, int local_gnid, boolean route_map_striping, int topology_type, ValuePairIntInt[] wnode_to_cnode, LinkData[] links) {
        this.port = port;
        this.local_wnode = local_wnode;
        this.local_gnid = local_gnid;
        this.route_map_striping = route_map_striping;
        this.topology_type = topology_type;
        this.setWnodeToCnodeMap(wnode_to_cnode);
        this.setLinks(links);
    }

    private void dumpArray(String message, int[] ints) {
        MessageLog.getInstance().logMessage(message, MessageLog.MEDIUM);
        MessageLog.getInstance().logMessage("Array Length = " + ints.length, MessageLog.MEDIUM);
        int i = 0;
        while (i < ints.length) {
            MessageLog.getInstance().logMessage("\t array[" + i + "] = " + ints[i], MessageLog.MEDIUM);
            ++i;
        }
    }

    private void dumpArray(String message, boolean[] bools) {
        MessageLog.getInstance().logMessage(message, MessageLog.MEDIUM);
        MessageLog.getInstance().logMessage("Array Length = " + bools.length, MessageLog.MEDIUM);
        int i = 0;
        while (i < bools.length) {
            MessageLog.getInstance().logMessage("\t array[" + i + "] = " + bools[i], MessageLog.MEDIUM);
            ++i;
        }
    }

    public int[] getGNIDToWnodeMap() {
        return this.gnid_to_wnode;
    }

    public boolean[] getReachableWnodes() {
        return this.wnode_reachable;
    }

    public int[] getWnodeToCnodeMap() {
        return this.wnode_to_cnode;
    }

    public int mapGNIDToCNode(int gnid) {
        return this.wnode_to_cnode[this.gnid_to_wnode[gnid]];
    }

    public int mapGNIDToWNode(int gnid) {
        return this.gnid_to_wnode[gnid];
    }

    public static String mapTopology(int topType) {
        String local = "com.sun.wildcat.fabric_management.pmgrs.common.WCIData.mapTopology(int)\n";
        String result = TOPOLOGIES[1];
        try {
            result = TOPOLOGIES[topType];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            MessageLog.getInstance().logMessage(String.valueOf(local) + "WCIData.mapTop: Error array index out of bounds given index = " + topType + " expected index range 0 - " + (TOPOLOGIES.length - 1), MessageLog.ERROR);
        }
        return result;
    }

    public static int mapTopology(String topType) {
        int result = 1;
        int i = 0;
        while (i < TOPOLOGIES.length) {
            if (TOPOLOGIES[i].equalsIgnoreCase(topType)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public int mapWNodeToCNode(int wnode) {
        return this.wnode_to_cnode[wnode];
    }

    public void setGNIDToWnodeMap(ValuePairIntInt[] gnidToWnodeMap) {
        String local = this.getClass().getName();
        this.gnid_to_wnode = new int[16];
        int i = 0;
        while (i < 16) {
            this.gnid_to_wnode[i] = 255;
            ++i;
        }
        int i2 = 0;
        while (i2 < gnidToWnodeMap.length) {
            int gnid = gnidToWnodeMap[i2].getIntValue1();
            int wnode = gnidToWnodeMap[i2].getIntValue2();
            if (gnid >= 0 && gnid < 16 && wnode >= 0 && wnode < 16) {
                this.gnid_to_wnode[gnid] = wnode;
            } else {
                System.err.println(String.valueOf(local) + " range error, gnid = " + gnid + " wnode = " + wnode);
            }
            ++i2;
        }
        this.dumpArray("^^^^^^^^ gnid_to_wnode ARRAY ^^^^^^^^^^^^^^^", this.gnid_to_wnode);
    }

    private void setLinks(LinkData[] links) {
        if (links.length == 3) {
            this.links = links;
        } else {
            this.links = new LinkData[3];
            int i = 0;
            while (i < 3 && i < links.length) {
                this.links[i] = links[i];
                ++i;
            }
            System.err.println("ERROR: LinkData array has a strange size, given = " + links.length + " expected = " + 3);
        }
    }

    public void setMapping(ValuePairIntInt[] wnode_to_cnode, ValuePairIntInt[] gnid_to_wnode_mapping, int[] wnode_reachable) {
        this.setWnodeToCnodeMap(wnode_to_cnode);
        this.setGNIDToWnodeMap(gnid_to_wnode_mapping);
        this.setReachableWnodes(wnode_reachable);
    }

    public void setReachableWnodes(int[] reachableWnodes) {
        String local = this.getClass().getName();
        this.wnode_reachable = new boolean[16];
        int i = 0;
        while (i < reachableWnodes.length) {
            int reachableWnode = reachableWnodes[i];
            if (reachableWnode >= 0 && reachableWnode < 16) {
                this.wnode_reachable[reachableWnode] = true;
            } else {
                System.err.println(String.valueOf(local) + " range error, wnode = " + reachableWnode);
            }
            ++i;
        }
        this.dumpArray("^^^^^^^^ wnode_reachable ARRAY ^^^^^^^^^^^^^^^", this.wnode_reachable);
    }

    public void setWnodeToCnodeMap(ValuePairIntInt[] wnodeToCnodeMap) {
        String local = this.getClass().getName();
        this.wnode_to_cnode = new int[16];
        int i = 0;
        while (i < wnodeToCnodeMap.length) {
            int wnode = wnodeToCnodeMap[i].getIntValue1();
            int cnode = wnodeToCnodeMap[i].getIntValue2();
            if (wnode >= 0 && wnode < 16 && cnode >= 0 && cnode < 256) {
                this.wnode_to_cnode[wnode] = cnode;
            } else {
                System.err.println(String.valueOf(local) + " range error, wnode = " + wnode + " cnode = " + cnode);
            }
            ++i;
        }
        this.dumpArray("^^^^^^^^ wnode_to_cnode ARRAY ^^^^^^^^^^^^^^^", this.wnode_to_cnode);
    }

    public String toString() {
        int i;
        StringBuffer buff = new StringBuffer("\n\t\t\tSafari Port       : " + this.port + "\n\t\t\tLocal WNode       : " + this.local_wnode + "\n\t\t\tRoute Map Striping: " + this.route_map_striping + "\n\t\t\tTopology Type     : " + WCIData.mapTopology(this.topology_type) + "\n\t\t\tGNID              : " + this.local_gnid);
        buff.append("\n\t\t\tReachable (wnode, cnode):");
        if (this.wnode_to_cnode != null) {
            i = 0;
            while (i < this.wnode_to_cnode.length) {
                if (this.wnode_reachable[i]) {
                    buff.append("\n\t\t\t\t(" + i + ", " + this.wnode_to_cnode[i] + ")");
                }
                ++i;
            }
        } else {
            buff.append("\n\t\t\t\t wnode_to_cnode is null");
        }
        buff.append("\n\t\t\tReachable (gnid, wnode):");
        if (this.gnid_to_wnode != null) {
            i = 0;
            while (i < this.gnid_to_wnode.length) {
                if (this.gnid_to_wnode[i] != 255) {
                    buff.append("\n\t\t\t\t(" + i + ", " + this.gnid_to_wnode[i] + ")");
                }
                ++i;
            }
        } else {
            buff.append("\n\t\t\t\t wnode_to_cnode is null");
        }
        if (this.links != null) {
            buff.append("\n\t\t\tLinks:");
            i = 0;
            while (i < this.links.length) {
                if (this.links[i].present) {
                    buff.append("\n\t\t\t\tLink[" + i + "] " + this.links[i]);
                } else {
                    buff.append("\n\t\t\t\tLink[" + i + "] not present");
                }
                ++i;
            }
        } else {
            buff.append("\n\t\t\t\t links are null");
        }
        return buff.toString();
    }

    public boolean wnodeReachable(int wnode) {
        return this.wnode_reachable[wnode];
    }
}

