/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import com.sun.wildcat.fabric_management.common.MessageLog;
import com.sun.wildcat.fabric_management.pmgrs.common.SynchObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ThreadedMethod
extends Thread {
    private Object target = null;
    private String methodName = null;
    private Object[] args = null;
    private SynchObject registerResult = null;

    public ThreadedMethod(Object target, String methodName, SynchObject registerResult) {
        this.target = target;
        this.methodName = methodName;
        Object[] temp = new Object[]{};
        this.args = temp;
        this.registerResult = registerResult;
    }

    public ThreadedMethod(Object target, String methodName, Object[] args, SynchObject registerResult) {
        this.target = target;
        this.methodName = methodName;
        this.args = args;
        this.registerResult = registerResult;
    }

    private Class[] getArgClass() {
        Class[] result = new Class[this.args.length];
        int i = 0;
        while (i < this.args.length) {
            result[i] = this.args[i].getClass();
            ++i;
        }
        return result;
    }

    public void run() {
        String local = String.valueOf(this.getClass().getName()) + ".run()\n";
        Class<?> targetClass = this.target.getClass();
        try {
            MessageLog.getInstance().logMessage(String.valueOf(local) + "target class = " + targetClass + "\nmethod name = " + this.methodName, MessageLog.HIGH);
            Class[] argClasses = this.getArgClass();
            MessageLog.getInstance().logMessage(String.valueOf(local) + "num args = " + argClasses.length, MessageLog.HIGH);
            int i = 0;
            while (i < argClasses.length) {
                MessageLog.getInstance().logMessage(String.valueOf(local) + "arg " + i + " = " + argClasses[i].getName(), MessageLog.HIGH);
                ++i;
            }
            Method method = targetClass.getMethod(this.methodName, argClasses);
            MessageLog.getInstance().logMessage(String.valueOf(local) + method, MessageLog.HIGH);
            Object result = method.invoke(this.target, this.args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof InterruptedException) {
                MessageLog.getInstance().logMessage(String.valueOf(local) + "Thread Interrupted calling Method " + this.methodName + "  " + e, MessageLog.ERROR);
            } else {
                MessageLog.getInstance().logMessage(String.valueOf(local) + "RUN ERROR: " + e.getTargetException(), MessageLog.ERROR);
                this.registerResult.registerResponse(SynchObject.FAILURE);
            }
            return;
        }
        catch (Exception e) {
            MessageLog.getInstance().logMessage(String.valueOf(local) + "RUN ERROR: " + e, MessageLog.ERROR);
            this.registerResult.registerResponse(SynchObject.FAILURE);
            return;
        }
        this.registerResult.registerResponse(SynchObject.SUCCESS);
    }
}

