/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import com.sun.wildcat.fabric_management.common.MessageLog;

public class SynchObject {
    public static int SUCCESS = 0;
    public static int FAILURE = -1;
    public static int WAIT_FOREVER = 0;
    private int responsesToWaitFor = 0;
    private int responsesReceived = 0;
    private boolean error = false;
    private boolean done = false;

    public SynchObject() {
    }

    public SynchObject(int responsesToWaitFor) {
        this.responsesToWaitFor = responsesToWaitFor;
    }

    public synchronized void registerResponse(int result) {
        String local = String.valueOf(this.getClass().getName()) + ".registerResponse(int)\n";
        if (result != SUCCESS) {
            this.error = true;
        }
        ++this.responsesReceived;
        MessageLog.getInstance().logMessage(String.valueOf(local) + " responses received = " + this.responsesReceived + " result = " + result, MessageLog.HIGH);
        if (this.error || this.responsesReceived == this.responsesToWaitFor) {
            this.done = true;
            this.notifyAll();
        }
    }

    public void setResponseCount(int count) {
        this.responsesToWaitFor = count;
    }

    public synchronized boolean waitForResponses() {
        return this.waitForResponses(WAIT_FOREVER);
    }

    public synchronized boolean waitForResponses(int millisecondsToWait) {
        String local = String.valueOf(this.getClass().getName()) + ".waitForResponses(int)\n";
        if (!this.done) {
            try {
                MessageLog.getInstance().logMessage(local, MessageLog.HIGH);
                this.wait(millisecondsToWait);
            }
            catch (InterruptedException e) {
                System.err.println("Error " + e);
            }
        }
        return this.done && !this.error;
    }
}

