/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RsmNCSliceInfo
implements Serializable {
    public static final int NUM_SLICES = 256;
    public static final int INVALID = 0;
    public static final int PASSTHROUGH = 1;
    public static final int SMALL_PAGE = 2;
    public static final int LARGE_PAGE = 3;
    private static final String[] MODE_MAP = new String[]{"INVALID", "PASSTHROUGH", "SMALL", "LARGE"};
    public int[] incoming_slices;
    public int[] incoming_slice_modes;
    public int[] outgoing_slices;
    public int[] outgoing_slice_modes;

    public RsmNCSliceInfo(int[] incoming_slices, int[] incoming_slice_modes, int[] outgoing_slices, int[] outgoing_slice_modes) {
        this.incoming_slices = incoming_slices;
        this.incoming_slice_modes = incoming_slice_modes;
        this.outgoing_slices = outgoing_slices;
        this.outgoing_slice_modes = outgoing_slice_modes;
    }

    public static int[] buildSliceIDs(int[] bitmask) {
        int bitsInt = 32;
        ArrayList<Integer> sliceIDs = new ArrayList<Integer>();
        int maskInt = 0;
        while (maskInt < bitmask.length) {
            int currentInt = bitmask[maskInt];
            int bit = 0;
            while (bit < 32) {
                int bitValue = currentInt & 1 << bit;
                if (bitValue != 0) {
                    int sliceID = maskInt * 32 + bit;
                    sliceIDs.add(new Integer(sliceID));
                }
                ++bit;
            }
            ++maskInt;
        }
        int[] result = new int[sliceIDs.size()];
        int i = 0;
        while (i < sliceIDs.size()) {
            Integer sliceID = (Integer)sliceIDs.get(i);
            result[i] = sliceID;
            ++i;
        }
        return result;
    }

    private static void main(String[] args) {
    }

    private String mapMode(int mode) {
        return MODE_MAP[mode];
    }

    public static String mapSliceMode(int size) {
        String result = MODE_MAP[0];
        try {
            result = MODE_MAP[size];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Error, mapSliceSize index out of range, defaulted to " + result);
        }
        return result;
    }

    public static int mapSliceMode(String size) {
        int result = 0;
        int i = 0;
        while (i < MODE_MAP.length) {
            if (MODE_MAP[i].equalsIgnoreCase(size)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public List toList() {
        Integer slice = null;
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (this.incoming_slices != null) {
            int i = 0;
            while (i < this.incoming_slices.length) {
                slice = new Integer(this.incoming_slices[i]);
                result.add(slice);
                ++i;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        boolean count = false;
        int i = 0;
        while (i < this.incoming_slices.length) {
            buff.append("\n\tslice " + this.incoming_slices[i] + " with " + this.mapMode(this.incoming_slice_modes[i]) + " page mode");
            ++i;
        }
        buff.append("outgoing slices \n");
        int i2 = 0;
        while (i2 < this.outgoing_slices.length) {
            buff.append("\n\tslice " + this.outgoing_slices[i2] + " with " + this.mapMode(this.outgoing_slice_modes[i2]) + " page mode");
            ++i2;
        }
        return buff.toString();
    }
}

