/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import com.sun.wildcat.fabric_management.common.EndPoint;
import com.sun.wildcat.fabric_management.common.FailedCommandException;
import com.sun.wildcat.fabric_management.common.MessageLog;
import com.sun.wildcat.fabric_management.common.Node;
import com.sun.wildcat.fabric_management.common.PartitionInterface;
import com.sun.wildcat.fabric_management.common.ReserveLink;
import com.sun.wildcat.fabric_management.common.ReserveWCI;
import com.sun.wildcat.fabric_management.common.ValuePairIntInt;
import com.sun.wildcat.fabric_management.common.WCISafariPortUtil;
import com.sun.wildcat.fabric_management.pmgrs.common.LinkData;
import com.sun.wildcat.fabric_management.pmgrs.common.NetMember;
import com.sun.wildcat.fabric_management.pmgrs.common.NidManager;
import com.sun.wildcat.fabric_management.pmgrs.common.Route;
import com.sun.wildcat.fabric_management.pmgrs.common.RoutingData;
import com.sun.wildcat.fabric_management.pmgrs.common.RoutingPolicy;
import com.sun.wildcat.fabric_management.pmgrs.common.RsmConfiguration;
import com.sun.wildcat.fabric_management.pmgrs.common.StripeGroup;
import com.sun.wildcat.fabric_management.pmgrs.common.WCIData;
import com.sun.wildcat.fabric_management.wcfm.FabricManagerInterfacePrivate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RsmController
implements Serializable {
    public int config_protocol_version = 2;
    public int controller_id = -1;
    public long fmnode_id = -1L;
    public String hostname;
    public long version_stamp = -1L;
    public int cnodeid = -1;
    public int extra_slice = -1;
    public RoutingData routing;
    private NetMember[] members;
    private static final int COMM_BASE = 2;
    private static final int PAGE_SIZE = 8192;

    public RsmController() {
    }

    public RsmController(int config_protocol_version, int controller_id, long fmnode_id, String hostname, long version_stamp) {
        this.config_protocol_version = config_protocol_version;
        this.controller_id = controller_id;
        this.fmnode_id = fmnode_id;
        this.hostname = hostname;
        this.version_stamp = version_stamp;
    }

    public RsmController(int config_protocol_version, int controller_id, long fmnode_id, String hostname, long version_stamp, int cnodeid, RoutingData routing, NetMember[] members) {
        this.config_protocol_version = config_protocol_version;
        this.controller_id = controller_id;
        this.fmnode_id = fmnode_id;
        this.hostname = hostname;
        this.version_stamp = version_stamp;
        this.cnodeid = cnodeid;
        this.routing = routing;
        this.members = members;
    }

    private int NumSCPerChassis(Node[] nodes) {
        int maxNumber = 1;
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < nodes.length) {
            String scName;
            Node nd = nodes[i];
            boolean isStarCat = Node.S72.equals(nd.getType());
            if (isStarCat && !list.contains(scName = nd.getSCName())) {
                list.add(scName);
                int numInChassis = 1;
                int j = i + 1;
                while (j < nodes.length) {
                    Node nd2 = nodes[j];
                    boolean isnd2StarCat = Node.S72.equals(nd2.getType());
                    if (isnd2StarCat) {
                        if (nd2.getSCName().compareToIgnoreCase(scName) == 0) {
                            ++numInChassis;
                        }
                        if (maxNumber < numInChassis) {
                            maxNumber = numInChassis;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return maxNumber;
    }

    NetMember[] buildNetMembers(int thisCNode, Node controllerNode, String partitionName, Node[] nodes, NidManager nidManager) {
        int comm_offset = (thisCNode + 2) * 8192;
        ArrayList<NetMember> lst = new ArrayList<NetMember>(nodes.length);
        int i = 0;
        while (i < nodes.length) {
            Node nd = nodes[i];
            if (!nd.getType().equals(Node.WCIX_SWITCH)) {
                int localCnodeID = nd.getCnodeId(this.controller_id);
                int local_offset = (localCnodeID + 2) * 8192;
                int[] slices = new int[1];
                lst.add(new NetMember(localCnodeID, nd.getFMNodeID(), nd.getSolarisHostname(), slices, slices, 0, comm_offset, local_offset));
            }
            ++i;
        }
        NetMember[] rv = lst.toArray(new NetMember[lst.size()]);
        this.printNetMembers(rv, false);
        Arrays.sort(rv, new Comparator(){

            public int compare(Object o1, Object o2) {
                NetMember n1 = (NetMember)o1;
                NetMember n2 = (NetMember)o2;
                return n1.cnodeid - n2.cnodeid;
            }

            public boolean equals(Object o1) {
                return false;
            }
        });
        this.printNetMembers(rv, true);
        return rv;
    }

    public void buildWCIMaps(String partitionName, String scName, String scDomain, Map links, NidManager nidManager, Node[] nodes) {
        WCIData[] wciArray = this.routing.getWCIData();
        int i = 0;
        while (i < wciArray.length) {
            ArrayList<ValuePairIntInt> wnodeList = new ArrayList<ValuePairIntInt>();
            ArrayList<ValuePairIntInt> gnidList = new ArrayList<ValuePairIntInt>();
            int[] reachable = new int[nidManager.getCnodeIDKeySet().size()];
            int numWnodes = 0;
            Iterator cnodeIter = nidManager.getCnodeIDKeySet().iterator();
            while (cnodeIter.hasNext()) {
                String aNodeName = (String)cnodeIter.next();
                int lastPos = aNodeName.lastIndexOf(":");
                if (lastPos < 0) continue;
                int aCnode = nidManager.getCNode(aNodeName, false);
                int aWnode = nidManager.getWNode(aNodeName, false);
                wnodeList.add(new ValuePairIntInt(aWnode, aCnode));
                reachable[numWnodes++] = aWnode;
                int plane = nidManager.getPlane(wciArray[i].wciKey);
                int[] gnids = nidManager.getGNIDS(aNodeName, plane);
                int j = 0;
                while (j < gnids.length) {
                    gnidList.add(new ValuePairIntInt(gnids[j], aWnode));
                    ++j;
                }
            }
            ValuePairIntInt[] wnode_to_cnode = wnodeList.toArray(new ValuePairIntInt[0]);
            ValuePairIntInt[] gnid_to_wnode = gnidList.toArray(new ValuePairIntInt[0]);
            wciArray[i].setMapping(wnode_to_cnode, gnid_to_wnode, reachable);
            ++i;
        }
    }

    public void createNCSlices(String partition, Node[] nodes, int controllerID, FabricManagerInterfacePrivate fmPriv, PartitionInterface pi, Map configs) throws Exception {
        NetMember[] rv = new NetMember[nodes.length];
        NCBitSet allFreeSlices = new NCBitSet();
        NCBitSet usedBs = new NCBitSet();
        HashMap nodesNeedingNCSlices = new HashMap();
        boolean initFreeSlices = true;
        NCBitSet slicesUsed = new NCBitSet();
        int i = 0;
        while (i < nodes.length) {
            Node nd = nodes[i];
            BitSet slicesUsedThisNode = fmPriv.getUsedNCSlices(partition, nd.getSCNameAndDomain());
            slicesUsed.or(slicesUsedThisNode);
            ++i;
        }
        int i2 = 0;
        while (i2 < nodes.length) {
            Node nd = nodes[i2];
            boolean nodeHasAllocatedSlices = false;
            if (!nd.getType().equals(Node.WCIX_SWITCH)) {
                BitSet slices = null;
                try {
                    slices = nd.getAvaliableNCSlices();
                }
                catch (FailedCommandException fce) {
                    String error = "RsmController:buildNCSlices falied to retrieve NC avaliable nc from <" + nd.getSCName() + ">";
                    MessageLog.getInstance().logMessage(error, MessageLog.ERROR);
                    throw fce;
                }
                if (initFreeSlices) {
                    allFreeSlices.or(slices);
                    initFreeSlices = false;
                } else {
                    allFreeSlices.intersect(slices);
                }
                RsmConfiguration cfg = (RsmConfiguration)pi.getNodeConfigObject(nd.getSCNameAndDomain());
                if (cfg != null) {
                    List UsedLst = cfg.controller.getUsedSlices(-1L, true);
                    usedBs.setFrom(UsedLst);
                }
            }
            ++i2;
        }
        BitSet tset = (BitSet)usedBs.clone();
        tset.and(allFreeSlices);
        if (!tset.equals(usedBs)) {
            String error = "Node being added to a fabric doesn't have a ncslice avaliable which a current node in the fabric is using.";
            MessageLog.getInstance().logMessage(error, MessageLog.ERROR);
            FailedCommandException fce = new FailedCommandException(error, 13, "Free Allocated NC Slice Not Available Exception");
            fce.addDataValue("partition_name", partition);
            throw fce;
        }
        int startSliceBit = 32 * controllerID;
        allFreeSlices.andNot(usedBs);
        int numSCPerChassis = this.NumSCPerChassis(nodes);
        if (numSCPerChassis > 1) {
            Node nd;
            NASMSlicer slicer = new NASMSlicer(numSCPerChassis, nodes, pi);
            int i3 = 0;
            while (i3 < nodes.length) {
                NCBitSet allFreeAcrossPartitions = (NCBitSet)allFreeSlices.clone();
                allFreeAcrossPartitions.andNot(slicesUsed);
                nd = nodes[i3];
                if (!nd.getType().equals(Node.WCIX_SWITCH)) {
                    int numSlices;
                    int j = numSlices = slicer.getNumSlices(nd);
                    while (j < numSCPerChassis) {
                        int sliceBit = allFreeAcrossPartitions.findSlice(startSliceBit);
                        if (sliceBit == -1) {
                            String error = "Failed to Allocate an NC Slice for partition: " + partition;
                            MessageLog.getInstance().logMessage(error, MessageLog.ERROR);
                            FailedCommandException fce = new FailedCommandException(error, 12, "Failed NC Slice Allocation Exception");
                            fce.addDataValue("partition_name", partition);
                            throw fce;
                        }
                        allFreeSlices.clear(sliceBit);
                        slicer.addNewSlice(nd, sliceBit);
                        ++j;
                    }
                }
                ++i3;
            }
            int i4 = 0;
            while (i4 < nodes.length) {
                nd = nodes[i4];
                if (!nd.getType().equals(Node.WCIX_SWITCH)) {
                    int j = 0;
                    while (j < nodes.length) {
                        Node nd2 = nodes[j];
                        if (!nd2.getType().equals(Node.WCIX_SWITCH)) {
                            ArrayList slices = slicer.getSlice(nd, nd2);
                            this.setImportSlice(configs, nd, nd2, slices);
                        }
                        ++j;
                    }
                }
                ++i4;
            }
        } else {
            int i5 = 0;
            while (i5 < nodes.length) {
                Node nd = nodes[i5];
                if (!nd.getType().equals(Node.WCIX_SWITCH)) {
                    List defaultSlices = null;
                    RsmConfiguration cfg = (RsmConfiguration)pi.getNodeConfigObject(nd.getSCNameAndDomain());
                    defaultSlices = cfg != null ? cfg.controller.getUsedSlices(nd.getFMNodeID(), true) : new ArrayList();
                    NCBitSet allFreeAcrossPartitions = (NCBitSet)allFreeSlices.clone();
                    allFreeAcrossPartitions.andNot(slicesUsed);
                    if (defaultSlices.size() == 0) {
                        int sliceBit = allFreeAcrossPartitions.findSlice(startSliceBit);
                        allFreeSlices.clear(sliceBit);
                        if (sliceBit == -1) {
                            String error = "Failed to Allocate an NC Slice for partition: " + partition;
                            MessageLog.getInstance().logMessage(error, MessageLog.ERROR);
                            FailedCommandException fce = new FailedCommandException(error, 12, "Failed NC Slice Allocation Exception");
                            fce.addDataValue("partition_name", partition);
                            throw fce;
                        }
                        defaultSlices.add(new Integer(sliceBit));
                    }
                    int j = 0;
                    while (j < nodes.length) {
                        Node memberNd = nodes[j];
                        if (!memberNd.getType().equals(Node.WCIX_SWITCH)) {
                            this.setImportSlice(configs, nd, memberNd, defaultSlices);
                        }
                        ++j;
                    }
                }
                ++i5;
            }
        }
        int i6 = 0;
        while (i6 < nodes.length) {
            Node nd = nodes[i6];
            if (!nd.getType().equals(Node.WCIX_SWITCH)) {
                int j = 0;
                while (j < nodes.length) {
                    Node memberNd = nodes[j];
                    if (!memberNd.getType().equals(Node.WCIX_SWITCH)) {
                        RsmController.setExportSliceFromImportSlices(configs, nd, memberNd);
                    }
                    ++j;
                }
            }
            ++i6;
        }
    }

    public boolean generateConfigInfo(String partitionName, String scName, String scDomain, Map links, NidManager nidManager, Node[] nodes) {
        Iterator iter = links.keySet().iterator();
        WCIData[] wciArray = new WCIData[links.size()];
        int wciIndex = 0;
        String nodeName = Node.concatSCNameDomain(scName, scDomain);
        boolean isDirectConnect = true;
        int i = 0;
        while (i < nodes.length) {
            Node nd = nodes[i];
            if (nd.getType().equals(Node.WCIX_SWITCH)) {
                isDirectConnect = false;
                break;
            }
            ++i;
        }
        this.cnodeid = nidManager.getCNode(nodeName, false);
        Node thisNode = this.lookupNode(nodeName, nodes);
        int[] wcisUsed = new int[4];
        int wciUsedIndex = 0;
        while (iter.hasNext()) {
            try {
                Integer safPortID = (Integer)iter.next();
                List lst = (List)links.get(safPortID);
                int safPort = safPortID;
                int size = lst.size();
                LinkData[] linkData = new LinkData[3];
                int i2 = 0;
                while (i2 < 3) {
                    linkData[i2] = new LinkData();
                    linkData[i2].present = false;
                    ++i2;
                }
                String wciKey = null;
                wcisUsed[wciUsedIndex++] = safPort;
                HashSet<Node> remoteNodes = new HashSet<Node>();
                int i3 = 0;
                while (i3 < size) {
                    ReserveLink aLink = (ReserveLink)lst.get(i3);
                    int index = aLink.getEndPointIndex(scName, scDomain);
                    EndPoint[] endPts = aLink.getEndpoints();
                    int otherIndex = 1;
                    if (index == 1) {
                        otherIndex = 0;
                    }
                    EndPoint rep = endPts[otherIndex];
                    EndPoint thisEndPt = endPts[index];
                    if (wciKey == null) {
                        wciKey = thisEndPt.getWCI().toString();
                    }
                    ReserveWCI remWCI = rep.getWCI();
                    String remoteNodeName = Node.concatSCNameDomain(remWCI.getSCName(), remWCI.getSCDomain());
                    Node remoteNd = this.lookupNode(remoteNodeName, nodes);
                    remoteNodes.add(remoteNd);
                    int remoteSafPort = WCISafariPortUtil.convertToSafariPort(remWCI.getSlot(), remWCI.getID(), remoteNd.getType());
                    String remoteWciKey = remWCI.toString();
                    int remoteGnid = nidManager.getGNID(remoteWciKey);
                    linkData[endPts[index].getPort()] = new LinkData(true, remoteGnid, remoteSafPort, rep.getPort());
                    lst.add(safPortID);
                    ++i3;
                }
                int wciSlot = WCISafariPortUtil.getSlotNumber(safPort, thisNode.getType());
                int wciID = WCISafariPortUtil.getWciNumber(safPort, thisNode.getType());
                int local_wnode = nidManager.getWNode(wciKey, true);
                int local_gnid = nidManager.getGNID(wciKey);
                int WCITopologyType = isDirectConnect ? 1 : 2;
                WCIData aWCIData = new WCIData(safPort, local_wnode, local_gnid, false, WCITopologyType, null, null, null, linkData);
                aWCIData.wciKey = wciKey;
                wciArray[wciIndex++] = aWCIData;
            }
            catch (Exception e) {
                MessageLog.getInstance().logMessage("RsmController:generateConfigInfo", MessageLog.ERROR);
                MessageLog.getInstance().logStackTrace(e);
                return false;
            }
        }
        Iterator cnodeIter = nidManager.getCnodeIDKeySet().iterator();
        RoutingPolicy[] routingPolicy = new RoutingPolicy[nidManager.getCnodeIDKeySet().size()];
        int index = 0;
        while (cnodeIter.hasNext()) {
            String aNodeName = (String)cnodeIter.next();
            int aCnode = nidManager.getCNode(aNodeName, false);
            int numberRoutes = wciUsedIndex;
            int arrayOffset = 0;
            Route[] routes = null;
            if (wciUsedIndex > 1 && aCnode != this.cnodeid) {
                arrayOffset = 1;
                routes = new Route[numberRoutes + 1];
                routes[0] = new Route(numberRoutes, 0, 0, null, 1, 0, 0);
            } else {
                routes = new Route[numberRoutes];
            }
            int k = 0;
            while (k < numberRoutes) {
                routes[arrayOffset + k] = new Route(1, 0, 0, null, 2, 0, wcisUsed[k]);
                ++k;
            }
            routingPolicy[index++] = new RoutingPolicy(aCnode, false, true, false, routes);
        }
        StripeGroup[] sg = null;
        if (wciUsedIndex > 1) {
            sg = new StripeGroup[]{new StripeGroup(0, wciUsedIndex, wcisUsed)};
        }
        this.routing = new RoutingData(false, wciArray, sg, routingPolicy);
        this.members = this.buildNetMembers(this.cnodeid, thisNode, partitionName, nodes, nidManager);
        return true;
    }

    public NetMember[] getNetMembers() {
        return this.members;
    }

    public List getRemovedWCIs(RsmController diffConfig) {
        ArrayList<WCIData> result = new ArrayList<WCIData>();
        WCIData[] wcis = this.routing.getWCIData();
        int wciCount = wcis.length;
        RoutingData newRoute = diffConfig.routing;
        int i = 0;
        while (i < wciCount) {
            WCIData wci = wcis[i];
            if (!newRoute.inWCIList(wci)) {
                result.add(wci);
            }
            ++i;
        }
        return result;
    }

    public List getUsedSlices(long goalfmNodeID, boolean importedNCSlices) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        if (this.members != null) {
            int i = 0;
            while (i < this.members.length) {
                NetMember member = this.members[i];
                if (goalfmNodeID < 0L || member.fmnodeid == goalfmNodeID) {
                    int[] slices = null;
                    slices = importedNCSlices ? member.imported_ncslices : member.exported_ncslices;
                    if (slices != null) {
                        int j = 0;
                        while (j < slices.length) {
                            if (slices[j] > 0) {
                                lst.add(new Integer(slices[j]));
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return lst;
    }

    public int getUsedSlices(Node nd, boolean importedNCSlices) {
        long goalfmNodeID = nd.getFMNodeID();
        if (this.members != null) {
            int i = 0;
            while (i < this.members.length) {
                NetMember member = this.members[i];
                if (member.fmnodeid == goalfmNodeID) {
                    int[] slices = null;
                    slices = importedNCSlices ? member.imported_ncslices : member.exported_ncslices;
                    if (slices != null && slices.length > 0) {
                        return slices[0];
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    private final int[] integerTointArray(List lst, int minArraySize) {
        int lstSz = lst.size();
        int size = lstSz > minArraySize ? lstSz : minArraySize;
        int[] rv = new int[size];
        int i = 0;
        while (i < size) {
            if (i < lstSz) {
                Integer ival = (Integer)lst.get(i);
                rv[i] = ival;
            }
            ++i;
        }
        return rv;
    }

    private Node lookupNode(String scNameDomain, Node[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            Node nd = nodes[i];
            if (nd.getSCNameAndDomain().equals(scNameDomain)) {
                return nd;
            }
            ++i;
        }
        return null;
    }

    private void printNetMembers(NetMember[] members, boolean sorted) {
        if (members == null) {
            MessageLog.getInstance().logMessage("members == null", MessageLog.MEDIUM);
            return;
        }
        if (sorted) {
            MessageLog.getInstance().logMessage("Net members sorted [", MessageLog.MEDIUM);
        } else {
            MessageLog.getInstance().logMessage("Net members unsorted [", MessageLog.MEDIUM);
        }
        int i = 0;
        while (i < members.length) {
            MessageLog.getInstance().logMessage("cnodeid: " + members[i].cnodeid, MessageLog.MEDIUM);
            ++i;
        }
        MessageLog.getInstance().logMessage("]", MessageLog.MEDIUM);
    }

    private static void setExportSliceFromImportSlices(Map cfgs, Node nd, Node memberNd) {
        String scNameAndDomain = nd.getSCNameAndDomain();
        String scNameAndDomainMember = memberNd.getSCNameAndDomain();
        RsmConfiguration cfg = (RsmConfiguration)cfgs.get(scNameAndDomain);
        int[] imported = null;
        long goalfmNodeID = memberNd.getFMNodeID();
        int i = 0;
        while (i < cfg.controller.members.length) {
            NetMember member = cfg.controller.members[i];
            if (member.fmnodeid == goalfmNodeID) {
                imported = member.imported_ncslices;
                break;
            }
            ++i;
        }
        long goalfmNodeIDMember = nd.getFMNodeID();
        RsmConfiguration memberCfg = (RsmConfiguration)cfgs.get(scNameAndDomainMember);
        int i2 = 0;
        while (i2 < memberCfg.controller.members.length) {
            NetMember member = memberCfg.controller.members[i2];
            if (member.fmnodeid == goalfmNodeIDMember) {
                member.exported_ncslices = imported;
                member.comm_ncslice = imported[0];
                break;
            }
            ++i2;
        }
    }

    private void setImportSlice(Map cfgs, Node nd, Node memberNd, List slicesForStarcat) {
        long goalfmNodeID = memberNd.getFMNodeID();
        String scNameAndDomain = nd.getSCNameAndDomain();
        RsmConfiguration cfg = (RsmConfiguration)cfgs.get(scNameAndDomain);
        int i = 0;
        while (i < cfg.controller.members.length) {
            NetMember member = cfg.controller.members[i];
            if (member.fmnodeid == goalfmNodeID) {
                member.imported_ncslices = this.integerTointArray(slicesForStarcat, 8);
            }
            ++i;
        }
    }

    public void setNetMembers(NetMember[] members) {
        this.printNetMembers(members, false);
        Arrays.sort(members, new Comparator(){

            public int compare(Object o1, Object o2) {
                NetMember n1 = (NetMember)o1;
                NetMember n2 = (NetMember)o2;
                return n1.cnodeid - n2.cnodeid;
            }

            public boolean equals(Object o1) {
                return false;
            }
        });
        this.members = members;
        this.printNetMembers(this.members, true);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("***** RSM Controller *****\nConfig Protocol Version: " + this.config_protocol_version + "\nController ID          : " + this.controller_id + "\nFM Node ID             : " + this.fmnode_id + "\nHostname               : " + this.hostname + "\nVersion Stamp          : " + this.version_stamp + "\nC Node ID              : " + this.cnodeid + "\n**Routing Data         : " + this.routing);
        int i = 0;
        while (i < this.members.length) {
            buff.append("\n**Net Member[" + i + "]: " + this.members[i]);
            ++i;
        }
        return buff.toString();
    }

    class NCBitSet
    extends BitSet {
        private static final int NUMSLICES = 255;

        NCBitSet() {
            super(255);
        }

        public int findSlice(int startSliceBit) {
            int i = startSliceBit;
            while (i < 255) {
                if (this.get(i)) {
                    this.clear(i);
                    return i;
                }
                ++i;
            }
            if (startSliceBit != 0) {
                int i2 = 0;
                while (i2 < startSliceBit) {
                    if (this.get(i2)) {
                        this.clear(i2);
                        return i2;
                    }
                    ++i2;
                }
            }
            return -1;
        }

        public void intersect(BitSet bs) {
            this.and(bs);
        }

        public void setFrom(List lst) {
            String local = String.valueOf(this.getClass().getName()) + ".setFrom(List)\n";
            Iterator iter = lst.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                MessageLog.getInstance().logMessage(String.valueOf(local) + obj, MessageLog.HIGH);
                MessageLog.getInstance().logMessage(String.valueOf(local) + "class type is " + obj.getClass().getName(), MessageLog.HIGH);
                Integer slice = (Integer)obj;
                this.set(slice);
            }
        }
    }

    class NASMSlicer {
        private Map exportedSlices = new HashMap();

        NASMSlicer(int numSCPerChassis, Node[] nodes, PartitionInterface pi) {
            int i = 0;
            while (i < nodes.length) {
                RsmConfiguration cfg;
                Node nd = nodes[i];
                ArrayList<importSlice> lst = (ArrayList<importSlice>)this.exportedSlices.get(new Long(nd.getFMNodeID()));
                if (lst == null) {
                    lst = new ArrayList<importSlice>();
                    this.exportedSlices.put(new Long(nd.getFMNodeID()), lst);
                }
                if (!nd.getType().equals(Node.WCIX_SWITCH) && (cfg = (RsmConfiguration)pi.getNodeConfigObject(nd.getSCNameAndDomain())) != null) {
                    int j = 0;
                    while (j < nodes.length) {
                        int slice;
                        Node nd2 = nodes[j];
                        if (!nd2.getType().equals(Node.WCIX_SWITCH) && (slice = cfg.controller.getUsedSlices(nd2, true)) > 0) {
                            importSlice thisSlice = new importSlice(slice);
                            if (lst.contains(thisSlice)) {
                                thisSlice = (importSlice)lst.get(lst.indexOf(thisSlice));
                            } else {
                                lst.add(thisSlice);
                            }
                            int index = lst.indexOf(thisSlice);
                            if (index >= 0) {
                                thisSlice = (importSlice)lst.get(index);
                            }
                            thisSlice.addImporter(nd2.getFMNodeID(), nd2.getSCName());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        public void addNewSlice(Node nd, int slice) {
            List lst = (List)this.exportedSlices.get(new Long(nd.getFMNodeID()));
            lst.add(new importSlice(slice));
        }

        public int getNumSlices(Node nd) {
            List lst = (List)this.exportedSlices.get(new Long(nd.getFMNodeID()));
            return lst.size();
        }

        public ArrayList getSlice(Node nd, Node nd2) {
            List lst = (List)this.exportedSlices.get(new Long(nd.getFMNodeID()));
            importSlice returnedIS = null;
            boolean prevAlloc = false;
            int lstSize = lst.size();
            int i = 0;
            while (i < lst.size()) {
                importSlice is = (importSlice)lst.get(i);
                if (is.exportedTo.contains(new Long(nd2.getFMNodeID()))) {
                    returnedIS = is;
                    prevAlloc = true;
                    break;
                }
                if (returnedIS == null && !is.exportedToChassis.contains(nd2.getSCName())) {
                    returnedIS = is;
                }
                ++i;
            }
            if (!prevAlloc) {
                returnedIS.exportedToChassis.add(nd2.getSCName());
                returnedIS.exportedTo.add(new Long(nd2.getFMNodeID()));
            }
            ArrayList<Integer> rv = new ArrayList<Integer>(1);
            rv.add(new Integer(returnedIS.sliceValue));
            return rv;
        }

        class importSlice {
            public List exportedTo = new ArrayList();
            public List exportedToChassis = new ArrayList();
            public int sliceValue;

            importSlice(int sliceValue) {
                this.sliceValue = sliceValue;
            }

            public void addImporter(long importer, String chassisName) {
                this.exportedTo.add(new Long(importer));
                this.exportedToChassis.add(chassisName);
            }

            public boolean equals(Object thatObj) {
                return thatObj.getClass() == this.getClass() && this.sliceValue == ((importSlice)thatObj).sliceValue;
            }
        }
    }
}

