/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import com.sun.wildcat.fabric_management.common.EndPoint;
import com.sun.wildcat.fabric_management.common.MessageLog;
import com.sun.wildcat.fabric_management.common.Node;
import com.sun.wildcat.fabric_management.common.ReserveLink;
import com.sun.wildcat.fabric_management.common.ReserveWCI;
import com.sun.wildcat.fabric_management.common.WCISafariPortUtil;
import com.sun.wildcat.fabric_management.pmgrs.common.LinkData;
import com.sun.wildcat.fabric_management.pmgrs.common.RsmController;
import com.sun.wildcat.fabric_management.pmgrs.common.WCIData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class RsmConfiguration
implements Serializable {
    public RsmController controller;

    public RsmConfiguration() {
        this.controller = new RsmController();
    }

    public RsmConfiguration(RsmController controller) {
        this.controller = controller;
    }

    private List createLinks(WCIData wci, Node.NodeType nt) {
        ArrayList<ReserveLink> result = new ArrayList<ReserveLink>();
        ReserveWCI localWCI = this.getWCI(wci, nt);
        LinkData[] links = wci.links;
        int i = 0;
        while (i < links.length) {
            LinkData link = links[i];
            if (link.present) {
                int wnode = wci.getGNIDToWnodeMap()[link.remote_gnid];
                int cnode = wci.getWnodeToCnodeMap()[wnode];
                int wciSlot = WCISafariPortUtil.getSlotNumber(link.remote_port, nt);
                int wciID = WCISafariPortUtil.getWciNumber(link.remote_port, nt);
                EndPoint localEnd = new EndPoint(localWCI, i);
                EndPoint remoteEnd = new EndPoint(cnode, wciSlot, wciID, link.remote_link_num);
                result.add(new ReserveLink(localEnd, remoteEnd));
            }
            ++i;
        }
        return result;
    }

    public List getLinks(Node.NodeType nt) {
        ArrayList result = new ArrayList();
        try {
            WCIData[] wcis = this.controller.routing.getWCIData();
            int i = 0;
            while (i < wcis.length) {
                List links = this.createLinks(wcis[i], nt);
                result.addAll(links);
                ++i;
            }
        }
        catch (NullPointerException npe) {
            MessageLog.getInstance().logMessage("RsmConfiguration - getLinks: " + ((Throwable)npe).getMessage(), MessageLog.ERROR);
            MessageLog.getInstance().logStackTrace(npe);
        }
        return result;
    }

    public BitSet getUsedNCSlices() {
        BitSet bs = new BitSet(255);
        if (this.controller != null) {
            List slices = this.controller.getUsedSlices(-1L, true);
            List slicesImport = this.controller.getUsedSlices(-1L, false);
            slices.addAll(slicesImport);
            int size = slices.size();
            int i = 0;
            while (i < size) {
                bs.set((Integer)slices.get(i));
                ++i;
            }
        }
        return bs;
    }

    private ReserveWCI getWCI(WCIData wci, Node.NodeType nt) {
        int cnode = wci.getWnodeToCnodeMap()[wci.local_wnode];
        int wciSlot = WCISafariPortUtil.getSlotNumber(wci.port, nt);
        int wciID = WCISafariPortUtil.getWciNumber(wci.port, nt);
        return new ReserveWCI(cnode, wciSlot, wciID);
    }

    public List getWCIs(Node.NodeType nt) {
        ArrayList<ReserveWCI> result = new ArrayList<ReserveWCI>();
        try {
            WCIData[] wcis = this.controller.routing.getWCIData();
            int i = 0;
            while (i < wcis.length) {
                ReserveWCI wci = this.getWCI(wcis[i], nt);
                result.add(wci);
                ++i;
            }
        }
        catch (NullPointerException npe) {
            MessageLog.getInstance().logMessage("RsmConfiguration - getWCIs: " + ((Throwable)npe).getMessage(), MessageLog.ERROR);
            MessageLog.getInstance().logStackTrace(npe);
        }
        return result;
    }

    public String toString() {
        return this.controller.toString();
    }
}

