/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import com.sun.wildcat.fabric_management.common.MessageLog;
import com.sun.wildcat.fabric_management.pmgrs.common.RoutingPolicy;
import com.sun.wildcat.fabric_management.pmgrs.common.StripeGroup;
import com.sun.wildcat.fabric_management.pmgrs.common.WCIData;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class RoutingData
implements Serializable {
    public boolean other_routes_allowed;
    private WCIData[] wcis;
    private StripeGroup[] stripe_groups;
    private RoutingPolicy[] policy;

    public RoutingData() {
    }

    public RoutingData(boolean other_routes_allowed, WCIData[] wcis, StripeGroup[] stripe_groups, RoutingPolicy[] policy) {
        this.other_routes_allowed = other_routes_allowed;
        this.setWCIData(wcis);
        this.setStripeGroups(stripe_groups);
        this.setRoutingPolicy(policy);
    }

    public RoutingPolicy[] getRoutingPolicy() {
        return this.policy;
    }

    public StripeGroup[] getStripeGroups() {
        return this.stripe_groups;
    }

    public WCIData[] getWCIData() {
        return this.wcis;
    }

    public boolean inWCIList(WCIData searchWCI) {
        boolean result = false;
        int wciCount = this.wcis.length;
        int i = 0;
        while (i < wciCount) {
            WCIData wci = this.wcis[i];
            if (wci.port == searchWCI.port) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private void printRoutes(RoutingPolicy[] policy, boolean sorted) {
        if (policy == null) {
            MessageLog.getInstance().logMessage("policies == null", MessageLog.MEDIUM);
            return;
        }
        if (sorted) {
            MessageLog.getInstance().logMessage("Routing policy sorted [", MessageLog.MEDIUM);
        } else {
            MessageLog.getInstance().logMessage("Routing policy unsorted [", MessageLog.MEDIUM);
        }
        int i = 0;
        while (i < policy.length) {
            MessageLog.getInstance().logMessage("cnode id: " + policy[i].cnodeid, MessageLog.MEDIUM);
            ++i;
        }
        MessageLog.getInstance().logMessage("]", MessageLog.MEDIUM);
    }

    private void printStripeGroups(StripeGroup[] stripeGroups, boolean sorted) {
        if (stripeGroups == null) {
            MessageLog.getInstance().logMessage("stripe groups == null", MessageLog.MEDIUM);
            return;
        }
        if (sorted) {
            MessageLog.getInstance().logMessage("Stripe groups sorted [", MessageLog.MEDIUM);
        } else {
            MessageLog.getInstance().logMessage("WCIData policy unsorted [", MessageLog.MEDIUM);
        }
        int i = 0;
        while (i < stripeGroups.length) {
            MessageLog.getInstance().logMessage("strip group id: " + stripeGroups[i].group_id, MessageLog.MEDIUM);
            ++i;
        }
        MessageLog.getInstance().logMessage("]", MessageLog.MEDIUM);
    }

    private void printWCIs(WCIData[] wcis, boolean sorted) {
        if (wcis == null) {
            MessageLog.getInstance().logMessage("wcis == null", MessageLog.MEDIUM);
            return;
        }
        if (sorted) {
            MessageLog.getInstance().logMessage("WCIData sorted [", MessageLog.MEDIUM);
        } else {
            MessageLog.getInstance().logMessage("WCIData unsorted [", MessageLog.MEDIUM);
        }
        int i = 0;
        while (i < wcis.length) {
            MessageLog.getInstance().logMessage("port: " + wcis[i].port, MessageLog.MEDIUM);
            ++i;
        }
        MessageLog.getInstance().logMessage("]", MessageLog.MEDIUM);
    }

    public void setRoutingPolicy(RoutingPolicy[] policy) {
        this.printRoutes(policy, false);
        if (policy == null) {
            return;
        }
        Arrays.sort(policy, new Comparator(){

            public int compare(Object o1, Object o2) {
                RoutingPolicy r1 = (RoutingPolicy)o1;
                RoutingPolicy r2 = (RoutingPolicy)o2;
                return r1.cnodeid - r2.cnodeid;
            }

            public boolean equals(Object o1) {
                return false;
            }
        });
        this.policy = policy;
        this.printRoutes(this.policy, true);
    }

    public void setStripeGroups(StripeGroup[] stripe_groups) {
        this.printStripeGroups(stripe_groups, false);
        if (stripe_groups == null) {
            return;
        }
        Arrays.sort(stripe_groups, new Comparator(){

            public int compare(Object o1, Object o2) {
                StripeGroup s1 = (StripeGroup)o1;
                StripeGroup s2 = (StripeGroup)o2;
                return s1.group_id - s2.group_id;
            }

            public boolean equals(Object o1) {
                return false;
            }
        });
        this.stripe_groups = stripe_groups;
        this.printStripeGroups(this.stripe_groups, true);
    }

    public void setWCIData(WCIData[] wcis) {
        this.printWCIs(wcis, false);
        if (wcis == null) {
            return;
        }
        Arrays.sort(wcis, new Comparator(){

            public int compare(Object o1, Object o2) {
                WCIData w1 = (WCIData)o1;
                WCIData w2 = (WCIData)o2;
                return w1.port - w2.port;
            }

            public boolean equals(Object o1) {
                return false;
            }
        });
        this.wcis = wcis;
        this.printWCIs(this.wcis, true);
    }

    public String toString() {
        int numWCIs = 0;
        int numStripeGroups = 0;
        int numPolicies = 0;
        if (this.wcis != null) {
            numWCIs = this.wcis.length;
        }
        if (this.stripe_groups != null) {
            numStripeGroups = this.stripe_groups.length;
        }
        if (this.policy != null) {
            numPolicies = this.policy.length;
        }
        StringBuffer buff = new StringBuffer("\nNumber of WCIs      : " + numWCIs + "\n\tWCI Data");
        int i = 0;
        while (i < numWCIs) {
            buff.append("\n\t\tWCI [" + i + "] :" + this.wcis[i]);
            ++i;
        }
        buff.append("\nNumber Stripe Groups: " + numStripeGroups);
        int i2 = 0;
        while (i2 < numStripeGroups) {
            buff.append("\n\tStripe group [" + i2 + "] :" + this.stripe_groups[i2]);
            ++i2;
        }
        buff.append("\nNumber Policies     : " + numPolicies);
        int i3 = 0;
        while (i3 < numPolicies) {
            buff.append("\n\tPolicy [" + i3 + "] :" + this.policy[i3]);
            ++i3;
        }
        buff.append("\nOtherRoutes Allowed : " + this.other_routes_allowed);
        return buff.toString();
    }
}

