/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import java.io.Serializable;

public class Route
implements Serializable {
    public static final int MULTIHOP = 0;
    public static final int PASSTHROUGH = 1;
    public static final int ROUTE_STRIPE_GROUP = 1;
    public static final int ROUTE_WCI = 2;
    private static final String[] ROUTE_METHOD = new String[]{"MULTIHOP", "PASSTHROUGH"};
    private static final String[] ROUTE_TYPE = new String[]{null, "ROUTE_STRIPE_GROUP", "ROUTE_WCI"};
    private static final int WRSM_MAX_SWITCHES = 38;
    public int striping_level;
    public int routing_method;
    public int nswitches;
    public int[] switches;
    public int route_type;
    public int stripe_group_id;
    public int wci_id;

    public Route(int striping_level, int routing_method, int nswitches, int[] switches, int route_type, int stripe_group_id, int wci_id) {
        this.striping_level = striping_level;
        this.routing_method = routing_method;
        this.nswitches = nswitches;
        this.initSwitches(switches);
        this.route_type = route_type;
        this.stripe_group_id = stripe_group_id;
        this.wci_id = wci_id;
    }

    private void initSwitches(int[] switches) {
        if (switches != null) {
            if (switches.length == 38) {
                this.switches = switches;
            } else {
                this.switches = new int[38];
                int i = 0;
                while (i < 38 && i < switches.length) {
                    this.switches[i] = switches[i];
                    ++i;
                }
            }
        } else {
            this.switches = new int[38];
        }
    }

    public static String mapRouteType(int routeType) {
        String result = ROUTE_TYPE[2];
        try {
            result = ROUTE_TYPE[routeType];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Error, mapRouteType index out of bounds, defaulted to " + result);
        }
        return result;
    }

    public static int mapRouteType(String routeType) {
        int result = 2;
        int i = 1;
        while (i < ROUTE_TYPE.length) {
            if (ROUTE_TYPE[i].equalsIgnoreCase(routeType)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public static String mapRoutingMethod(int routeMethod) {
        String result = ROUTE_METHOD[0];
        try {
            result = ROUTE_METHOD[routeMethod];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Error, mapRoutingMethod index out of bounds, defaulted to " + result);
        }
        return result;
    }

    public static int mapRoutingMethod(String routeMethod) {
        int result = 0;
        int i = 0;
        while (i < ROUTE_METHOD.length) {
            if (ROUTE_METHOD[i].equalsIgnoreCase(routeMethod)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("\n\t\t\tStriping Level : " + this.striping_level);
        buff.append("\n\t\t\tRouting Method : " + (this.routing_method == 0 ? "MULTIHOP" : "PASSTHROUGH"));
        buff.append("\n\t\t\tRoute Type     : " + (this.route_type == 2 ? "ROUTE_WCI" : "ROUTE_STRIPE_GROUP"));
        if (this.route_type == 2) {
            buff.append("\n\t\t\tWCI ID         : " + this.wci_id);
        } else {
            buff.append("\n\t\t\tStripe Group ID: " + this.stripe_group_id);
        }
        buff.append("\n\t\t\tSwitch IDs     : ");
        int i = 0;
        while (i < this.nswitches) {
            buff.append(String.valueOf(this.switches[i]) + " ");
            ++i;
        }
        return buff.toString();
    }
}

