/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import com.sun.wildcat.fabric_management.common.MessageLog;
import com.sun.wildcat.fabric_management.common.RMILkupSettings;
import com.sun.wildcat.fabric_management.common.RMILookupUtils;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;

public class RMIObjectRetriever {
    private RMILkupSettings rmiSettings;
    private RegularModeRetrieval proxyRetriever;
    private RegularModeRetrieval scRetriever;
    private RegularModeRetrieval switchRetriever;

    public RMIObjectRetriever(RMILkupSettings rmiSettings) {
        this.rmiSettings = rmiSettings;
        this.init();
    }

    public Remote getProxy(String host) throws NotBoundException, MalformedURLException, RemoteException {
        return this.proxyRetriever.getRemoteObject(host, this.rmiSettings.wrsmProxyPort, this.rmiSettings.wrsmProxyLkupName);
    }

    public RMILkupSettings getRMILkupSettings() {
        return this.rmiSettings;
    }

    public Remote getSC(String host) throws NotBoundException, MalformedURLException, RemoteException {
        return this.proxyRetriever.getRemoteObject(host, this.rmiSettings.scPort, this.rmiSettings.scLkupName);
    }

    public Remote getSwitch(String host) throws NotBoundException, MalformedURLException, RemoteException {
        return this.proxyRetriever.getRemoteObject(host, this.rmiSettings.switchPort, this.rmiSettings.switchLkupName);
    }

    private void init() {
        this.proxyRetriever = this.rmiSettings.proxySimulation ? new SimulationModeRetrieval() : new RegularModeRetrieval();
        this.scRetriever = this.rmiSettings.scSimulation ? new SimulationModeRetrieval() : new RegularModeRetrieval();
        this.switchRetriever = this.rmiSettings.switchSimulation ? new SimulationModeRetrieval() : new RegularModeRetrieval();
    }

    public class RegularModeRetrieval {
        protected String buildURL(String host, int port, String lkupName) {
            String local = String.valueOf(this.getClass().getName()) + ".buildURL(String, int, String)\n";
            String url = "rmi://" + host + ":" + port + "/" + lkupName;
            MessageLog.getInstance().logMessage(String.valueOf(local) + "url = " + url, MessageLog.HIGH);
            return url;
        }

        public Remote getRemoteObject(String host, int port, String lkupName) throws NotBoundException, MalformedURLException, RemoteException {
            String url = this.buildURL(host, port, lkupName);
            return RMILookupUtils.getRemoteObject(url);
        }
    }

    class SimulationModeRetrieval
    extends RegularModeRetrieval {
        protected String buildURL(String host, int port, String lkupName) {
            String local = String.valueOf(this.getClass().getName()) + ".buildURL(String, int, String)\n";
            String url = "rmi://localhost:" + port + "/" + host;
            MessageLog.getInstance().logMessage(String.valueOf(local) + "url = " + url, MessageLog.HIGH);
            return url;
        }
    }
}

