/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import java.io.Serializable;

public class NetMember
implements Serializable {
    private static final int HOSTNAME_LENGTH = 256;
    public static final int WRSM_NODE_NCSLICES = 8;
    public int cnodeid;
    public long fmnodeid;
    public String hostname;
    public int[] exported_ncslices;
    public int[] imported_ncslices;
    public int comm_ncslice;
    public long comm_offset;
    public long local_offset;

    public NetMember(int cnodeid, long fmnodeid, String hostname, int[] exported_ncslices, int[] imported_ncslices, int comm_ncslice, long comm_offset, long local_offset) {
        int i;
        this.cnodeid = cnodeid;
        this.fmnodeid = fmnodeid;
        this.hostname = hostname != null && hostname.length() >= 256 ? hostname.substring(0, 254) : hostname;
        if (exported_ncslices.length != 8) {
            this.exported_ncslices = new int[8];
            i = 0;
            while (i < 8 && i < exported_ncslices.length) {
                this.exported_ncslices[i] = exported_ncslices[i];
                ++i;
            }
        } else {
            this.exported_ncslices = exported_ncslices;
        }
        if (imported_ncslices.length != 8) {
            this.imported_ncslices = new int[8];
            i = 0;
            while (i < 8 && i < exported_ncslices.length) {
                this.imported_ncslices[i] = imported_ncslices[i];
                ++i;
            }
        } else {
            this.imported_ncslices = imported_ncslices;
        }
        this.comm_ncslice = comm_ncslice;
        this.comm_offset = comm_offset;
        this.local_offset = local_offset;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("NetMember:");
        buf.append("\n\tC Node ID                : " + this.cnodeid);
        buf.append("\n\tFM Node ID               : " + this.fmnodeid);
        buf.append("\n\tHostname                 : " + this.hostname);
        buf.append("\n\tImported NC Slices       :");
        int i = 0;
        while (i < this.imported_ncslices.length) {
            int sliceID = this.imported_ncslices[i];
            if (sliceID > 0) {
                buf.append("\n\t 0x" + Integer.toHexString(sliceID).toUpperCase());
            }
            ++i;
        }
        buf.append("\n\tExported NC Slices       :");
        int i2 = 0;
        while (i2 < this.exported_ncslices.length) {
            int sliceID = this.exported_ncslices[i2];
            if (sliceID > 0) {
                buf.append("\n\t 0x" + Integer.toHexString(sliceID).toUpperCase());
            }
            ++i2;
        }
        buf.append("\n\tComm NC Slice            : " + this.comm_ncslice);
        buf.append("\n\tComm Offset              : 0x" + Long.toHexString(this.comm_offset));
        buf.append("\n\tLocal Offset             : 0x" + Long.toHexString(this.local_offset));
        return buf.toString();
    }
}

