/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.pmgrs.common;

import com.sun.wildcat.fabric_management.common.GraphNode;
import java.util.ArrayList;
import java.util.List;

public class DirectConnectDB {
    private boolean linkStripeFirst = true;
    private int linksPerWCI = 3;

    public DirectConnectDB() {
    }

    public DirectConnectDB(boolean linkStripeFirst, int linksPerWCI) {
        this.linkStripeFirst = linkStripeFirst;
        this.linksPerWCI = linksPerWCI;
    }

    private int calculateNumWCIsPerNode(int numNodes, int stripeLevel) {
        int result = 0;
        if (numNodes <= 2 && this.linkStripeFirst) {
            int tempLinksPerWCI = this.linksPerWCI <= 2 ? this.linksPerWCI : 2;
            result = (int)Math.ceil((double)stripeLevel / (double)tempLinksPerWCI);
        } else {
            result = stripeLevel;
        }
        return result;
    }

    private GraphNode[][] createWCIs(int numberNodes, int numWCIsPerNode) {
        GraphNode[][] result = new GraphNode[numberNodes][numWCIsPerNode];
        int node = 0;
        while (node < numberNodes) {
            int wci = 0;
            while (wci < numWCIsPerNode) {
                int id = node * numWCIsPerNode + wci;
                GraphNode gn = new GraphNode(id);
                gn.setApplicationData(new Integer(node));
                gn.setType(1);
                result[node][wci] = gn;
                ++wci;
            }
            ++node;
        }
        return result;
    }

    public List generateGraph(int numberNodes, int stripeLevel, int numStarCats) {
        List result = null;
        if (stripeLevel <= 0 || numberNodes <= 0) {
            return result;
        }
        if (this.linksPerWCI < numberNodes - 1) {
            return result;
        }
        int numWCIsPerNode = this.calculateNumWCIsPerNode(numberNodes, stripeLevel);
        int edgesBetweenWCIs = numWCIsPerNode == 0 ? 0 : stripeLevel / numWCIsPerNode;
        GraphNode[][] wcis = this.createWCIs(numberNodes, numWCIsPerNode);
        result = this.setAdjacencyLists(wcis, numberNodes, numWCIsPerNode, edgesBetweenWCIs, numStarCats);
        return result;
    }

    public boolean getLinkStripeFirst() {
        return this.linkStripeFirst;
    }

    public int getLinksPerWCI() {
        return this.linksPerWCI;
    }

    public static void main(String[] args) {
        int MAX_DIRECT_CONNECT_NODES = 4;
        int MAX_STRIPE_LEVEL = 4;
        int MAX_LINKS_PER_WCI = 3;
        DirectConnectDB dcdb = new DirectConnectDB();
        List result = null;
        int nodes = 1;
        while (nodes <= 4) {
            int stripeLevel = 1;
            while (stripeLevel <= 4) {
                int linksPerWCI = 1;
                while (linksPerWCI <= 3) {
                    dcdb.setLinksPerWCI(linksPerWCI);
                    dcdb.setLinkStripeFirst(false);
                    result = dcdb.generateGraph(nodes, stripeLevel, 0);
                    DirectConnectDB.printGraph(result, nodes, stripeLevel, dcdb.getLinksPerWCI(), dcdb.getLinkStripeFirst());
                    dcdb.setLinkStripeFirst(true);
                    result = dcdb.generateGraph(nodes, stripeLevel, 0);
                    DirectConnectDB.printGraph(result, nodes, stripeLevel, dcdb.getLinksPerWCI(), dcdb.getLinkStripeFirst());
                    ++linksPerWCI;
                }
                stripeLevel *= 2;
            }
            ++nodes;
        }
    }

    private static void printGraph(List graph, int numNodes, int stripeLevel, int linkPerWCI, boolean linkStripeFirst) {
        if (graph == null) {
            System.out.println("$$$$$$$$ NO BUILD Graph with " + numNodes + " nodes and a stripe level of " + stripeLevel);
            System.out.println("\t Links per WCI = " + linkPerWCI + "  linkStripeFirst = " + linkStripeFirst + "\n\n");
            return;
        }
        int numWCIs = graph.size();
        GraphNode wci = null;
        System.out.println("$$$$$$$$ Graph with " + numNodes + " nodes and a stripe level of " + stripeLevel);
        System.out.println("\t Links per WCI = " + linkPerWCI + "  linkStripeFirst = " + linkStripeFirst);
        int i = 0;
        while (i < numWCIs) {
            wci = (GraphNode)graph.get(i);
            System.out.println(wci);
            ++i;
        }
        System.out.println("\n\n");
    }

    private List setAdjacencyLists(GraphNode[][] wcis, int numberNodes, int numWCIsPerNode, int edgeCountBetweenWCIs, int numStarCats) {
        ArrayList<GraphNode> result = new ArrayList<GraphNode>();
        GraphNode currentWCI = null;
        GraphNode illegalWCI = null;
        GraphNode adjacentWCI = null;
        int node = 0;
        while (node < numberNodes) {
            int wci = 0;
            while (wci < numWCIsPerNode) {
                currentWCI = wcis[node][wci];
                int i = 0;
                while (i < numWCIsPerNode) {
                    illegalWCI = wcis[node][i];
                    if (illegalWCI.getId() != currentWCI.getId()) {
                        currentWCI.addIllegalAdjacentNode(illegalWCI);
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < numberNodes) {
                    adjacentWCI = wcis[i2][wci];
                    if (adjacentWCI.getId() != currentWCI.getId()) {
                        int j = 0;
                        while (j < edgeCountBetweenWCIs) {
                            currentWCI.addAdjacentNode(adjacentWCI);
                            ++j;
                        }
                    }
                    ++i2;
                }
                result.add(currentWCI);
                ++wci;
            }
            if (node < numStarCats && numWCIsPerNode > 1) {
                GraphNode aWCI = wcis[node][0];
                GraphNode nextWCI = wcis[node][1];
                aWCI.setBuddy(nextWCI);
                nextWCI.setBuddy(aWCI);
            }
            ++node;
        }
        return result;
    }

    public void setLinkStripeFirst(boolean linkStripeFirst) {
        this.linkStripeFirst = linkStripeFirst;
    }

    public void setLinksPerWCI(int linksPerWCI) {
        this.linksPerWCI = linksPerWCI;
    }
}

