/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.Node;
import java.util.StringTokenizer;

public final class WCISafariPortUtil {
    private WCISafariPortUtil() {
    }

    public static int convertToSafariPort(int slot, int wciID, Node.NodeType ntype) {
        int result = 0;
        result = Node.S72.equals(ntype) ? slot << 5 | wciID : (slot > 5 ? (slot - 6) * 2 + 24 + wciID : slot * 4 | wciID);
        return result;
    }

    public static int convertToSafariPort(Integer slot, Integer wciID, Node.NodeType ntype) {
        if (slot == null || wciID == null) {
            return -1;
        }
        return WCISafariPortUtil.convertToSafariPort((int)slot, (int)wciID, ntype);
    }

    public static int convertToSafariPort(String slotAndWci, Node.NodeType ntype) {
        if (slotAndWci == null) {
            return -1;
        }
        StringTokenizer t = new StringTokenizer(slotAndWci, ":");
        if (t.countTokens() != 2) {
            return -1;
        }
        return WCISafariPortUtil.convertToSafariPort(Integer.parseInt(t.nextToken()), Integer.parseInt(t.nextToken()), ntype);
    }

    public static int getSlotNumber(int safariPortId, Node.NodeType ntype) {
        int slot = Node.S72.equals(ntype) ? safariPortId >> 5 & 0x1F : ((safariPortId %= 32) < 24 ? safariPortId / 4 : safariPortId / 2 - 6);
        return slot;
    }

    public static int getSlotNumber(Integer IsafariPortId, Node.NodeType ntype) {
        if (IsafariPortId == null) {
            return -1;
        }
        return WCISafariPortUtil.getSlotNumber((int)IsafariPortId, ntype);
    }

    public static int getWciNumber(int safariPortId, Node.NodeType ntype) {
        int slot;
        int wci = Node.S72.equals(ntype) ? safariPortId & 0x1F : ((slot = WCISafariPortUtil.getSlotNumber(safariPortId %= 32, ntype)) > 5 ? 1 & safariPortId : 3 & safariPortId);
        return wci;
    }

    public static int getWciNumber(Integer IsafariPortId, Node.NodeType ntype) {
        if (IsafariPortId == null) {
            return -1;
        }
        int safariPortId = IsafariPortId;
        return WCISafariPortUtil.getWciNumber(safariPortId, ntype);
    }

    public static void main(String[] args) {
        int safariPort = -1;
        int wciSlot = -1;
        int wciID = -1;
        String delimiter = ":";
        if (args.length != 1) {
            System.out.println("Usage: java WCISafariPortUtil safari_port | wci_slot:wci_id");
        } else {
            String arg = args[0];
            if (arg.indexOf(delimiter) == -1) {
                if (arg.startsWith("0x") | arg.startsWith("0X")) {
                    arg = arg.substring(2);
                    safariPort = Integer.parseInt(arg, 16);
                } else {
                    safariPort = Integer.parseInt(arg);
                }
                wciSlot = WCISafariPortUtil.getSlotNumber(safariPort, Node.S24);
                wciID = WCISafariPortUtil.getWciNumber(safariPort, Node.S24);
            } else {
                StringTokenizer toke = new StringTokenizer(arg, delimiter);
                wciSlot = Integer.parseInt(toke.nextToken().trim());
                wciID = Integer.parseInt(toke.nextToken().trim());
                safariPort = WCISafariPortUtil.convertToSafariPort(wciSlot, wciID, Node.S24);
            }
            System.out.println(String.valueOf(safariPort) + "/0x" + Integer.toHexString(safariPort).toUpperCase() + " - [" + wciSlot + ":" + wciID + "]");
        }
    }
}

