/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.Node;
import com.sun.wildcat.fabric_management.common.Paroli;
import com.sun.wildcat.fabric_management.common.RemoteEnd;
import com.sun.wildcat.fabric_management.common.WCISafariPortUtil;
import com.sun.wildcat.fabric_management.common.WciDataInterface;
import java.io.Serializable;

public class WCI
implements Serializable,
WciDataInterface {
    public static final WCIMode UNKNOWN;
    public static final WCIMode RSM;
    public static final WCIMode SSM;
    public static final WCIMode FREE;
    public static final WCIMode ERROR;
    private int slot;
    private int wciID;
    private WCIMode mode = UNKNOWN;
    private int gnid;
    private int rnid;
    private Paroli[] parolis;
    private int dimmSize = 10;
    private Node.NodeType nt;

    static {
        class Com_sun_wildcat_fabric_management_common_WCI$1 {
            /* synthetic */ Com_sun_wildcat_fabric_management_common_WCI$1() {
            }
        }
        UNKNOWN = new WCIMode(null, 0);
        RSM = new WCIMode(null, 1);
        SSM = new WCIMode(null, 2);
        FREE = new WCIMode(null, 3);
        ERROR = new WCIMode(null, 4);
    }

    public WCI(int slot, int wciID, Node.NodeType nt) {
        this(nt);
        this.slot = slot;
        this.wciID = wciID;
    }

    public WCI(int slot, int wciID, WCIMode mode, int gnid, int dimmSize, Node.NodeType nt) {
        this(slot, wciID, mode, gnid, nt);
        this.dimmSize = dimmSize;
    }

    public WCI(int slot, int wciID, WCIMode mode, int gnid, Node.NodeType nt) {
        this(slot, wciID, nt);
        this.mode = mode;
        this.gnid = gnid;
    }

    public WCI(int safariPort, Node.NodeType nt) {
        this(nt);
        this.slot = WCISafariPortUtil.getSlotNumber(safariPort, nt);
        this.wciID = WCISafariPortUtil.getWciNumber(safariPort, nt);
    }

    public WCI(Node.NodeType nt) {
        if (nt.equals(Node.WCIX_SWITCH)) {
            this.parolis = new Paroli[8];
            int i = 0;
            while (i < 8) {
                this.parolis[i] = new Paroli();
                ++i;
            }
        } else {
            this.parolis = new Paroli[3];
            int i = 0;
            while (i < 3) {
                this.parolis[i] = new Paroli();
                ++i;
            }
        }
        this.nt = nt;
    }

    public boolean equals(Object thatObject) {
        boolean result = false;
        if (thatObject != null && this.getClass() == thatObject.getClass()) {
            WCI that = (WCI)thatObject;
            result = that.getSlot() == this.getSlot() && that.getWCIID() == this.getWCIID();
        }
        return result;
    }

    public int getDimmSize() {
        return this.dimmSize;
    }

    public int getGNID() {
        return this.gnid;
    }

    public WCIMode getMode() {
        return this.mode;
    }

    public Paroli[] getParolis() {
        return this.parolis;
    }

    public int getRNID() {
        return this.rnid;
    }

    public String[] getRemoteEnd() {
        String[] remoteEnd = new String[this.parolis.length];
        int i = 0;
        while (i < this.parolis.length) {
            remoteEnd[i] = this.getRemoteEnd(i);
            ++i;
        }
        return remoteEnd;
    }

    public String getRemoteEnd(int paroliID) {
        String remoteEndString = null;
        Paroli paroli = null;
        RemoteEnd endPoint = null;
        WCI wci = null;
        if (this.parolis == null) {
            return null;
        }
        paroli = this.parolis[paroliID];
        if (!paroli.isInstalled()) {
            return null;
        }
        endPoint = paroli.getRemoteEnd();
        if (endPoint == null) {
            return null;
        }
        wci = endPoint.getRemoteEnd();
        if (wci != null) {
            remoteEndString = String.valueOf(endPoint.getSCName()) + ":" + endPoint.getSCDomain() + ":" + wci.getSlot() + ":" + wci.getWCIID() + ":" + endPoint.getRemotePort();
        }
        return remoteEndString;
    }

    public int getSafariPortID() {
        return WCISafariPortUtil.convertToSafariPort(this.slot, this.wciID, this.nt);
    }

    public int getSlot() {
        return this.slot;
    }

    public int getWCIID() {
        return this.wciID;
    }

    public int getWCIMode() {
        return this.mode.asInt();
    }

    public void setDimmSize(int dimmSize) {
        this.dimmSize = dimmSize;
    }

    public void setGNID(int gnid) {
        this.gnid = gnid;
    }

    public void setMode(WCIMode mode) {
        this.mode = mode;
    }

    public void setParoli(int portID, Paroli paroli) {
        int maxParolis = 0;
        maxParolis = this.nt.equals(Node.WCIX_SWITCH) ? 8 : 3;
        if (portID >= 0 && portID < maxParolis) {
            this.parolis[portID] = paroli;
        }
    }

    public void setRNID(int rnid) {
        this.rnid = rnid;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public void setWCIID(int wciID) {
        this.wciID = wciID;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentTabs) {
        if (this.parolis == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        StringBuffer tabs = new StringBuffer();
        int i = 0;
        while (i < indentTabs) {
            tabs.append("\t");
            ++i;
        }
        StringBuffer installedParolis = new StringBuffer("[");
        int i2 = 0;
        while (i2 < this.parolis.length) {
            if (this.parolis[i2] == null || !this.parolis[i2].isInstalled()) {
                installedParolis.append("0");
            } else {
                RemoteEnd end = this.parolis[i2].getRemoteEnd();
                if (end != null) {
                    WCI remoteWCI = end.getRemoteEnd();
                    if (remoteWCI != null) {
                        installedParolis.append(String.valueOf(end.getSCName()) + ":" + end.getSCDomain() + ":" + remoteWCI.getSlot() + ":" + remoteWCI.getWCIID() + ":" + end.getRemotePort());
                    } else {
                        installedParolis.append("-1");
                    }
                } else {
                    installedParolis.append("-1");
                }
            }
            if (i2 < this.parolis.length - 1) {
                installedParolis.append(", ");
            }
            ++i2;
        }
        installedParolis.append("]");
        buf.append(String.valueOf(String.valueOf(tabs)) + String.valueOf(this.slot) + ":" + this.wciID + ", " + this.mode + " " + "  gnid-" + this.gnid + "  " + installedParolis.toString());
        return buf.toString();
    }

    public void uninstallParoli(int portID) {
        this.parolis[portID] = new Paroli();
    }

    public static class WCIMode
    implements Serializable {
        private static final String[] modes = new String[]{"UNKNOWN", "RSM", "SSM", "FREE", "ERROR"};
        private int mode;

        private WCIMode(int mode) {
            this.mode = mode;
        }

        /* synthetic */ WCIMode(1 $0, int $1) {
            this($1);
        }

        public int asInt() {
            return this.mode;
        }

        public String toString() {
            return modes[this.mode];
        }
    }
}

