/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.RegistryUtils;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;

public class UnbindRemoteObject {
    private static final String USAGE = "usage: unbindobject object_name [-host hostname] [-port rmi_registry_port]";
    private static final String REG_ACCESS_ERR = "ERROR Accessing Registry ";
    private static final String REG_CONTACT_ERR = "ERROR Contacting Registry ";
    private static final String NOT_BOUND_ERR = "ERROR Object Not Bound To Registry ";
    private static final String REG_LIST_ERR = "ERROR Listing Registry Objects ";
    private String rmiHost = "localhost";
    private int rmiPort = 1099;
    private String objectName;
    private boolean unbindAll = false;

    private UnbindRemoteObject() {
    }

    public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        UnbindRemoteObject uro = new UnbindRemoteObject();
        uro.processCommandLineArgs(args);
        if (uro.unbindAll) {
            uro.removeAllObjects();
        } else {
            uro.removeObject();
        }
    }

    private void printCommandLineError(String error) {
        System.err.println(error);
        System.err.println(this.usage());
        System.exit(1);
    }

    private void processCommandLineArgs(String[] args) {
        if (args.length < 1 || args.length > 5) {
            System.out.println(this.usage());
            System.exit(1);
        }
        if (args[0].equalsIgnoreCase("-unbindall")) {
            this.unbindAll = true;
        } else {
            this.objectName = args[0];
        }
        int index = 1;
        while (index < args.length) {
            if (args[index].equalsIgnoreCase("-host")) {
                if (++index < args.length) {
                    this.rmiHost = args[index];
                } else {
                    this.printCommandLineError("Must specify a hostname");
                }
            } else if (args[index].equalsIgnoreCase("-port")) {
                if (++index < args.length) {
                    try {
                        this.rmiPort = Integer.parseInt(args[index]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.printCommandLineError("Bad RMI Port Number [" + args[index] + "]");
                    }
                } else {
                    this.printCommandLineError("Must specify a port number");
                }
            } else {
                this.printCommandLineError("Bad Command Line Option [" + args[index] + "]");
            }
            ++index;
        }
    }

    private void removeAllObjects() {
        Registry registry = RegistryUtils.getRunningRegistry(this.rmiHost, this.rmiPort);
        String[] objectNames = null;
        if (registry != null) {
            try {
                objectNames = registry.list();
            }
            catch (AccessException accessException) {
                System.err.println(REG_ACCESS_ERR);
                System.exit(1);
            }
            catch (RemoteException remoteException) {
                System.err.println(REG_LIST_ERR);
                System.exit(1);
            }
            int i = 0;
            while (i < objectNames.length) {
                this.removeObject(registry, objectNames[i]);
                ++i;
            }
        } else {
            System.out.println("No Such Registry " + this.rmiHost + ":" + this.rmiPort);
        }
    }

    private void removeObject() {
        Registry registry = RegistryUtils.getRunningRegistry(this.rmiHost, this.rmiPort);
        this.removeObject(registry, this.objectName);
    }

    private void removeObject(Registry registry, String name) {
        if (registry != null) {
            try {
                registry.unbind(name);
                System.out.println("Object Unbound: " + this.rmiHost + ":" + this.rmiPort + "/" + name);
            }
            catch (AccessException accessException) {
                System.err.println(REG_ACCESS_ERR + this.rmiHost + ":" + this.rmiPort);
                System.exit(1);
            }
            catch (RemoteException remoteException) {
                System.err.println(REG_CONTACT_ERR + this.rmiHost + ":" + this.rmiPort);
                System.exit(1);
            }
            catch (NotBoundException notBoundException) {
                System.err.println(NOT_BOUND_ERR + this.rmiHost + ":" + this.rmiPort + "/" + name);
            }
        } else {
            System.out.println("No Such Object " + this.rmiHost + ":" + this.rmiPort + "/" + name);
        }
    }

    private String usage() {
        return USAGE;
    }
}

