/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.Node;
import com.sun.wildcat.fabric_management.common.WCISafariPortUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ReserveWCI
implements Serializable {
    private static final String SEPARATOR = ":";
    private int cnode = -1;
    private String scName;
    private String scDomain;
    private int slot;
    private int id;

    public ReserveWCI(int cnode, int slot, int id) {
        this.cnode = cnode;
        this.slot = slot;
        this.id = id;
    }

    public ReserveWCI(String scName, String scDomain, int slot, int id) {
        this.scName = scName;
        this.scDomain = scDomain;
        this.slot = slot;
        this.id = id;
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (!(thatObj instanceof ReserveWCI)) {
            return false;
        }
        ReserveWCI that = (ReserveWCI)thatObj;
        boolean scNamesMatch = this.getSCName() != null && this.getSCName().equals(that.getSCName()) && (this.getSCDomain() == null && that.getSCDomain() == null || this.getSCDomain() != null && this.getSCDomain().equals(that.getSCDomain()));
        boolean result = false;
        result = this.getCnodeID() != -1 && that.getCnodeID() != -1 ? (scNamesMatch || this.getCnodeID() == that.getCnodeID()) && this.getSlot() == that.getSlot() && this.getID() == that.getID() : scNamesMatch && this.getSlot() == that.getSlot() && this.getID() == that.getID();
        return result;
    }

    public int getCnodeID() {
        return this.cnode;
    }

    public int getID() {
        return this.id;
    }

    public String getMoniker(Node.NodeType nt) {
        String domain = this.getSCDomain();
        if (domain == null) {
            domain = new String("");
        }
        String result = null;
        int safariPort = WCISafariPortUtil.convertToSafariPort(this.getSlot(), this.getID(), nt);
        result = this.getSCName() == null && this.cnode != -1 ? new String(String.valueOf(this.cnode) + SEPARATOR + safariPort) : new String(String.valueOf(this.getSCName()) + SEPARATOR + domain + SEPARATOR + safariPort);
        return result;
    }

    public static List getPorts(ReserveWCI[] wcis, Node.NodeType nt) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (wcis == null) {
            return result;
        }
        int i = 0;
        while (i < wcis.length) {
            Integer safPort = new Integer(wcis[i].getSafariPort(nt));
            result.add(safPort);
            ++i;
        }
        return result;
    }

    public String getSCDomain() {
        return this.scDomain;
    }

    public String getSCName() {
        return this.scName;
    }

    public int getSafariPort(Node.NodeType nt) {
        return WCISafariPortUtil.convertToSafariPort(this.slot, this.id, nt);
    }

    public int getSlot() {
        return this.slot;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.slot;
        result = 37 * result + this.id;
        return result;
    }

    public void setCnodeID(int cnode) {
        this.cnode = cnode;
    }

    public void setSCDomain(String scDomain) {
        this.scDomain = scDomain;
    }

    public void setSCName(String scName) {
        this.scName = scName;
    }

    public String toString() {
        String domain = this.getSCDomain();
        if (domain == null) {
            domain = new String("");
        }
        String result = null;
        int safariPort = WCISafariPortUtil.convertToSafariPort(this.getSlot(), this.getID(), Node.UNKNOWN);
        result = this.getSCName() == null && this.cnode != -1 ? new String(String.valueOf(this.cnode) + SEPARATOR + safariPort) : new String(String.valueOf(this.getSCName()) + SEPARATOR + domain + SEPARATOR + safariPort);
        return result;
    }
}

