/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.EndPoint;
import java.io.Serializable;
import java.util.StringTokenizer;

public class ReserveLink
implements Serializable {
    private EndPoint endPointA;
    private EndPoint endPointB;
    private int status;
    public static final String[] linkStatusStrings = new String[]{"LC_UP", "LC_DOWN", "LC_NOT_THERE", "SC_WAIT_DOWN", "SC_WAIT_UP", "SC_WAIT_ERRDOWN"};

    public ReserveLink(EndPoint endPointA, EndPoint endPointB) {
        this(endPointA, endPointB, -1);
    }

    public ReserveLink(EndPoint endPointA, EndPoint endPointB, int status) {
        this.endPointA = endPointA;
        this.endPointB = endPointB;
        this.status = status;
    }

    public ReserveLink(String linkStr) {
        StringTokenizer endPoints = new StringTokenizer(linkStr, "=");
        this.endPointA = new EndPoint(endPoints.nextToken());
        this.endPointB = new EndPoint(endPoints.nextToken());
        this.status = -1;
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (!(thatObj instanceof ReserveLink)) {
            return false;
        }
        ReserveLink that = (ReserveLink)thatObj;
        boolean result = this.endPointA.equals(that.getEndPointA()) && this.endPointB.equals(that.getEndPointB()) || this.endPointA.equals(that.getEndPointB()) && this.endPointB.equals(that.getEndPointA());
        return result;
    }

    public EndPoint getEndPointA() {
        return this.endPointA;
    }

    public EndPoint getEndPointB() {
        return this.endPointB;
    }

    public int getEndPointIndex(String SCName, String SCDomain) {
        if (SCDomain == null) {
            if (this.endPointA.getWCI().getSCDomain() == null && this.endPointA.getWCI().getSCName().equals(SCName)) {
                return 0;
            }
            if (this.endPointB.getWCI().getSCDomain() == null && this.endPointB.getWCI().getSCName().equals(SCName)) {
                return 1;
            }
        }
        if (this.endPointA.getWCI().getSCName().equals(SCName) && this.endPointA.getWCI().getSCDomain().equals(SCDomain)) {
            return 0;
        }
        if (this.endPointB.getWCI().getSCName().equals(SCName) && this.endPointB.getWCI().getSCDomain().equals(SCDomain)) {
            return 1;
        }
        return -1;
    }

    public EndPoint[] getEndpoints() {
        return new EndPoint[]{this.endPointA, this.endPointB};
    }

    public String getLinkStatusString() {
        if (this.status != -1 && this.status >= 0 && this.status <= linkStatusStrings.length) {
            return linkStatusStrings[this.status];
        }
        return "UNKNOWN";
    }

    public String getSCDomainA() {
        return this.endPointA.getSCDomain();
    }

    public String getSCDomainB() {
        return this.endPointB.getSCDomain();
    }

    public String getSCNameA() {
        return this.endPointA.getSCName();
    }

    public String getSCNameB() {
        return this.endPointB.getSCName();
    }

    public String getSCNameDomainA() {
        return String.valueOf(this.getSCNameA()) + ":" + this.getSCDomainA();
    }

    public String getSCNameDomainB() {
        return String.valueOf(this.getSCNameB()) + ":" + this.getSCDomainB();
    }

    public int getStatus() {
        return this.status;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.endPointA.hashCode();
        result = 37 * result + this.endPointB.hashCode();
        return result;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean printStatus) {
        StringBuffer buf = new StringBuffer(this.endPointA.toString());
        buf.append("=" + this.endPointB.toString());
        if (printStatus) {
            buf.append("=" + this.status);
        }
        return buf.toString();
    }
}

