/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class RegistryUtils {
    private static final String REG_ERR = "ERROR Contacting Registry ";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 1099;

    public static void bindObject(Registry localRegistry, String name, Remote object) throws UnknownHostException, RemoteException, Exception {
        RegistryUtils.bindObject(localRegistry, name, object, false);
    }

    public static void bindObject(Registry localRegistry, String name, Remote object, boolean forceRebind) throws UnknownHostException, RemoteException, Exception {
        String[] roNames = localRegistry.list();
        int i = 0;
        while (i < roNames.length) {
            if (roNames[i].equalsIgnoreCase(name)) {
                if (forceRebind) {
                    System.out.println(String.valueOf(name) + " Forced To Re-Bind To Registry");
                    localRegistry.rebind(name, object);
                } else {
                    System.out.println(String.valueOf(name) + " Already Bound To Registry");
                }
                return;
            }
            ++i;
        }
        localRegistry.bind(name, object);
        System.out.println(String.valueOf(name) + " Bound To Registry");
    }

    public static Registry getRunningRegistry() {
        return RegistryUtils.getRunningRegistry(DEFAULT_HOST, 1099);
    }

    public static Registry getRunningRegistry(int port) {
        return RegistryUtils.getRunningRegistry(DEFAULT_HOST, port);
    }

    public static Registry getRunningRegistry(String host, int port) {
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(host, port);
        }
        catch (RemoteException remoteException) {
            System.err.println(REG_ERR + host + ":" + port);
            System.exit(1);
        }
        try {
            String[] boundNames = registry.list();
        }
        catch (Exception exception) {
            registry = null;
        }
        return registry;
    }
}

