/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.NoSuchNCSliceError;
import com.sun.wildcat.fabric_management.common.WCI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RSMPartitionMembershipDescriptor
implements Serializable {
    private int cnodeID;
    private int controllerID;
    private String partitionName;
    private List ncSlices = new ArrayList();
    private List usedWCIs = new ArrayList();
    private boolean isPartOfAnUpgrade = false;

    RSMPartitionMembershipDescriptor() {
    }

    public RSMPartitionMembershipDescriptor(int cnodeID, int controllerID) {
        this.cnodeID = cnodeID;
        this.controllerID = controllerID;
    }

    public RSMPartitionMembershipDescriptor(int cnodeID, int controllerID, String partitionName, List ncSlices) {
        this(cnodeID, controllerID);
        this.partitionName = partitionName;
        this.ncSlices = ncSlices;
    }

    public RSMPartitionMembershipDescriptor(int cnodeID, int controllerID, String partitionName, List ncSlices, boolean isPartOfUpgrade) {
        this(cnodeID, controllerID, partitionName, ncSlices);
        this.isPartOfAnUpgrade = isPartOfUpgrade;
    }

    public final void addNCSlice(int sliceID, boolean isSmall) {
        NCSlice newSlice = null;
        class Com_sun_wildcat_fabric_management_common_RSMPartitionMembershipDescriptor$1 {
            /* synthetic */ Com_sun_wildcat_fabric_management_common_RSMPartitionMembershipDescriptor$1() {
            }
        }
        newSlice = new NCSlice(null, sliceID, isSmall ? 0 : 1);
        if (this.ncSlices == null) {
            this.ncSlices = new ArrayList(2);
        }
        this.ncSlices.add(newSlice);
    }

    public void addWCI(WCI wci) {
        this.usedWCIs.add(wci);
    }

    public void addWCI(List wcis) {
        this.usedWCIs.addAll(wcis);
    }

    public final int getCnodeID() {
        return this.cnodeID;
    }

    public final int getControllerID() {
        return this.controllerID;
    }

    public final List getExportedNCSlices() {
        return this.ncSlices;
    }

    public int getExportedSliceCount() {
        if (this.ncSlices != null) {
            return this.ncSlices.size();
        }
        return 0;
    }

    public final int[] getNCSlices() {
        int sz = this.ncSlices.size();
        int[] rv = new int[sz];
        int i = 0;
        while (i < sz) {
            NCSlice slice = (NCSlice)this.ncSlices.get(i);
            rv[i] = slice.sliceID;
            ++i;
        }
        return rv;
    }

    public final String getPartitionName() {
        return this.partitionName;
    }

    public WCI[] getWCIArray() {
        WCI[] wcis = new WCI[this.usedWCIs.size()];
        wcis = this.usedWCIs.toArray(wcis);
        return wcis;
    }

    public List getWCIList() {
        return this.usedWCIs;
    }

    public boolean isPartOfAnUpgrade() {
        return this.isPartOfAnUpgrade;
    }

    public final void removeAllNCSlices() {
        this.ncSlices = new ArrayList();
    }

    public void removeWCI(List wcis) {
        if (wcis == null) {
            return;
        }
        int numWCIs = wcis.size();
        int i = 0;
        while (i < numWCIs) {
            WCI wci = (WCI)wcis.get(i);
            this.usedWCIs.remove(this.usedWCIs.indexOf(wci));
            ++i;
        }
    }

    public final void setCnodeID(int cnodeID) {
        this.cnodeID = cnodeID;
    }

    public final void setControllerID(int controllerID) {
        this.controllerID = controllerID;
    }

    public final void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public void setWCI(WCI wci) {
        this.usedWCIs.clear();
        this.usedWCIs.add(wci);
    }

    public void setWCI(List wcis) {
        this.usedWCIs.clear();
        this.usedWCIs.addAll(wcis);
    }

    public final void unexportNCMemorySlice(int sliceID) throws NoSuchNCSliceError {
        NCSlice deleteSlice = new NCSlice(null, sliceID, 1);
        int index = this.ncSlices.indexOf(deleteSlice);
        if (index == -1) {
            throw new NoSuchNCSliceError(String.valueOf(sliceID));
        }
        this.ncSlices.remove(index);
    }

    public class NCSlice
    implements Serializable {
        public int sliceID;
        public int pageSize;
        public static final int SMALL_PAGE = 0;
        public static final int LARGE_PAGE = 1;

        private NCSlice(int sliceID, int pageSize) {
            this.sliceID = sliceID;
            this.pageSize = pageSize;
        }

        /* synthetic */ NCSlice(1 $0, int $1, int $2) {
            this($1, $2);
        }

        public boolean equals(Object thatObj) {
            boolean result = false;
            if (thatObj == null) {
                result = false;
            } else if (this == thatObj) {
                result = true;
            } else if (this.getClass() == thatObj.getClass()) {
                NCSlice that = (NCSlice)thatObj;
                result = this.sliceID == that.sliceID;
            }
            return result;
        }

        public boolean isSmallPage() {
            return this.pageSize == 0;
        }
    }
}

