/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.RSMPartitionMembershipDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RSMMember
implements Serializable {
    private String solarisHostname;
    private String proxyUsername;
    private String proxyPassword;
    private List partitionMemberDescriptors = new ArrayList();
    private boolean isGlobalDomain;

    public RSMMember() {
    }

    public RSMMember(String solarisHostname) {
        this.solarisHostname = solarisHostname;
    }

    public final void addMemberToPartition(RSMPartitionMembershipDescriptor rsmPMD) {
        this.partitionMemberDescriptors.add(rsmPMD);
    }

    public final void addMemberToPartition(List rsmPMDs) {
        this.partitionMemberDescriptors.addAll(rsmPMDs);
    }

    public void addRSMWCIs(List wcis, String partName) {
        RSMPartitionMembershipDescriptor part = this.getRSMDescriptor(partName);
        if (part != null) {
            part.addWCI(wcis);
        }
    }

    int getCnodeID(int controllerID) {
        int size = this.partitionMemberDescriptors.size();
        RSMPartitionMembershipDescriptor descriptor = null;
        int cnode = -1;
        int i = 0;
        while (i < size) {
            descriptor = (RSMPartitionMembershipDescriptor)this.partitionMemberDescriptors.get(i);
            if (controllerID == descriptor.getControllerID()) {
                cnode = descriptor.getCnodeID();
                break;
            }
            ++i;
        }
        return cnode;
    }

    boolean getGlobalDomain() {
        return this.isGlobalDomain;
    }

    public final int getPartitionDescriptorCount() {
        return this.partitionMemberDescriptors.size();
    }

    public final String getProxyPassword() {
        return this.proxyPassword;
    }

    public final String getProxyUsername() {
        return this.proxyUsername;
    }

    private RSMPartitionMembershipDescriptor getRSMDescriptor(String name) {
        RSMPartitionMembershipDescriptor result = null;
        if (name == null) {
            return result;
        }
        int numParts = this.getPartitionDescriptorCount();
        int i = 0;
        while (i < numParts) {
            RSMPartitionMembershipDescriptor part = (RSMPartitionMembershipDescriptor)this.partitionMemberDescriptors.get(i);
            if (part.getPartitionName().equalsIgnoreCase(name)) {
                result = part;
                break;
            }
            ++i;
        }
        return result;
    }

    public RSMPartitionMembershipDescriptor getRSMPartitionMembershipDescriptor(String partitionName) {
        int numMemberDescrs = this.partitionMemberDescriptors.size();
        int i = 0;
        while (i < numMemberDescrs) {
            RSMPartitionMembershipDescriptor desc = (RSMPartitionMembershipDescriptor)this.partitionMemberDescriptors.get(i);
            if (desc.getPartitionName().equalsIgnoreCase(partitionName)) {
                return desc;
            }
            ++i;
        }
        return null;
    }

    public final List getRSMPartitionMembershipDescriptors() {
        return this.partitionMemberDescriptors;
    }

    public final String getSolarisHostname() {
        return this.solarisHostname;
    }

    public List getWCIList() {
        int numParts = this.getPartitionDescriptorCount();
        ArrayList usedWCIs = new ArrayList();
        int i = 0;
        while (i < numParts) {
            RSMPartitionMembershipDescriptor part = (RSMPartitionMembershipDescriptor)this.partitionMemberDescriptors.get(i);
            usedWCIs.addAll(part.getWCIList());
            ++i;
        }
        return usedWCIs;
    }

    public List getWCIList(String partName) {
        List result = null;
        if (partName == null) {
            return result;
        }
        RSMPartitionMembershipDescriptor part = this.getRSMDescriptor(partName);
        if (part != null) {
            result = part.getWCIList();
        }
        return result;
    }

    public void removeFromPartition(int controllerID) {
        int numMemberDescrs = this.partitionMemberDescriptors.size();
        int i = 0;
        while (i < numMemberDescrs) {
            RSMPartitionMembershipDescriptor desc = (RSMPartitionMembershipDescriptor)this.partitionMemberDescriptors.get(i);
            if (desc.getControllerID() == controllerID) {
                this.partitionMemberDescriptors.remove(i);
                break;
            }
            ++i;
        }
    }

    public void removeFromPartition(String partitionName) {
        int numMemberDescrs = this.partitionMemberDescriptors.size();
        int i = 0;
        while (i < numMemberDescrs) {
            RSMPartitionMembershipDescriptor desc = (RSMPartitionMembershipDescriptor)this.partitionMemberDescriptors.get(i);
            if (desc.getPartitionName().equalsIgnoreCase(partitionName)) {
                this.partitionMemberDescriptors.remove(i);
                break;
            }
            ++i;
        }
    }

    public void removeRSMWCIs(List wcis, String partName) {
        RSMPartitionMembershipDescriptor part = this.getRSMDescriptor(partName);
        if (part != null) {
            part.removeWCI(wcis);
        }
    }

    void setGlobalDomain(boolean isGlobalDomain) {
        this.isGlobalDomain = isGlobalDomain;
    }

    public final void setMemberToPartition(RSMPartitionMembershipDescriptor rsmPMD) {
        this.partitionMemberDescriptors.clear();
        this.partitionMemberDescriptors.add(rsmPMD);
    }

    public final void setMemberToPartition(List rsmPMDs) {
        this.partitionMemberDescriptors.clear();
        this.partitionMemberDescriptors.addAll(rsmPMDs);
    }

    public final void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public final void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setRSMWCIs(List wcis, String partName) {
        RSMPartitionMembershipDescriptor part = this.getRSMDescriptor(partName);
        if (part != null) {
            part.setWCI(wcis);
        }
    }

    public final void setSolarisHostname(String solarisHostname) {
        this.solarisHostname = solarisHostname;
    }
}

