/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.MessageLog;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;

public final class RMILookupUtils {
    private static final String CLASS_NAME = "com.sun.wildcat.fabric_management.common.RMILookupUtils";
    public static final int REGISTRY_PORT = 1099;

    private RMILookupUtils() {
    }

    public static Remote getRemoteObject(String url) throws NotBoundException, MalformedURLException, RemoteException {
        Remote result = null;
        String local = "com.sun.wildcat.fabric_management.common.RMILookupUtils.getRemoteObject(String)\n";
        try {
            result = Naming.lookup(url);
            MessageLog.getInstance().logMessage(String.valueOf(local) + "FOUND Object [" + url + "]", MessageLog.HIGH);
        }
        catch (NotBoundException nbe) {
            MessageLog.getInstance().logMessage(String.valueOf(local) + "Object not bound to registry [" + url + "]", MessageLog.ERROR);
            throw nbe;
        }
        catch (MalformedURLException mue) {
            MessageLog.getInstance().logMessage(String.valueOf(local) + "Malformed URL [" + url + "]", MessageLog.ERROR);
            throw mue;
        }
        catch (RemoteException re) {
            MessageLog.getInstance().logMessage(String.valueOf(local) + "Remote Exception [" + url + "]", MessageLog.ERROR);
            throw re;
        }
        return result;
    }

    public static Remote getRemoteObject(String host, int port, String lkupName) throws NotBoundException, MalformedURLException, RemoteException {
        String url = "rmi://" + host + ":" + port + "/" + lkupName;
        return RMILookupUtils.getRemoteObject(url);
    }

    public static Remote getRemoteObject(String host, String lkupName) throws NotBoundException, MalformedURLException, RemoteException {
        String url = "rmi://" + host + ":" + 1099 + "/" + lkupName;
        return RMILookupUtils.getRemoteObject(url);
    }
}

