/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.Inventory;
import com.sun.wildcat.fabric_management.common.NodeData;
import com.sun.wildcat.fabric_management.common.ReserveLink;
import com.sun.wildcat.fabric_management.common.ReserveWCI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PartitionData
implements Serializable {
    public static final String CENTRAL_SWITCH = "CentralSwitch";
    public static final String DIRECT_CONNECT = "DirectConnect";
    public static final String WCIX_SWITCH = "WcixSwitch";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String SSM = "SSM";
    public static final String RSM = "RSM";
    public static final String[] TOPOLOGY_TYPES = new String[]{"CentralSwitch", "DirectConnect", "WcixSwitch"};
    public static final String[] PARTITION_TYPES = new String[]{"UNKNOWN", "SSM", "RSM"};
    private String name;
    private String topology;
    private String partitionType;
    private int partitionID = -1;
    private int linkStripingLevel = 1;
    private int wciStripingLevel = 1;
    private int desiredLinkStripingLevel = -1;
    private int desiredWciStripingLevel = -1;
    private List nodeData = new ArrayList();
    private List nodesToRemove = new ArrayList();
    private StringBuffer discoveryData;
    private StringBuffer privateData = new StringBuffer();
    private boolean usePrivateDataInBuild = false;

    public PartitionData() {
    }

    public PartitionData(String name) {
        this.name = name;
    }

    public PartitionData(String name, int topology) {
        this(name);
        this.topology = PartitionData.mapTopologyType(topology);
    }

    public PartitionData(String name, int topology, int partitionType) {
        this(name, topology);
        this.partitionType = PartitionData.mapPartitionType(partitionType);
    }

    public PartitionData(String name, int topology, int partitionType, int linkStripingLevel, int wciStripingLevel) {
        this(name, topology, partitionType);
        this.linkStripingLevel = linkStripingLevel;
        this.wciStripingLevel = wciStripingLevel;
    }

    public PartitionData(String name, String topology) {
        this(name);
        this.topology = topology;
    }

    public PartitionData(String name, String topology, String partitionType) {
        this(name, topology);
        this.partitionType = partitionType;
    }

    public PartitionData(String name, String topology, String partitionType, int linkStripingLevel, int wciStripingLevel) {
        this(name, topology, partitionType);
        this.linkStripingLevel = linkStripingLevel;
        this.wciStripingLevel = wciStripingLevel;
    }

    public final void addNodeData(NodeData node) {
        this.nodeData.add(node);
    }

    public final void addNodeData(List nodeData) {
        this.nodeData.addAll(nodeData);
    }

    public final void addNodeToRemove(NodeData node) {
        this.nodesToRemove.add(node);
    }

    public final void addNodesToRemove(List nodesToRemove) {
        this.nodesToRemove.addAll(nodesToRemove);
    }

    public final void appendPrivateData(String data) {
        this.privateData.append(data);
    }

    public boolean containsNode(NodeData node) {
        NodeData currentNode = null;
        boolean result = false;
        int i = 0;
        while (i < this.nodeData.size()) {
            currentNode = (NodeData)this.nodeData.get(i);
            if (currentNode.equals(node)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public NodeData findNode(String scName, String scDomain) {
        NodeData currentNode = null;
        int i = 0;
        while (i < this.nodeData.size()) {
            currentNode = (NodeData)this.nodeData.get(i);
            if (scName.equals(currentNode.getSCHost()) && (scDomain == null && currentNode.getSCDomain() == null || scDomain.equals(currentNode.getSCDomain()))) {
                return currentNode;
            }
            ++i;
        }
        return null;
    }

    public ReserveLink[] getAdditionalLinks(ReserveLink[] currentLinks) {
        HashSet<ReserveLink> addLinks = new HashSet<ReserveLink>();
        int numNodes = this.nodeData == null ? 0 : this.nodeData.size();
        int i = 0;
        while (i < numNodes) {
            NodeData node = (NodeData)this.nodeData.get(i);
            ReserveLink[] nodeLinks = node.getInventory().getReservedLinks(this.name);
            int numReserveLinks = nodeLinks == null ? 0 : nodeLinks.length;
            int j = 0;
            while (j < numReserveLinks) {
                ReserveLink link = nodeLinks[j];
                if (!this.linkInList(currentLinks, link)) {
                    addLinks.add(link);
                }
                ++j;
            }
            ++i;
        }
        return addLinks.toArray(new ReserveLink[0]);
    }

    public ReserveWCI[] getAdditionalWCIs(ReserveWCI[] currentWCIs) {
        HashSet<ReserveWCI> addWCIs = new HashSet<ReserveWCI>();
        int numNodes = this.nodeData == null ? 0 : this.nodeData.size();
        int i = 0;
        while (i < numNodes) {
            NodeData node = (NodeData)this.nodeData.get(i);
            ReserveWCI[] nodeWCIs = node.getInventory().getReservedWcis(this.name);
            int numReserveWCIs = nodeWCIs == null ? 0 : nodeWCIs.length;
            int j = 0;
            while (j < numReserveWCIs) {
                ReserveWCI wci = nodeWCIs[j];
                if (!this.wciInList(currentWCIs, wci)) {
                    addWCIs.add(wci);
                }
                ++j;
            }
            ++i;
        }
        return addWCIs.toArray(new ReserveWCI[0]);
    }

    public final int getDesiredLinkStripingLevel() {
        return this.desiredLinkStripingLevel;
    }

    public final int getDesiredWCIStripingLevel() {
        return this.desiredWciStripingLevel;
    }

    public final String getDiscoveryData() {
        String result = null;
        if (this.discoveryData != null) {
            result = this.discoveryData.toString();
        }
        return result;
    }

    public final int getLinkStripingLevel() {
        return this.linkStripingLevel;
    }

    public final String getName() {
        return this.name;
    }

    public final List getNodeData() {
        return this.nodeData;
    }

    public String[] getNodeNames(boolean computeNodes) {
        int numNodes = this.nodeData.size();
        ArrayList<String> lst = new ArrayList<String>(numNodes);
        int i = 0;
        while (i < numNodes) {
            NodeData node = (NodeData)this.nodeData.get(i);
            if (computeNodes) {
                if (node.getSCDomain() != null) {
                    lst.add(node.getFullNodeName());
                }
            } else if (node.getSCDomain() == null) {
                lst.add(node.getFullNodeName());
            }
            ++i;
        }
        return lst.toArray(new String[lst.size()]);
    }

    public final List getNodesToRemove() {
        int nodeCount = this.nodesToRemove.size();
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < nodeCount) {
            NodeData node = (NodeData)this.nodesToRemove.get(i);
            result.add(String.valueOf(node.getSCHost()) + ":" + node.getSCDomain());
            ++i;
        }
        return result;
    }

    public final int getPartitionID() {
        return this.partitionID;
    }

    public final String getPartitionType() {
        return this.partitionType.toUpperCase();
    }

    public final int getPartitionTypeAsInt() {
        return PartitionData.getPartitionTypeAsInt(this.partitionType);
    }

    public static int getPartitionTypeAsInt(String pType) {
        int result = 0;
        if (SSM.equalsIgnoreCase(pType)) {
            result = 1;
        } else if (RSM.equalsIgnoreCase(pType)) {
            result = 2;
        }
        return result;
    }

    public final StringBuffer getPrivateData() {
        return this.privateData;
    }

    public ReserveLink[] getRemovableLinks(ReserveLink[] currentLinks) {
        ArrayList<ReserveLink> removeableLinks = new ArrayList<ReserveLink>();
        int i = 0;
        while (i < currentLinks.length) {
            ReserveLink link = currentLinks[i];
            if (!this.linkInReserveList(link)) {
                removeableLinks.add(link);
            }
            ++i;
        }
        return removeableLinks.toArray(new ReserveLink[0]);
    }

    public ReserveWCI[] getRemovableWCIs(ReserveWCI[] currentWCIs) {
        ArrayList<ReserveWCI> removeableWCIs = new ArrayList<ReserveWCI>();
        int numCurrentWCIs = currentWCIs == null ? 0 : currentWCIs.length;
        int i = 0;
        while (i < numCurrentWCIs) {
            ReserveWCI wci = currentWCIs[i];
            if (!this.wciInReserveList(wci)) {
                removeableWCIs.add(wci);
            }
            ++i;
        }
        return removeableWCIs.toArray(new ReserveWCI[0]);
    }

    public final String getTopology() {
        return this.topology;
    }

    public final int getTopologyAsInt() {
        return PartitionData.getTopologyAsInt(this.topology);
    }

    public static final int getTopologyAsInt(String topo) {
        int result = 0;
        if (CENTRAL_SWITCH.equalsIgnoreCase(topo)) {
            result = 0;
        } else if (DIRECT_CONNECT.equalsIgnoreCase(topo)) {
            result = 1;
        } else if (WCIX_SWITCH.equalsIgnoreCase(topo)) {
            result = 2;
        }
        return result;
    }

    public boolean getUsePrivateDataInBuild() {
        return this.usePrivateDataInBuild;
    }

    public final int getWCIStripingLevel() {
        return this.wciStripingLevel;
    }

    private boolean linkInList(ReserveLink[] links, ReserveLink link) {
        boolean result = false;
        int numLinks = links == null ? 0 : links.length;
        int i = 0;
        while (i < numLinks) {
            if (links[i].equals(link)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean linkInReserveList(ReserveLink link) {
        boolean result = false;
        if (link == null) {
            return result;
        }
        NodeData nodeA = this.findNode(link.getSCNameA(), link.getSCDomainA());
        NodeData nodeB = this.findNode(link.getSCNameB(), link.getSCDomainB());
        ReserveLink[] ReserveLinksA = nodeA.getInventory().getReservedLinks(this.name);
        ReserveLink[] ReserveLinksB = nodeB.getInventory().getReservedLinks(this.name);
        return this.linkInList(ReserveLinksA, link) && this.linkInList(ReserveLinksB, link);
    }

    public static String mapPartitionType(int partitionType) {
        String result = UNKNOWN;
        if (partitionType >= 0 && partitionType < PARTITION_TYPES.length) {
            result = PARTITION_TYPES[partitionType];
        }
        return result;
    }

    public static String mapTopologyType(int topologyType) {
        String result = UNKNOWN;
        if (topologyType >= 0 && topologyType < TOPOLOGY_TYPES.length) {
            result = TOPOLOGY_TYPES[topologyType];
        }
        return result;
    }

    public final void removeDiscoveryData() {
        this.discoveryData = null;
    }

    public final void setDesiredLinkStripingLevel(int linkStripingLevel) {
        this.desiredLinkStripingLevel = linkStripingLevel;
    }

    public final void setDesiredWCIStripingLevel(int wciStripingLevel) {
        this.desiredWciStripingLevel = wciStripingLevel;
    }

    public final void setDiscoveryData(StringBuffer discoveryData) {
        this.discoveryData = discoveryData;
    }

    public final void setLinkStripingLevel(int linkStripingLevel) {
        this.linkStripingLevel = linkStripingLevel;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setNodeData(List nodeData) {
        if (nodeData != null) {
            this.nodeData = nodeData;
        }
    }

    public final void setNodesToRemove(List nodesToRemove) {
        if (nodesToRemove != null) {
            this.nodesToRemove = nodesToRemove;
        }
    }

    public final void setPartitionID(int partitionID) {
        this.partitionID = partitionID;
    }

    public final void setPartitionType(int partitionType) {
        this.partitionType = PartitionData.mapPartitionType(partitionType);
    }

    public final void setPartitionType(String partitionType) {
        this.partitionType = partitionType;
    }

    public final void setPrivateData(String data) {
        if (data == null) {
            this.privateData = null;
        } else {
            this.privateData.replace(0, this.privateData.length(), data);
        }
    }

    public final void setPrivateData(String data, boolean usePrivateDataInBuild) {
        this.setPrivateData(data);
        this.usePrivateDataInBuild = usePrivateDataInBuild;
    }

    public final void setTopology(int topology) {
        this.topology = PartitionData.mapTopologyType(topology);
    }

    public final void setTopology(String topology) {
        this.topology = topology;
    }

    public void setUsePrivateDataInBuild(boolean usePrivateDataInBuild) {
        this.usePrivateDataInBuild = usePrivateDataInBuild;
    }

    public final void setWCIStripingLevel(int wciStripingLevel) {
        this.wciStripingLevel = wciStripingLevel;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentTabs) {
        int j = 0;
        StringBuffer buf = new StringBuffer();
        String tabs = "";
        while (j < indentTabs) {
            tabs = String.valueOf(tabs) + "\t";
            ++j;
        }
        buf.append(String.valueOf(tabs) + "Partition \"" + this.name + "\" [" + this.partitionID + "] " + "is a " + this.topology + " " + this.partitionType + " with striping: link = " + this.linkStripingLevel + " WCI = " + this.wciStripingLevel + "\n");
        int numNodes = this.nodeData.size();
        int i = 0;
        while (i < numNodes) {
            NodeData node = (NodeData)this.nodeData.get(i);
            buf.append(String.valueOf(tabs) + "\tMember " + i + ": " + node);
            ++i;
        }
        buf.append(String.valueOf(tabs) + "\tPrivate Data String: " + this.privateData.toString() + "\n");
        return buf.toString();
    }

    public void updateStripingLevels() {
        if (this.desiredLinkStripingLevel != -1) {
            this.linkStripingLevel = this.desiredLinkStripingLevel;
        }
        if (this.desiredWciStripingLevel != -1) {
            this.wciStripingLevel = this.desiredWciStripingLevel;
        }
        this.desiredLinkStripingLevel = -1;
        this.desiredWciStripingLevel = -1;
    }

    private boolean wciInList(ReserveWCI[] wcis, ReserveWCI wci) {
        boolean result = false;
        int numWCIs = wcis == null ? 0 : wcis.length;
        int i = 0;
        while (i < numWCIs) {
            if (wcis[i].equals(wci)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean wciInReserveList(ReserveWCI wci) {
        boolean result = false;
        if (wci == null) {
            return result;
        }
        NodeData node = this.findNode(wci.getSCName(), wci.getSCDomain());
        if (node == null) {
            return result;
        }
        Inventory inventory = node.getInventory();
        ReserveWCI[] reserveWCIs = inventory.getReservedWcis(this.name);
        return this.wciInList(reserveWCIs, wci);
    }
}

