/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.Inventory;
import com.sun.wildcat.fabric_management.common.MessageLog;
import com.sun.wildcat.fabric_management.common.Node;
import com.sun.wildcat.fabric_management.security.PasswordCredHandler;
import java.io.Serializable;
import java.util.Map;

public class NodeData
implements Serializable {
    private String scHost;
    private String scDomain;
    private String scUserName;
    private String scPassword;
    private String chassisType;
    private String info;
    private String solarisHostname;
    private String proxyUsername;
    private String proxyPassword;
    private long fmNodeID = -1L;
    private Inventory inventory = new Inventory();
    private Map properties;

    public NodeData() {
    }

    public NodeData(String scHost) {
        this.scHost = scHost;
    }

    public NodeData(String scHost, String scDomain) {
        this.scHost = scHost;
        this.scDomain = scDomain;
    }

    public NodeData(String scHost, String scDomain, long fmNodeID) {
        this(scHost, scDomain);
        this.fmNodeID = fmNodeID;
    }

    public NodeData(String scHost, String scDomain, String scUserNameAndPassword) {
        this(scHost, scDomain);
        String local = String.valueOf(this.getClass().getName()) + ".NodeData(String, String, String)\n";
        this.scUserName = Node.getSCUserName(scUserNameAndPassword);
        this.scPassword = Node.getSCPassword(scUserNameAndPassword);
    }

    public NodeData(String scHost, String scDomain, String solarisHostname, int fmNodeID) {
        this(scHost, scDomain, solarisHostname);
        this.fmNodeID = fmNodeID;
    }

    public NodeData(String scHost, String scDomain, String scUserNameAndPassword, int chassisType, String info) {
        this(scHost, scDomain, scUserNameAndPassword);
        this.chassisType = Node.mapChassisString(chassisType);
        this.info = info;
    }

    public NodeData(String scHost, String scDomain, String scUserNameAndPassword, int chassisType, String info, String solarisHostname, String proxyUserNameAndPassword, Map props) {
        this(scHost, scDomain, scUserNameAndPassword, chassisType, info);
        this.solarisHostname = solarisHostname;
        this.proxyUsername = Node.getProxyUsername(proxyUserNameAndPassword);
        this.proxyPassword = Node.getProxyPassword(proxyUserNameAndPassword);
        this.properties = props;
    }

    public NodeData(String scHost, String scDomain, String scUserNameAndPassword, int chassisType, String info, String solarisHostname, Map props) {
        this(scHost, scDomain, scUserNameAndPassword, chassisType, info);
        this.solarisHostname = solarisHostname;
        this.properties = props;
    }

    public NodeData(String scHost, String scDomain, String scUserName, String scPassword) {
        this(scHost, scDomain);
        this.scUserName = scUserName;
        this.scPassword = scPassword;
    }

    public NodeData(String scHost, String scDomain, String scUserName, String scPassword, int chassisType, String info, long fmNodeID, String solarisHostname, Map props) {
        this(scHost, scDomain, scUserName, scPassword);
        this.chassisType = Node.mapChassisString(chassisType);
        this.info = info;
        this.fmNodeID = fmNodeID;
        this.solarisHostname = solarisHostname;
        this.properties = props;
    }

    public NodeData(String scHost, String scDomain, String scUserNameAndPassword, String chassisType, String info) {
        this(scHost, scDomain, scUserNameAndPassword);
        this.chassisType = chassisType;
        this.info = info;
    }

    public NodeData(String scHost, String scDomain, String scUserName, String scPassword, String chassisType, String info, long fmNodeID, String solarisHostname, String proxyUsername, String proxyPassword, Map props) {
        this(scHost, scDomain, scUserName, scPassword);
        this.chassisType = chassisType;
        this.info = info;
        this.fmNodeID = fmNodeID;
        this.solarisHostname = solarisHostname;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.properties = props;
    }

    public NodeData(String scHost, String scDomain, String scUserName, String scPassword, String chassisType, String info, long fmNodeID, String solarisHostname, Map props) {
        this(scHost, scDomain, scUserName, scPassword);
        this.chassisType = chassisType;
        this.info = info;
        this.fmNodeID = fmNodeID;
        this.solarisHostname = solarisHostname;
        this.properties = props;
    }

    public NodeData(String scHost, String scDomain, String scUserNameAndPassword, String chassisType, String info, String solarisHostname, String proxyUserNameAndPassword, Map props) {
        this(scHost, scDomain, scUserNameAndPassword, chassisType, info);
        this.solarisHostname = solarisHostname;
        this.proxyUsername = Node.getProxyUsername(proxyUserNameAndPassword);
        this.proxyPassword = Node.getProxyPassword(proxyUserNameAndPassword);
        this.properties = props;
    }

    public NodeData(String scHost, String scDomain, String scUserNameAndPassword, String chassisType, String info, String solarisHostname, Map props) {
        this(scHost, scDomain, scUserNameAndPassword, chassisType, info);
        this.solarisHostname = solarisHostname;
        this.properties = props;
    }

    public NodeData(String scHost, String scDomain, StringBuffer solarisHostname) {
        this(scHost, scDomain);
        this.solarisHostname = solarisHostname.toString();
    }

    public void cacheLoginData() {
        try {
            PasswordCredHandler.instance().addPassword(this.scHost, this.scDomain, this.scUserName, this.scPassword);
            if (this.solarisHostname != null) {
                PasswordCredHandler.instance().addPassword(this.solarisHostname, null, this.proxyUsername, this.proxyPassword);
            }
        }
        catch (Exception exception) {
            MessageLog.getInstance().logMessage("NodeData.cacheLoginData() could not add security info to filenode sc and domain/solaris host name is [" + this.scHost + ":" + this.scDomain + "]", MessageLog.ERROR);
        }
    }

    public boolean equals(Object thatObject) {
        boolean result = false;
        if (this == thatObject) {
            return true;
        }
        if (thatObject != null && this.getClass() == thatObject.getClass()) {
            NodeData that = (NodeData)thatObject;
            result = (this.scHost == null && that.getSCHost() == null || this.scHost != null && this.scHost.equalsIgnoreCase(that.getSCHost())) && (this.scDomain == null && that.getSCDomain() == null || this.scDomain != null && this.scDomain.equalsIgnoreCase(that.getSCDomain()));
        }
        return result;
    }

    public final String getChassisType() {
        return this.chassisType;
    }

    public final long getFMNodeID() {
        return this.fmNodeID;
    }

    public final String getFMNodeIDString() {
        return String.valueOf(this.fmNodeID);
    }

    public String getFullNodeName() {
        return String.valueOf(this.scHost) + ":" + this.scDomain;
    }

    public final String getInfo() {
        return this.info;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public final Map getProperties() {
        return this.properties;
    }

    public final String getProxyPassword() {
        return this.proxyPassword;
    }

    public final String getProxyUsername() {
        return this.proxyUsername;
    }

    public final String getSCDomain() {
        return this.scDomain;
    }

    public final String getSCHost() {
        return this.scHost;
    }

    public final String getSCPassword() {
        return this.scPassword;
    }

    public final String getSCUserName() {
        return this.scUserName;
    }

    public final String getSolarisHostname() {
        return this.solarisHostname;
    }

    public final void setChassisType(int chassisType) {
        this.chassisType = Node.mapChassisString(chassisType);
    }

    public final void setChassisType(String chassisType) {
        this.chassisType = chassisType;
    }

    public final void setFMNodeID(long fmNodeID) {
        this.fmNodeID = fmNodeID;
    }

    public final void setFMNodeID(String fmNodeID) {
        if (fmNodeID != null && fmNodeID.length() > 0) {
            this.fmNodeID = Long.parseLong(fmNodeID);
        }
    }

    public final void setInfo(String info) {
        this.info = info;
    }

    public final void setInventory(Inventory inv) {
        this.inventory = inv;
    }

    public final void setProperties(Map props) {
        this.properties = props;
    }

    public final void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public final void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public final void setSCDomain(String scDomain) {
        this.scDomain = scDomain;
    }

    public final void setSCHost(String scHost) {
        this.scHost = scHost;
    }

    public final void setSCPassword(String scPassword) {
        this.scPassword = scPassword;
    }

    public final void setSCUserName(String scUserName) {
        this.scUserName = scUserName;
    }

    public final void setSolarisHostname(String solarisHostname) {
        this.solarisHostname = solarisHostname;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentTabs) {
        String tabs = "";
        int i = 0;
        while (i < indentTabs) {
            tabs = String.valueOf(tabs) + "\t";
            ++i;
        }
        return String.valueOf(tabs) + this.scHost + ":" + this.scDomain + "  Solaris Hostname: " + this.solarisHostname + "  FM Node ID: " + this.fmNodeID + "\n" + tabs + "  SC User name: " + this.scUserName + "  Chassis Type: " + this.chassisType + "  Additional Info: " + this.info + "\n";
    }
}

