/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.common.FabricManagerException;
import com.sun.wildcat.common.ScBaseIntf;
import com.sun.wildcat.common.ScRsmIntf;
import com.sun.wildcat.common.SecurityCredential;
import com.sun.wildcat.common.SwitchBaseIntf;
import com.sun.wildcat.common.Wci;
import com.sun.wildcat.common.WciInventory;
import com.sun.wildcat.fabric_management.common.FailedCommandException;
import com.sun.wildcat.fabric_management.common.Inventory;
import com.sun.wildcat.fabric_management.common.MessageLog;
import com.sun.wildcat.fabric_management.common.NodeDataInterface;
import com.sun.wildcat.fabric_management.common.RMILkupSettings;
import com.sun.wildcat.fabric_management.common.RMILookupUtils;
import com.sun.wildcat.fabric_management.common.RSMMember;
import com.sun.wildcat.fabric_management.common.RSMPartitionMembershipDescriptor;
import com.sun.wildcat.fabric_management.common.SSMMember;
import com.sun.wildcat.fabric_management.common.WCI;
import com.sun.wildcat.fabric_management.common.WciDataInterface;
import com.sun.wildcat.fabric_management.security.PasswordCredHandler;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;

public class Node
extends Inventory
implements Serializable,
NodeDataInterface {
    private static final long DEFAULT_FM_NODE_ID = -1L;
    public static final NodeMode NONE;
    public static final NodeMode SSM;
    public static final NodeMode RSM;
    public static final NodeMode RSM_SSM;
    public static final NodeType UNKNOWN;
    public static final NodeType S72;
    public static final NodeType S72_CENTRAL_SWITCH;
    public static final NodeType S24;
    public static final NodeType S12;
    public static final NodeType S12_DESK_SIDE;
    public static final NodeType S8;
    public static final NodeType WCIX_SWITCH;
    public static final String scNameDomainSeparator = ":";
    public static final String scUserPasswordSeparator = ":";
    public static final String proxyUserPasswordSeparator = ":";
    private static final String wciSlotAndIDSeparator = ":";
    private String scName;
    private String scDomain;
    private String scUserName;
    private String scPassword;
    private NodeType type = UNKNOWN;
    private NodeMode mode = NONE;
    private long fmNodeID = -1L;
    private SSMMember ssmMembershipData;
    private RSMMember rsmMembershipData;
    private String info = "Use this field to store any type of character information";
    private boolean simulationEnabled = false;
    private boolean resetNodes = true;
    private boolean isMaster = false;
    private transient RMILkupSettings rmiSettings;
    private Map properties;
    public static final String CONFIG_REMOVE_ERROR_MSG = "ERROR Could not delete configuration on ";
    public static final int SC_MAX_DISCOVERY_LINK_TIME = 10;
    public static final int SSC_MAX_DISCOVERY_LINK_TIME = 10;
    public static final int SCSC_MAX_DISCOVERY_LINK_TIME = 10;
    public static final int SC_MAX_LINK_COUNT = 8;
    public static final int SSC_MAX_LINK_COUNT = 8;
    public static final int SCSC_MAX_LINK_COUNT = 16;
    public static final int SC_MAX_SC_LKUP_TIME = 20;
    public static final int SSC_MAX_SC_LKUP_TIME = 20;
    public static final int SCSC_MAX_SC_LKUP_TIME = 20;

    static {
        class Com_sun_wildcat_fabric_management_common_Node$1 {
            /* synthetic */ Com_sun_wildcat_fabric_management_common_Node$1() {
            }
        }
        NONE = new NodeMode(null, 0);
        SSM = new NodeMode(null, 1);
        RSM = new NodeMode(null, 2);
        RSM_SSM = new NodeMode(null, 3);
        UNKNOWN = new NodeType(null, 0);
        S72 = new NodeType(null, 1);
        S72_CENTRAL_SWITCH = new NodeType(null, 2);
        S24 = new NodeType(null, 3);
        S12 = new NodeType(null, 4);
        S12_DESK_SIDE = new NodeType(null, 5);
        S8 = new NodeType(null, 6);
        WCIX_SWITCH = new NodeType(null, 7);
    }

    public Node() {
    }

    public Node(String scName, String scDomain) {
        this.scName = scName;
        this.scDomain = scDomain;
    }

    public Node(String scName, String scDomain, NodeType type, NodeMode mode) {
        this(scName, scDomain);
        this.type = type;
        this.mode = mode;
    }

    public Node(String scName, String scDomain, String scUserName, String scPassword, int chassisType, String info) {
        this.scName = scName;
        this.scDomain = scDomain;
        this.scUserName = scUserName;
        this.scPassword = scPassword;
        this.info = info;
        this.setType(chassisType);
    }

    public Node(String scName, String scDomain, String scUserName, String scPassword, int chassisType, String info, long fmNodeID) throws Exception {
        this(scName, scDomain, scUserName, scPassword, chassisType, info);
        this.setFMNodeID(fmNodeID, false);
    }

    public Node(String scName, String scDomain, String scUserName, String scPassword, int chassisType, String info, String solarisHostname) {
        this(scName, scDomain, scUserName, scPassword, chassisType, info);
        this.setSolarisHostname(solarisHostname);
    }

    public Node(String scName, String scDomain, String scUserName, String scPassword, String chassisType, String info) {
        this.scName = scName;
        this.scDomain = scDomain;
        this.scUserName = scUserName;
        this.scPassword = scPassword;
        this.info = info;
        this.setType(chassisType);
    }

    public Node(String scName, String scDomain, String scUserName, String scPassword, String chassisType, String info, long fmNodeID) throws Exception {
        this(scName, scDomain, scUserName, scPassword, chassisType, info);
        this.setFMNodeID(fmNodeID, false);
    }

    public Node(String scName, String scDomain, String scUserName, String scPassword, String chassisType, String info, String solarisHostname) {
        this(scName, scDomain, scUserName, scPassword, chassisType, info);
        this.setSolarisHostname(solarisHostname);
    }

    public Node(boolean simulationEnabled, boolean resetNodes, String scName, String scDomain) {
        this(scName, scDomain);
        this.simulationEnabled = simulationEnabled;
        this.resetNodes = resetNodes;
    }

    public final void addNCSlice(String partitionName, int ncSliceID, boolean isSmall) {
        RSMPartitionMembershipDescriptor desc = this.rsmMembershipData.getRSMPartitionMembershipDescriptor(partitionName);
        desc.addNCSlice(ncSliceID, isSmall);
    }

    private boolean addSSMWCIs(List wcis, String partName) {
        boolean result = false;
        if (this.ssmMembershipData != null && this.ssmMembershipData.getSsmID().equalsIgnoreCase(partName)) {
            this.ssmMembershipData.addWCI(wcis);
            result = true;
        }
        return result;
    }

    public static String concatProxyUsernamePassword(String username, String password) {
        return String.valueOf(username.trim()) + ":" + password.trim();
    }

    public static String concatSCNameDomain(String scName, String scDomain) {
        if (scDomain == null) {
            return scName.trim();
        }
        return String.valueOf(scName.trim()) + ":" + scDomain.trim();
    }

    private List convertWciInventory(List usedWCIs, WciInventory inv) {
        Wci[] wcis = inv.getWciList();
        ArrayList<WCI> result = new ArrayList<WCI>(wcis.length);
        int i = 0;
        while (i < wcis.length) {
            Wci wci = wcis[i];
            WCI newWci = new WCI(wci.getSafariPortId(), this.getType());
            newWci.setDimmSize(wci.getDimmSize());
            if (!this.wciInUse(newWci, usedWCIs)) {
                newWci.setMode(WCI.FREE);
                result.add(newWci);
            }
            ++i;
        }
        return result;
    }

    private void determineFMException(FabricManagerException fme, String msg, SecurityCredential cred) throws FailedCommandException {
        FailedCommandException fce = null;
        if (fme.getExceptionID() == 1) {
            if (this.type == WCIX_SWITCH) {
                String error = String.valueOf(msg) + " " + this.scName + " [ SSC Authentication Error ]";
                fce = new FailedCommandException(error, 4, "SSC Security Exception");
                fce.addDataValue("sc_name", this.scName);
                fce.addDataValue("password", cred.getPasswd());
            } else {
                String error = String.valueOf(msg) + " " + this.scName + ":" + this.scDomain + " [ SC Authentication Error ]";
                fce = new FailedCommandException(error, 3, "SC Security Exception");
                fce.addDataValue("sc_name", this.scName);
                fce.addDataValue("sc_domain", this.scDomain);
                fce.addDataValue("username", cred.getUsername());
                fce.addDataValue("password", cred.getPasswd());
            }
        } else {
            fce = fme.getExceptionID() == 0 || fme.getExceptionID() == 2 ? new FailedCommandException(String.valueOf(msg) + " " + this.scName + ":" + this.scDomain + " [ Version Incompatibility ]") : (fme.getExceptionID() == 3 ? new FailedCommandException(String.valueOf(msg) + " " + this.scName + ":" + this.scDomain + " [ FM Node ID Not Set ]") : new FailedCommandException(fme.getMessage()));
        }
        throw fce;
    }

    public final void discoverWCIs() {
    }

    public boolean equals(Object thatObj) {
        Node that;
        boolean result = false;
        if (thatObj == null) {
            result = false;
        } else if (this == thatObj) {
            result = true;
        } else if (this.scName == null) {
            result = false;
        } else if (this.getClass() == thatObj.getClass() && this.scName.equalsIgnoreCase((that = (Node)thatObj).getSCName())) {
            String domain = that.getSCDomain();
            if ((this.scDomain == null || this.scDomain.equalsIgnoreCase("null")) && (domain == null || domain.equalsIgnoreCase("null")) || this.scDomain.equalsIgnoreCase(domain)) {
                result = true;
            }
        }
        return result;
    }

    private Class[] getArgClass(Object[] args) {
        Class[] result = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            result[i] = args[i].getClass();
            ++i;
        }
        return result;
    }

    public final BitSet getAvaliableNCSlices() throws FailedCommandException, IOException, DataFormatException {
        String local = String.valueOf(this.getClass().getName()) + ".getNCSlices";
        BitSet bs = new BitSet(255);
        if (this.simulationEnabled()) {
            bs = new BitSet(255);
            int i = 167;
            while (i < 187) {
                bs.set(i);
                ++i;
            }
        } else {
            SecurityCredential cred = PasswordCredHandler.instance().createCredential(this.scName, this.scDomain, this.scUserName);
            try {
                ScRsmIntf sc = (ScRsmIntf)RMILookupUtils.getRemoteObject(this.scName, this.rmiSettings.scPort, this.rmiSettings.scLkupName);
                bs = sc.getAvailableNCslices(cred, this.scDomain);
            }
            catch (FabricManagerException fme) {
                this.determineFMException(fme, "Exception getting avaliable NC Slices for node: ", cred);
            }
            catch (RemoteException remoteException) {
                this.tossAndLogNodeRemoteException(local);
            }
            catch (NotBoundException notBoundException) {
                this.tossAndLogNodeRemoteException(local);
            }
            catch (MalformedURLException malformedURLException) {
                this.tossAndLogNodeRemoteException(local);
            }
            catch (Exception e) {
                throw new FailedCommandException(e.getMessage());
            }
        }
        return bs;
    }

    public final int getChassisType() {
        return this.type.asInt();
    }

    public int getCnodeId(int controllerID) {
        if (this.rsmMembershipData == null) {
            return -1;
        }
        return this.rsmMembershipData.getCnodeID(controllerID);
    }

    public final List getExportedNCSlices(String partitionName) {
        RSMPartitionMembershipDescriptor desc = this.rsmMembershipData.getRSMPartitionMembershipDescriptor(partitionName);
        return desc.getExportedNCSlices();
    }

    public int getExportedSliceCount(String partitionName) {
        int result = 0;
        Iterator iter = this.rsmMembershipData.getRSMPartitionMembershipDescriptors().iterator();
        while (iter.hasNext()) {
            RSMPartitionMembershipDescriptor rsmPMD = (RSMPartitionMembershipDescriptor)iter.next();
            if (!rsmPMD.getPartitionName().equalsIgnoreCase(partitionName)) continue;
            result = rsmPMD.getExportedSliceCount();
            break;
        }
        return result;
    }

    public final long getFMNodeID() {
        return this.fmNodeID;
    }

    private static String getFirstPart(String aString, String separator) {
        String result = aString.trim();
        int index = result.indexOf(separator);
        if (index < 0) {
            index = result.length();
        }
        return result.substring(0, index);
    }

    public final WciDataInterface[] getIdleWcis() {
        WciDataInterface[] wcis = new WciDataInterface[this.availableWcis.size()];
        this.availableWcis.toArray(wcis);
        return wcis;
    }

    public final WciDataInterface[] getInUseWcis() {
        List inUseWCIs = this.getInUseWcisList();
        WciDataInterface[] wcis = new WciDataInterface[inUseWCIs.size()];
        inUseWCIs.toArray(wcis);
        return wcis;
    }

    public final WciDataInterface[] getInUseWcis(String partitionName) {
        List inUseWCIs = this.getUsedWcis(partitionName);
        WciDataInterface[] wcis = new WciDataInterface[inUseWCIs.size()];
        inUseWCIs.toArray(wcis);
        return wcis;
    }

    public final List getInUseWcisList() {
        ArrayList inUseWCIs = new ArrayList();
        inUseWCIs.addAll(this.getUsedWcis());
        return inUseWCIs;
    }

    public final String getInfo() {
        return this.info;
    }

    public static final int getMaxDiscoveryLinkTime() {
        return 10;
    }

    public final int getMaxDiscoveryLinkTimeForNodeType() {
        NodeType type = this.getType();
        if (type == S72) {
            return 10;
        }
        if (type == WCIX_SWITCH) {
            return 10;
        }
        return 10;
    }

    public static final int getMaxLinkCount() {
        return 16;
    }

    public final int getMaxLinkCountForNodeType() {
        NodeType type = this.getType();
        if (type == S72) {
            return 16;
        }
        if (type == WCIX_SWITCH) {
            return 8;
        }
        return 8;
    }

    public static final int getMaxScLkupTime() {
        return 20;
    }

    public final int getMaxScLkupTimeForNodeType() {
        NodeType type = this.getType();
        if (type == S72) {
            return 20;
        }
        if (type == WCIX_SWITCH) {
            return 20;
        }
        return 20;
    }

    public final NodeMode getMode() {
        NodeMode mode = NONE;
        if (this.rsmMembershipData.getRSMPartitionMembershipDescriptors() == null || this.rsmMembershipData.getRSMPartitionMembershipDescriptors().size() > 0) {
            mode = RSM;
        }
        return mode;
    }

    public final int[] getNCSlices(String partitionName) {
        RSMPartitionMembershipDescriptor desc = this.rsmMembershipData.getRSMPartitionMembershipDescriptor(partitionName);
        return desc.getNCSlices();
    }

    public final int getNodeMode() {
        return this.getMode().asInt();
    }

    public final Map getProperties() {
        return this.properties;
    }

    public final String getProxyPassword() {
        if (this.rsmMembershipData == null) {
            return null;
        }
        return this.rsmMembershipData.getProxyPassword();
    }

    public static String getProxyPassword(String proxyUserNameAndPassword) {
        return Node.getSecondPart(proxyUserNameAndPassword, ":");
    }

    public final String getProxyUsername() {
        if (this.rsmMembershipData == null) {
            return null;
        }
        return this.rsmMembershipData.getProxyUsername();
    }

    public static String getProxyUsername(String proxyUserNameAndPassword) {
        return Node.getFirstPart(proxyUserNameAndPassword, ":");
    }

    public final RSMMember getRSMMembershipData() {
        return this.rsmMembershipData;
    }

    public RSMPartitionMembershipDescriptor getRSMPartitionMembershipDescriptor(String partitionName) {
        RSMPartitionMembershipDescriptor desc = this.rsmMembershipData.getRSMPartitionMembershipDescriptor(partitionName);
        return desc;
    }

    public List getRSMWCIs() {
        return this.rsmMembershipData.getWCIList();
    }

    public final String getSCDomain() {
        return this.scDomain;
    }

    public static String getSCDomain(String scNameDomain) {
        return Node.getSecondPart(scNameDomain, ":");
    }

    public final String getSCName() {
        return this.scName;
    }

    public static String getSCName(String scNameDomain) {
        return Node.getFirstPart(scNameDomain, ":");
    }

    public final String getSCNameAndDomain() {
        if (this.scDomain == null) {
            return this.scName.trim();
        }
        return String.valueOf(this.scName) + ":" + this.scDomain;
    }

    public final String getSCPassword() {
        return this.scPassword;
    }

    public static String getSCPassword(String scUserNameAndPassword) {
        return Node.getSecondPart(scUserNameAndPassword, ":");
    }

    public final String getSCUserName() {
        return this.scUserName;
    }

    public static String getSCUserName(String scUserNameAndPassword) {
        return Node.getFirstPart(scUserNameAndPassword, ":");
    }

    public final SSMMember getSSMMembershipData() {
        return this.ssmMembershipData;
    }

    public List getSSMWCIs() {
        return this.ssmMembershipData.getWCIList();
    }

    private static String getSecondPart(String aString, String separator) {
        String result = aString.trim();
        int index = result.indexOf(separator);
        if (index < 0) {
            return null;
        }
        return result.substring(index + 1, result.length());
    }

    public final String getSolarisHostname() {
        if (this.rsmMembershipData == null) {
            return null;
        }
        return this.rsmMembershipData.getSolarisHostname();
    }

    public final NodeType getType() {
        return this.type;
    }

    public final List getUsedWcis(String partName) {
        List result = null;
        if (this.rsmMembershipData != null) {
            result = this.rsmMembershipData.getWCIList(partName);
        }
        if (result == null && this.ssmMembershipData != null) {
            result = this.ssmMembershipData.getWCIList();
        }
        return result;
    }

    public static String getWCIID(String slotAndWciID) {
        return Node.getSecondPart(slotAndWciID, ":");
    }

    public static String getWCISlot(String slotAndWciID) {
        return Node.getFirstPart(slotAndWciID, ":");
    }

    private WciInventory getWciInventory() throws NotBoundException, MalformedURLException, RemoteException, IOException, DataFormatException {
        String local = String.valueOf(this.getClass().getName()) + ".getWciInventory";
        WciInventory inv = null;
        if (this.type == WCIX_SWITCH) {
            inv = new WciInventory();
            Wci[] wciList = new Wci[]{new Wci()};
            wciList[0].setSafariPortId(0);
            inv.setWciList(wciList);
        } else {
            SecurityCredential cred = PasswordCredHandler.instance().createCredential(this.scName, this.scDomain, this.scUserName);
            ScBaseIntf sc = (ScBaseIntf)RMILookupUtils.getRemoteObject(this.scName, this.rmiSettings.scPort, this.rmiSettings.scLkupName);
            try {
                inv = sc.getInventory(cred, this.scDomain);
            }
            catch (FabricManagerException e) {
                MessageLog.getInstance().logMessage(String.valueOf(local) + " failed:" + e.toString(), MessageLog.ERROR);
            }
        }
        return inv;
    }

    public final boolean inPartition() {
        return this.inRSM() && this.inSSM();
    }

    public final boolean inRSM() {
        return this.rsmMembershipData.getPartitionDescriptorCount() > 0;
    }

    public final boolean inSSM() {
        return this.ssmMembershipData != null;
    }

    private Object invokeMethod(Object target, String methodName, Object[] args) throws Exception {
        String local = String.valueOf(this.getClass().getName()) + ".invokeMethod()\n";
        Object result = null;
        try {
            Class[] argClasses = this.getArgClass(args);
            Class<?> targetClass = target.getClass();
            Method method = targetClass.getMethod(methodName, argClasses);
            MessageLog.getInstance().logMessage(String.valueOf(local) + method, MessageLog.HIGH);
            result = method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof InterruptedException) {
                MessageLog.getInstance().logMessage(String.valueOf(local) + "Thread Interrupted calling Method " + methodName + "  " + e, MessageLog.ERROR);
            } else {
                MessageLog.getInstance().logMessage(String.valueOf(local) + "RUN ERROR: " + e.getTargetException(), MessageLog.ERROR);
            }
            throw e;
        }
        catch (Exception e) {
            MessageLog.getInstance().logMessage(String.valueOf(local) + "RUN ERROR: " + e, MessageLog.ERROR);
            throw e;
        }
        return result;
    }

    public final boolean isMaster() {
        return this.isMaster;
    }

    public final void isMaster(boolean master) {
        this.isMaster = master;
    }

    public static String mapChassisString(int chassisType) {
        NodeType result = Node.mapChassisType(chassisType);
        return result.toString();
    }

    public static NodeType mapChassisType(int chassisType) {
        NodeType result = UNKNOWN;
        if (S72.asInt() == chassisType) {
            result = S72;
        } else if (S72_CENTRAL_SWITCH.asInt() == chassisType) {
            result = S72_CENTRAL_SWITCH;
        } else if (S24.asInt() == chassisType) {
            result = S24;
        } else if (S12.asInt() == chassisType) {
            result = S12;
        } else if (S12_DESK_SIDE.asInt() == chassisType) {
            result = S12_DESK_SIDE;
        } else if (S8.asInt() == chassisType) {
            result = S8;
        } else if (WCIX_SWITCH.asInt() == chassisType) {
            result = WCIX_SWITCH;
        }
        return result;
    }

    public static NodeType mapChassisType(String chassisType) {
        NodeType result = UNKNOWN;
        if (S72.toString().equalsIgnoreCase(chassisType)) {
            result = S72;
        } else if (S72_CENTRAL_SWITCH.toString().equalsIgnoreCase(chassisType)) {
            result = S72_CENTRAL_SWITCH;
        } else if (S24.toString().equalsIgnoreCase(chassisType)) {
            result = S24;
        } else if (S12.toString().equalsIgnoreCase(chassisType)) {
            result = S12;
        } else if (S12_DESK_SIDE.toString().equalsIgnoreCase(chassisType)) {
            result = S12_DESK_SIDE;
        } else if (S8.toString().equalsIgnoreCase(chassisType)) {
            result = S8;
        } else if (WCIX_SWITCH.toString().equalsIgnoreCase(chassisType)) {
            result = WCIX_SWITCH;
        }
        return result;
    }

    public void refreshWciInventory(List usedWCIs) {
        String local = String.valueOf(this.getClass().getName()) + ".refreshWciInventory()";
        this.setUsedWcis(usedWCIs);
        try {
            WciInventory inv = this.getWciInventory();
            this.setAvailableWcis(usedWCIs, inv);
        }
        catch (Exception exception) {
            MessageLog.getInstance().logMessage(String.valueOf(local) + " failed! for node [" + this.scName + ":" + this.scDomain + "]", MessageLog.HIGH);
        }
    }

    public final void removeFromRSM(String partitionName) {
        this.removeRSMMembershipData(partitionName);
    }

    public final void removeFromSSM() {
        this.ssmMembershipData = null;
    }

    private void removeNodeConfigs(String partitionName) throws FailedCommandException {
        String local = String.valueOf(this.getClass().getName()) + ".removeNodeConfigs(String)\n";
        String hostname = this.getSolarisHostname();
        try {
            MessageLog.getInstance().logMessage(String.valueOf(local) + "delete any previous installed configs on system " + this.scName + ":" + this.scDomain, MessageLog.LOW);
            Remote rp = RMILookupUtils.getRemoteObject(hostname, this.rmiSettings.wrsmProxyPort, this.rmiSettings.wrsmProxyLkupName);
            if (rp != null) {
                String proxyUserName = this.getProxyUsername();
                SecurityCredential proxyCred = PasswordCredHandler.instance().createCredential(hostname, null, proxyUserName);
                Object[] args = new Object[]{proxyCred};
                int[] configured = (int[])this.invokeMethod(rp, "getRsmControllers", args);
                if (configured != null) {
                    int partIndex = 0;
                    while (partIndex < configured.length) {
                        Object[] args2 = new Object[]{proxyCred, new Integer(configured[partIndex])};
                        this.invokeMethod(rp, "deleteRsmController", args2);
                        MessageLog.getInstance().logMessage(String.valueOf(local) + "remove config for partition " + configured[partIndex] + " on machine " + hostname, MessageLog.LOW);
                        ++partIndex;
                    }
                }
            }
        }
        catch (Exception e) {
            String error = CONFIG_REMOVE_ERROR_MSG + hostname + ": " + e.getMessage();
            MessageLog.getInstance().logMessage(String.valueOf(local) + error, MessageLog.ERROR);
            FailedCommandException fce = new FailedCommandException(error, 14, "Configuration Failed Exception");
            fce.addDataValue("solaris_hostname", hostname);
            fce.addDataValue("partition_name", partitionName);
            throw fce;
        }
    }

    public void removeRSMMembershipData(String partitionName) {
        RSMPartitionMembershipDescriptor desc = this.rsmMembershipData.getRSMPartitionMembershipDescriptor(partitionName);
        if (desc != null) {
            this.rsmMembershipData.getRSMPartitionMembershipDescriptors().remove(desc);
        }
    }

    private boolean removeSSMWCIs(List wcis, String partName) {
        boolean result = false;
        if (this.ssmMembershipData != null && this.ssmMembershipData.getSsmID().equalsIgnoreCase(partName)) {
            this.ssmMembershipData.removeWCI(wcis);
            result = true;
        }
        return result;
    }

    private void removeSwitchConfigs(String partitionName) throws FailedCommandException {
        String local = String.valueOf(this.getClass().getName()) + ".removeSwitchConfigs(String)\n";
        try {
            SecurityCredential cred = PasswordCredHandler.instance().createCredential(this.scName, this.scDomain, this.scUserName);
            SwitchBaseIntf ssc = (SwitchBaseIntf)RMILookupUtils.getRemoteObject(this.scName, this.rmiSettings.switchPort, this.rmiSettings.switchLkupName);
            MessageLog.getInstance().logMessage(String.valueOf(local) + "now remove configs for the switch: " + this.scName, MessageLog.LOW);
            int[] configured = ssc.getConfiguredPartitions(cred);
            if (configured != null) {
                int partIndex = 0;
                while (partIndex < configured.length) {
                    ssc.removeConfig(cred, configured[partIndex]);
                    MessageLog.getInstance().logMessage(String.valueOf(local) + "remove config for partition " + configured[partIndex] + " on machine " + this.scName, MessageLog.LOW);
                    ++partIndex;
                }
            }
        }
        catch (Exception exception) {
            String error = CONFIG_REMOVE_ERROR_MSG + this.scName;
            MessageLog.getInstance().logMessage(String.valueOf(local) + error, MessageLog.ERROR);
            FailedCommandException fce = new FailedCommandException(error, 14, "Configuration Failed Exception");
            fce.addDataValue("solaris_hostname", this.scName);
            fce.addDataValue("partition_name", partitionName);
            throw fce;
        }
    }

    public final void removeUsedWcis(List wcis, String partName) {
        if (!this.removeSSMWCIs(wcis, partName)) {
            this.rsmMembershipData.removeRSMWCIs(wcis, partName);
        }
    }

    public void resetFMNodeID() throws FailedCommandException {
        String local = String.valueOf(this.getClass().getName()) + ".resetFMNodeID()\n";
        try {
            if (!this.simulationEnabled) {
                this.setRemoteNodeFMID(-1L, false);
                MessageLog.getInstance().logMessage(String.valueOf(local) + this.getSCNameAndDomain() + "FM node ID set to " + -1L, MessageLog.HIGH);
            }
        }
        catch (FailedCommandException e) {
            MessageLog.getInstance().logMessage(String.valueOf(local) + " Unable to reset FM Node ID on " + this.getSCName() + ":" + this.getSCDomain() + " [" + this.getSolarisHostname() + "]", MessageLog.ERROR);
            throw e;
        }
    }

    private void setAvailableWcis(List usedWCIs, WciInventory inv) {
        List invList = this.convertWciInventory(usedWCIs, inv);
        this.setAvailableWcis(invList);
    }

    public final void setFMNodeID(long fmNodeID, boolean isInternalID) throws FailedCommandException {
        String local = String.valueOf(this.getClass().getName()) + ".setFMNodeID(long)\n";
        try {
            if (!this.simulationEnabled() && !isInternalID) {
                this.setRemoteNodeFMID(fmNodeID);
            }
            this.fmNodeID = fmNodeID;
            MessageLog.getInstance().logMessage(String.valueOf(local) + "FM Node ID for " + this.scName + ":" + this.scDomain + " is " + fmNodeID, MessageLog.MEDIUM);
        }
        catch (FailedCommandException fce) {
            this.fmNodeID = -1L;
            MessageLog.getInstance().logMessage(String.valueOf(local) + " Unable to set FM Node ID on " + this.getSCName() + ":" + this.getSCDomain() + " [" + this.getSolarisHostname() + "]", MessageLog.ERROR);
            throw fce;
        }
    }

    public final void setInfo(String info) {
        this.info = info;
    }

    public final void setMode(NodeMode mode) {
        this.mode = mode;
    }

    public final void setProperties(Map props) {
        this.properties = props;
    }

    public final void setProxyPassword(String pword) {
        if (this.rsmMembershipData == null) {
            this.rsmMembershipData = new RSMMember();
        }
        this.rsmMembershipData.setProxyPassword(pword);
    }

    public final void setProxyUsername(String name) {
        if (this.rsmMembershipData == null) {
            this.rsmMembershipData = new RSMMember();
        }
        this.rsmMembershipData.setProxyUsername(name);
    }

    public final void setRSMMembershipData(int cnodeID, int controllerID, String partitionName, List ncSlices, boolean isPartOfUpgrade, boolean isExternalUpdate) throws FailedCommandException {
        if (!this.simulationEnabled && this.resetNodes && isExternalUpdate && !this.inRSM()) {
            if (this.type != WCIX_SWITCH) {
                this.removeNodeConfigs(partitionName);
            } else {
                this.removeSwitchConfigs(partitionName);
            }
        }
        this.removeRSMMembershipData(partitionName);
        RSMPartitionMembershipDescriptor rsmPMD = new RSMPartitionMembershipDescriptor(cnodeID, controllerID, partitionName, ncSlices, isPartOfUpgrade);
        this.rsmMembershipData.addMemberToPartition(rsmPMD);
    }

    public final void setRSMMembershipData(RSMMember rsmMembershipData) {
        this.rsmMembershipData = rsmMembershipData;
    }

    private void setRemoteNodeFMID(long fmNodeID) throws FailedCommandException {
        this.setRemoteNodeFMID(fmNodeID, true);
    }

    private void setRemoteNodeFMID(long fmNodeID, boolean refreshInventory) throws FailedCommandException {
        String local = String.valueOf(this.getClass().getName()) + ".setRemoteNodeFMID(long, boolean)\n";
        if (this.type == WCIX_SWITCH) {
            this.setRemoteNodeFMIDSwitch(fmNodeID);
        } else {
            SecurityCredential cred = null;
            try {
                cred = PasswordCredHandler.instance().createCredential(this.scName, this.scDomain, this.scUserName);
                ScBaseIntf sc = (ScBaseIntf)RMILookupUtils.getRemoteObject(this.scName, this.rmiSettings.scPort, this.rmiSettings.scLkupName);
                long currentFMNid = sc.getFmNodeId(cred, this.scDomain);
                if (fmNodeID != currentFMNid) {
                    sc.setFmNodeId(cred, this.scDomain, fmNodeID);
                    MessageLog.getInstance().logMessage(String.valueOf(local) + "FM Node ID set to: " + fmNodeID + ", for node: " + this.scName + ":" + this.scDomain, MessageLog.LOW);
                } else {
                    MessageLog.getInstance().logMessage(String.valueOf(local) + "FM Node ID already: " + fmNodeID + ", for node: " + this.scName + ":" + this.scDomain, MessageLog.LOW);
                }
            }
            catch (FabricManagerException fme) {
                this.determineFMException(fme, "FM Node ID not set for: ", cred);
            }
            catch (RemoteException remoteException) {
                this.tossAndLogNodeRemoteException(local);
            }
            catch (NotBoundException notBoundException) {
                this.tossAndLogNodeRemoteException(local);
            }
            catch (MalformedURLException malformedURLException) {
                this.tossAndLogNodeRemoteException(local);
            }
            catch (Exception e) {
                throw new FailedCommandException(e.getMessage());
            }
        }
        if (refreshInventory) {
            this.refreshWciInventory(this.usedWcis);
        }
    }

    private void setRemoteNodeFMIDSwitch(long fmNodeID) throws FailedCommandException {
        String local = String.valueOf(this.getClass().getName()) + ".setRemoteNodeFMIDSwitch(long)\n";
        SecurityCredential cred = null;
        try {
            cred = PasswordCredHandler.instance().createCredential(this.scName, this.scDomain, this.scUserName);
            SwitchBaseIntf ssc = (SwitchBaseIntf)RMILookupUtils.getRemoteObject(this.scName, this.rmiSettings.switchPort, this.rmiSettings.switchLkupName);
            long currentFMNid = ssc.getFMNodeId(cred);
            if (fmNodeID != currentFMNid) {
                ssc.setFMNodeId(cred, fmNodeID);
                MessageLog.getInstance().logMessage(String.valueOf(local) + "FM Node ID set to: " + fmNodeID + ", for switch: " + this.scName, MessageLog.LOW);
            } else {
                MessageLog.getInstance().logMessage(String.valueOf(local) + "FM Node ID already: " + fmNodeID + ", for switch: " + this.scName, MessageLog.LOW);
            }
        }
        catch (FabricManagerException fme) {
            this.determineFMException(fme, "FM Node ID not set for switch: ", cred);
        }
        catch (RemoteException remoteException) {
            this.tossAndLogNodeRemoteException(local);
        }
        catch (NotBoundException notBoundException) {
            this.tossAndLogNodeRemoteException(local);
        }
        catch (MalformedURLException malformedURLException) {
            this.tossAndLogNodeRemoteException(local);
        }
        catch (Exception e) {
            throw new FailedCommandException(e.getMessage());
        }
    }

    public void setRmiSettings(RMILkupSettings rmiSettings) {
        this.rmiSettings = rmiSettings;
    }

    public final void setSCDomain(String scDomain) {
        this.scDomain = scDomain;
    }

    public final void setSCName(String scName) {
        this.scName = scName;
    }

    public final void setSCPassword(String scPassword) {
        this.scPassword = scPassword;
    }

    public final void setSCUserName(String scUserName) {
        this.scUserName = scUserName;
    }

    public final void setSSMMembershipData(SSMMember ssmMembershipData) {
        this.ssmMembershipData = ssmMembershipData;
    }

    private boolean setSSMWCIs(List wcis, String partName) {
        boolean result = false;
        if (this.ssmMembershipData != null && this.ssmMembershipData.getSsmID().equalsIgnoreCase(partName)) {
            this.ssmMembershipData.setWCI(wcis);
            result = true;
        }
        return result;
    }

    public void setSimulationMode(boolean enabled) {
        this.simulationEnabled = enabled;
    }

    public final void setSolarisHostname(String hostname) {
        if (this.rsmMembershipData == null) {
            this.rsmMembershipData = new RSMMember(hostname);
        } else {
            this.rsmMembershipData.setSolarisHostname(hostname);
        }
    }

    public final void setType(int type) {
        this.type = Node.mapChassisType(type);
    }

    public final void setType(NodeType type) {
        this.type = type;
    }

    public final void setType(String type) {
        this.type = Node.mapChassisType(type);
    }

    public boolean simulationEnabled() {
        return this.simulationEnabled;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentTabs) {
        StringBuffer buf = new StringBuffer();
        StringBuffer tabs = new StringBuffer();
        int i = 0;
        while (i < indentTabs) {
            tabs.append("\t");
            ++i;
        }
        buf.append(String.valueOf(String.valueOf(tabs)) + "Node: " + this.scName + ":" + this.scDomain + "\n");
        buf.append(String.valueOf(String.valueOf(tabs)) + "\t" + "SC user name: " + this.scUserName + "\n");
        buf.append(String.valueOf(String.valueOf(tabs)) + "\t" + "FM node ID  : " + this.fmNodeID + "\n");
        buf.append(String.valueOf(String.valueOf(tabs)) + "\t" + "Node type   : " + this.type + "\n");
        buf.append(String.valueOf(String.valueOf(tabs)) + "\t" + "Node mode   : " + this.mode + "\n");
        buf.append(String.valueOf(String.valueOf(tabs)) + "\t" + "Info        : " + this.info + "\n");
        List usedWcis = this.getInUseWcisList();
        int numWcis = usedWcis.size();
        Object wci = null;
        if (this.rsmMembershipData == null) {
            buf.append(String.valueOf(String.valueOf(tabs)) + "\t** Not a member of any RSM\n");
        } else {
            buf.append(String.valueOf(String.valueOf(tabs)) + "\t** RSM specific node data:\n");
            buf.append(String.valueOf(String.valueOf(tabs)) + "\t\t" + "Solaris hostname: " + this.rsmMembershipData.getSolarisHostname() + "\n");
            buf.append(String.valueOf(String.valueOf(tabs)) + "\t\t" + "Is global domain: " + this.rsmMembershipData.getGlobalDomain() + "\n");
            List partitions = this.rsmMembershipData.getRSMPartitionMembershipDescriptors();
            int numPartitions = 0;
            if (partitions != null) {
                numPartitions = partitions.size();
            }
            buf.append(String.valueOf(String.valueOf(tabs)) + "\t** Member of " + numPartitions + " RSM partitions, named:\n");
            int i2 = 0;
            while (i2 < numPartitions) {
                RSMPartitionMembershipDescriptor partition = (RSMPartitionMembershipDescriptor)partitions.get(i2);
                buf.append(String.valueOf(String.valueOf(tabs)) + "\t\t" + partition.getPartitionName());
                buf.append(" [id = " + partition.getControllerID() + "]");
                buf.append(", C node ID = " + this.getCnodeId(partition.getControllerID()) + "\n");
                ++i2;
            }
            super.toString(indentTabs);
        }
        if (this.ssmMembershipData == null) {
            buf.append(String.valueOf(String.valueOf(tabs)) + "\t** Not a member of any SSM\n");
        } else {
            buf.append(String.valueOf(String.valueOf(tabs)) + "\t** Member of " + this.ssmMembershipData.getSsmID() + " SSM\n");
            buf.append(String.valueOf(String.valueOf(tabs)) + "\t\t" + "W node ID: " + this.ssmMembershipData.getWnodeID() + "\n");
            buf.append(String.valueOf(String.valueOf(tabs)) + "\t\t" + "Is master: " + this.ssmMembershipData.getMaster() + "\n");
        }
        return buf.toString();
    }

    private void tossAndLogNodeRemoteException(String method) throws FailedCommandException {
        FailedCommandException fce = null;
        if (this.type != WCIX_SWITCH) {
            String msg = String.valueOf(method) + "Error, Unreachable Node: " + this.scName + ":" + this.scDomain;
            MessageLog.getInstance().logMessage(msg, MessageLog.ERROR);
            fce = new FailedCommandException(msg, 7, "Unreachable Node Exception");
            fce.addDataValue("sc_name", this.scName);
            fce.addDataValue("sc_domain", this.scDomain);
        } else {
            String msg = String.valueOf(method) + "Error, Unreachable Switch: " + this.scName;
            MessageLog.getInstance().logMessage(msg, MessageLog.ERROR);
            fce = new FailedCommandException(msg, 8, "Unreachable Switch Exception");
            fce.addDataValue("sc_name", this.scName);
        }
        throw fce;
    }

    public final boolean verifyFMNodeID() {
        String local = String.valueOf(this.getClass().getName()) + ".verifyFMNodeID()\n";
        boolean result = false;
        SecurityCredential cred = null;
        long currentFMNid = -1L;
        try {
            if (this.type == WCIX_SWITCH) {
                cred = PasswordCredHandler.instance().createCredential(this.scName, this.scDomain, this.scUserName);
                SwitchBaseIntf ssc = (SwitchBaseIntf)RMILookupUtils.getRemoteObject(this.scName, this.rmiSettings.switchPort, this.rmiSettings.switchLkupName);
                currentFMNid = ssc.getFMNodeId(cred);
            } else {
                cred = PasswordCredHandler.instance().createCredential(this.scName, this.scDomain, this.scUserName);
                ScBaseIntf sc = (ScBaseIntf)RMILookupUtils.getRemoteObject(this.scName, this.rmiSettings.scPort, this.rmiSettings.scLkupName);
                currentFMNid = sc.getFmNodeId(cred, this.scDomain);
            }
            if (this.fmNodeID == currentFMNid) {
                result = true;
            }
        }
        catch (Exception e) {
            MessageLog.getInstance().logMessage(String.valueOf(local) + e, MessageLog.MEDIUM);
        }
        return result;
    }

    private boolean wciInUse(WCI wci, List wciList) {
        boolean result = false;
        if (wciList == null || wciList.size() == 0) {
            return result;
        }
        result = this.type == WCIX_SWITCH ? !((WCI)wciList.get(0)).getMode().equals(WCI.FREE) : wciList.contains(wci);
        return result;
    }

    public static final class NodeMode
    implements Serializable {
        private static final String MODE_ERR = "Error, undefined node mode";
        private static final String[] modes = new String[]{"NONE", "SSM", "RSM", "RSM_SSM"};
        private int mode;

        private NodeMode(int mode) {
            this.mode = mode;
        }

        /* synthetic */ NodeMode(1 $0, int $1) {
            this($1);
        }

        public int asInt() {
            return this.mode;
        }

        public String toString() {
            if (this.mode < modes.length) {
                return modes[this.mode];
            }
            return MODE_ERR;
        }
    }

    public static final class NodeType
    implements Serializable {
        private static final String TYPE_ERR = "Error, undefined node type";
        private static final String[] types = new String[]{"UNKNOWN", "S72", "S72_CENTRAL_SWITCH", "S24", "S12", "S12_DESK_SIDE", "S8", "WCIX_SWITCH"};
        private int type;

        private NodeType(int type) {
            this.type = type;
        }

        /* synthetic */ NodeType(1 $0, int $1) {
            this($1);
        }

        public int asInt() {
            return this.type;
        }

        public String toString() {
            if (this.type < types.length) {
                return types[this.type];
            }
            return TYPE_ERR;
        }
    }
}

