/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.Date;

public class MessageLog {
    public static final LogLevel NONE;
    public static final LogLevel ERROR;
    public static final LogLevel LOW;
    public static final LogLevel MEDIUM;
    public static final LogLevel HIGH;
    public static final LogLevel DEFAULT_LEVEL;
    private static final LogLevel[] LOG_LEVELS;
    private static final String INVALID_LEVEL_ERROR = "Error Invalid Log Level Specified";
    private static final String DEFAULT_LEVEL_MESSAGE;
    private static MessageLog instance;
    private static final String FABRIC_MANAGER_LOG_HEADER = "* Fabric Manager Message Log Started, Created On: ";
    public static final String DAQ_LOG_HEADER = "* FMDaq Message Log Started, Created On: ";
    private static final String LOG_HEADER_DELIM = "******************************************************************************";
    private String defaultHeader = "* Fabric Manager Message Log Started, Created On: ";
    private LogLevel currentLogLevel = DEFAULT_LEVEL;
    private boolean firstLogMessage = true;
    private PrintStream out = System.out;
    private String LogDir;

    static {
        class Com_sun_wildcat_fabric_management_common_MessageLog$1 {
            /* synthetic */ Com_sun_wildcat_fabric_management_common_MessageLog$1() {
            }
        }
        NONE = new LogLevel(null, 0);
        ERROR = new LogLevel(null, 1);
        LOW = new LogLevel(null, 2);
        MEDIUM = new LogLevel(null, 3);
        HIGH = new LogLevel(null, 4);
        DEFAULT_LEVEL = LOW;
        LOG_LEVELS = new LogLevel[]{NONE, ERROR, LOW, MEDIUM, HIGH};
        DEFAULT_LEVEL_MESSAGE = "Using Default Log Level - " + MessageLog.DEFAULT_LEVEL.getLevelDescriptor();
    }

    private MessageLog() {
    }

    public static MessageLog getInstance() {
        if (instance == null) {
            instance = new MessageLog();
        }
        return instance;
    }

    public LogLevel getLogLevel() {
        return this.currentLogLevel;
    }

    public synchronized void logMessage(String message, LogLevel level) {
        if (this.currentLogLevel == NONE || level == NONE) {
            return;
        }
        Date timeStamp = new Date(System.currentTimeMillis());
        if (level.getLevel() <= this.currentLogLevel.getLevel()) {
            if (this.firstLogMessage && this.out != System.out) {
                this.out.println(LOG_HEADER_DELIM);
                this.out.println(String.valueOf(this.defaultHeader) + new Date(System.currentTimeMillis()));
                this.out.println(LOG_HEADER_DELIM);
                this.out.println();
                this.firstLogMessage = false;
            }
            this.out.println(String.valueOf(String.valueOf(timeStamp)) + ": " + message);
            this.out.println();
        }
    }

    public synchronized void logStackTrace(Exception e) {
        try {
            ByteArrayOutputStream bso = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bso);
            e.printStackTrace(ps);
            this.logMessage(bso.toString(), ERROR);
        }
        catch (Exception exception) {}
    }

    public static void main(String[] args) {
        try {
            MessageLog.getInstance().setLogLevel(MessageLog.getInstance().mapIntToLevel(10));
            MessageLog.getInstance().logMessage("Message log level set to high, high", HIGH);
            MessageLog.getInstance().logMessage("Message log level set to high, medium", MEDIUM);
            MessageLog.getInstance().logMessage("Message log level set to high, low", LOW);
            MessageLog.getInstance().logMessage("Message log level set to high, error", ERROR);
            MessageLog.getInstance().logMessage("Message log level set to high, none", NONE);
            MessageLog.getInstance().setLogDestination("./", new File("./test-out"), true);
            MessageLog.getInstance().logMessage("Message log level set to high, high", HIGH);
            MessageLog.getInstance().logMessage("Message log level set to high, medium", MEDIUM);
            MessageLog.getInstance().logMessage("Message log level set to high, low", LOW);
            MessageLog.getInstance().logMessage("Message log level set to high, error", ERROR);
            MessageLog.getInstance().logMessage("Message log level set to high, none", NONE);
            MessageLog.getInstance().logMessage("Message log level set to high, high", HIGH);
            MessageLog.getInstance().logMessage("Message log level set to high, medium", MEDIUM);
            MessageLog.getInstance().logMessage("Message log level set to high, low", LOW);
            MessageLog.getInstance().logMessage("Message log level set to high, error", ERROR);
            MessageLog.getInstance().logMessage("Message log level set to high, none", NONE);
            MessageLog.getInstance().setLogLevel(ERROR);
            MessageLog.getInstance().logMessage("Message log level set to error, low", LOW);
            MessageLog.getInstance().logMessage("Message log level set to error, error", ERROR);
            MessageLog.getInstance().logMessage("Message log level set to error, none", NONE);
            if (MessageLog.getInstance().getLogLevel() == ERROR) {
                MessageLog.getInstance().logMessage("LOG LEVEL IS ERROR", ERROR);
            }
        }
        catch (Exception exception) {
            System.err.println("Unexpected ERROR");
        }
    }

    public LogLevel mapIntToLevel(int level) {
        if (level >= 0 && level < LOG_LEVELS.length) {
            return LOG_LEVELS[level];
        }
        this.logMessage("Error Invalid Log Level Specified: " + level + ", " + DEFAULT_LEVEL_MESSAGE, DEFAULT_LEVEL);
        return DEFAULT_LEVEL;
    }

    public synchronized void setDefaultHeader(String header) {
        this.defaultHeader = header;
    }

    public synchronized void setLogDestination(String logDir, File file) throws FileNotFoundException {
        this.setLogDestination(logDir, file, true);
    }

    public synchronized void setLogDestination(String logDir, File file, boolean append) throws FileNotFoundException {
        this.setLogDestination(logDir, file.getPath(), append);
    }

    public synchronized void setLogDestination(String logDir, String filename) throws FileNotFoundException {
        this.setLogDestination(logDir, filename, true);
    }

    public synchronized void setLogDestination(String logDir, String filename, boolean append) throws FileNotFoundException {
        this.LogDir = logDir;
        this.out = new PrintStream(new FileOutputStream(filename, append), true);
    }

    public synchronized void setLogLevel(LogLevel level) {
        this.currentLogLevel = level;
    }

    public void writeObjectToLog(Object obj, String baseName, String extension) {
        try {
            String fname = String.valueOf(this.LogDir) + baseName + System.currentTimeMillis() + extension;
            File file = new File(fname);
            FileOutputStream fis = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fis);
            oos.writeObject(obj);
        }
        catch (Exception e) {
            MessageLog.getInstance().logMessage("can't persist object to log file" + e.getMessage(), HIGH);
            MessageLog.getInstance().logStackTrace(e);
        }
    }

    public static final class LogLevel {
        private static final String[] LEVEL_DESCRIPTORS = new String[]{"NONE", "ERROR", "LOW", "MEDIUM", "HIGH"};
        private int level;

        private LogLevel(int level) {
            this.level = level;
        }

        /* synthetic */ LogLevel(1 $0, int $1) {
            this($1);
        }

        private int getLevel() {
            return this.level;
        }

        private String getLevelDescriptor() {
            return LEVEL_DESCRIPTORS[this.level];
        }
    }
}

