/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.ReserveLink;
import com.sun.wildcat.fabric_management.common.ReserveWCI;
import com.sun.wildcat.fabric_management.common.WCI;
import com.sun.wildcat.fabric_management.common.WciDataInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Inventory
implements Serializable {
    protected List usedWcis = new ArrayList();
    protected List availableWcis = new ArrayList();
    protected HashMap removeWcis = new HashMap();
    protected HashMap removeLinks = new HashMap();
    protected HashMap reservedWcis = new HashMap();
    protected HashMap reservedLinks = new HashMap();

    public void addAvailableWcis(WCI wci) {
        this.availableWcis.add(wci);
    }

    public void addAvailableWcis(List wcis) {
        this.availableWcis.addAll(wcis);
    }

    public void addRemoveLinks(String partitionName, ReserveLink link) {
        List lst = this.createOrGetList(this.removeLinks, partitionName);
        lst.add(link);
    }

    public void addRemoveLinks(String partitionName, List links) {
        List lst = this.createOrGetList(this.removeLinks, partitionName);
        lst.addAll(links);
    }

    public void addRemoveWcis(String partitionName, ReserveWCI wci) {
        List lst = this.createOrGetList(this.removeWcis, partitionName);
        lst.add(wci);
    }

    public void addRemoveWcis(String partitionName, List wcis) {
        List lst = this.createOrGetList(this.removeWcis, partitionName);
        lst.addAll(wcis);
    }

    public void addReservedLinks(String partitionName, ReserveLink link) {
        List lst = this.createOrGetList(this.reservedLinks, partitionName);
        lst.add(link);
    }

    public void addReservedLinks(String partitionName, List links) {
        List lst = this.createOrGetList(this.reservedLinks, partitionName);
        lst.addAll(links);
    }

    public void addReservedWcis(String partitionName, ReserveWCI wci) {
        List lst = this.createOrGetList(this.reservedWcis, partitionName);
        lst.add(wci);
    }

    public void addReservedWcis(String partitionName, List wcis) {
        List lst = this.createOrGetList(this.reservedWcis, partitionName);
        lst.addAll(wcis);
    }

    public void addUsedWcis(WCI wci) {
        this.usedWcis.add(wci);
    }

    public void addUsedWcis(List wcis) {
        this.usedWcis.addAll(wcis);
    }

    public void addUsedWcis(Object[] wcis) {
        this.usedWcis.clear();
        int i = 0;
        while (i < wcis.length) {
            this.setUsedWcis((WCI)wcis[i]);
            ++i;
        }
    }

    public void appendReservedInventory(Inventory that) {
        String partitionName;
        Iterator iter = that.reservedWcis.keySet().iterator();
        while (iter.hasNext()) {
            partitionName = (String)iter.next();
            this.addReservedWcis(partitionName, (List)that.reservedWcis.get(partitionName));
        }
        iter = that.reservedLinks.keySet().iterator();
        while (iter.hasNext()) {
            partitionName = (String)iter.next();
            this.addReservedLinks(partitionName, (List)that.reservedLinks.get(partitionName));
        }
        iter = that.removeLinks.keySet().iterator();
        while (iter.hasNext()) {
            partitionName = (String)iter.next();
            this.addRemoveLinks(partitionName, (List)that.removeLinks.get(partitionName));
        }
        iter = that.removeWcis.keySet().iterator();
        while (iter.hasNext()) {
            partitionName = (String)iter.next();
            this.addRemoveWcis(partitionName, (List)that.removeWcis.get(partitionName));
        }
    }

    public void clear() {
        this.clearReserve();
        this.clearRemove();
    }

    public void clear(String partitionName) {
        this.clearReserve(partitionName);
        this.clearRemove(partitionName);
    }

    public void clearRemove() {
        this.removeWcis.clear();
        this.removeLinks.clear();
    }

    public void clearRemove(String partitionName) {
        List lst = null;
        lst = this.createOrGetList(this.removeWcis, partitionName);
        lst.clear();
        lst = this.createOrGetList(this.removeLinks, partitionName);
        lst.clear();
    }

    public void clearReserve() {
        this.reservedLinks.clear();
        this.reservedWcis.clear();
    }

    public void clearReserve(String partitionName) {
        List lst = null;
        lst = this.createOrGetList(this.reservedLinks, partitionName);
        lst.clear();
        lst = this.createOrGetList(this.reservedWcis, partitionName);
        lst.clear();
    }

    private List createOrGetList(HashMap map, String partitionName) {
        ArrayList lst = (ArrayList)map.get(partitionName);
        if (lst == null) {
            lst = new ArrayList();
            map.put(partitionName, lst);
        }
        return lst;
    }

    public boolean equals(Object thatObj) {
        boolean result = false;
        if (thatObj == null) {
            result = false;
        } else if (this == thatObj) {
            result = true;
        }
        return result;
    }

    public List getAvailableWcis() {
        return this.availableWcis;
    }

    public WciDataInterface[] getIdleWcis() {
        WciDataInterface[] wcis = new WciDataInterface[this.availableWcis.size()];
        this.availableWcis.toArray(wcis);
        return wcis;
    }

    public WciDataInterface[] getInUseWcis() {
        WciDataInterface[] wcis = new WciDataInterface[this.usedWcis.size()];
        this.usedWcis.toArray(wcis);
        return wcis;
    }

    public int getNumAvailableWcis() {
        return this.availableWcis.size();
    }

    public int getNumRemoveLinks(String partitionName) {
        List lst = this.createOrGetList(this.removeLinks, partitionName);
        return lst.size();
    }

    public int getNumRemoveWcis(String partitionName) {
        List lst = this.createOrGetList(this.removeWcis, partitionName);
        return lst.size();
    }

    public int getNumReservedLinks(String partitionName) {
        List lst = this.createOrGetList(this.reservedLinks, partitionName);
        return lst.size();
    }

    public int getNumReservedWcis(String partitionName) {
        List lst = this.createOrGetList(this.reservedWcis, partitionName);
        return lst.size();
    }

    public int getNumUsedWcis() {
        return this.usedWcis.size();
    }

    public ReserveLink[] getRemoveLinks(String partitionName) {
        List lst = this.createOrGetList(this.removeLinks, partitionName);
        return lst.toArray(new ReserveLink[0]);
    }

    public List getRemoveLinksList(String partitionName) {
        List lst = this.createOrGetList(this.removeLinks, partitionName);
        return lst;
    }

    public ReserveWCI[] getRemoveWcis(String partitionName) {
        List lst = this.createOrGetList(this.removeWcis, partitionName);
        return lst.toArray(new ReserveWCI[0]);
    }

    public List getRemoveWcisList(String partitionName) {
        List lst = this.createOrGetList(this.removeWcis, partitionName);
        return lst;
    }

    public ReserveLink[] getReservedLinks(String partitionName) {
        List lst = this.createOrGetList(this.reservedLinks, partitionName);
        return lst.toArray(new ReserveLink[0]);
    }

    public ReserveWCI[] getReservedWcis(String partitionName) {
        List lst = this.createOrGetList(this.reservedWcis, partitionName);
        return lst.toArray(new ReserveWCI[0]);
    }

    public List getUsedWcis() {
        return this.usedWcis;
    }

    public void removeUsedWci(WCI wci) {
        this.usedWcis.remove(this.usedWcis.indexOf(wci));
    }

    public void setAvailableWcis(WCI wci) {
        this.availableWcis.clear();
        this.availableWcis.add(wci);
    }

    public void setAvailableWcis(List wcis) {
        this.availableWcis.clear();
        this.availableWcis.addAll(wcis);
    }

    public void setRemoveLinks(String partitionName, List links) {
        List lst = this.createOrGetList(this.removeLinks, partitionName);
        lst.clear();
        lst.addAll(links);
    }

    public void setRemoveWcis(String partitionName, List wcis) {
        List lst = this.createOrGetList(this.removeWcis, partitionName);
        lst.clear();
        lst.addAll(wcis);
    }

    public void setReservedInventory(Inventory that) {
        String partitionName;
        Iterator iter = that.reservedWcis.keySet().iterator();
        while (iter.hasNext()) {
            partitionName = (String)iter.next();
            this.setReservedWcis(partitionName, (List)that.reservedWcis.get(partitionName));
        }
        iter = that.reservedLinks.keySet().iterator();
        while (iter.hasNext()) {
            partitionName = (String)iter.next();
            this.setReservedLinks(partitionName, (List)that.reservedLinks.get(partitionName));
        }
        iter = that.removeLinks.keySet().iterator();
        while (iter.hasNext()) {
            partitionName = (String)iter.next();
            this.setRemoveLinks(partitionName, (List)that.removeLinks.get(partitionName));
        }
        iter = that.removeWcis.keySet().iterator();
        while (iter.hasNext()) {
            partitionName = (String)iter.next();
            this.setRemoveWcis(partitionName, (List)that.removeWcis.get(partitionName));
        }
    }

    public void setReservedLinks(String partitionName, List links) {
        List lst = this.createOrGetList(this.reservedLinks, partitionName);
        lst.clear();
        lst.addAll(links);
    }

    public void setReservedWcis(String partitionName, List wcis) {
        List lst = this.createOrGetList(this.reservedWcis, partitionName);
        lst.clear();
        lst.addAll(wcis);
    }

    public void setUsedWcis(WCI wci) {
        this.usedWcis.clear();
        this.usedWcis.add(wci);
    }

    public void setUsedWcis(List wcis) {
        this.usedWcis.clear();
        this.usedWcis.addAll(wcis);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentTabs) {
        StringBuffer buf = new StringBuffer();
        StringBuffer tabs = new StringBuffer();
        int numWcis = this.usedWcis.size();
        WCI wci = null;
        buf.append(String.valueOf(String.valueOf(tabs)) + "\t" + "Used WCIs:\n");
        int i = 0;
        while (i < numWcis) {
            wci = (WCI)this.usedWcis.get(i);
            buf.append(wci.toString(indentTabs + 2));
            ++i;
        }
        numWcis = this.availableWcis.size();
        buf.append("\n" + tabs + "\t" + "Available WCIs:\n");
        int i2 = 0;
        while (i2 < numWcis) {
            wci = (WCI)this.availableWcis.get(i2);
            buf.append(wci.toString(indentTabs + 2));
            ++i2;
        }
        return buf.toString();
    }
}

