/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class GraphNode
implements Serializable {
    int id;
    int mappedId;
    List adjacentNodes;
    List illegalAdjacentNodes;
    int nodeType;
    boolean isMapped = false;
    GraphNode mappedNode = null;
    GraphNode buddyNode = null;
    Object applicationData;
    boolean passThroughEnabled = false;
    int bfsTouches = 0;

    public GraphNode(int id) {
        this(id, new ArrayList(), new ArrayList(), 0);
    }

    public GraphNode(int id, int nType) {
        this(id, new ArrayList(), new ArrayList(), nType);
    }

    public GraphNode(int id, List adjNodes, List illegalAdjNodes, int nodeType) {
        this.id = id;
        this.mappedId = -1;
        this.adjacentNodes = adjNodes;
        this.illegalAdjacentNodes = illegalAdjNodes;
        this.nodeType = nodeType;
    }

    public GraphNode(int id, Vector adjNodes, Vector illegalAdjNodes) {
        this(id, adjNodes, illegalAdjNodes, 0);
    }

    public void addAdjacentNode(GraphNode g) {
        this.adjacentNodes.add(g);
    }

    public void addIllegalAdjacentNode(GraphNode g) {
        if (!this.illegalAdjacentNodes.contains(g)) {
            this.illegalAdjacentNodes.add(g);
        }
    }

    public Vector getAdjacentMappedNodes() {
        Vector<GraphNode> v = new Vector<GraphNode>();
        int i = 0;
        while (i < this.adjacentNodes.size()) {
            GraphNode gn = (GraphNode)this.adjacentNodes.get(i);
            if (gn.isMapped()) {
                v.addElement(gn);
            }
            ++i;
        }
        return v;
    }

    public List getAdjacentNodes() {
        return this.adjacentNodes;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public int getBfsTouches() {
        return this.bfsTouches;
    }

    public GraphNode getBuddy() {
        return this.buddyNode;
    }

    public int[] getExtraneousLinks() {
        if (this.mappedNode == null || !this.isMapped) {
            List adjNodes = this.getAdjacentNodes();
            int[] ret = new int[adjNodes.size()];
            int i = 0;
            while (i < adjNodes.size()) {
                GraphNode gn = (GraphNode)adjNodes.get(i);
                ret[i] = gn.getMappedId();
                ++i;
            }
            return ret;
        }
        ArrayList<Integer> idProcessed = new ArrayList<Integer>();
        List adjNodes = this.getAdjacentNodes();
        Vector<Integer> extraLinks = new Vector<Integer>();
        int i = 0;
        while (i < adjNodes.size()) {
            GraphNode adjNode = (GraphNode)adjNodes.get(i);
            if (!this.mappedNode.isAdjacentToMappedId(adjNode.getId(), GraphNode.getNumInVector(idProcessed, adjNode.getMappedId()))) {
                extraLinks.addElement(new Integer(adjNode.getMappedId()));
            }
            idProcessed.add(new Integer(adjNode.getMappedId()));
            ++i;
        }
        int[] ret = new int[extraLinks.size()];
        int i2 = 0;
        while (i2 < extraLinks.size()) {
            ret[i2] = (Integer)extraLinks.elementAt(i2);
            ++i2;
        }
        return ret;
    }

    public int getId() {
        return this.id;
    }

    public List getIllegalAdjacentNodes() {
        return this.illegalAdjacentNodes;
    }

    public int getMappedId() {
        return this.mappedId;
    }

    public GraphNode getMappedNode() {
        return this.mappedNode;
    }

    public int[] getMissingLinks() {
        if (this.mappedNode == null || !this.isMapped) {
            return new int[0];
        }
        List mappedAdjNodes = this.mappedNode.getAdjacentNodes();
        Vector<Integer> missingLinks = new Vector<Integer>();
        Vector<Integer> idProcessed = new Vector<Integer>();
        int i = 0;
        while (i < mappedAdjNodes.size()) {
            GraphNode mappedAdjNode = (GraphNode)mappedAdjNodes.get(i);
            if (mappedAdjNode.isMapped()) {
                if (!this.isAdjacentToMappedId(mappedAdjNode.getId(), GraphNode.getNumInVector(idProcessed, mappedAdjNode.getId()))) {
                    missingLinks.addElement(new Integer(mappedAdjNode.getId()));
                }
                idProcessed.add(new Integer(mappedAdjNode.getId()));
            }
            ++i;
        }
        int[] ret = new int[missingLinks.size()];
        int i2 = 0;
        while (i2 < missingLinks.size()) {
            ret[i2] = (Integer)missingLinks.elementAt(i2);
            ++i2;
        }
        return ret;
    }

    public static int getNumInVector(List v, int i) {
        int size = v.size();
        int count = 0;
        int j = 0;
        while (j < size) {
            if ((Integer)v.get(j) == i) {
                ++count;
            }
            ++j;
        }
        return count;
    }

    public int getType() {
        return this.nodeType;
    }

    public boolean isAbleToConnectTo(int mappedId) {
        int i = 0;
        while (i < this.illegalAdjacentNodes.size()) {
            GraphNode illNode = (GraphNode)this.illegalAdjacentNodes.get(i);
            if (illNode.isMapped() && illNode.getMappedId() == mappedId) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAdjacentToMappedId(int mappedId, int countforThisID) {
        if (this.adjacentNodes == null) {
            return false;
        }
        int count = 0;
        int i = 0;
        while (i < this.adjacentNodes.size()) {
            GraphNode gn = (GraphNode)this.adjacentNodes.get(i);
            if (gn.isMapped() && gn.getMappedId() == mappedId) {
                if (countforThisID == count) {
                    return true;
                }
                ++count;
            }
            ++i;
        }
        return false;
    }

    public boolean isMapped() {
        return this.isMapped;
    }

    public boolean isPassThroughEnabled() {
        return this.passThroughEnabled;
    }

    public void setAdjacentNodes(Vector adjNodes) {
        if (adjNodes != null) {
            this.adjacentNodes = adjNodes;
        }
    }

    public void setApplicationData(Object obj) {
        this.applicationData = obj;
    }

    public void setBfsTouches(int num) {
        this.bfsTouches = num;
    }

    public void setBuddy(GraphNode nd) {
        this.buddyNode = nd;
    }

    public void setIllegalAdjacentNodes(List illAdjNodes) {
        if (illAdjNodes != null) {
            this.illegalAdjacentNodes = illAdjNodes;
        }
    }

    public void setMapped(boolean isMapped) {
        this.isMapped = isMapped;
        if (!isMapped) {
            this.mappedNode = null;
            this.mappedId = -1;
        }
    }

    public void setMappedNode(GraphNode mappedNode) {
        this.mappedNode = mappedNode;
        this.mappedId = mappedNode.getId();
    }

    public void setPassThroughEnabled(boolean b) {
        this.passThroughEnabled = b;
    }

    public void setType(int nodeType) {
        this.nodeType = nodeType;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id: " + this.id + "\n");
        sb.append("mappedId: " + this.mappedId + "\n");
        sb.append("isMapped: " + this.isMapped + "\n\n");
        sb.append("AdjacentNodes:\n");
        sb.append("==============\n");
        int i = 0;
        while (i < this.adjacentNodes.size()) {
            GraphNode gn = (GraphNode)this.adjacentNodes.get(i);
            sb.append("[" + gn.getId() + ", " + gn.getMappedId() + "]  ");
            ++i;
        }
        sb.append("\n\n");
        sb.append("IllegalAdjacentNodes:\n");
        sb.append("=====================\n");
        int i2 = 0;
        while (i2 < this.illegalAdjacentNodes.size()) {
            GraphNode gn = (GraphNode)this.illegalAdjacentNodes.get(i2);
            sb.append("[" + gn.getId() + ", " + gn.getMappedId() + "]  ");
            ++i2;
        }
        sb.append("\n");
        sb.append("applicationData " + this.applicationData);
        sb.append("\n");
        return sb.toString();
    }
}

