/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.GraphNode;
import com.sun.wildcat.fabric_management.common.MessageLog;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Graph {
    private final String LOG_FILENAME = "graph.log";
    private static Graph g = null;
    List currentBestMapping;
    int currentLowestNumLinkChanges = Integer.MAX_VALUE;
    long stopTime;
    int leastMissingLinksPossible;
    long startTime;

    private Graph() {
    }

    private void addMap(List desiredGraph, List currentGraph, List mappings) {
        int i = 0;
        while (i < mappings.size()) {
            int[] nodePair = (int[])mappings.get(i);
            GraphNode idsGraphNode = null;
            GraphNode mappedIdsGraphNode = null;
            int j = 0;
            while (j < currentGraph.size()) {
                GraphNode gn = (GraphNode)currentGraph.get(j);
                if (gn.getId() == nodePair[0]) {
                    idsGraphNode = gn;
                    break;
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < desiredGraph.size()) {
                GraphNode gn = (GraphNode)desiredGraph.get(j2);
                if (gn.getId() == nodePair[1]) {
                    mappedIdsGraphNode = gn;
                    break;
                }
                ++j2;
            }
            if (idsGraphNode != null && mappedIdsGraphNode != null && idsGraphNode.getType() == mappedIdsGraphNode.getType()) {
                idsGraphNode.setMappedNode(mappedIdsGraphNode);
                idsGraphNode.setMapped(true);
                mappedIdsGraphNode.setMappedNode(idsGraphNode);
                mappedIdsGraphNode.setMapped(true);
            }
            ++i;
        }
    }

    public Vector computeMultiHopSubnets(Vector graph) {
        Vector allSubnets = new Vector();
        int i = 0;
        while (i < graph.size()) {
            GraphNode gn = (GraphNode)graph.elementAt(i);
            gn.setBfsTouches(0);
            ++i;
        }
        GraphNode untouchedGN = (GraphNode)graph.elementAt(0);
        block1: while (untouchedGN != null) {
            untouchedGN.setBfsTouches(1);
            Vector<GraphNode> subnet = new Vector<GraphNode>();
            subnet.addElement(untouchedGN);
            LinkedList<GraphNode> queue = new LinkedList<GraphNode>();
            queue.add(untouchedGN);
            while (queue.size() > 0) {
                untouchedGN = (GraphNode)queue.getFirst();
                List adjNodes = untouchedGN.getAdjacentNodes();
                int i2 = 0;
                while (i2 < adjNodes.size()) {
                    untouchedGN = (GraphNode)adjNodes.get(i2);
                    if (untouchedGN.getBfsTouches() == 0) {
                        subnet.addElement(untouchedGN);
                        untouchedGN.setBfsTouches(1);
                        queue.add(untouchedGN);
                    }
                    ++i2;
                }
                untouchedGN = (GraphNode)queue.removeFirst();
                untouchedGN.setBfsTouches(2);
            }
            allSubnets.addElement(subnet);
            untouchedGN = null;
            int i3 = 0;
            while (i3 < graph.size()) {
                GraphNode _gn = (GraphNode)graph.get(i3);
                if (_gn.getBfsTouches() == 0) {
                    untouchedGN = _gn;
                    continue block1;
                }
                ++i3;
            }
        }
        return allSubnets;
    }

    private int computeNumLinkChanges(List mappedGraph) {
        List missingLinks = this.getMissingLinks(mappedGraph);
        return missingLinks.size();
    }

    public Vector computePassThroughSubnets(Vector graph) {
        Vector allSubnets = new Vector();
        int i = 0;
        while (i < graph.size()) {
            GraphNode gn = (GraphNode)graph.elementAt(i);
            gn.setBfsTouches(0);
            ++i;
        }
        GraphNode untouchedGN = (GraphNode)graph.elementAt(0);
        block1: while (untouchedGN != null) {
            untouchedGN.setBfsTouches(1);
            Vector<GraphNode> subnet = new Vector<GraphNode>();
            subnet.addElement(untouchedGN);
            LinkedList<GraphNode> queue = new LinkedList<GraphNode>();
            queue.add(untouchedGN);
            while (queue.size() > 0) {
                untouchedGN = (GraphNode)queue.getFirst();
                Vector reachableNodes = new Vector();
                if (untouchedGN.isPassThroughEnabled()) {
                    List sameSetNodes = untouchedGN.getIllegalAdjacentNodes();
                    reachableNodes.addAll(sameSetNodes);
                    int i2 = 0;
                    while (i2 < sameSetNodes.size()) {
                        GraphNode sameSetNode = (GraphNode)sameSetNodes.get(i2);
                        List adjNodes = sameSetNode.getAdjacentNodes();
                        reachableNodes.addAll(adjNodes);
                        ++i2;
                    }
                } else {
                    List adjNodes = untouchedGN.getAdjacentNodes();
                    reachableNodes.addAll(adjNodes);
                }
                int i3 = 0;
                while (i3 < reachableNodes.size()) {
                    untouchedGN = (GraphNode)reachableNodes.elementAt(i3);
                    if (untouchedGN.getBfsTouches() == 0) {
                        subnet.addElement(untouchedGN);
                        untouchedGN.setBfsTouches(1);
                        queue.add(untouchedGN);
                    }
                    ++i3;
                }
                untouchedGN = (GraphNode)queue.removeFirst();
                untouchedGN.setBfsTouches(2);
            }
            allSubnets.addElement(subnet);
            untouchedGN = null;
            int i4 = 0;
            while (i4 < graph.size()) {
                GraphNode _gn = (GraphNode)graph.elementAt(i4);
                if (_gn.getBfsTouches() == 0) {
                    untouchedGN = _gn;
                    continue block1;
                }
                ++i4;
            }
        }
        return allSubnets;
    }

    private List getBestMappableNodes(GraphNode graphNode, List graph) {
        List<GraphNode> nodesToTry = null;
        List illegalAdjacentNodes = graphNode.getIllegalAdjacentNodes();
        int i = 0;
        while (i < illegalAdjacentNodes.size()) {
            GraphNode illAdjNode = (GraphNode)illegalAdjacentNodes.get(i);
            if (illAdjNode.isMapped()) {
                GraphNode mappedNode = illAdjNode.getMappedNode();
                nodesToTry = mappedNode.getIllegalAdjacentNodes();
                break;
            }
            ++i;
        }
        if (nodesToTry == null) {
            nodesToTry = new Vector();
            int i2 = 0;
            while (i2 < graph.size()) {
                GraphNode gn = (GraphNode)graph.get(i2);
                List illAdjNodes = gn.getIllegalAdjacentNodes();
                boolean illAdjNodesMapped = false;
                int j = 0;
                while (j < illAdjNodes.size()) {
                    GraphNode _gn = (GraphNode)illAdjNodes.get(j);
                    if (_gn.isMapped()) {
                        illAdjNodesMapped = true;
                        break;
                    }
                    ++j;
                }
                if (!illAdjNodesMapped && gn.getType() == graphNode.getType()) {
                    nodesToTry.add(gn);
                }
                ++i2;
            }
        }
        Vector adjacentNodes = graphNode.getAdjacentMappedNodes();
        Vector<GraphNode> bestMappableNodesV = new Vector<GraphNode>();
        int mostMatchedLinks = -1;
        int i3 = 0;
        while (i3 < nodesToTry.size()) {
            boolean mappable = true;
            GraphNode currGN = (GraphNode)nodesToTry.get(i3);
            if (!currGN.isMapped()) {
                int numMatchedLinks = 0;
                Vector<Integer> idProcessed = new Vector<Integer>();
                int j = 0;
                while (j < adjacentNodes.size()) {
                    GraphNode currAdjNode = (GraphNode)adjacentNodes.elementAt(j);
                    if (!currGN.isAbleToConnectTo(currAdjNode.getId())) {
                        mappable = false;
                        break;
                    }
                    if (currGN.isAdjacentToMappedId(currAdjNode.getId(), GraphNode.getNumInVector(idProcessed, currAdjNode.getId()))) {
                        ++numMatchedLinks;
                    }
                    idProcessed.add(new Integer(currAdjNode.getMappedId()));
                    ++j;
                }
                if (mappable && numMatchedLinks > mostMatchedLinks) {
                    bestMappableNodesV.clear();
                    bestMappableNodesV.addElement(currGN);
                    mostMatchedLinks = numMatchedLinks;
                } else if (mappable && numMatchedLinks == mostMatchedLinks) {
                    bestMappableNodesV.addElement(currGN);
                }
            }
            ++i3;
        }
        return bestMappableNodesV;
    }

    public List getExtraneousLinks(List currentGraph) {
        Hashtable<String, int[]> extraLinksHT = new Hashtable<String, int[]>();
        int i = 0;
        while (i < currentGraph.size()) {
            GraphNode currNode = (GraphNode)currentGraph.get(i);
            int mappedId1 = currNode.getMappedId();
            int[] extraLinksArr = currNode.getExtraneousLinks();
            Vector<Integer> idProcessed = new Vector<Integer>();
            int j = 0;
            while (j < extraLinksArr.length) {
                int[] linkPair = new int[3];
                int mappedId2 = extraLinksArr[j];
                if (mappedId1 < mappedId2) {
                    linkPair[0] = mappedId1;
                    linkPair[1] = mappedId2;
                } else {
                    linkPair[0] = mappedId2;
                    linkPair[1] = mappedId1;
                }
                linkPair[2] = GraphNode.getNumInVector(idProcessed, mappedId2);
                extraLinksHT.put(String.valueOf(linkPair[0]) + ":" + linkPair[1] + ":" + linkPair[2], linkPair);
                idProcessed.add(new Integer(mappedId2));
                ++j;
            }
            ++i;
        }
        return new Vector(extraLinksHT.values());
    }

    public static Graph getInstance() {
        if (g == null) {
            g = new Graph();
        }
        return g;
    }

    private List getMapping(List graph) {
        Vector<int[]> mapping = new Vector<int[]>();
        int i = 0;
        while (i < graph.size()) {
            GraphNode gn = (GraphNode)graph.get(i);
            if (gn.isMapped()) {
                int[] pair = new int[]{gn.getId(), gn.getMappedId()};
                mapping.addElement(pair);
            }
            ++i;
        }
        return mapping;
    }

    public List getMissingLinks(List currentGraph) {
        Hashtable<String, int[]> missingLinksHT = new Hashtable<String, int[]>();
        int i = 0;
        while (i < currentGraph.size()) {
            GraphNode currNode = (GraphNode)currentGraph.get(i);
            if (currNode.isMapped()) {
                int mappedId1 = currNode.getMappedId();
                int[] missingLinksArr = currNode.getMissingLinks();
                Vector<Integer> idProcessed = new Vector<Integer>();
                int j = 0;
                while (j < missingLinksArr.length) {
                    int[] linkPair = new int[3];
                    int mappedId2 = missingLinksArr[j];
                    if (mappedId1 < mappedId2) {
                        linkPair[0] = mappedId1;
                        linkPair[1] = mappedId2;
                    } else {
                        linkPair[0] = mappedId2;
                        linkPair[1] = mappedId1;
                    }
                    linkPair[2] = GraphNode.getNumInVector(idProcessed, mappedId2);
                    missingLinksHT.put(String.valueOf(linkPair[0]) + ":" + linkPair[1] + ":" + linkPair[2], linkPair);
                    idProcessed.add(new Integer(mappedId2));
                    ++j;
                }
            }
            ++i;
        }
        return new Vector(missingLinksHT.values());
    }

    private GraphNode getNextNodeToMap(List graph) {
        if (graph == null) {
            return null;
        }
        int i = 0;
        while (i < graph.size()) {
            GraphNode gn = (GraphNode)graph.get(i);
            if (gn.isMapped()) {
                List nodes = gn.getAdjacentNodes();
                int j = 0;
                while (j < nodes.size()) {
                    GraphNode adjNode = (GraphNode)nodes.get(j);
                    if (!adjNode.isMapped()) {
                        return adjNode;
                    }
                    ++j;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < graph.size()) {
            GraphNode gn = (GraphNode)graph.get(i2);
            if (!gn.isMapped()) {
                return gn;
            }
            ++i2;
        }
        return null;
    }

    public List getNonMappedGraphNodes(List desiredGraph) {
        ArrayList<GraphNode> rv = new ArrayList<GraphNode>();
        int i = 0;
        while (i < desiredGraph.size()) {
            GraphNode gn = (GraphNode)desiredGraph.get(i);
            if (gn.getMappedNode() == null) {
                rv.add(gn);
            }
            ++i;
        }
        return rv;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: java Graph <desiredConfig>  <currentConfig>");
        } else {
            String desiredPropFile = args[0];
            String currentPropFile = args[1];
            Vector desiredGraph = Graph.getInstance().parseConfigFile(desiredPropFile);
            Vector vector = Graph.getInstance().parseConfigFile(currentPropFile);
        }
    }

    public List mapGraphDumpInfo(List desiredGraph, List currentGraph) {
        List extraneousLinks;
        List mappedGraph = Graph.getInstance().mapGraphs(desiredGraph, currentGraph);
        System.out.println("Here's the mapping:");
        int i = 0;
        while (i < mappedGraph.size()) {
            System.out.println(mappedGraph.get(i));
            ++i;
        }
        List missingLinks = Graph.getInstance().getMissingLinks(mappedGraph);
        if (missingLinks != null) {
            System.out.println("\nHere's the missing links:");
            int i2 = 0;
            while (i2 < missingLinks.size()) {
                int[] linkPair = (int[])missingLinks.get(i2);
                System.out.print("[" + linkPair[0] + ", " + linkPair[1] + "]  ");
                ++i2;
            }
        }
        if ((extraneousLinks = Graph.getInstance().getExtraneousLinks(mappedGraph)) != null) {
            System.out.println("\n\nHere's the extraneous links:");
            int i3 = 0;
            while (i3 < extraneousLinks.size()) {
                int[] linkPair = (int[])extraneousLinks.get(i3);
                System.out.print("[" + linkPair[0] + ", " + linkPair[1] + "]  ");
                ++i3;
            }
            System.out.println();
        }
        return mappedGraph;
    }

    public List mapGraphs(List desiredGraph, List currentGraph) {
        return this.mapGraphs(desiredGraph, currentGraph, 0L);
    }

    public List mapGraphs(List desiredGraph, List currentGraph, long maxTime) {
        Vector<int[]> mapping;
        String timeString = new Date(System.currentTimeMillis()).toString();
        this.startTime = System.currentTimeMillis();
        this.stopTime = maxTime == 0L ? 0L : System.currentTimeMillis() + maxTime;
        this.currentLowestNumLinkChanges = Integer.MAX_VALUE;
        this.currentBestMapping = null;
        this.leastMissingLinksPossible = this.numberOfLinks(desiredGraph) - this.numberOfLinks(currentGraph);
        if (this.leastMissingLinksPossible < 0) {
            this.leastMissingLinksPossible = 0;
        }
        if ((mapping = this.getMapping(currentGraph)).size() == 0) {
            GraphNode desiredGNToMap = (GraphNode)desiredGraph.get(0);
            int j = 0;
            while (j < currentGraph.size()) {
                GraphNode currentGNToMap = (GraphNode)currentGraph.get(j);
                if (currentGNToMap.getType() == desiredGNToMap.getType()) {
                    boolean desiredHasBuddy;
                    boolean currentHasBuddy = currentGNToMap.getBuddy() != null;
                    boolean bl = desiredHasBuddy = desiredGNToMap.getBuddy() != null;
                    if (currentHasBuddy != desiredHasBuddy) {
                        MessageLog.getInstance().logMessage("current and desired parity mismatch current is  " + currentHasBuddy + " desired " + desiredHasBuddy, MessageLog.HIGH);
                    } else {
                        int[] newMapPair = new int[]{currentGNToMap.getId(), desiredGNToMap.getId()};
                        mapping = new Vector<int[]>();
                        mapping.add(newMapPair);
                        if (currentHasBuddy) {
                            MessageLog.getInstance().logMessage("using graph buddy code", MessageLog.HIGH);
                            newMapPair = new int[]{currentGNToMap.getBuddy().getId(), desiredGNToMap.getBuddy().getId()};
                            mapping.add(newMapPair);
                        }
                        this.mapGraphs(desiredGraph, currentGraph, mapping);
                    }
                }
                ++j;
            }
        } else {
            this.mapGraphs(desiredGraph, currentGraph, mapping);
        }
        if (this.currentBestMapping == null) {
            this.currentBestMapping = new Vector();
        }
        int i = 0;
        while (i < this.currentBestMapping.size()) {
            int[] pair = (int[])this.currentBestMapping.get(i);
            ++i;
        }
        long currentTime = System.currentTimeMillis();
        this.preMap(desiredGraph, currentGraph, this.currentBestMapping);
        return currentGraph;
    }

    private void mapGraphs(List desiredGraph, List currentGraph, List mappings) {
        if (this.stopTime != 0L && System.currentTimeMillis() > this.stopTime || this.currentLowestNumLinkChanges <= this.leastMissingLinksPossible) {
            return;
        }
        if (mappings != null) {
            this.preMap(desiredGraph, currentGraph, mappings);
        }
        if (this.computeNumLinkChanges(currentGraph) >= this.currentLowestNumLinkChanges) {
            return;
        }
        GraphNode desiredGNToMap = this.getNextNodeToMap(desiredGraph);
        if (desiredGNToMap != null) {
            List bestMappableNodes = this.getBestMappableNodes(desiredGNToMap, currentGraph);
            if (bestMappableNodes.size() == 0) {
                int numLinkChanges = this.computeNumLinkChanges(currentGraph);
                if (numLinkChanges < this.currentLowestNumLinkChanges) {
                    this.currentBestMapping = this.getMapping(currentGraph);
                    this.currentLowestNumLinkChanges = numLinkChanges;
                }
                return;
            }
            List currentMapping = this.getMapping(currentGraph);
            ArrayList<int[]> newMapping = new ArrayList<int[]>();
            int i = 0;
            while (i < bestMappableNodes.size()) {
                boolean desiredHasBuddy;
                GraphNode currentGN = (GraphNode)bestMappableNodes.get(i);
                boolean currentHasBuddy = currentGN.getBuddy() != null;
                boolean bl = desiredHasBuddy = desiredGNToMap.getBuddy() != null;
                if (currentHasBuddy != desiredHasBuddy) {
                    MessageLog.getInstance().logMessage("current and desired parity mismatch current is " + currentHasBuddy + " desired " + desiredHasBuddy, MessageLog.HIGH);
                } else {
                    newMapping = new ArrayList(currentMapping);
                    int[] newMapPair = new int[]{currentGN.getId(), desiredGNToMap.getId()};
                    newMapping.add(newMapPair);
                    if (currentHasBuddy) {
                        MessageLog.getInstance().logMessage("using graph buddy code", MessageLog.HIGH);
                        newMapPair = new int[]{currentGN.getBuddy().getId(), desiredGNToMap.getBuddy().getId()};
                        newMapping.add(newMapPair);
                        int index = bestMappableNodes.indexOf(desiredGNToMap.getBuddy());
                        if (index > 0) {
                            bestMappableNodes.remove(index);
                        }
                    }
                    this.mapGraphs(desiredGraph, currentGraph, newMapping);
                }
                ++i;
            }
        } else {
            int numLinkChanges = this.computeNumLinkChanges(currentGraph);
            if (numLinkChanges < this.currentLowestNumLinkChanges) {
                this.currentBestMapping = this.getMapping(currentGraph);
                this.currentLowestNumLinkChanges = numLinkChanges;
                long l = System.currentTimeMillis() - this.startTime;
            }
        }
    }

    private int numberOfLinks(List graph) {
        if (graph == null) {
            return 0;
        }
        Hashtable<String, int[]> linksHT = new Hashtable<String, int[]>();
        int i = 0;
        while (i < graph.size()) {
            GraphNode gn1 = (GraphNode)graph.get(i);
            List adjacentNodes = gn1.getAdjacentNodes();
            int j = 0;
            while (j < adjacentNodes.size()) {
                GraphNode gn2 = (GraphNode)adjacentNodes.get(j);
                int[] pair = new int[2];
                if (gn1.getId() < gn2.getId()) {
                    pair[0] = gn1.getId();
                    pair[1] = gn2.getId();
                } else {
                    pair[0] = gn2.getId();
                    pair[1] = gn1.getId();
                }
                linksHT.put(String.valueOf(pair[0]) + ":" + pair[1], pair);
                ++j;
            }
            ++i;
        }
        return linksHT.size();
    }

    public Vector parseConfigFile(String filename) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Properties file not found: " + filename);
        }
        Properties graphProps = new Properties();
        try {
            graphProps.load(fis);
        }
        catch (IOException e) {
            System.err.println("Error loading properties file: " + e);
        }
        int numNodes = Integer.parseInt(graphProps.getProperty("numNodes"));
        GraphNode[] graphNodes = new GraphNode[numNodes];
        int i = 0;
        while (i < numNodes) {
            String nodeTypeS = graphProps.getProperty("node" + i + "Type");
            int nodeType = 0;
            if (nodeTypeS != null) {
                nodeType = Integer.parseInt(nodeTypeS);
            }
            graphNodes[i] = new GraphNode(i, nodeType);
            ++i;
        }
        int i2 = 0;
        while (i2 < numNodes) {
            int nodeId;
            StringTokenizer st;
            Vector<GraphNode> adjNodesV = new Vector<GraphNode>();
            String adjNodes = graphProps.getProperty("node" + i2 + "Adjacent");
            if (adjNodes != null) {
                st = new StringTokenizer(adjNodes, ", ", false);
                while (st.hasMoreTokens()) {
                    nodeId = Integer.parseInt(st.nextToken());
                    adjNodesV.addElement(graphNodes[nodeId]);
                }
            }
            adjNodes = null;
            graphNodes[i2].setAdjacentNodes(adjNodesV);
            Vector<GraphNode> illAdjNodesV = new Vector<GraphNode>();
            String illAdjNodes = graphProps.getProperty("node" + i2 + "IllegalAdjacent");
            if (illAdjNodes != null) {
                st = new StringTokenizer(illAdjNodes, ", ", false);
                while (st.hasMoreTokens()) {
                    nodeId = Integer.parseInt(st.nextToken());
                    illAdjNodesV.addElement(graphNodes[nodeId]);
                }
            }
            graphNodes[i2].setIllegalAdjacentNodes(illAdjNodesV);
            boolean passThroughEnabled = Boolean.getBoolean(graphProps.getProperty("node" + i2 + "PassThroughEnabled"));
            graphNodes[i2].setPassThroughEnabled(passThroughEnabled);
            ++i2;
        }
        try {
            fis.close();
        }
        catch (IOException e) {
            System.err.println("Error trying to close config file: " + e);
        }
        Vector<GraphNode> returnV = new Vector<GraphNode>();
        int i3 = 0;
        while (i3 < graphNodes.length) {
            returnV.addElement(graphNodes[i3]);
            ++i3;
        }
        return returnV;
    }

    private void preMap(List desiredGraph, List currentGraph, List mappings) {
        this.unMap(desiredGraph);
        this.unMap(currentGraph);
        this.addMap(desiredGraph, currentGraph, mappings);
    }

    private void unMap(List graph) {
        int j = 0;
        while (j < graph.size()) {
            GraphNode gn = (GraphNode)graph.get(j);
            gn.setMapped(false);
            ++j;
        }
    }
}

