/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public final class FileUtility {
    private static final int MAX_BUFFER_SIZE = 1024;

    private FileUtility() {
    }

    public static synchronized void copy(String source, String destination) throws FileNotFoundException, IOException {
        FileUtility.copy(source, destination, true);
    }

    public static synchronized void copy(String source, String destination, boolean overwriteExisting) throws FileNotFoundException, IOException {
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        if (!overwriteExisting && FileUtility.fileExists(destination)) {
            throw new FileNotFoundException("Destination file \"" + destination + "\"exists");
        }
        BufferedInputStream sourceStream = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream destinationStream = new BufferedOutputStream(new FileOutputStream(destination));
        try {
            while ((bytesRead = sourceStream.read(buffer, 0, buffer.length)) > 0) {
                destinationStream.write(buffer, 0, bytesRead);
            }
        }
        finally {
            Object var8_7 = null;
            sourceStream.close();
            destinationStream.close();
        }
    }

    public static synchronized void createDir(String dir) throws NullPointerException, SecurityException, Exception {
        boolean result = false;
        File dirFile = new File(dir);
        result = dirFile.mkdir();
        if (!result) {
            throw new Exception("Could not create directory " + dir);
        }
    }

    public static synchronized void createFile(String filename) throws NullPointerException, SecurityException, IOException {
        boolean result = false;
        File file = new File(filename);
        result = file.createNewFile();
        if (!result) {
            throw new IOException("Could not create file " + filename);
        }
    }

    public static synchronized boolean deleteFile(String filename) {
        File file = new File(filename);
        return file.delete();
    }

    public static synchronized boolean dirExists(String dir) {
        boolean result = false;
        try {
            File dirFile = new File(dir);
            result = dirFile.exists() && dirFile.isDirectory();
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("NullPointerException in dirExists");
            return false;
        }
        catch (SecurityException securityException) {
            System.err.println("SecurityException in dirExists");
            return false;
        }
        return result;
    }

    public static synchronized boolean fileExists(String filename) {
        boolean result = false;
        try {
            File file = new File(filename);
            result = file.exists() && file.isFile();
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("NullPointerException in fileExists");
            return false;
        }
        catch (SecurityException securityException) {
            System.err.println("SecurityException in fileExists");
            return false;
        }
        return result;
    }

    public static synchronized String[] listDirFiles(String dirName) {
        ArrayList<String> filenames = new ArrayList<String>();
        File dir = new File(dirName);
        File[] contents = dir.listFiles();
        int i = 0;
        while (i < contents.length) {
            if (contents[i].isFile()) {
                filenames.add(contents[i].getName());
            }
            ++i;
        }
        String[] result = new String[filenames.size()];
        return filenames.toArray(result);
    }

    public static synchronized boolean move(String source, String destination) throws FileNotFoundException {
        return FileUtility.move(source, destination, true);
    }

    public static synchronized boolean move(String source, String destination, boolean overwriteExisting) throws FileNotFoundException {
        if (!overwriteExisting && FileUtility.fileExists(destination)) {
            throw new FileNotFoundException("Destination file \"" + destination + "\"exists");
        }
        File sourceFile = new File(source);
        File destinationFile = new File(destination);
        return sourceFile.renameTo(destinationFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Object readObject(String location) {
        ObjectInputStream ois = null;
        Object result = null;
        try {
            try {
                ois = new ObjectInputStream(new FileInputStream(location));
                result = ois.readObject();
            }
            catch (Exception exception) {
                System.err.println("Error reading object " + location);
                result = null;
            }
            Object var4_3 = null;
            if (ois == null) return result;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ois.close();
            return result;
        }
        catch (IOException iOException) {}
        return result;
    }

    public static synchronized void removeDirRecursively(String directory) throws SecurityException, NullPointerException {
        File dir = null;
        dir = new File(directory);
        String[] filesInDir = dir.list();
        File currentFile = null;
        int i = 0;
        while (i < filesInDir.length) {
            currentFile = new File(directory, filesInDir[i]);
            if (currentFile.isFile()) {
                System.out.println("Removing file " + currentFile);
                currentFile.delete();
            } else if (currentFile.isDirectory()) {
                FileUtility.removeDirRecursively(currentFile.getPath());
            } else {
                System.out.println("Error in removeDirRecursively, unknown file type " + currentFile.getPath());
            }
            ++i;
        }
        System.out.println("Removing directory " + dir);
        dir.delete();
    }

    public static synchronized void writeObject(String location, Object object) throws FileNotFoundException, SecurityException, IOException, InvalidClassException, NotSerializableException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(location));
            oos.writeObject(object);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        Object var4_3 = null;
        if (oos != null) {
            try {
                oos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

