/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.NodeData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FabricData
implements Serializable {
    private String name;
    private String propsFile;
    private List nodeData = new ArrayList();
    private List nodesToRemove = new ArrayList();

    public FabricData() {
    }

    public FabricData(String name) {
        this.name = name;
    }

    public FabricData(String name, String propsFile) {
        this.name = name;
        this.propsFile = propsFile;
    }

    public final void addNodeData(NodeData node) {
        this.nodeData.add(node);
    }

    public final void addNodeData(List nodeData) {
        this.nodeData.addAll(nodeData);
    }

    public final void addNodeToRemove(NodeData node) {
        this.nodesToRemove.add(node);
    }

    public final void addNodesToRemove(List nodesToRemove) {
        this.nodesToRemove.addAll(nodesToRemove);
    }

    public boolean containsNode(NodeData node) {
        NodeData currentNode = null;
        boolean result = false;
        int i = 0;
        while (i < this.nodeData.size()) {
            currentNode = (NodeData)this.nodeData.get(i);
            if (currentNode.equals(node)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public final String getName() {
        return this.name;
    }

    public final List getNodeData() {
        return this.nodeData;
    }

    public final List getNodesToRemove() {
        int nodeCount = this.nodesToRemove.size();
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < nodeCount) {
            NodeData node = (NodeData)this.nodesToRemove.get(i);
            result.add(String.valueOf(node.getSCHost()) + ":" + node.getSCDomain());
            ++i;
        }
        return result;
    }

    public final String getPropsFile() {
        return this.propsFile;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setNodeData(List nodeData) {
        if (nodeData != null) {
            this.nodeData = nodeData;
        }
    }

    public final void setNodesToRemove(List nodesToRemove) {
        if (nodesToRemove != null) {
            this.nodesToRemove = nodesToRemove;
        }
    }

    public final void setPropsFile(String propsFile) {
        this.propsFile = propsFile;
    }

    public String toString() {
        NodeData node = null;
        StringBuffer buf = new StringBuffer("Fabric name: " + this.name + "\nProperty File: " + this.propsFile);
        int i = 0;
        while (i < this.nodeData.size()) {
            node = (NodeData)this.nodeData.get(i);
            buf.append("\n\tMember " + i + ": " + node);
            ++i;
        }
        buf.append("\n");
        return buf.toString();
    }
}

