/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.MessageLog;
import com.sun.wildcat.fabric_management.common.ReserveWCI;
import java.io.Serializable;
import java.util.StringTokenizer;

public class EndPoint
implements Serializable {
    private static final int SWITCH_END_POINT_STR_LEN = 2;
    private static final int NODE_END_POINT_STR_LEN = 5;
    private static final String ILLEGAL_END_POINT_DATA_ERROR = "Illegal End Point Data detected in: ";
    private ReserveWCI wci;
    private int port;

    public EndPoint(int cnode, int slot, int id, int port) {
        this.wci = new ReserveWCI(cnode, slot, id);
        this.port = port;
    }

    public EndPoint(ReserveWCI wci, int port) {
        this.wci = wci;
        this.port = port;
    }

    public EndPoint(String EndPtData) {
        StringTokenizer st = new StringTokenizer(EndPtData, ":");
        int tokenCnt = st.countTokens();
        if (tokenCnt == 2) {
            this.wci = new ReserveWCI(st.nextToken(), null, -1, -1);
            this.port = Integer.parseInt(st.nextToken());
        } else if (tokenCnt == 5) {
            this.wci = new ReserveWCI(st.nextToken(), st.nextToken(), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
            this.port = Integer.parseInt(st.nextToken());
        } else {
            String local = String.valueOf(this.getClass().getName()) + ".EndPoint(String)\n";
            MessageLog.getInstance().logMessage(String.valueOf(local) + ILLEGAL_END_POINT_DATA_ERROR + EndPtData, MessageLog.ERROR);
            this.wci = new ReserveWCI(null, null, -1, -1);
            this.port = -1;
        }
    }

    public EndPoint(String scName, int port) {
        this.wci = new ReserveWCI(scName, null, -1, -1);
        this.port = port;
    }

    public EndPoint(String scName, String scDomain, int slot, int id, int port) {
        this.wci = new ReserveWCI(scName, scDomain, slot, id);
        this.port = port;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof EndPoint)) {
            return false;
        }
        EndPoint thatEP = (EndPoint)that;
        boolean result = this.getWCI().equals(thatEP.getWCI()) && this.getPort() == thatEP.getPort();
        return result;
    }

    public int getPort() {
        return this.port;
    }

    public ReserveWCI getReserveWCI() {
        return this.wci;
    }

    public String getSCDomain() {
        return this.wci.getSCDomain();
    }

    public String getSCName() {
        return this.wci.getSCName();
    }

    public ReserveWCI getWCI() {
        return this.wci;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.port;
        result = 37 * result + this.wci.hashCode();
        return result;
    }

    public boolean isSwitchEP() {
        return this.getSCDomain() == null;
    }

    public String toString() {
        String result = null;
        result = !this.isSwitchEP() ? new String(String.valueOf(this.wci.getSCName()) + ":" + this.wci.getSCDomain() + ":" + this.wci.getSlot() + ":" + this.wci.getID() + ":" + this.port) : new String(String.valueOf(this.wci.getSCName()) + ":" + ":" + ":" + ":" + this.port);
        return result;
    }
}

