/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.common.DiscoveryLink;
import com.sun.wildcat.common.LinkEndPoint;
import com.sun.wildcat.common.ScBaseIntf;
import com.sun.wildcat.common.SecurityCredential;
import com.sun.wildcat.common.SwitchBaseIntf;
import com.sun.wildcat.fabric_management.common.DiscoveryDomainException;
import com.sun.wildcat.fabric_management.common.DiscoveryNodeException;
import com.sun.wildcat.fabric_management.common.MessageLog;
import com.sun.wildcat.fabric_management.common.Node;
import com.sun.wildcat.fabric_management.common.RMILkupSettings;
import com.sun.wildcat.fabric_management.common.RMILookupUtils;
import com.sun.wildcat.fabric_management.common.WCISafariPortUtil;
import com.sun.wildcat.fabric_management.security.PasswordCredHandler;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Discovery
extends Thread {
    private static final String DISC_NO_HOSTS = "No hosts specified, discovery aborted";
    private static final String DISC_NO_HOST = "Specified host was not registered with the fabric, discovery aborted";
    private static final String DISC_STATE_CONTACT = "Contacting system controller";
    private static final String DISC_STATE_START = "Starting Discovery";
    private static final String DISC_STATE_WAIT = "Waiting for discovery to complete";
    private static final String DISC_STATE_STOP = "Stopping Discovery";
    private static final String DISC_STATE_GET = "Getting Discovery Data";
    private static final String DISC_STATE_FINISHED = "Discovery Finished";
    private static final String DISC_DOM_FAILED = "Discovery on host failed";
    private static final String DISC_SPID_FAILED = "All wcis failed";
    private static final String DISC_ABORT = "Discovery aborted";
    private static final int SC_SLEEP_TIME = 4;
    private Map hosts;
    private Map fmNodeMap;
    public RMILkupSettings rmiSettings;
    private boolean stop = false;
    private Probe[] probe;
    private List exceptions;
    private List discoveryLinks = new ArrayList();
    private static List simulationLinks = new ArrayList();
    public static final String LINK_SEPARATOR = "#";

    public Discovery() {
    }

    public Discovery(Map hosts, Map fmNodeMap) throws Exception {
        this.hosts = hosts;
        this.fmNodeMap = fmNodeMap;
        if (hosts == null || fmNodeMap == null) {
            throw new NullPointerException();
        }
        if (hosts.size() == 0 || fmNodeMap.size() == 0) {
            throw new Exception(DISC_NO_HOSTS);
        }
        this.debugPrintFmNodeMap(fmNodeMap);
        Map scHostMap = this.createScHostMap(fmNodeMap);
        if (scHostMap == null || scHostMap.size() == 0) {
            throw new NullPointerException();
        }
        HashMap<String, Probe> probeMap = new HashMap<String, Probe>();
        Iterator iterator = hosts.entrySet().iterator();
        while (iterator.hasNext()) {
            String domainId;
            Map.Entry entry = iterator.next();
            String nodeString = (String)entry.getKey();
            List safariPortIds = (List)entry.getValue();
            if (nodeString == null) {
                throw new NullPointerException();
            }
            StringTokenizer st = new StringTokenizer(nodeString, ":");
            String hostname = st.nextToken();
            Probe probe = (Probe)probeMap.get(hostname);
            if (probe == null) {
                Node node = (Node)scHostMap.get(hostname);
                if (node == null) {
                    throw new Exception(DISC_NO_HOST);
                }
                probe = new Probe(node);
                probeMap.put(hostname, probe);
            }
            if (!st.hasMoreTokens() || (domainId = st.nextToken()) == null || domainId.equals("")) continue;
            probe.addDomain(domainId, safariPortIds);
        }
        this.probe = probeMap.values().toArray(new Probe[probeMap.size()]);
    }

    public void addAndLogException(Exception e) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        this.exceptions.add(e);
        MessageLog.getInstance().logMessage(e.toString(), MessageLog.ERROR);
    }

    private void addDiscoveryData(List singleHostData) {
        this.discoveryLinks.addAll(singleHostData);
    }

    public static boolean containsLink(DiscoveryLink link, List links) {
        LinkEndPoint le = link.getLocalEnd();
        LinkEndPoint re = link.getRemoteEnd();
        int j = 0;
        while (j < links.size()) {
            DiscoveryLink existingLink = (DiscoveryLink)links.get(j);
            LinkEndPoint ele = existingLink.getLocalEnd();
            LinkEndPoint ere = existingLink.getRemoteEnd();
            if (le.getFmNodeId() == ele.getFmNodeId() && le.getSafariPort() == ele.getSafariPort() && le.getLinkNumber() == ele.getLinkNumber() && re.getFmNodeId() == ere.getFmNodeId() && re.getSafariPort() == ere.getSafariPort() && re.getLinkNumber() == ere.getLinkNumber() || le.getFmNodeId() == ere.getFmNodeId() && le.getSafariPort() == ere.getSafariPort() && le.getLinkNumber() == ere.getLinkNumber() && re.getFmNodeId() == ele.getFmNodeId() && re.getSafariPort() == ele.getSafariPort() && re.getLinkNumber() == ele.getLinkNumber()) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private Map createScHostMap(Map fmNodeMap) {
        HashMap<String, Node> scHostMap = new HashMap<String, Node>();
        if (fmNodeMap == null) {
            return null;
        }
        Iterator iterator = fmNodeMap.values().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == null) continue;
            scHostMap.put(node.getSCName(), node);
        }
        return scHostMap;
    }

    private void debugPrintFmNodeMap(Map fmNodeMap) {
        MessageLog.getInstance().logMessage("******** DISCOVERY FM NODE ID MAP ********", MessageLog.HIGH);
        Iterator iterator = fmNodeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Long fmNodeId = (Long)entry.getKey();
            Node node = (Node)entry.getValue();
            MessageLog.getInstance().logMessage(String.valueOf(String.valueOf(fmNodeId)) + " = " + node.getSCName(), MessageLog.HIGH);
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public List getRawDiscoveryData() {
        return this.discoveryLinks;
    }

    private String getStackTrace(Exception e) {
        ByteArrayOutputStream bso = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bso);
        e.printStackTrace(ps);
        return bso.toString();
    }

    public String[] getStringLinkData() throws Exception {
        String local = String.valueOf(this.getClass().getName()) + ".getStringLinkData()\n";
        if (simulationLinks.size() > 0) {
            String[] result = null;
            try {
                result = simulationLinks.toArray(new String[0]);
            }
            catch (Exception e) {
                MessageLog.getInstance().logStackTrace(e);
            }
            return result;
        }
        MessageLog.getInstance().logMessage("********** Discovery Links **********\n" + this.discoveryLinks + "\n", MessageLog.HIGH);
        if (this.discoveryLinks.isEmpty()) {
            return null;
        }
        ArrayList<DiscoveryLink> nonRepeatingLinks = new ArrayList<DiscoveryLink>();
        int i = 0;
        while (i < this.discoveryLinks.size()) {
            DiscoveryLink link = (DiscoveryLink)this.discoveryLinks.get(i);
            LinkEndPoint localEnd = link.getLocalEnd();
            LinkEndPoint remoteEnd = link.getRemoteEnd();
            if (!Discovery.containsLink(link, nonRepeatingLinks)) {
                nonRepeatingLinks.add(link);
            }
            ++i;
        }
        String[] parsedDiscoveryLinks = Discovery.parseDiscoveryLinks(nonRepeatingLinks, this.fmNodeMap);
        MessageLog.getInstance().logMessage("********** Parsed Discovery Links **********", MessageLog.HIGH);
        if (parsedDiscoveryLinks != null && parsedDiscoveryLinks.length > 0) {
            int i2 = 0;
            while (i2 < parsedDiscoveryLinks.length) {
                MessageLog.getInstance().logMessage(parsedDiscoveryLinks[i2], MessageLog.HIGH);
                ++i2;
            }
        }
        return parsedDiscoveryLinks;
    }

    public int getTimeout() {
        return Node.getMaxLinkCount() * Node.getMaxDiscoveryLinkTime() + Node.getMaxScLkupTime();
    }

    public boolean isExceptions() {
        return this.exceptions != null && this.exceptions.size() > 0;
    }

    public static String[] parseDiscoveryLinks(List links, Map fmNodeMap) {
        ArrayList<String> discoveryLinkStrings = new ArrayList<String>();
        int i = 0;
        while (i < links.size()) {
            String localScHostDomain;
            DiscoveryLink link = (DiscoveryLink)links.get(i);
            LinkEndPoint localEnd = link.getLocalEnd();
            LinkEndPoint remoteEnd = link.getRemoteEnd();
            Node nd = (Node)fmNodeMap.get(new Long(localEnd.getFmNodeId()));
            if (nd != null && (localScHostDomain = nd.getSCNameAndDomain()) != null) {
                String remoteScHostDomain;
                String localLinkString;
                StringTokenizer localT = new StringTokenizer(localScHostDomain, ":");
                if (localT.countTokens() == 2) {
                    int safariPort = localEnd.getSafariPort();
                    localLinkString = String.valueOf(localT.nextToken()) + ":" + localT.nextToken() + ":" + WCISafariPortUtil.getSlotNumber(safariPort, nd.getType()) + ":" + WCISafariPortUtil.getWciNumber(safariPort, nd.getType()) + ":" + localEnd.getLinkNumber();
                } else {
                    localLinkString = String.valueOf(localT.nextToken()) + ":" + ":" + ":" + ":" + localEnd.getLinkNumber();
                }
                Node remoteND = (Node)fmNodeMap.get(new Long(remoteEnd.getFmNodeId()));
                if (remoteND != null && (remoteScHostDomain = remoteND.getSCNameAndDomain()) != null) {
                    String remoteLinkString;
                    StringTokenizer remoteT = new StringTokenizer(remoteScHostDomain, ":");
                    if (remoteT.countTokens() == 2) {
                        int remoteSafariPort = remoteEnd.getSafariPort();
                        remoteLinkString = String.valueOf(remoteT.nextToken()) + ":" + remoteT.nextToken() + ":" + WCISafariPortUtil.getSlotNumber(remoteSafariPort, remoteND.getType()) + ":" + WCISafariPortUtil.getWciNumber(remoteSafariPort, remoteND.getType()) + ":" + remoteEnd.getLinkNumber();
                    } else {
                        remoteLinkString = String.valueOf(remoteT.nextToken()) + ":" + ":" + ":" + ":" + remoteEnd.getLinkNumber();
                    }
                    discoveryLinkStrings.add(String.valueOf(localLinkString) + "=" + remoteLinkString);
                }
            }
            ++i;
        }
        String[] linkStrings = new String[discoveryLinkStrings.size()];
        return discoveryLinkStrings.toArray(linkStrings);
    }

    public void run() {
        Probe waitingProbe;
        Iterator iterator;
        String local = String.valueOf(this.getClass().getName()) + ".run()\n";
        if (simulationLinks.size() > 0) {
            return;
        }
        int i = 0;
        while (i < this.probe.length) {
            this.probe[i].contactSC();
            ++i;
        }
        MessageLog.getInstance().logMessage("Discovery waiting for contact to finish", MessageLog.HIGH);
        int i2 = 0;
        while (i2 < this.probe.length) {
            this.probe[i2].waitForContactToFinish();
            ++i2;
        }
        int timeout = 0;
        int i3 = 0;
        while (i3 < this.probe.length) {
            int waitTime = this.probe[i3].startDiscovery();
            if (waitTime > 0 && waitTime > timeout) {
                timeout = waitTime;
            }
            ++i3;
        }
        MessageLog.getInstance().logMessage("Discovery calculated timeout = " + timeout, MessageLog.HIGH);
        ArrayList<Probe> waitingProbes = new ArrayList<Probe>(Arrays.asList(this.probe));
        int doneCt = 0;
        int i4 = 0;
        while (i4 < timeout && doneCt != this.probe.length) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                MessageLog.getInstance().logMessage("Discovery received stop request", MessageLog.HIGH);
                break;
            }
            iterator = waitingProbes.iterator();
            while (iterator.hasNext()) {
                waitingProbe = (Probe)iterator.next();
                if (!waitingProbe.isDiscoveryDone()) continue;
                MessageLog.getInstance().logMessage("Discovery complete for: " + waitingProbe.getHostName(), MessageLog.HIGH);
                this.addDiscoveryData(waitingProbe.getDiscoveryData());
                iterator.remove();
                ++doneCt;
            }
            i4 += 4;
        }
        if (waitingProbes.size() > 0) {
            MessageLog.getInstance().logMessage("Discovery timeout met for host(s). Retrieving discovery data for remaining hosts.", MessageLog.HIGH);
        }
        iterator = waitingProbes.iterator();
        while (iterator.hasNext()) {
            waitingProbe = (Probe)iterator.next();
            this.addDiscoveryData(waitingProbe.getDiscoveryData());
        }
        int i5 = 0;
        while (i5 < this.probe.length) {
            this.probe[i5].stopDiscovery();
            ++i5;
        }
    }

    public void setRMILkupSettings(RMILkupSettings rmiSettings) {
        this.rmiSettings = rmiSettings;
    }

    public static void setSimulationLinks(String data) {
        StringTokenizer links = new StringTokenizer(data, LINK_SEPARATOR);
        simulationLinks.clear();
        while (links.hasMoreTokens()) {
            String link = links.nextToken();
            simulationLinks.add(link);
            MessageLog.getInstance().logMessage("Degraded configuration link added \"" + link + "\"", MessageLog.HIGH);
        }
    }

    public void setTimeout(int time) {
    }

    public void stopDiscovery() {
        this.interrupt();
    }

    class Probe {
        private Node node;
        private String hostname;
        private Map domainMap;
        private Remote sc;
        private boolean failed;
        private int linkWaitTime = 0;
        private int maxLinks = 0;
        private Thread contactThread;

        public Probe(Node node) {
            this.node = node;
            this.hostname = node.getSCName();
            this.linkWaitTime = node.getMaxDiscoveryLinkTimeForNodeType();
            this.maxLinks = node.getMaxLinkCountForNodeType();
        }

        static /* synthetic */ Map access$1(Probe $0) {
            return $0.domainMap;
        }

        static /* synthetic */ String access$2(Probe $0) {
            return $0.hostname;
        }

        static /* synthetic */ Discovery access$3(Probe $0) {
            return $0.Discovery.this;
        }

        static /* synthetic */ Remote access$4(Probe $0) {
            return $0.sc;
        }

        static /* synthetic */ void access$5(Probe $0, Remote $1) {
            $0.sc = $1;
        }

        static /* synthetic */ boolean access$6(Probe $0) {
            return $0.failed;
        }

        static /* synthetic */ void access$7(Probe $0, boolean $1) {
            $0.failed = $1;
        }

        public void addDomain(String domain, List safariPortIdList) {
            if (this.domainMap == null) {
                this.domainMap = new HashMap();
            }
            int[] safariPortIds = null;
            if (safariPortIdList != null && safariPortIdList.size() != 0) {
                safariPortIds = new int[safariPortIdList.size()];
                int i = 0;
                while (i < safariPortIds.length) {
                    safariPortIds[i] = (Integer)safariPortIdList.get(i);
                    ++i;
                }
            }
            this.domainMap.put(domain, safariPortIds);
        }

        public void contactSC() {
            this.contactThread = new Thread(this){
                private final /* synthetic */ Probe this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    String state = "Contacting system controller";
                    String service = Probe.access$1(this.this$1) == null || Probe.access$1(this.this$1).size() == 0 ? "//" + Probe.access$2(this.this$1) + ":" + Probe.access$3((Probe)this.this$1).rmiSettings.switchPort + "/" + Probe.access$3((Probe)this.this$1).rmiSettings.switchLkupName : "//" + Probe.access$2(this.this$1) + ":" + Probe.access$3((Probe)this.this$1).rmiSettings.scPort + "/" + Probe.access$3((Probe)this.this$1).rmiSettings.scLkupName;
                    try {
                        MessageLog.getInstance().logMessage(String.valueOf(Probe.access$2(this.this$1)) + ":" + state, MessageLog.HIGH);
                        Probe.access$5(this.this$1, RMILookupUtils.getRemoteObject(service));
                    }
                    catch (NotBoundException e) {
                        String error = String.valueOf(state) + ":" + "obj not bound on " + Probe.access$2(this.this$1) + " " + e.getMessage();
                        Probe.access$7(this.this$1, true);
                        Probe.access$3(this.this$1).addAndLogException(new DiscoveryNodeException(Probe.access$2(this.this$1), error));
                    }
                    catch (MalformedURLException e) {
                        String error = String.valueOf(state) + ":" + "Bad URL -- " + e.getMessage();
                        Probe.access$7(this.this$1, true);
                        Probe.access$3(this.this$1).addAndLogException(new DiscoveryNodeException(Probe.access$2(this.this$1), error));
                    }
                    catch (UnknownHostException e) {
                        String error = e.getMessage();
                        Probe.access$7(this.this$1, true);
                        Probe.access$3(this.this$1).addAndLogException(new DiscoveryNodeException(Probe.access$2(this.this$1), error));
                    }
                    catch (RemoteException e) {
                        String error = String.valueOf(state) + ":" + "registry failure on " + Probe.access$2(this.this$1) + "  " + e.getMessage();
                        Probe.access$7(this.this$1, true);
                        Probe.access$3(this.this$1).addAndLogException(new DiscoveryNodeException(Probe.access$2(this.this$1), error));
                    }
                }
            };
            this.contactThread.start();
        }

        public List getDiscoveryData() {
            String state = Discovery.DISC_STATE_GET;
            ArrayList singleHostData = new ArrayList();
            if (this.failed) {
                return singleHostData;
            }
            if (this.domainMap == null || this.domainMap.size() == 0) {
                try {
                    MessageLog.getInstance().logMessage(String.valueOf(this.hostname) + ":" + state, MessageLog.LOW);
                    DiscoveryLink[] links = ((SwitchBaseIntf)this.sc).getDiscoveryData(this.getSecurityCredential(this.hostname, ""));
                    ArrayList<DiscoveryLink> nonNullList = new ArrayList<DiscoveryLink>();
                    int i = 0;
                    while (i < links.length) {
                        if (links[i] != null && links[i].getLocalEnd() != null && links[i].getRemoteEnd() != null) {
                            nonNullList.add(links[i]);
                        }
                        ++i;
                    }
                    singleHostData.addAll(nonNullList);
                }
                catch (Exception e) {
                    this.failed = true;
                    Discovery.this.addAndLogException(new DiscoveryNodeException(this.hostname, String.valueOf(state) + ":" + Discovery.DISC_DOM_FAILED + ":" + Discovery.this.getStackTrace(e)));
                }
            } else {
                int domainFailedCount = 0;
                int domainCount = this.domainMap.size();
                Iterator iterator = this.domainMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String domainName = (String)entry.getKey();
                    int[] safariPortIds = (int[])entry.getValue();
                    try {
                        MessageLog.getInstance().logMessage(String.valueOf(this.hostname) + ":" + domainName + " " + state, MessageLog.LOW);
                        if (safariPortIds == null || safariPortIds.length == 0) {
                            singleHostData.addAll(Arrays.asList(((ScBaseIntf)this.sc).getDiscoveryData(this.getSecurityCredential(this.hostname, domainName), domainName)));
                            continue;
                        }
                        singleHostData.addAll(Arrays.asList(((ScBaseIntf)this.sc).getDiscoveryData(this.getSecurityCredential(this.hostname, domainName), domainName, safariPortIds)));
                    }
                    catch (Exception e) {
                        iterator.remove();
                        ++domainFailedCount;
                        Discovery.this.addAndLogException(new DiscoveryDomainException(this.hostname, domainName, String.valueOf(state) + ":" + Discovery.this.getStackTrace(e)));
                    }
                }
                if (domainFailedCount == domainCount) {
                    Discovery.this.addAndLogException(new DiscoveryNodeException(this.hostname, String.valueOf(state) + ":" + Discovery.DISC_DOM_FAILED));
                }
            }
            return singleHostData;
        }

        public String getHostName() {
            return this.hostname;
        }

        private SecurityCredential getSecurityCredential(String host, String domainName) throws Exception {
            SecurityCredential credential = PasswordCredHandler.instance().createCredential(host, domainName);
            return credential;
        }

        public boolean isDiscoveryDone() {
            String state = Discovery.DISC_STATE_WAIT;
            if (this.failed) {
                return true;
            }
            if (this.domainMap == null || this.domainMap.size() == 0) {
                return true;
            }
            int domainFailedCount = 0;
            int domainCount = this.domainMap.size();
            int doneCt = 0;
            Iterator iterator = this.domainMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String domainName = (String)entry.getKey();
                int[] safariPortIds = (int[])entry.getValue();
                try {
                    if (safariPortIds == null || safariPortIds.length == 0) {
                        if (!((ScBaseIntf)this.sc).isDiscoveryDone(this.getSecurityCredential(this.hostname, domainName), domainName)) continue;
                        ++doneCt;
                        MessageLog.getInstance().logMessage(String.valueOf(this.hostname) + ":" + domainName + " " + state + " DONE", MessageLog.HIGH);
                        continue;
                    }
                    if (!((ScBaseIntf)this.sc).isDiscoveryDone(this.getSecurityCredential(this.hostname, domainName), domainName, safariPortIds)) continue;
                    ++doneCt;
                    MessageLog.getInstance().logMessage(String.valueOf(this.hostname) + ":" + domainName + " " + state + " DONE", MessageLog.HIGH);
                }
                catch (Exception e) {
                    iterator.remove();
                    ++domainFailedCount;
                    Discovery.this.addAndLogException(new DiscoveryDomainException(this.hostname, domainName, String.valueOf(state) + ":" + Discovery.this.getStackTrace(e)));
                }
            }
            if (domainFailedCount == domainCount) {
                this.failed = true;
                Discovery.this.addAndLogException(new DiscoveryNodeException(this.hostname, String.valueOf(state) + ":" + Discovery.DISC_DOM_FAILED));
                return true;
            }
            return doneCt == domainCount;
        }

        private int startDiscovery() {
            String state = Discovery.DISC_STATE_START;
            if (this.failed) {
                return 0;
            }
            if (this.domainMap == null || this.domainMap.size() == 0) {
                return 0;
            }
            int domainFailedCount = 0;
            int domainCount = this.domainMap.size();
            int waitTime = 0;
            Iterator iterator = this.domainMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String domainName = (String)entry.getKey();
                int[] safariPortIds = (int[])entry.getValue();
                try {
                    MessageLog.getInstance().logMessage(String.valueOf(this.hostname) + ":" + domainName + " " + state, MessageLog.HIGH);
                    if (safariPortIds == null || safariPortIds.length == 0) {
                        ((ScBaseIntf)this.sc).startDiscovery(this.getSecurityCredential(this.hostname, domainName), domainName);
                        waitTime = this.linkWaitTime * this.maxLinks;
                        continue;
                    }
                    ((ScBaseIntf)this.sc).startDiscovery(this.getSecurityCredential(this.hostname, domainName), domainName, safariPortIds);
                    int localWaitTime = this.linkWaitTime * safariPortIds.length * 2;
                    if (localWaitTime <= waitTime) continue;
                    waitTime = localWaitTime;
                }
                catch (Exception e) {
                    iterator.remove();
                    ++domainFailedCount;
                    Discovery.this.addAndLogException(new DiscoveryDomainException(this.hostname, domainName, String.valueOf(state) + ":" + Discovery.this.getStackTrace(e)));
                }
            }
            if (domainFailedCount == domainCount) {
                this.failed = true;
                Discovery.this.addAndLogException(new DiscoveryNodeException(this.hostname, String.valueOf(state) + ":" + Discovery.DISC_DOM_FAILED));
                return 0;
            }
            return waitTime;
        }

        public void stopDiscovery() {
            String state = Discovery.DISC_STATE_STOP;
            if (this.failed) {
                return;
            }
            if (this.domainMap == null || this.domainMap.size() == 0) {
                return;
            }
            int domainFailedCount = 0;
            int domainCount = this.domainMap.size();
            Iterator iterator = this.domainMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String domainName = (String)entry.getKey();
                int[] safariPortIds = (int[])entry.getValue();
                try {
                    MessageLog.getInstance().logMessage(String.valueOf(this.hostname) + ":" + domainName + " " + state, MessageLog.HIGH);
                    if (safariPortIds == null || safariPortIds.length == 0) {
                        ((ScBaseIntf)this.sc).stopDiscovery(this.getSecurityCredential(this.hostname, domainName), domainName);
                        continue;
                    }
                    ((ScBaseIntf)this.sc).stopDiscovery(this.getSecurityCredential(this.hostname, domainName), domainName, safariPortIds);
                }
                catch (Exception e) {
                    iterator.remove();
                    ++domainFailedCount;
                    Discovery.this.addAndLogException(new DiscoveryDomainException(this.hostname, domainName, String.valueOf(state) + ":" + Discovery.this.getStackTrace(e)));
                }
            }
            if (domainFailedCount == domainCount) {
                this.failed = true;
                Discovery.this.addAndLogException(new DiscoveryNodeException(this.hostname, String.valueOf(state) + ":" + Discovery.DISC_DOM_FAILED));
            }
        }

        public void waitForContactToFinish() {
            try {
                this.contactThread.join(this.node.getMaxScLkupTimeForNodeType() * 1000);
            }
            catch (InterruptedException interruptedException) {
                this.failed = true;
                Discovery.this.addAndLogException(new DiscoveryNodeException(this.hostname, "Timed out waiting for discover to finish"));
            }
        }
    }
}

