/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.InvalidFlagException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CommandLineArgProc {
    public static final String ARG_DELIMITER = " ";
    private static final String FLAG_DELIMITER = "-";
    private Map flagValues = new HashMap();
    private String[] possibleFlags;
    private String[] commandLineArgs;
    private List invalidArgs = new ArrayList();
    private String badFlag;
    private boolean ignoreInvalidFlags = false;

    public CommandLineArgProc() {
    }

    public CommandLineArgProc(String[] possibleFlags, String[] commandLineArgs) throws InvalidFlagException {
        if (!this.isFlag(possibleFlags)) {
            throw new InvalidFlagException("bad flag = " + this.badFlag);
        }
        this.possibleFlags = possibleFlags;
        this.commandLineArgs = commandLineArgs;
    }

    public CommandLineArgProc(String[] possibleFlags, String[] commandLineArgs, boolean ignoreInvalidFlags) {
        this.possibleFlags = possibleFlags;
        this.commandLineArgs = commandLineArgs;
        this.ignoreInvalidFlags = ignoreInvalidFlags;
    }

    public boolean flagPresent(String flag) {
        boolean result = false;
        try {
            result = this.flagValues.containsKey(flag);
        }
        catch (Exception exception) {
            result = false;
        }
        return result;
    }

    public String[] getArgs() {
        return this.commandLineArgs;
    }

    public List getErrantFlags() {
        return this.invalidArgs;
    }

    public String getExceptionFlag() {
        return this.badFlag;
    }

    private String getFlagValue(int valueIndex) {
        String possibleValue;
        if (valueIndex < this.commandLineArgs.length && !this.isFlag(possibleValue = this.commandLineArgs[valueIndex])) {
            return possibleValue;
        }
        return null;
    }

    public String getFlagValue(String flag) {
        String result = null;
        try {
            return (String)this.flagValues.get(flag);
        }
        catch (Exception exception) {
            result = null;
            return result;
        }
    }

    public String[] getPossibleFlags() {
        return this.possibleFlags;
    }

    public String[] getRemainingFlags() {
        if (this.flagValues.size() <= 0) {
            return null;
        }
        ArrayList<String> flags = new ArrayList<String>();
        Iterator iter = this.flagValues.keySet().iterator();
        while (iter.hasNext()) {
            String flag = (String)iter.next();
            String value = (String)this.flagValues.get(flag);
            flags.add(flag);
            if (value == null) continue;
            flags.add(value);
        }
        String[] result = new String[flags.size()];
        return flags.toArray(result);
    }

    public boolean hasErrors() {
        if (this.ignoreInvalidFlags) {
            return false;
        }
        return this.invalidArgs.size() > 0;
    }

    private boolean isFlag(String flag) {
        if (flag == null) {
            return false;
        }
        return flag.startsWith(FLAG_DELIMITER);
    }

    private boolean isFlag(String[] flags) {
        boolean result = true;
        if (flags == null) {
            result = false;
        } else {
            int i = 0;
            while (i < flags.length) {
                if (!this.isFlag(flags[i])) {
                    result = false;
                    this.badFlag = flags[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private boolean isValidFlag(String flag) {
        if (this.ignoreInvalidFlags) {
            return true;
        }
        boolean result = false;
        if (flag == null) {
            return result;
        }
        int i = 0;
        while (i < this.possibleFlags.length) {
            if (flag.equalsIgnoreCase(this.possibleFlags[i])) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            String[] possibleFlags = new String[]{"-flag1", "-flag2", "-flag3", "-flag4", "-flag5"};
            String[] testArgs = new String[]{"-flag", "-flag4", "-flag1", "1", "-flag2", "2", "-flag3", "-flag6", "junk"};
            CommandLineArgProc clp = new CommandLineArgProc(possibleFlags, testArgs);
            clp.processArgs();
            if (clp.hasErrors()) {
                System.out.println("Errors found on command line, Errant flags are:");
                List errors = clp.getErrantFlags();
                int i = 0;
                while (i < errors.size()) {
                    System.out.println("\t" + (String)errors.get(i));
                    ++i;
                }
            } else {
                System.out.println("No Parse Errors");
            }
            if (clp.flagPresent("-flag1")) {
                System.out.println("Flag 1 is present value = " + clp.getFlagValue("-flag1"));
            } else {
                System.out.println("Flag 1 NOT present");
            }
            if (clp.flagPresent("-flag2")) {
                System.out.println("Flag 2 is present value = " + clp.getFlagValue("-flag2"));
            } else {
                System.out.println("Flag 2 NOT present");
            }
            if (clp.flagPresent("-flag3")) {
                System.out.println("Flag 3 is present value = " + clp.getFlagValue("-flag3"));
            } else {
                System.out.println("Flag 3 NOT present");
            }
            if (clp.flagPresent("-flag4")) {
                System.out.println("Flag 4 is present value = " + clp.getFlagValue("-flag4"));
            } else {
                System.out.println("Flag 4 NOT present");
            }
            if (clp.flagPresent("-flag5")) {
                System.out.println("Flag 5 is present value = " + clp.getFlagValue("-flag5"));
            } else {
                System.out.println("Flag 5 NOT present");
            }
        }
        catch (Exception e) {
            System.out.println("Unexpected Exception " + e);
        }
    }

    public void processArgs() {
        String currentArg = null;
        String currentArgValue = null;
        if (this.commandLineArgs == null || this.possibleFlags == null) {
            return;
        }
        int i = 0;
        while (i < this.commandLineArgs.length) {
            currentArg = this.commandLineArgs[i];
            if (this.isFlag(currentArg) && this.isValidFlag(currentArg)) {
                int possibleValueIndex = i + 1;
                currentArgValue = this.getFlagValue(possibleValueIndex);
                if (currentArgValue != null) {
                    i = possibleValueIndex;
                }
                while (i + 1 < this.commandLineArgs.length && !this.isFlag(this.commandLineArgs[i + 1])) {
                    currentArgValue = String.valueOf(currentArgValue) + ARG_DELIMITER + this.commandLineArgs[++i];
                }
                this.flagValues.put(currentArg, currentArgValue);
            } else if (this.ignoreInvalidFlags) {
                this.flagValues.put(currentArg, null);
            } else {
                this.invalidArgs.add(currentArg);
            }
            ++i;
        }
    }

    public void removeFlag(String flagName) {
        if (this.flagValues.containsKey(flagName)) {
            this.flagValues.remove(flagName);
        }
    }

    public void setArgs(String[] commandLineArgs) {
        this.commandLineArgs = commandLineArgs;
    }

    public void setPossibleFlags(String[] possibleFlags) throws InvalidFlagException {
        if (!this.ignoreInvalidFlags && !this.isFlag(possibleFlags)) {
            throw new InvalidFlagException("bad flag = " + this.badFlag);
        }
        this.possibleFlags = possibleFlags;
    }
}

