/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.MessageLog;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class ClassServer
implements Runnable {
    private static final String MALFORMED_HEADER_ERR = "Malformed Header";
    private static final String SERVER_DIED_ERR = "Class Server died";
    private static final String RESPONSE_ERR = "Error writing response";
    private static final String REQUEST_MSG = "ClassServer recieved request for class";
    private static final String SERVER_CREATED_MSG = "new ClassServer on port";
    private ServerSocket server;
    private int port;

    protected ClassServer(int port) throws IOException {
        this.port = port;
        this.server = new ServerSocket(port);
        this.newListener();
        MessageLog.getInstance().logMessage("new ClassServer on port " + port, MessageLog.HIGH);
    }

    public abstract byte[] getBytes(String var1) throws IOException, ClassNotFoundException;

    private static String getPath(DataInputStream in) throws IOException {
        int index;
        BufferedReader d = new BufferedReader(new InputStreamReader(in));
        String line = d.readLine();
        String path = "";
        if (line.startsWith("GET /") && (index = (line = line.substring(5, line.length() - 1).trim()).indexOf(".class")) != -1) {
            path = line.substring(0, index).replace('/', '.');
        }
        while ((line = d.readLine()).length() != 0 && line.charAt(0) != '\r' && line.charAt(0) != '\n') {
        }
        MessageLog.getInstance().logMessage("ClassServer recieved request for class " + path, MessageLog.HIGH);
        if (path.length() != 0) {
            return path;
        }
        throw new IOException(MALFORMED_HEADER_ERR);
    }

    private void newListener() {
        Thread runner = new Thread(this);
        runner.setDaemon(true);
        runner.start();
    }

    public void run() {
        Socket socket;
        try {
            socket = this.server.accept();
        }
        catch (IOException e) {
            System.out.println("Class Server died " + e.getMessage());
            return;
        }
        this.newListener();
        try {
            try {
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                try {
                    DataInputStream in = new DataInputStream(socket.getInputStream());
                    String path = ClassServer.getPath(in);
                    byte[] bytecodes = this.getBytes(path);
                    try {
                        out.writeBytes("HTTP/1.0 200 OK\r\n");
                        out.writeBytes("Content-Length: " + bytecodes.length + "\r\n");
                        out.writeBytes("Content-Type: application/java\r\n\r\n");
                        out.write(bytecodes);
                        out.flush();
                    }
                    catch (IOException iOException) {
                        Object var3_10 = null;
                        try {
                            socket.close();
                        }
                        catch (IOException iOException2) {}
                        return;
                    }
                }
                catch (Exception e) {
                    out.writeBytes("HTTP/1.0 400 " + e.getMessage() + "\r\n");
                    out.writeBytes("Content-Type: text/html\r\n\r\n");
                    out.flush();
                    MessageLog.getInstance().logStackTrace(e);
                }
            }
            catch (IOException ex) {
                MessageLog.getInstance().logMessage("Error writing response " + ex.getMessage(), MessageLog.HIGH);
                MessageLog.getInstance().logStackTrace(ex);
            }
            Object var3_11 = null;
        }
        catch (Throwable throwable) {
            Object var3_12 = null;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }
}

