/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.ClassServer;
import com.sun.wildcat.fabric_management.common.CommandLineArgProc;
import com.sun.wildcat.fabric_management.common.MessageLog;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassFileServer
extends ClassServer
implements FileFilter {
    private static final String ZERO_LENGTH_FILE_ERR = "File length is zero";
    private static final String MEM_CLASS_SERVED_MSG = "Class served from memory";
    private static final String DISK_CLASS_SERVED_MSG = "Class served from disk";
    private static final String PORT_ERR = "Error, must specify a port number";
    private static final String USAGE_MSG = "usage: ClassFileServer -port port_number";
    private static final String portFlag = "-port";
    private static final int BUF_SIZE = 4096;
    private static final int END_OF_STREAM = -1;
    public static int defaultServerPort = 8080;
    private String classpath;
    private String jarDirectory;

    public ClassFileServer() throws IOException {
        super(defaultServerPort);
    }

    public ClassFileServer(int port) throws IOException {
        super(port);
    }

    public ClassFileServer(int port, String classpath) throws IOException {
        super(port);
        this.classpath = classpath;
    }

    public boolean accept(File file) {
        return file.getName().endsWith(".jar");
    }

    private void dumpBytesToFile(byte[] bytes) {
        String file = "/wcfm/SUNWwrsmp/RP_Stub.dump";
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write(bytes);
        }
        catch (Exception e) {
            System.err.println("Could not write file " + file);
            System.err.println(e);
        }
    }

    public byte[] getBytes(String path) throws IOException, ClassNotFoundException {
        byte[] result = null;
        if (this.classpath == null) {
            try {
                result = this.getBytesFromMemory(path);
            }
            catch (Exception exception) {
                MessageLog.getInstance().logMessage("Could not get bytecode from memory trying jars [" + path + "]", MessageLog.HIGH);
                result = this.getBytesFromJar(path);
            }
        } else {
            result = this.getBytesFromFile(path);
        }
        return result;
    }

    public byte[] getBytesFromFile(String path) throws IOException, ClassNotFoundException {
        File f = new File(String.valueOf(this.classpath) + File.separator + path.replace('.', File.separatorChar) + ".class");
        int length = (int)f.length();
        if (length == 0) {
            throw new IOException("File length is zero " + path);
        }
        FileInputStream fin = new FileInputStream(f);
        DataInputStream in = new DataInputStream(fin);
        byte[] bytecodes = new byte[length];
        in.readFully(bytecodes);
        return bytecodes;
    }

    public byte[] getBytesFromJar(String path) throws IOException, ClassNotFoundException {
        byte[] bytecodes = null;
        String resource = "/" + path.replace('.', '/') + ".class";
        MessageLog.getInstance().logMessage("Looking for class \"" + path + "\"", MessageLog.HIGH);
        File[] jarFiles = this.getJarFiles();
        int i = 0;
        while (i < jarFiles.length) {
            File jar = jarFiles[i];
            String jarurl = "jar:file:" + this.jarDirectory + jar.getName() + "!" + resource;
            MessageLog.getInstance().logMessage("Searching Jar URL = " + jarurl + "  for " + resource, MessageLog.HIGH);
            try {
                URL jurl = new URL(jarurl);
                JarURLConnection jarURL = (JarURLConnection)jurl.openConnection();
                JarEntry entry = jarURL.getJarEntry();
                JarFile file = jarURL.getJarFile();
                long classSize = entry.getSize();
                bytecodes = this.readJar(file, entry, classSize);
                break;
            }
            catch (IOException iOException) {
                MessageLog.getInstance().logMessage("Could not find class \"" + path + "\" in \"" + jarurl + "\"", MessageLog.HIGH);
                MessageLog.getInstance().logMessage("Will continue searching jars", MessageLog.HIGH);
            }
            catch (Exception exception) {
                MessageLog.getInstance().logMessage("Could not find class \"" + path + "\" in \"" + jarurl + "\"", MessageLog.HIGH);
            }
            ++i;
        }
        return bytecodes;
    }

    public byte[] getBytesFromMemory(String path) throws IOException, ClassNotFoundException {
        Class<?> cl = Class.forName(path);
        String resource = "/" + path.replace('.', '/') + ".class";
        URL url = cl.getResource(resource);
        InputStream in = url.openStream();
        byte[] bytecodes = this.readEntireByteStream(in);
        in.close();
        return bytecodes;
    }

    private File[] getJarFiles() {
        File jarDir = new File(this.jarDirectory);
        File[] jars = jarDir.listFiles(this);
        return jars;
    }

    public static void main(String[] args) {
        String tempPort = null;
        try {
            CommandLineArgProc clap = new CommandLineArgProc(new String[]{portFlag}, args);
            clap.processArgs();
            if (clap.hasErrors()) {
                ClassFileServer.showUsageExit();
            }
            if (clap.flagPresent(portFlag)) {
                tempPort = clap.getFlagValue(portFlag);
                if (tempPort == null) {
                    ClassFileServer.showUsageExit();
                }
            } else {
                ClassFileServer.showUsageExit();
            }
            new ClassFileServer(Integer.parseInt(tempPort));
        }
        catch (Exception exception) {
            ClassFileServer.showUsageExit();
        }
    }

    private void printJars(File[] jarFiles) {
        if (jarFiles == null) {
            System.out.println("**** NO JAR FILE");
        }
        int i = 0;
        while (i < jarFiles.length) {
            System.out.println("**** JAR FILE NAMES ARE " + jarFiles[i].getName());
            ++i;
        }
    }

    private byte[] readEntireByteStream(InputStream is) throws IOException {
        int numBytesRead = 0;
        int totalBytesRead = 0;
        byte[] result = null;
        byte[] tempBytes = null;
        byte[] tempBytesNew = new byte[4096];
        while ((numBytesRead = is.read(tempBytesNew, 0, 4096)) != -1) {
            tempBytes = new byte[totalBytesRead += numBytesRead];
            if (totalBytesRead != numBytesRead) {
                int prevBytes = totalBytesRead - numBytesRead;
                System.arraycopy(tempBytesNew, 0, tempBytes, prevBytes, numBytesRead);
                System.arraycopy(result, 0, tempBytes, 0, prevBytes);
            } else {
                System.arraycopy(tempBytesNew, 0, tempBytes, 0, numBytesRead);
            }
            result = new byte[totalBytesRead];
            System.arraycopy(tempBytes, 0, result, 0, totalBytesRead);
        }
        return result;
    }

    private byte[] readJar(JarFile file, JarEntry entry, long classSize) throws IOException {
        InputStream is = file.getInputStream(entry);
        int size = (int)classSize;
        byte[] bytecodes = new byte[size];
        int numBytesRead = 0;
        int totalBytesRead = 0;
        while (numBytesRead != -1) {
            numBytesRead = is.read(bytecodes, totalBytesRead, 4096);
            totalBytesRead += numBytesRead;
        }
        return bytecodes;
    }

    public void setJarDirectory(String jarDirectory) {
        this.jarDirectory = !jarDirectory.endsWith(File.separator) ? String.valueOf(jarDirectory) + File.separator : jarDirectory;
    }

    private static void showUsageExit() {
        System.err.println(PORT_ERR);
        System.err.println(USAGE_MSG);
        System.exit(-1);
    }
}

