/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.fabric_management.common;

import com.sun.wildcat.fabric_management.common.AbsentHWInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AbsentHWImpl
implements AbsentHWInterface,
Serializable {
    private List missingLinks = new ArrayList();
    private Map missingWCIs = new HashMap();
    private int missingCentralSwitches;
    private int missingWCIXSwitches;
    private int missingComputeNodes;

    public AbsentHWImpl() {
    }

    public AbsentHWImpl(String[] missingLinks, String[] missingWCIs, int missingCentralSwitches, int missingWCIXSwitches, int missingComputeNodes) {
        this.addMissingLink(missingLinks);
        this.addMissingWCI(missingWCIs);
        this.missingCentralSwitches = missingCentralSwitches;
        this.missingWCIXSwitches = missingWCIXSwitches;
        this.missingComputeNodes = missingComputeNodes;
    }

    public void addMissingHW(AbsentHWInterface missingHW) {
        if (missingHW == null) {
            return;
        }
        this.addMissingLink(missingHW.getMissingLinks());
        this.addMissingWCI(missingHW.getMissingWCIs());
        this.setMissingCentralSwitcheCount(this.missingCentralSwitchCount() + missingHW.missingCentralSwitchCount());
        this.setMissingWCIXSwitchCount(this.missingWCIXSwitchCount() + missingHW.missingWCIXSwitchCount());
        this.setMissingComputeNodeCount(this.missingComputeNodeCount() + missingHW.missingComputeNodeCount());
    }

    public void addMissingLink(String link) {
        this.missingLinks.add(new String(link));
    }

    public void addMissingLink(List links) {
        if (links != null) {
            this.addMissingLink(links.toArray(new String[0]));
        }
    }

    public void addMissingLink(String[] links) {
        if (links != null) {
            int i = 0;
            while (i < links.length) {
                this.missingLinks.add(new String(links[i]));
                ++i;
            }
        }
    }

    public void addMissingWCI(String wci) {
        int currentCount = 0;
        if (this.missingWCIs.containsKey(wci)) {
            Integer val = (Integer)this.missingWCIs.get(wci);
            currentCount = val;
        }
        this.missingWCIs.remove(wci);
        this.missingWCIs.put(wci, new Integer(++currentCount));
    }

    public void addMissingWCI(List wcis) {
        if (wcis != null) {
            this.addMissingWCI(wcis.toArray(new String[0]));
        }
    }

    public void addMissingWCI(String[] wcis) {
        if (wcis != null) {
            int i = 0;
            while (i < wcis.length) {
                this.addMissingWCI(wcis[i]);
                ++i;
            }
        }
    }

    public String[] getMissingLinks() {
        return this.missingLinks.toArray(new String[0]);
    }

    public String[] getMissingWCIs() {
        String[] rv = new String[this.missingWCIs.size()];
        int index = 0;
        Iterator iter = this.missingWCIs.keySet().iterator();
        while (iter.hasNext()) {
            String wci = (String)iter.next();
            Integer ival = (Integer)this.missingWCIs.get(wci);
            rv[index++] = String.valueOf(wci) + ":" + ival;
        }
        return rv;
    }

    public boolean hardwareIsMissing() {
        boolean result = this.missingLinks.size() > 0 || this.missingWCIs.size() > 0 || this.missingCentralSwitches > 0 || this.missingWCIXSwitches > 0 || this.missingComputeNodes > 0;
        return result;
    }

    public int missingCentralSwitchCount() {
        return this.missingCentralSwitches;
    }

    public int missingComputeNodeCount() {
        return this.missingComputeNodes;
    }

    public int missingWCIXSwitchCount() {
        return this.missingWCIXSwitches;
    }

    public void setMissingCentralSwitcheCount(int count) {
        this.missingCentralSwitches = count;
    }

    public void setMissingComputeNodeCount(int count) {
        this.missingComputeNodes = count;
    }

    public void setMissingWCIXSwitchCount(int count) {
        this.missingWCIXSwitches = count;
    }

    public String toString() {
        String[] links = this.getMissingLinks();
        StringBuffer sbuffer = new StringBuffer();
        int j = 0;
        while (j < links.length) {
            if (j == 0) {
                sbuffer.append("Missing Links are: \n");
            }
            sbuffer.append(String.valueOf(links[j]) + "\n");
            ++j;
        }
        String[] wcis = this.getMissingWCIs();
        int j2 = 0;
        while (j2 < wcis.length) {
            if (j2 == 0) {
                sbuffer.append("Missing Wcis are: \n");
            }
            sbuffer.append(String.valueOf(wcis[j2]) + "\n");
            ++j2;
        }
        return sbuffer.toString();
    }
}

