/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wildcat.common;

import com.sun.wildcat.common.Wci;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;

public class WciInventory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STATE_POWERED_OFF = 0;
    public static final int STATE_STANDBY = 1;
    public static final int STATE_RUNNING_POST = 2;
    public static final int STATE_DOMAIN_IDLE = 3;
    public static final int STATE_ACTIVE = 4;
    public static final int STATE_ACTIVE_OBP = 5;
    public static final int STATE_ACTIVE_BOOTING = 6;
    public static final int STATE_ACTIVE_SOLARIS = 7;
    public static final int STATE_ACTIVE_HALTED = 8;
    public static final int STATE_ACTIVE_RESET = 9;
    public static final int STATE_ACTIVE_PANIC = 10;
    public static final int STATE_ACTIVE_DEBUG = 11;
    public static final int STATE_ACTIVE_HUNG = 12;
    public static final int STATE_ACTIVE_PAUSED = 13;
    private static final String[] STATENAME = new String[]{"STATE_POWERED_OFF", "STATE_STANDBY", "STATE_RUNNING_POST", "STATE_DOMAIN_IDLE", "STATE_ACTIVE", "STATE_ACTIVE_OBP", "STATE_ACTIVE_BOOTING", "STATE_ACTIVE_SOLARIS", "STATE_ACTIVE_HALTED", "STATE_ACTIVE_RESET", "STATE_ACTIVE_PANIC", "STATE_ACTIVE_DEBUG", "STATE_ACTIVE_HUNG", "STATE_ACTIVE_PAUSED"};
    private static final String UNKNOWNSTATENAME = "STATE_UNKNOWN";
    private byte nid;
    private String chassisType;
    private int state;
    private Wci[] wciList;
    private BitSet availableNCslices;
    private static final String NODE_ID = "nid";
    private static final String CHASSIS_TYPE = "chassisType";
    private static final String STATE = "state";
    private static final String AVAILABLE_NC_SLICES = "availableNCslices";

    public BitSet getAvailableNCslices() {
        return this.availableNCslices;
    }

    public String getChassisType() {
        return this.chassisType;
    }

    public byte getNid() {
        return this.nid;
    }

    public int getState() {
        return this.state;
    }

    public Wci[] getWciList() {
        return this.wciList;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Hashtable objectData = (Hashtable)in.readObject();
        if (objectData.containsKey(NODE_ID)) {
            this.nid = ((Integer)objectData.get(NODE_ID)).byteValue();
        }
        if (objectData.containsKey(CHASSIS_TYPE)) {
            this.chassisType = ((String)objectData.get(CHASSIS_TYPE)).toString();
        }
        if (objectData.containsKey(STATE)) {
            this.state = (Integer)objectData.get(STATE);
        }
        if (objectData.containsKey(AVAILABLE_NC_SLICES)) {
            this.availableNCslices = (BitSet)objectData.get(AVAILABLE_NC_SLICES);
        }
        this.wciList = (Wci[])in.readObject();
    }

    public void setAvailableNCslices(BitSet availableNCslices) {
        this.availableNCslices = availableNCslices;
    }

    public void setChassisType(String chassisType) {
        this.chassisType = chassisType;
    }

    public void setNid(byte nid) {
        this.nid = nid;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setWciList(Wci[] wciList) {
        this.wciList = wciList;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("nid = " + this.nid + "\n");
        buf.append("chassisType = " + this.chassisType + "\n");
        switch (this.state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                buf.append("state = " + STATENAME[this.state] + "\n");
                break;
            }
            default: {
                buf.append("state = STATE_UNKNOWN\n");
            }
        }
        if (this.wciList != null && this.wciList.length > 0) {
            buf.append("wciList = " + Arrays.asList(this.wciList) + "\n");
        } else {
            buf.append("wciList = null\n");
        }
        buf.append("availableNCslices = " + this.availableNCslices + "\n");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable<String, Object> objectData = new Hashtable<String, Object>();
        objectData.put(NODE_ID, new Integer(this.nid));
        if (this.chassisType != null) {
            objectData.put(CHASSIS_TYPE, this.chassisType);
        }
        objectData.put(STATE, new Integer(this.state));
        if (this.availableNCslices != null) {
            objectData.put(AVAILABLE_NC_SLICES, this.availableNCslices);
        }
        out.writeObject(objectData);
        out.writeObject(this.wciList);
    }
}

