/*
 * Decompiled with CFR 0.152.
 */
package tools.wcfmver;

import com.sun.wildcat.common.MemberInfo;
import com.sun.wildcat.common.RsmSwitchConfig;
import com.sun.wildcat.fabric_management.common.EndPoint;
import com.sun.wildcat.fabric_management.common.FailedCommandException;
import com.sun.wildcat.fabric_management.common.MessageLog;
import com.sun.wildcat.fabric_management.common.Node;
import com.sun.wildcat.fabric_management.common.NodeData;
import com.sun.wildcat.fabric_management.common.PartitionData;
import com.sun.wildcat.fabric_management.common.ReserveLink;
import com.sun.wildcat.fabric_management.common.ReserveWCI;
import com.sun.wildcat.fabric_management.common.WCISafariPortUtil;
import com.sun.wildcat.fabric_management.pmgrs.common.NetMember;
import com.sun.wildcat.fabric_management.pmgrs.common.PartitionInfoInterface;
import com.sun.wildcat.fabric_management.pmgrs.common.RsmConfiguration;
import com.sun.wildcat.fabric_management.pmgrs.rsmdc.XMLPartitionConfig;
import com.sun.wildcat.fabric_management.pmgrs.rsmwcix.RSMSwitchConfigData;
import com.sun.wildcat.fabric_management.pmgrs.rsmwcix.XMLPartitionConfigSwitch;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class XMLPartitionLinksCfg
implements PartitionInfoInterface {
    private static final String FMAPP_BASEDIR = "/opt";
    private static final String RELATIVE_XML_DIR = "SUNWwcfm/dtds/";
    private String dtdBasePath = "/opt/SUNWwcfm/dtds/";
    private PartitionData partitionInfo = null;
    private List partitionLinks = null;
    private long versionStamp;
    public static final String HOSTNAME_DELIMITER = "-";

    public XMLPartitionLinksCfg(PartitionData partitionInfo) {
        this.partitionInfo = partitionInfo;
    }

    public XMLPartitionLinksCfg(PartitionData partitionInfo, String dtdBasePath) {
        this.partitionInfo = partitionInfo;
        this.setDTDBasePath(dtdBasePath);
    }

    private void addNonDuplicateLinks(List links, List newLinks) {
        int numLinks = newLinks.size();
        int i = 0;
        while (i < numLinks) {
            ReserveLink rLink = (ReserveLink)newLinks.get(i);
            if (!this.linkIsInList(links, rLink)) {
                links.add(rLink);
            }
            ++i;
        }
    }

    private EndPoint convertEndPoint(EndPoint ep, NetMember[] members) {
        String hostname = null;
        ReserveWCI wci = ep.getWCI();
        int port = ep.getPort();
        int cnode = wci.getCnodeID();
        int numMembers = members.length;
        int i = 0;
        while (i < numMembers) {
            NetMember member = members[i];
            if (member.cnodeid == cnode) {
                hostname = member.hostname;
                break;
            }
            ++i;
        }
        StringTokenizer st = new StringTokenizer(hostname, HOSTNAME_DELIMITER);
        EndPoint result = new EndPoint(st.nextToken(), st.nextToken(), wci.getSlot(), wci.getID(), port);
        return result;
    }

    private List convertLinks(List links, NetMember[] members) {
        ArrayList<ReserveLink> result = new ArrayList<ReserveLink>();
        int numLinks = links.size();
        int i = 0;
        while (i < numLinks) {
            ReserveLink link = (ReserveLink)links.get(i);
            EndPoint epA = link.getEndPointA();
            EndPoint convEPA = this.convertEndPoint(epA, members);
            EndPoint epB = link.getEndPointB();
            EndPoint convEPB = this.convertEndPoint(epB, members);
            ReserveLink rLink = new ReserveLink(convEPA, convEPB);
            result.add(rLink);
            ++i;
        }
        return result;
    }

    private List getDCLinks(XMLPartitionConfig parser) {
        Map rsmConfigs = parser.getRSMConfigs();
        ArrayList links = new ArrayList();
        Iterator iter = rsmConfigs.keySet().iterator();
        while (iter.hasNext()) {
            String scNameAndDomain = (String)iter.next();
            RsmConfiguration config = (RsmConfiguration)rsmConfigs.get(scNameAndDomain);
            List nodeLinks = config.getLinks(this.getNode(scNameAndDomain).getType());
            List convLinks = this.convertLinks(nodeLinks, config.controller.getNetMembers());
            this.addNonDuplicateLinks(links, convLinks);
        }
        return links;
    }

    public final String getDTDBasePath() {
        return this.dtdBasePath;
    }

    public long getFMNodeID(String scNameAndDomain) {
        return this.getFMNodeID(Node.getSCName((String)scNameAndDomain), Node.getSCDomain((String)scNameAndDomain));
    }

    public long getFMNodeID(String scName, String scDomain) {
        Node node = this.getNode(scName, scDomain);
        if (node == null) {
            return -1L;
        }
        return node.getFMNodeID();
    }

    public String getLinkStatus(String scNameAndDomain, int slot, int wcID, int linkNum) {
        return ReserveLink.linkStatusStrings[0];
    }

    public Node getNode(String scNameAndDomain) {
        String scName = Node.getSCName((String)scNameAndDomain);
        String scDomain = Node.getSCDomain((String)scNameAndDomain);
        return this.getNode(scName, scDomain);
    }

    public Node getNode(String scName, String scDomain) {
        NodeData node = this.partitionInfo.findNode(scName, scDomain);
        Node resultNode = new Node(scName, scDomain, node.getSCUserName(), node.getSCPassword(), node.getChassisType(), node.getInfo(), node.getSolarisHostname());
        return resultNode;
    }

    public int getNumMembers() {
        return this.partitionInfo.getNodeData().size();
    }

    public final String getPartitionData() {
        return this.partitionInfo.toString();
    }

    public int getPartitionID() {
        return this.partitionInfo.getPartitionID();
    }

    public final List getPartitionLinks() {
        return this.partitionLinks;
    }

    public String getSolarisHostname(String scNameAndDomain) {
        return this.getSolarisHostname(Node.getSCName((String)scNameAndDomain), Node.getSCDomain((String)scNameAndDomain));
    }

    public String getSolarisHostname(String scName, String scDomain) {
        Node node = this.getNode(scName, scDomain);
        if (node == null) {
            return null;
        }
        return node.getSolarisHostname();
    }

    private List getSwitchLinks(XMLPartitionConfig parser) {
        ArrayList<ReserveLink> links = new ArrayList<ReserveLink>();
        Map rsmSwitchConfigs = parser.getRSMSwitchConfigs();
        Iterator iter = rsmSwitchConfigs.keySet().iterator();
        while (iter.hasNext()) {
            String scNameDomain = (String)iter.next();
            RSMSwitchConfigData configData = (RSMSwitchConfigData)rsmSwitchConfigs.get(scNameDomain);
            RsmSwitchConfig config = configData.getRsmSwitchConfig((PartitionInfoInterface)this);
            MemberInfo[] members = config.getMemberInfo();
            int memberCount = members.length;
            int i = 0;
            while (i < memberCount) {
                MemberInfo member = members[i];
                if (member != null) {
                    int remSafariPort = member.getSafariPort();
                    String scName = member.getScName();
                    String domainName = member.getDomainName();
                    Node.NodeType ntype = this.getNode(scName, domainName).getType();
                    EndPoint memberRemoteEP = new EndPoint(scName, domainName, WCISafariPortUtil.getSlotNumber((int)remSafariPort, (Node.NodeType)ntype), WCISafariPortUtil.getWciNumber((int)remSafariPort, (Node.NodeType)ntype), member.getLinkNumber());
                    EndPoint switchEP = new EndPoint(scNameDomain, i);
                    ReserveLink rLink = new ReserveLink(memberRemoteEP, switchEP);
                    links.add(rLink);
                }
                ++i;
            }
        }
        return links;
    }

    public long getVersionStamp() {
        return this.versionStamp;
    }

    private boolean linkIsInList(List links, ReserveLink link) {
        int numLinks = links.size();
        int i = 0;
        while (i < numLinks) {
            if (((ReserveLink)links.get(i)).equals((Object)link)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void parseContents() throws IOException, FailedCommandException {
        String local = String.valueOf(this.getClass().getName()) + ".parseContents()\n";
        StringBuffer privateCfgData = this.partitionInfo.getPrivateData();
        XMLPartitionConfigSwitch parser = new XMLPartitionConfigSwitch(privateCfgData, this.dtdBasePath, (PartitionInfoInterface)this);
        try {
            parser.parseFile();
        }
        catch (FileNotFoundException fnfe) {
            MessageLog.getInstance().logMessage(String.valueOf(local) + " " + fnfe, MessageLog.ERROR);
            throw new FailedCommandException(fnfe.toString());
        }
        catch (IOException ioe) {
            MessageLog.getInstance().logMessage(String.valueOf(local) + " " + ioe, MessageLog.ERROR);
            throw new FailedCommandException(ioe.toString());
        }
        catch (Exception e) {
            System.err.println("ERROR &&&&&&&&" + e);
            e.printStackTrace();
        }
        this.versionStamp = parser.getVersionStamp();
        this.partitionLinks = this.partitionInfo.getTopology().equals("WcixSwitch") ? this.getSwitchLinks((XMLPartitionConfig)parser) : this.getDCLinks((XMLPartitionConfig)parser);
    }

    public final void setDTDBasePath(String dtdBasePath) {
        if (dtdBasePath != null && !dtdBasePath.endsWith(File.separator)) {
            dtdBasePath = dtdBasePath.concat(File.separator);
        }
        this.dtdBasePath = dtdBasePath;
    }

    public void setVersionStamp(long value) {
        this.versionStamp = value;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentTabs) {
        StringBuffer buf = new StringBuffer();
        StringBuffer tabs = new StringBuffer();
        int i = 0;
        while (i < indentTabs) {
            tabs.append("\t");
            ++i;
        }
        buf.append(String.valueOf(String.valueOf(tabs)) + "\nXMLPartitionLinksCfg:\n");
        buf.append(String.valueOf(String.valueOf(tabs)) + "\tdtdBasePath: " + this.dtdBasePath + "\n");
        buf.append(String.valueOf(String.valueOf(tabs)) + "\tPartition Data: " + this.partitionInfo.toString() + "\n\n");
        buf.append(String.valueOf(String.valueOf(tabs)) + "Partition Links:\n");
        int numLinks = this.partitionLinks.size();
        int j = 0;
        while (j < numLinks) {
            buf.append(String.valueOf(String.valueOf(tabs)) + ((ReserveLink)this.partitionLinks.get(j)).toString() + "\n");
            ++j;
        }
        buf.append("\n");
        return buf.toString();
    }
}

