/*
 * Decompiled with CFR 0.152.
 */
package tools.wcfmver;

import com.sun.wildcat.common.SecurityCredential;
import com.sun.wildcat.fabric_management.common.CommandLineArgProc;
import com.sun.wildcat.fabric_management.common.FabricData;
import com.sun.wildcat.fabric_management.common.FailedCommandException;
import com.sun.wildcat.fabric_management.common.FileUtility;
import com.sun.wildcat.fabric_management.common.InvalidFlagException;
import com.sun.wildcat.fabric_management.common.Inventory;
import com.sun.wildcat.fabric_management.common.Node;
import com.sun.wildcat.fabric_management.common.NodeData;
import com.sun.wildcat.fabric_management.common.NodeDataInterface;
import com.sun.wildcat.fabric_management.common.PartitionData;
import com.sun.wildcat.fabric_management.common.RMILkupSettings;
import com.sun.wildcat.fabric_management.common.ReserveLink;
import com.sun.wildcat.fabric_management.wcfm.FabricManagerInterface;
import com.sun.wildcat.fabric_management.wcfm.NoSuchNodeException;
import com.sun.wildcat.fabric_management.wcfm.XMLConfigFile;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import tools.wcfmver.XMLPartitionLinksCfg;

public class WildcatFMVer {
    private static final int DEFAULT_RMI_PORT = 1099;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String HOST_FLAG = "--host";
    private static final String SHOW_USAGE_FLAG = "--showusage";
    private static final String PORT_FLAG = "-p";
    private static final String NODES_FLAG = "-n";
    private static final String CONFIG_FLAG = "-c";
    private static final String FM_BASE_DIR_FLAG = "-fm_base_dir";
    private static final String FM_DATA_DIR_FLAG = "-fm_data_dir";
    private static final String[] FLAGS = new String[]{"-c", "--host", "-p", "-n", "-fm_base_dir", "-fm_data_dir"};
    private static final String EMPTY_STRING = "";
    private static final String RELATIVE_XML_DIR = "SUNWwcfm/dtds/";
    private static final String SECURITY_FILENAME = "security.info";
    private String fmBaseDir = "/opt";
    private String fmDtdDir = String.valueOf(this.fmBaseDir) + "/" + "SUNWwcfm/dtds/";
    private int rmiPort = 1099;
    private String hostname = "localhost";
    private String fabricName = "";
    private String configFile = "";
    private boolean configFileSpecified = false;
    private Map nodes = new HashMap();
    private FabricManagerInterface fm = null;
    private SecurityCredential credential = null;
    private RMILkupSettings rmiSettings = new RMILkupSettings(1099, "RP", 1099, "ScRsm", 1099, "fmV1", 60000);

    private WildcatFMVer() {
    }

    private void compareLinks(List configLinks, List discoveryLinks) {
        System.out.println("\nThe following links are in the configuration but were not discovered...\n");
        this.outputNonCommonLinks(configLinks, discoveryLinks);
        System.out.println("\nThe following links were discovered but are not in the configuration...\n");
        this.outputNonCommonLinks(discoveryLinks, configLinks);
        System.out.println("\n");
    }

    private void createFabricNodeMap(FabricData fd) {
        Object slotAndWcis = null;
        List nodeList = fd.getNodeData();
        int nodeCount = nodeList.size();
        if (nodeCount > 0) {
            this.nodes = new HashMap();
        }
        NodeData node = null;
        int i = 0;
        while (i < nodeCount) {
            node = (NodeData)nodeList.get(i);
            String SCDomain = Node.concatSCNameDomain((String)node.getSCHost(), (String)node.getSCDomain());
            if (this.nodeIsInFabric(SCDomain)) {
                this.nodes.put(SCDomain, slotAndWcis);
            } else {
                System.exit(1);
            }
            ++i;
        }
    }

    private SecurityCredential createSecurityCredential() {
        return new SecurityCredential();
    }

    private List discoverLinks() {
        List links = null;
        try {
            System.out.println("Starting discovery.");
            int timeout = this.fm.startDiscovery(this.credential, this.nodes);
            System.out.println("Estimated wait time = " + timeout + " sec.");
            int i = 0;
            while (!this.fm.isDiscoveryDone(this.credential)) {
                System.out.print("...");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
            System.out.print("\n");
            String[] discoveryLinks = this.fm.getStringDiscoveryData(this.credential);
            links = this.extractDiscoveryLinkData(discoveryLinks);
        }
        catch (Exception e) {
            System.err.println("Error, running discovery \"" + this.fabricName + "\" " + e.getMessage());
            System.exit(1);
        }
        return links;
    }

    private List extractDiscoveryLinkData(String[] links) {
        ArrayList<ReserveLink> discoverLinks = new ArrayList<ReserveLink>();
        int linkCount = links != null ? links.length : 0;
        int i = 0;
        while (i < linkCount) {
            ReserveLink link = new ReserveLink(links[i]);
            discoverLinks.add(link);
            ++i;
        }
        return discoverLinks;
    }

    private Document getDocument(Reader fileReader) throws JDOMException {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder(true);
        doc = builder.build(fileReader, this.fmDtdDir);
        return doc;
    }

    private FabricManagerInterface getFM(String fabricName) {
        FabricManagerInterface fm = null;
        String url = "//" + this.hostname + ":" + this.rmiPort + "/" + fabricName;
        try {
            fm = (FabricManagerInterface)WildcatFMVer.getRemoteObject(url);
            System.out.println("Found FM at [" + url + "]\n");
        }
        catch (NotBoundException notBoundException) {
            System.err.println("Object not bound to registry [" + url + "]");
            System.exit(1);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Malformed URL [" + url + "]");
            System.exit(1);
        }
        catch (RemoteException re) {
            System.err.println("Remote Exception [" + url + "] " + re.getMessage());
            System.exit(1);
        }
        return fm;
    }

    private List getPartitionReservedLinks(PartitionData partition) {
        ArrayList<ReserveLink> links = new ArrayList<ReserveLink>();
        List nodes = partition.getNodeData();
        int numNodes = nodes.size();
        int i = 0;
        while (i < numNodes) {
            Inventory nodeInv = ((NodeData)nodes.get(i)).getInventory();
            ReserveLink[] reservedLinks = nodeInv.getReservedLinks(partition.getName());
            int numLinks = reservedLinks.length;
            int j = 0;
            while (j < numLinks) {
                if (!this.linkIsInList(links, reservedLinks[j])) {
                    links.add(reservedLinks[j]);
                }
                ++j;
            }
            ++i;
        }
        return links;
    }

    private List getPartitonNodeData(List nodeList, PartitionData pd) {
        ArrayList<NodeData> result = new ArrayList<NodeData>();
        int nodeCount = nodeList.size();
        int i = 0;
        while (i < nodeCount) {
            NodeData fnode = (NodeData)nodeList.get(i);
            NodeData pnode = pd.findNode(fnode.getSCHost(), fnode.getSCDomain());
            if (pnode != null) {
                result.add(fnode);
            }
            ++i;
        }
        return result;
    }

    public static Remote getRemoteObject(String url) throws NotBoundException, MalformedURLException, RemoteException {
        Remote result = null;
        result = Naming.lookup(url);
        return result;
    }

    private boolean isFlag(String arg) {
        int flagCount = FLAGS.length;
        int i = 0;
        while (i < flagCount) {
            if (arg.equals(FLAGS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean linkIsInList(List links, ReserveLink link) {
        int numLinks = links.size();
        int i = 0;
        while (i < numLinks) {
            if (((ReserveLink)links.get(i)).equals((Object)link)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            WildcatFMVer.usage();
            System.exit(1);
        }
        WildcatFMVer.setSecurityManager();
        WildcatFMVer wcfmver = new WildcatFMVer();
        wcfmver.processArgs(args);
        List configLinks = null;
        if (wcfmver.configFileSpecified) {
            configLinks = wcfmver.retrieveConfigFileLinks();
        }
        List discoveredLinks = wcfmver.discoverLinks();
        wcfmver.compareLinks(configLinks, discoveredLinks);
    }

    private boolean nodeIsInFabric(String SCNameDomain) {
        NodeDataInterface ndi = null;
        boolean inFabric = false;
        try {
            ndi = this.fm.getMember(this.credential, Node.getSCName((String)SCNameDomain), Node.getSCDomain((String)SCNameDomain));
            if (ndi != null) {
                inFabric = true;
            }
        }
        catch (NoSuchNodeException noSuchNodeException) {
            inFabric = false;
        }
        catch (Exception e) {
            System.out.println("Exception received: " + e);
        }
        return inFabric;
    }

    private void outputNonCommonLinks(List a, List b) {
        boolean printLinkStatus = false;
        int numALinks = a != null ? a.size() : 0;
        int i = 0;
        while (i < numALinks) {
            boolean matchFound = false;
            int numBLinks = b != null ? b.size() : 0;
            ReserveLink linka = (ReserveLink)a.get(i);
            int j = 0;
            while (j < numBLinks) {
                ReserveLink linkb = (ReserveLink)b.get(j);
                if (linka.equals((Object)linkb)) {
                    matchFound = true;
                    break;
                }
                ++j;
            }
            if (!matchFound) {
                System.out.println(linka.toString(printLinkStatus));
            }
            ++i;
        }
    }

    private List parsePartitionConfigurationData(PartitionData partition) {
        List linkList = null;
        try {
            XMLPartitionLinksCfg linksReader = new XMLPartitionLinksCfg(partition, this.fmDtdDir);
            linksReader.parseContents();
            linkList = linksReader.getPartitionLinks();
        }
        catch (IOException ioe) {
            System.out.println("Error, Parsing Config Data: " + ioe.getMessage());
            System.exit(1);
        }
        catch (FailedCommandException fce) {
            System.out.println("Error, Parsing Config Data: " + fce.getMessage());
            System.exit(1);
        }
        return linkList;
    }

    private void printLinks(List links) {
        int numLinks = links.size();
        int i = 0;
        while (i < numLinks) {
            System.out.println("Link: " + ((ReserveLink)links.get(i)).toString());
            ++i;
        }
    }

    private void processArgs(String[] args) {
        String temp;
        if (args[0].equals(SHOW_USAGE_FLAG)) {
            WildcatFMVer.usage();
            System.exit(2);
        }
        this.fabricName = args[args.length - 1];
        Object slotAndWcis = null;
        boolean nodesSpecified = false;
        this.credential = this.createSecurityCredential();
        this.credential.setUsername("sfluser");
        String[] flags = new String[args.length - 1];
        System.arraycopy(args, 0, flags, 0, flags.length);
        CommandLineArgProc clap = null;
        try {
            clap = new CommandLineArgProc(FLAGS, flags);
        }
        catch (InvalidFlagException invalidFlagException) {
            System.out.println("Error, invalid flag specified");
            WildcatFMVer.usage();
            System.exit(1);
        }
        clap.processArgs();
        if (clap.hasErrors()) {
            System.out.println("Errors found on command line, Errant flags are:");
            List errors = clap.getErrantFlags();
            int i = 0;
            while (i < errors.size()) {
                System.out.println("\t" + (String)errors.get(i));
                ++i;
            }
            System.exit(1);
        }
        if (clap.flagPresent(HOST_FLAG)) {
            temp = clap.getFlagValue(HOST_FLAG);
            if (temp != null) {
                this.hostname = temp;
            } else {
                System.err.println("Error, must specify a hostname");
                System.exit(1);
            }
        }
        if (clap.flagPresent(PORT_FLAG)) {
            temp = clap.getFlagValue(PORT_FLAG);
            if (temp != null) {
                this.rmiPort = Integer.parseInt(temp);
            } else {
                System.err.println("Error, must specify a port number");
                System.exit(1);
            }
        }
        if (clap.flagPresent(FM_BASE_DIR_FLAG) && (temp = clap.getFlagValue(FM_BASE_DIR_FLAG)) != null) {
            this.fmBaseDir = temp;
            this.fmDtdDir = String.valueOf(this.fmBaseDir) + "/" + RELATIVE_XML_DIR;
        }
        if (clap.flagPresent(FM_DATA_DIR_FLAG) && (temp = clap.getFlagValue(FM_DATA_DIR_FLAG)) != null) {
            String passwd = this.retrieveSecurityPassword(temp);
            this.credential.setPasswd(passwd);
        }
        if (clap.flagPresent(CONFIG_FLAG)) {
            temp = clap.getFlagValue(CONFIG_FLAG);
            if (temp != null) {
                if (FileUtility.fileExists((String)temp)) {
                    this.configFile = temp;
                    this.configFileSpecified = true;
                } else {
                    this.showErrorMessageAndExit("Error, file not found: ", temp);
                }
            } else {
                this.showMissingDataErrorAndExit(CONFIG_FLAG);
            }
        }
        if (clap.flagPresent(NODES_FLAG)) {
            temp = clap.getFlagValue(NODES_FLAG);
            if (temp != null) {
                StringTokenizer stringtokens = new StringTokenizer(temp, " ");
                while (stringtokens.hasMoreTokens()) {
                    String nodeName = stringtokens.nextToken();
                    if (nodeName.endsWith(",")) {
                        nodeName = nodeName.substring(0, nodeName.length() - 1);
                    }
                    this.nodes.put(nodeName, slotAndWcis);
                }
                nodesSpecified = true;
            } else {
                this.showMissingDataErrorAndExit(NODES_FLAG);
            }
        }
        if (this.configFileSpecified && nodesSpecified) {
            String msg = "Error: Use only one of the following options: -c | -n";
            System.err.println(msg);
            WildcatFMVer.usage();
            System.exit(1);
        }
        this.fm = this.getFM(this.fabricName);
        this.pruneNodeList();
    }

    private void pruneNodeList() {
        Set nodeSet = this.nodes.keySet();
        Iterator iterator = nodeSet.iterator();
        Vector<String> notKnownNodes = new Vector<String>();
        while (iterator.hasNext()) {
            String nodeName = (String)iterator.next();
            if (this.nodeIsInFabric(nodeName)) continue;
            iterator.remove();
            notKnownNodes.addElement(nodeName);
        }
        if (notKnownNodes.size() > 0) {
            String error = "Warning: The following nodes are not registered with the fabric ";
            error = String.valueOf(error) + "\"" + this.fabricName + "\":\n";
            int i = 0;
            while (i < notKnownNodes.size()) {
                error = String.valueOf(error) + "\t" + (String)notKnownNodes.get(i) + "\n";
                ++i;
            }
            error = String.valueOf(error) + "Those nodes will be ignored.\n";
            System.err.println(error);
        }
    }

    private StringBuffer readConfigFile() {
        StringBuffer fileCont = new StringBuffer();
        BufferedReader bufReader = null;
        try {
            try {
                String line;
                bufReader = new BufferedReader(new FileReader(this.configFile));
                while ((line = bufReader.readLine()) != null) {
                    fileCont.append(line);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.showErrorMessageAndExit("Error: File not found: ", this.configFile);
            }
            catch (IOException iOException) {
                this.showErrorMessageAndExit("IO Error: closing file and aborting: ", this.configFile);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                bufReader.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            bufReader.close();
        }
        catch (Exception exception) {}
        return fileCont;
    }

    private List retrieveConfigFileLinks() {
        StringBuffer configFileContents = this.readConfigFile();
        XMLConfigFile fileReader = new XMLConfigFile(configFileContents, this.fmDtdDir);
        ArrayList partitionLinkStrings = new ArrayList();
        try {
            fileReader.readFile();
            FabricData fd = fileReader.getFabricData();
            this.createFabricNodeMap(fd);
            List partList = fileReader.getPartitionData();
            int numParts = partList.size();
            int i = 0;
            while (i < numParts) {
                PartitionData partition = (PartitionData)partList.get(i);
                StringBuffer privateCfgData = partition.getPrivateData();
                List linkList = null;
                if (privateCfgData.length() > 0) {
                    List nodes = this.getPartitonNodeData(fd.getNodeData(), partition);
                    partition.setNodeData(nodes);
                    linkList = this.parsePartitionConfigurationData(partition);
                } else {
                    linkList = this.getPartitionReservedLinks(partition);
                }
                if (linkList.size() > 0) {
                    partitionLinkStrings.addAll(linkList);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Error, getting link data \"" + this.fabricName + "\" " + e.getMessage());
            System.exit(1);
        }
        return partitionLinkStrings;
    }

    private String retrieveSecurityPassword(String fmBaseDataDir) {
        String password = null;
        try {
            String securityFile = String.valueOf(fmBaseDataDir) + "/" + SECURITY_FILENAME;
            FileInputStream fis = new FileInputStream(securityFile);
            Properties securityProps = new Properties();
            securityProps.load(fis);
            password = securityProps.getProperty("PASSWORD");
        }
        catch (Exception exception) {}
        return password;
    }

    private static void setSecurityManager() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
    }

    private void showErrorMessageAndExit(String info, String data) {
        System.err.println(String.valueOf(info) + data);
        System.exit(1);
    }

    private void showMissingDataErrorAndExit(String arg) {
        System.out.println("No data for flag: " + arg);
        System.exit(1);
    }

    private static void usage() {
        String usageString = "Usage: wcfmver [ -p rmi_port ] \n\t{ -c config_file | -n node:domain, switch, ... } \n\t{ fabric_name }";
        System.out.println(usageString);
    }
}

