/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.WBEMClient;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.WbemClientProxy;
import com.sun.admin.cis.common.WbemMgmtScope;
import com.sun.admin.usermgr.client.WBEMClient.ClientProxyException;
import com.sun.admin.usermgr.client.WBEMClient.ServerConnectException;
import com.sun.admin.usermgr.common.Permissions;
import com.sun.admin.usermgr.common.SolHomedirAttr;
import com.sun.admin.usermgr.common.UserObj;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMSecurityException;
import com.sun.wbem.cim.CIMTransportException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMClient;
import java.util.Vector;

public class HomeDirProxy
implements WbemClientProxy {
    private static final String HOME_DIR_CLASS = "Solaris_UserHomeDirectory";
    private static String SERVERNAME = "CSName";
    private static String PATHNAME = "Name";
    private static String USERNAME = "userName";
    private static String USERID = "uid";
    private static String PRIMARYGROUP = "primaryGroup";
    private static String INITFILES = "initFiles";
    private static String AUTOMOUNTHDIR = "autoMountHomeDir";
    private static String FORCE_MODIFY = "homeDirForceModify";
    private static String ALLOW_MODIFY = "homeDirAllowModifyServer";
    private static String OWNER_PERMS = "ownerPerms";
    private static String GROUP_PERMS = "groupPerms";
    private static String WORLD_PERMS = "worldPerms";
    private static String NEW_PATHNAME = "newPathName";
    private static String INIT_FILEPATH = "initFilePath";
    private CIMClient cimClient = null;
    private CIMClass cimClass = null;

    private CIMInstance convertUserObjToInstance(CIMClass cIMClass, UserObj userObj) {
        CIMInstance cIMInstance = null;
        cIMInstance = this.convertUserObjToInstance(cIMClass, userObj, null);
        return cIMInstance;
    }

    private CIMInstance convertUserObjToInstance(CIMClass cIMClass, UserObj userObj, String string) {
        CIMInstance cIMInstance = cIMClass.newInstance();
        if (userObj.getUserName() != null) {
            cIMInstance.setProperty(USERNAME, new CIMValue((Object)userObj.getUserName()));
        }
        if (userObj.getUserID() != null) {
            cIMInstance.setProperty(USERID, new CIMValue((Object)userObj.getUserID()));
        }
        if (userObj.getInitFilePath() != null) {
            cIMInstance.setProperty(INIT_FILEPATH, new CIMValue((Object)userObj.getInitFilePath()));
        }
        if (userObj.getSolGroupAttr() != null && userObj.getSolGroupAttr().getPrimaryGroup() != null) {
            cIMInstance.setProperty(PRIMARYGROUP, new CIMValue((Object)userObj.getSolGroupAttr().getPrimaryGroup()));
        }
        if (userObj.getSolHomedirAttr() != null) {
            Object object;
            SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
            cIMInstance.setProperty(SERVERNAME, new CIMValue((Object)solHomedirAttr.getServer()));
            if (string != null) {
                cIMInstance.setProperty(PATHNAME, new CIMValue((Object)string));
                if (solHomedirAttr.getPathname() != null) {
                    object = new CIMValue((Object)solHomedirAttr.getPathname());
                    cIMInstance.setProperty(NEW_PATHNAME, (CIMValue)object);
                }
            } else if (solHomedirAttr.getPathname() != null) {
                cIMInstance.setProperty(PATHNAME, new CIMValue((Object)solHomedirAttr.getPathname()));
            }
            cIMInstance.setProperty(AUTOMOUNTHDIR, new CIMValue((Object)new Boolean(solHomedirAttr.getAutomount())));
            cIMInstance.setProperty(INITFILES, new CIMValue((Object)new Boolean(solHomedirAttr.getInitFiles())));
            cIMInstance.setProperty(FORCE_MODIFY, new CIMValue((Object)new Boolean(solHomedirAttr.requireModify())));
            cIMInstance.setProperty(ALLOW_MODIFY, new CIMValue((Object)new Boolean(solHomedirAttr.getModifyServer())));
            if (solHomedirAttr.getPerms() != null) {
                object = solHomedirAttr.getPerms();
                cIMInstance.setProperty(OWNER_PERMS, new CIMValue((Object)Integer.toString(((Permissions)object).getOwner())));
                cIMInstance.setProperty(GROUP_PERMS, new CIMValue((Object)Integer.toString(((Permissions)object).getGroup())));
                cIMInstance.setProperty(WORLD_PERMS, new CIMValue((Object)Integer.toString(((Permissions)object).getWorld())));
            }
        }
        return cIMInstance;
    }

    public void createHomeDir(UserObj userObj) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(HOME_DIR_CLASS);
        if (userObj.getSolHomedirAttr() == null) {
            throw new ClientProxyException("EXM_HOMEDIR_ADD_BAD_NAME", userObj.getUserName());
        }
        SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
        if (solHomedirAttr.getPathname() == null) {
            throw new ClientProxyException("EXM_HOMEDIR_ADD_BAD_NAME", userObj.getUserName());
        }
        String string = userObj.getSolHomedirAttr().getPathname();
        if (solHomedirAttr.getPathname().trim().length() == 0) {
            throw new ClientProxyException("EXM_HOMEDIR_ADD_BAD_NAME", userObj.getUserName());
        }
        try {
            if (this.cimClass == null) {
                this.cimClass = this.cimClient.getClass(cIMObjectPath, false);
            }
            CIMInstance cIMInstance = this.convertUserObjToInstance(this.cimClass, userObj);
            this.cimClient.createInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_HOMEDIR_SCTY_ADD", userObj.getUserName());
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMTransportException cIMTransportException) {
            throw new ServerConnectException("EXM_HOMESERVER_ADD_CONTACT_ERR", solHomedirAttr.getPathname(), userObj.getUserName(), solHomedirAttr.getServer());
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_HOMEDIR_ADD_UNEXP", string, userObj.getUserName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_HOMEDIR_ADD_UNEXP", string, userObj.getUserName(), exception.getMessage());
        }
    }

    public void deleteHomeDir(String string) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(HOME_DIR_CLASS);
        if (string == null || string.trim().length() == 0) {
            throw new ClientProxyException("EXM_HOMEDIR_DEL_BAD_NAME");
        }
        cIMObjectPath.addKey(PATHNAME, new CIMValue((Object)string));
        try {
            this.cimClient.deleteInstance(cIMObjectPath);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_HOMEDIR_SCTY_DEL", string);
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_HOMEDIR_DEL_UNEXP", string, cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_HOMEDIR_DEL_UNEXP", string, exception.getMessage());
        }
    }

    public UserObj getHomeDirAttributes(UserObj userObj) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(HOME_DIR_CLASS);
        if (userObj.getSolHomedirAttr() == null) {
            return userObj;
        }
        SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
        if (solHomedirAttr.getPathname().trim().length() == 0) {
            return userObj;
        }
        String string = solHomedirAttr.getPathname();
        cIMObjectPath.addKey(PATHNAME, new CIMValue((Object)string));
        CIMInstance cIMInstance = null;
        try {
            cIMInstance = this.cimClient.getInstance(cIMObjectPath, false);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_HOMEDIR_SCTY_READATTR", userObj.getUserName());
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMTransportException cIMTransportException) {
            throw new ServerConnectException("EXM_HOMESERVER_PERMS_CONTACT_ERR", userObj.getUserName(), solHomedirAttr.getServer());
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_HOMEDIR_PERMS_UNEXP", string, userObj.getUserName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_HOMEDIR_PERMS_UNEXP", string, userObj.getUserName(), exception.getMessage());
        }
        if (cIMInstance == null) {
            throw new ClientProxyException("EXM_HOMEDIR_GET_PROV_ERR", string, userObj.getUserName());
        }
        Permissions permissions = new Permissions();
        String string3 = null;
        string3 = this.getStringValue(cIMInstance, OWNER_PERMS);
        if (string3 != null) {
            permissions.setOwner(Integer.valueOf(string3));
        }
        if ((string3 = this.getStringValue(cIMInstance, GROUP_PERMS)) != null) {
            permissions.setGroup(Integer.valueOf(string3));
        }
        if ((string3 = this.getStringValue(cIMInstance, WORLD_PERMS)) != null) {
            permissions.setWorld(Integer.valueOf(string3));
        }
        userObj.getSolHomedirAttr().setPerms(permissions);
        return userObj;
    }

    private String getStringValue(CIMInstance cIMInstance, String string) {
        String string2 = null;
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null) {
            cIMValue = cIMProperty.getValue();
        }
        if (cIMValue != null) {
            string2 = (String)cIMValue.getValue();
        }
        return string2;
    }

    private Vector getVectorValue(CIMInstance cIMInstance, String string) {
        Vector vector = null;
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null) {
            cIMValue = cIMProperty.getValue();
        }
        if (cIMValue != null) {
            vector = (Vector)cIMValue.getValue();
        }
        return vector;
    }

    private boolean getbooleanValue(CIMInstance cIMInstance, String string) {
        boolean bl = false;
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty != null) {
            cIMValue = cIMProperty.getValue();
        }
        if (cIMValue != null) {
            bl = (Boolean)cIMValue.getValue();
        }
        return bl;
    }

    public void init(CIMClient cIMClient, WbemMgmtScope wbemMgmtScope) throws AdminException {
        this.cimClient = cIMClient;
    }

    public void modifyHomeDir(UserObj userObj, String string) throws AdminException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(HOME_DIR_CLASS);
        if (string == null) {
            throw new ClientProxyException("EXM_HOMEDIR_MOD_BAD_NAME", userObj.getUserName());
        }
        if (string.trim().length() == 0) {
            throw new ClientProxyException("EXM_HOMEDIR_MOD_BAD_NAME", userObj.getUserName());
        }
        try {
            if (this.cimClass == null) {
                this.cimClass = this.cimClient.getClass(cIMObjectPath, false);
            }
            cIMObjectPath.addKey(PATHNAME, new CIMValue((Object)string));
            CIMInstance cIMInstance = this.convertUserObjToInstance(this.cimClass, userObj, string);
            this.cimClient.setInstance(cIMObjectPath, cIMInstance);
        }
        catch (CIMSecurityException cIMSecurityException) {
            if (cIMSecurityException.getID().equals("CIM_ERR_ACCESS_DENIED")) {
                throw new ClientProxyException("EXM_HOMEDIR_SCTY_DEL");
            }
            throw new ClientProxyException("EXM_GENERIC_CIM_SCTY_ERR");
        }
        catch (CIMTransportException cIMTransportException) {
            SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
            throw new ServerConnectException("EXM_HOMESERVER_MOD_CONTACT_ERR", solHomedirAttr.getPathname(), userObj.getUserName(), solHomedirAttr.getServer());
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("GENERAL_EXCEPTION")) {
                Object[] objectArray = cIMException.getParams();
                String string2 = (String)objectArray[0];
                throw new ClientProxyException("EXM_REMOTE", string2);
            }
            throw new ClientProxyException("EXM_HOMEDIR_MOD_UNEXP", string, userObj.getUserName(), cIMException.getID());
        }
        catch (Exception exception) {
            throw new ClientProxyException("EXM_HOMEDIR_MOD_UNEXP", string, userObj.getUserName(), exception.getMessage());
        }
    }

    public void printInst(CIMInstance cIMInstance) {
        System.out.println("CIMInstance = " + cIMInstance.toString());
    }
}

