/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jdmk.trace.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.relation.InvalidRelationIdException;
import javax.management.relation.InvalidRelationServiceException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationNotification;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupport;
import javax.management.relation.RelationType;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;

public class RelationService
extends NotificationBroadcasterSupport
implements RelationServiceMBean,
MBeanRegistration,
NotificationListener {
    private HashMap myRelId2ObjMap = new HashMap();
    private HashMap myRelId2RelTypeMap = new HashMap();
    private HashMap myRelMBeanObjName2RelIdMap = new HashMap();
    private HashMap myRelType2ObjMap = new HashMap();
    private HashMap myRelType2RelIdsMap = new HashMap();
    private HashMap myRefedMBeanObjName2RelIdsMap = new HashMap();
    private boolean myPurgeFlg = true;
    private Long myNtfSeqNbrCounter = new Long(0L);
    private ObjectName myObjName = null;
    private MBeanServer myMBeanServer = null;
    private MBeanServerNotificationFilter myUnregNtfFilter = null;
    private ArrayList myUnregNtfList = new ArrayList();
    private static String localClassName = "RelationService";

    public RelationService(boolean bl) {
        if (this.isTraceOn()) {
            this.trace("Constructor: entering", null);
        }
        this.setPurgeFlag(bl);
        if (this.isTraceOn()) {
            this.trace("Constructor: exiting", null);
        }
    }

    public void isActive() throws RelationServiceNotRegisteredException {
        if (this.myMBeanServer == null) {
            String string = "Relation Service not registered in the MBean Server.";
            throw new RelationServiceNotRegisteredException(string);
        }
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.myMBeanServer = mBeanServer;
        this.myObjName = objectName;
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public boolean getPurgeFlag() {
        return this.myPurgeFlg;
    }

    public void setPurgeFlag(boolean bl) {
        this.myPurgeFlg = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getNotificationSequenceNumber() {
        Long l = null;
        Long l2 = this.myNtfSeqNbrCounter;
        synchronized (l2) {
            l = new Long(this.myNtfSeqNbrCounter + 1L);
            this.myNtfSeqNbrCounter = new Long(l);
        }
        return l;
    }

    public void createRelationType(String string, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (string == null || roleInfoArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("createRelationType: entering", string);
        }
        RelationTypeSupport relationTypeSupport = new RelationTypeSupport(string, roleInfoArray);
        this.addRelationTypeInt(relationTypeSupport);
        if (this.isTraceOn()) {
            this.trace("createRelationType: exiting", null);
        }
    }

    public void addRelationType(RelationType relationType) throws IllegalArgumentException, InvalidRelationTypeException {
        List list;
        if (relationType == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("addRelationType: entering", null);
        }
        if ((list = relationType.getRoleInfos()) == null) {
            String string = "No role info provided.";
            throw new InvalidRelationTypeException(string);
        }
        RoleInfo[] roleInfoArray = new RoleInfo[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RoleInfo roleInfo;
            roleInfoArray[n] = roleInfo = (RoleInfo)iterator.next();
            ++n;
        }
        RelationTypeSupport.checkRoleInfos(roleInfoArray);
        this.addRelationTypeInt(relationType);
        if (this.isTraceOn()) {
            this.trace("addRelationType: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllRelationTypeNames() {
        ArrayList arrayList = null;
        HashMap hashMap = this.myRelType2ObjMap;
        synchronized (hashMap) {
            arrayList = new ArrayList(this.myRelType2ObjMap.keySet());
        }
        return arrayList;
    }

    public List getRoleInfos(String string) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getRoleInfos: entering", string);
        }
        RelationType relationType = this.getRelationType(string);
        if (this.isTraceOn()) {
            this.trace("getRoleInfos: exiting", null);
        }
        return relationType.getRoleInfos();
    }

    public RoleInfo getRoleInfo(String string, String string2) throws IllegalArgumentException, RelationTypeNotFoundException, RoleInfoNotFoundException {
        Object object;
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = "theRelTypeName " + string + ", theRoleInfoName " + string2;
            this.trace("getRoleInfo: entering", (String)object);
        }
        object = this.getRelationType(string);
        RoleInfo roleInfo = object.getRoleInfo(string2);
        if (this.isTraceOn()) {
            this.trace("getRoleInfo: exiting", null);
        }
        return roleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelationType(String string) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationTypeNotFoundException {
        Cloneable cloneable;
        this.isActive();
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("removeRelationType: entering", string);
        }
        RelationType relationType = this.getRelationType(string);
        ArrayList arrayList = null;
        HashMap hashMap = this.myRelType2RelIdsMap;
        synchronized (hashMap) {
            cloneable = (ArrayList)this.myRelType2RelIdsMap.get(string);
            if (cloneable != null) {
                arrayList = (ArrayList)cloneable.clone();
            }
        }
        cloneable = this.myRelType2ObjMap;
        synchronized (cloneable) {
            this.myRelType2ObjMap.remove(string);
        }
        HashMap hashMap2 = this.myRelType2RelIdsMap;
        synchronized (hashMap2) {
            this.myRelType2RelIdsMap.remove(string);
        }
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                try {
                    this.removeRelation(string3);
                }
                catch (RelationNotFoundException relationNotFoundException) {
                    throw new RuntimeException(relationNotFoundException.getMessage());
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("removeRelationType: exiting", null);
        }
    }

    public void createRelation(String string, String string2, RoleList roleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        Object object;
        this.isActive();
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = new StringBuffer("theRelId " + string + ", theRelTypeName " + string2);
            if (roleList != null) {
                ((StringBuffer)object).append(", theRoleList " + roleList.toString());
            }
            this.trace("createRelation: entering", ((StringBuffer)object).toString());
        }
        object = new RelationSupport(string, this.myObjName, string2, roleList);
        this.addRelationInt(true, (RelationSupport)object, null, string, string2, roleList);
        if (this.isTraceOn()) {
            this.trace("createRelation: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelation(ObjectName objectName) throws IllegalArgumentException, RelationServiceNotRegisteredException, NoSuchMethodException, InvalidRelationIdException, InstanceNotFoundException, InvalidRelationServiceException, RelationTypeNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        Object object;
        if (objectName == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("addRelation: entering", objectName.toString());
        }
        this.isActive();
        if (!this.myMBeanServer.isInstanceOf(objectName, "javax.management.relation.Relation")) {
            String string = "This MBean does not implement the Relation interface.";
            throw new NoSuchMethodException(string);
        }
        Object[] objectArray = new Object[]{};
        String[] stringArray = new String[]{};
        String string = null;
        try {
            string = (String)this.myMBeanServer.invoke(objectName, "getRelationId", objectArray, stringArray);
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        if (string == null) {
            String string2 = "This MBean does not provide a relation id.";
            throw new InvalidRelationIdException(string2);
        }
        ObjectName objectName2 = null;
        try {
            objectName2 = (ObjectName)this.myMBeanServer.invoke(objectName, "getRelationServiceName", objectArray, stringArray);
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        boolean bl = false;
        if (objectName2 == null) {
            bl = true;
        } else if (!objectName2.equals(this.myObjName)) {
            bl = true;
        }
        if (bl) {
            String string3 = "The Relation Service referenced in the MBean is not the current one.";
            throw new InvalidRelationServiceException(string3);
        }
        String string4 = null;
        try {
            string4 = (String)this.myMBeanServer.invoke(objectName, "getRelationTypeName", objectArray, stringArray);
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        if (string4 == null) {
            String string5 = "No relation type provided.";
            throw new RelationTypeNotFoundException(string5);
        }
        RoleList roleList = null;
        try {
            roleList = (RoleList)this.myMBeanServer.invoke(objectName, "retrieveAllRoles", objectArray, stringArray);
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        this.addRelationInt(false, null, objectName, string, string4, roleList);
        HashMap hashMap = this.myRelMBeanObjName2RelIdMap;
        synchronized (hashMap) {
            this.myRelMBeanObjName2RelIdMap.put(objectName, string);
        }
        try {
            object = new Object[]{new Boolean(true)};
            String[] stringArray2 = new String[]{"java.lang.Boolean"};
            this.myMBeanServer.invoke(objectName, "setRelationServiceManagementFlag", (Object[])object, stringArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new ArrayList();
        ((ArrayList)object).add(objectName);
        this.updateUnregistrationListener((List)object, null);
        if (this.isTraceOn()) {
            this.trace("addRelation: exiting", null);
        }
    }

    public ObjectName isRelationMBean(String string) throws IllegalArgumentException, RelationNotFoundException {
        Object object;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("isRelationMBean", string);
        }
        if ((object = this.getRelation(string)) instanceof ObjectName) {
            return (ObjectName)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String isRelation(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("isRelation", objectName.toString());
        }
        String string = null;
        HashMap hashMap = this.myRelMBeanObjName2RelIdMap;
        synchronized (hashMap) {
            String string2 = (String)this.myRelMBeanObjName2RelIdMap.get(objectName);
            if (string2 != null) {
                string = string2;
            }
        }
        return string;
    }

    public Boolean hasRelation(String string) throws IllegalArgumentException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("hasRelation", string);
        }
        try {
            Object object = this.getRelation(string);
            return new Boolean(true);
        }
        catch (RelationNotFoundException relationNotFoundException) {
            return new Boolean(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllRelationIds() {
        ArrayList arrayList = null;
        HashMap hashMap = this.myRelId2ObjMap;
        synchronized (hashMap) {
            arrayList = new ArrayList(this.myRelId2ObjMap.keySet());
        }
        return arrayList;
    }

    public Integer checkRoleReading(String string, String string2) throws IllegalArgumentException, RelationTypeNotFoundException {
        Object object;
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = "theRoleName " + string + ", theRelTypeName " + string2;
            this.trace("checkRoleReading: entering", (String)object);
        }
        object = null;
        RelationType relationType = this.getRelationType(string2);
        try {
            RoleInfo roleInfo = relationType.getRoleInfo(string);
            object = this.checkRoleInt(1, string, null, roleInfo, false);
        }
        catch (RoleInfoNotFoundException roleInfoNotFoundException) {
            object = new Integer(1);
        }
        if (this.isTraceOn()) {
            this.trace("checkRoleReading: exiting", null);
        }
        return object;
    }

    public Integer checkRoleWriting(Role role, String string, Boolean bl) throws IllegalArgumentException, RelationTypeNotFoundException {
        Object object;
        if (role == null || string == null || bl == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            object = new String("theRole " + role.toString() + ", theRelTypeName " + string + ", theInitFlg " + bl);
            this.trace("checkRoleWriting: entering", (String)object);
        }
        object = this.getRelationType(string);
        String string3 = role.getRoleName();
        ArrayList arrayList = (ArrayList)role.getRoleValue();
        boolean bl2 = true;
        if (bl.booleanValue()) {
            bl2 = false;
        }
        RoleInfo roleInfo = null;
        try {
            roleInfo = object.getRoleInfo(string3);
        }
        catch (RoleInfoNotFoundException roleInfoNotFoundException) {
            if (this.isTraceOn()) {
                this.trace("checkRoleWriting: exiting", null);
            }
            return new Integer(1);
        }
        Integer n = this.checkRoleInt(2, string3, arrayList, roleInfo, bl2);
        if (this.isTraceOn()) {
            this.trace("checkRoleWriting: exiting", null);
        }
        return n;
    }

    public void sendRelationCreationNotification(String string) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("sendRelationCreationNotification: entering", string);
        }
        StringBuffer stringBuffer = new StringBuffer("Creation of relation ");
        stringBuffer.append(string);
        this.sendNotificationInt(1, stringBuffer.toString(), string, null, null, null, null);
        if (this.isTraceOn()) {
            this.trace("sendRelationCreationNotification: exiting", null);
        }
    }

    public void sendRoleUpdateNotification(String string, Role role, List list) throws IllegalArgumentException, RelationNotFoundException {
        String string2;
        if (string == null || role == null || list == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            string2 = new String("theRelId " + string + ", theNewRole " + role.toString() + ", theOldRoleValue " + list.toString());
            this.trace("sendRoleUpdateNotification: entering", string2);
        }
        string2 = role.getRoleName();
        ArrayList arrayList = (ArrayList)role.getRoleValue();
        String string4 = Role.roleValueToString(arrayList);
        String string5 = Role.roleValueToString(list);
        StringBuffer stringBuffer = new StringBuffer("Value of role ");
        stringBuffer.append(string2);
        stringBuffer.append(" has changed\nOld value:\n");
        stringBuffer.append(string5);
        stringBuffer.append("\nNew value:\n");
        stringBuffer.append(string4);
        this.sendNotificationInt(2, stringBuffer.toString(), string, null, string2, arrayList, list);
        if (this.isTraceOn()) {
            this.trace("sendRoleUpdateNotification: exiting", null);
        }
    }

    public void sendRelationRemovalNotification(String string, List list) throws IllegalArgumentException, RelationNotFoundException {
        StringBuffer stringBuffer;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            stringBuffer = new StringBuffer("theRelId " + string);
            if (list != null) {
                stringBuffer.append(", theUnregMBeanList " + list.toString());
            }
            this.trace("sendRelationRemovalNotification: entering", stringBuffer.toString());
        }
        stringBuffer = new StringBuffer("Removal of relation ");
        stringBuffer.append(string);
        this.sendNotificationInt(3, stringBuffer.toString(), string, list, null, null, null);
        if (this.isTraceOn()) {
            this.trace("sendRelationRemovalNotification: exiting", null);
        }
    }

    public void updateRoleMap(String string, Role role, List list) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        Serializable serializable;
        Object object;
        if (string == null || role == null || list == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            object = new String("theRelId " + string + ", theNewRole " + role.toString() + ", theOldRoleValue " + list.toString());
            this.trace("updateRoleMap: entering", (String)object);
        }
        this.isActive();
        object = this.getRelation(string);
        String string3 = role.getRoleName();
        ArrayList arrayList = (ArrayList)role.getRoleValue();
        ArrayList arrayList2 = (ArrayList)((ArrayList)list).clone();
        ArrayList<Serializable> arrayList3 = new ArrayList<Serializable>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            serializable = (ObjectName)iterator.next();
            int n = arrayList2.indexOf(serializable);
            if (n == -1) {
                boolean bl = this.addNewMBeanReference((ObjectName)serializable, string, string3);
                if (!bl) continue;
                arrayList3.add(serializable);
                continue;
            }
            arrayList2.remove(n);
        }
        serializable = new ArrayList();
        Iterator iterator2 = arrayList2.iterator();
        while (iterator2.hasNext()) {
            ObjectName objectName = (ObjectName)iterator2.next();
            boolean bl = this.removeMBeanReference(objectName, string, string3, false);
            if (!bl) continue;
            ((ArrayList)serializable).add(objectName);
        }
        this.updateUnregistrationListener(arrayList3, (List)((Object)serializable));
        if (this.isTraceOn()) {
            this.trace("updateRoleMap: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelation(String string) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        Object object;
        Object object2;
        ArrayList<Object> arrayList;
        Object object3;
        this.isActive();
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("removeRelation: entering", string);
        }
        if ((object3 = this.getRelation(string)) instanceof ObjectName) {
            arrayList = new ArrayList<Object>();
            arrayList.add((ObjectName)object3);
            this.updateUnregistrationListener(null, arrayList);
        }
        this.sendRelationRemovalNotification(string, null);
        arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        HashMap hashMap = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (hashMap) {
            Serializable serializable;
            Object object4;
            object2 = this.myRefedMBeanObjName2RelIdsMap.keySet().iterator();
            while (object2.hasNext()) {
                object4 = (ObjectName)object2.next();
                serializable = (HashMap)this.myRefedMBeanObjName2RelIdsMap.get(object4);
                if (((HashMap)serializable).containsKey(string)) {
                    ((HashMap)serializable).remove(string);
                    arrayList.add(object4);
                }
                if (!((HashMap)serializable).isEmpty()) continue;
                arrayList2.add(object4);
            }
            object4 = arrayList2.iterator();
            while (object4.hasNext()) {
                serializable = (ObjectName)object4.next();
                this.myRefedMBeanObjName2RelIdsMap.remove(serializable);
            }
        }
        object2 = this.myRelId2ObjMap;
        synchronized (object2) {
            this.myRelId2ObjMap.remove(string);
        }
        if (object3 instanceof ObjectName) {
            object = this.myRelMBeanObjName2RelIdMap;
            synchronized (object) {
                this.myRelMBeanObjName2RelIdMap.remove((ObjectName)object3);
            }
        }
        object = null;
        HashMap hashMap2 = this.myRelId2RelTypeMap;
        synchronized (hashMap2) {
            object = (String)this.myRelId2RelTypeMap.get(string);
            this.myRelId2RelTypeMap.remove(string);
        }
        HashMap hashMap3 = this.myRelType2RelIdsMap;
        synchronized (hashMap3) {
            ArrayList arrayList3 = (ArrayList)this.myRelType2RelIdsMap.get(object);
            if (arrayList3 != null) {
                arrayList3.remove(string);
                if (arrayList3.isEmpty()) {
                    this.myRelType2RelIdsMap.remove(object);
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("removeRelation: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeRelations() throws RelationServiceNotRegisteredException {
        HashMap hashMap;
        ObjectName objectName;
        MBeanServerNotification mBeanServerNotification;
        Iterator iterator;
        if (this.isTraceOn()) {
            this.trace("purgeRelations: entering", null);
        }
        this.isActive();
        ArrayList arrayList = null;
        ArrayList arrayList2 = this.myUnregNtfList;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.myUnregNtfList.clone();
            this.myUnregNtfList = new ArrayList();
        }
        ArrayList<ObjectName> arrayList3 = new ArrayList<ObjectName>();
        HashMap<ObjectName, HashMap> hashMap2 = new HashMap<ObjectName, HashMap>();
        HashMap hashMap3 = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (hashMap3) {
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                mBeanServerNotification = (MBeanServerNotification)iterator.next();
                objectName = mBeanServerNotification.getMBeanName();
                arrayList3.add(objectName);
                hashMap = (HashMap)this.myRefedMBeanObjName2RelIdsMap.get(objectName);
                hashMap2.put(objectName, hashMap);
                this.myRefedMBeanObjName2RelIdsMap.remove(objectName);
            }
        }
        this.updateUnregistrationListener(null, arrayList3);
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            mBeanServerNotification = (MBeanServerNotification)iterator.next();
            objectName = mBeanServerNotification.getMBeanName();
            hashMap = (HashMap)hashMap2.get(objectName);
            Set set = hashMap.keySet();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                ArrayList arrayList4 = (ArrayList)hashMap.get(string);
                try {
                    this.handleReferenceUnregistration(string, objectName, arrayList4);
                }
                catch (RelationNotFoundException relationNotFoundException) {
                    throw new RuntimeException(relationNotFoundException.getMessage());
                }
                catch (RoleNotFoundException roleNotFoundException) {
                    throw new RuntimeException(roleNotFoundException.getMessage());
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("purgeRelations: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map findReferencingRelations(ObjectName objectName, String string, String string2) throws IllegalArgumentException {
        Object object;
        if (objectName == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = new String("theMBeanName " + objectName.toString() + ", theRelTypeName " + string + ", theRoleName " + string2);
            this.trace("findReferencingRelations: entering", (String)object);
        }
        object = new HashMap();
        HashMap hashMap = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (hashMap) {
            HashMap hashMap2 = (HashMap)this.myRefedMBeanObjName2RelIdsMap.get(objectName);
            if (hashMap2 != null) {
                Cloneable cloneable;
                Object object2;
                String string4;
                Iterator<Object> iterator;
                Set set = hashMap2.keySet();
                ArrayList<Object> arrayList = null;
                if (string == null) {
                    arrayList = new ArrayList(set);
                } else {
                    arrayList = new ArrayList();
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        string4 = (String)iterator.next();
                        object2 = null;
                        cloneable = this.myRelId2RelTypeMap;
                        synchronized (cloneable) {
                            object2 = (String)this.myRelId2RelTypeMap.get(string4);
                        }
                        if (!((String)object2).equals(string)) continue;
                        arrayList.add(string4);
                    }
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string4 = (String)iterator.next();
                    object2 = (ArrayList)hashMap2.get(string4);
                    if (string2 == null) {
                        ((HashMap)object).put(string4, (ArrayList)((ArrayList)object2).clone());
                        continue;
                    }
                    if (!((ArrayList)object2).contains(string2)) continue;
                    cloneable = new ArrayList();
                    ((ArrayList)cloneable).add(string2);
                    ((HashMap)object).put(string4, cloneable);
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("findReferencingRelations: exiting", null);
        }
        return object;
    }

    public Map findAssociatedMBeans(ObjectName objectName, String string, String string2) throws IllegalArgumentException {
        Object object;
        if (objectName == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = new String("theMBeanName " + objectName.toString() + ", theRelTypeName " + string + ", theRoleName " + string2);
            this.trace("findAssociatedMBeans: entering", (String)object);
        }
        object = (HashMap)this.findReferencingRelations(objectName, string, string2);
        HashMap<ObjectName, ArrayList<String>> hashMap = new HashMap<ObjectName, ArrayList<String>>();
        Iterator iterator = ((HashMap)object).keySet().iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            HashMap hashMap2 = null;
            try {
                hashMap2 = (HashMap)this.getReferencedMBeans(string4);
            }
            catch (RelationNotFoundException relationNotFoundException) {
                throw new RuntimeException(relationNotFoundException.getMessage());
            }
            Iterator iterator2 = hashMap2.keySet().iterator();
            while (iterator2.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator2.next();
                if (objectName2.equals(objectName)) continue;
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(objectName2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList.add(string4);
                    hashMap.put(objectName2, arrayList);
                    continue;
                }
                arrayList.add(string4);
            }
        }
        if (this.isTraceOn()) {
            this.trace("findReferencingRelations: exiting", null);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findRelationsOfType(String string) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("findRelationsOfType: entering", string);
        }
        RelationType relationType = this.getRelationType(string);
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = this.myRelType2RelIdsMap;
        synchronized (hashMap) {
            ArrayList arrayList2 = (ArrayList)this.myRelType2RelIdsMap.get(string);
            if (arrayList2 != null) {
                arrayList = (ArrayList)arrayList2.clone();
            }
        }
        if (this.isTraceOn()) {
            this.trace("findRelationsOfType: exiting", null);
        }
        return arrayList;
    }

    public List getRole(String string, String string2) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        Object object;
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = "theRelId " + string + ", theRoleName " + string2;
            this.trace("getRole: entering", (String)object);
        }
        this.isActive();
        object = this.getRelation(string);
        ArrayList arrayList = null;
        if (object instanceof RelationSupport) {
            arrayList = (ArrayList)((RelationSupport)object).getRoleInt(string2, true, this, false);
        } else {
            Object[] objectArray = new Object[]{string2};
            String[] stringArray = new String[]{"java.lang.String"};
            try {
                arrayList = (ArrayList)this.myMBeanServer.invoke((ObjectName)object, "getRole", objectArray, stringArray);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                if (exception instanceof RoleNotFoundException) {
                    throw (RoleNotFoundException)exception;
                }
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRole: exiting", null);
        }
        return arrayList;
    }

    public RoleResult getRoles(String string, String[] stringArray) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        if (string == null || stringArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getRoles: entering", string);
        }
        this.isActive();
        Object object = this.getRelation(string);
        RoleResult roleResult = null;
        if (object instanceof RelationSupport) {
            roleResult = ((RelationSupport)object).getRolesInt(stringArray, true, this);
        } else {
            Object[] objectArray = new Object[]{stringArray};
            String[] stringArray2 = new String[1];
            try {
                stringArray2[0] = stringArray.getClass().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                roleResult = (RoleResult)this.myMBeanServer.invoke((ObjectName)object, "getRoles", objectArray, stringArray2);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                throw new RuntimeException(mBeanException.getTargetException().getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRoles: exiting", null);
        }
        return roleResult;
    }

    public RoleResult getAllRoles(String string) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getAllRoles: entering", string);
        }
        Object object = this.getRelation(string);
        RoleResult roleResult = null;
        if (object instanceof RelationSupport) {
            roleResult = ((RelationSupport)object).getAllRolesInt(true, this);
        } else {
            Object[] objectArray = new Object[]{};
            String[] stringArray = new String[]{};
            try {
                roleResult = (RoleResult)this.myMBeanServer.invoke((ObjectName)object, "getAllRoles", objectArray, stringArray);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getAllRoles: exiting", null);
        }
        return roleResult;
    }

    public Integer getRoleCardinality(String string, String string2) throws IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        Object object;
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            object = "theRelId " + string + ", theRoleName " + string2;
            this.trace("getRoleCardinality: entering", (String)object);
        }
        object = this.getRelation(string);
        Integer n = null;
        if (object instanceof RelationSupport) {
            n = ((RelationSupport)object).getRoleCardinality(string2);
        } else {
            Object[] objectArray = new Object[]{string2};
            String[] stringArray = new String[]{"java.lang.String"};
            try {
                n = (Integer)this.myMBeanServer.invoke((ObjectName)object, "getRoleCardinality", objectArray, stringArray);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                if (exception instanceof RoleNotFoundException) {
                    throw (RoleNotFoundException)exception;
                }
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRoleCardinality: exiting", null);
        }
        return n;
    }

    public void setRole(String string, Role role) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        Object object;
        if (string == null || role == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            object = new String("theRelId " + string + ", theRole " + role.toString());
            this.trace("setRole: entering", (String)object);
        }
        this.isActive();
        object = this.getRelation(string);
        if (object instanceof RelationSupport) {
            try {
                ((RelationSupport)object).setRoleInt(role, true, this, false);
            }
            catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                throw new RuntimeException(relationTypeNotFoundException.getMessage());
            }
        }
        Object[] objectArray = new Object[]{role};
        String[] stringArray = new String[]{"javax.management.relation.Role"};
        try {
            this.myMBeanServer.invoke((ObjectName)object, "setRole", objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RuntimeException(instanceNotFoundException.getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof RoleNotFoundException) {
                throw (RoleNotFoundException)exception;
            }
            if (exception instanceof InvalidRoleValueException) {
                throw (InvalidRoleValueException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
        if (this.isTraceOn()) {
            this.trace("setRole: exiting", null);
        }
    }

    public RoleResult setRoles(String string, RoleList roleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        Object object;
        if (string == null || roleList == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            object = new String("theRelId " + string + ", theRoleList " + roleList.toString());
            this.trace("setRoles: entering", (String)object);
        }
        this.isActive();
        object = this.getRelation(string);
        RoleResult roleResult = null;
        if (object instanceof RelationSupport) {
            try {
                roleResult = ((RelationSupport)object).setRolesInt(roleList, true, this);
            }
            catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                throw new RuntimeException(relationTypeNotFoundException.getMessage());
            }
        }
        Object[] objectArray = new Object[]{roleList};
        String[] stringArray = new String[]{"javax.management.relation.RoleList"};
        try {
            roleResult = (RoleResult)this.myMBeanServer.invoke((ObjectName)object, "setRoles", objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RuntimeException(instanceNotFoundException.getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        if (this.isTraceOn()) {
            this.trace("setRoles: exiting", null);
        }
        return roleResult;
    }

    public Map getReferencedMBeans(String string) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getReferencedMBeans: entering", string);
        }
        Object object = this.getRelation(string);
        HashMap hashMap = null;
        if (object instanceof RelationSupport) {
            hashMap = (HashMap)((RelationSupport)object).getReferencedMBeans();
        } else {
            Object[] objectArray = new Object[]{};
            String[] stringArray = new String[]{};
            try {
                hashMap = (HashMap)this.myMBeanServer.invoke((ObjectName)object, "getReferencedMBeans", objectArray, stringArray);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getReferencedMBeans: exiting", null);
        }
        return hashMap;
    }

    public String getRelationTypeName(String string) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getRelationTypeName: entering", string);
        }
        Object object = this.getRelation(string);
        String string3 = null;
        if (object instanceof RelationSupport) {
            string3 = ((RelationSupport)object).getRelationTypeName();
        } else {
            Object[] objectArray = new Object[]{};
            String[] stringArray = new String[]{};
            try {
                string3 = (String)this.myMBeanServer.invoke((ObjectName)object, "getRelationTypeName", objectArray, stringArray);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRelationTypeName: exiting", null);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object object) {
        String string;
        if (notification == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("handleNotification: entering", notification.toString());
        }
        if (notification instanceof MBeanServerNotification && (string = notification.getType()).equals("JMX.mbean.unregistered")) {
            Object object2;
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            boolean bl = false;
            HashMap hashMap = this.myRefedMBeanObjName2RelIdsMap;
            synchronized (hashMap) {
                if (this.myRefedMBeanObjName2RelIdsMap.containsKey(objectName)) {
                    object2 = this.myUnregNtfList;
                    synchronized (object2) {
                        this.myUnregNtfList.add(notification);
                    }
                    bl = true;
                }
                if (bl && this.myPurgeFlg) {
                    try {
                        this.purgeRelations();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.getMessage());
                    }
                }
            }
            object2 = null;
            HashMap hashMap2 = this.myRelMBeanObjName2RelIdMap;
            synchronized (hashMap2) {
                object2 = (String)this.myRelMBeanObjName2RelIdMap.get(objectName);
            }
            if (object2 != null) {
                try {
                    this.removeRelation((String)object2);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("handleNotification: exiting", null);
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.isTraceOn()) {
            this.trace("getNotificationInfo: entering", null);
        }
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        String[] stringArray = new String[]{"jmx.relation.creation.basic", "jmx.relation.creation.mbean", "jmx.relation.update.basic", "jmx.relation.update.mbean", "jmx.relation.removal.basic", "jmx.relation.removal.mbean"};
        String string = "Sent when a relation is created, updated or deleted.";
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(stringArray, "RelationNotification", string);
        if (this.isTraceOn()) {
            this.trace("getNotificationInfo: exiting", null);
        }
        return mBeanNotificationInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelationTypeInt(RelationType relationType) throws IllegalArgumentException, InvalidRelationTypeException {
        Serializable serializable;
        if (relationType == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isDebugOn()) {
            this.debug("addRelationTypeInt: entering", null);
        }
        String string = relationType.getRelationTypeName();
        try {
            serializable = this.getRelationType(string);
            if (serializable != null) {
                String string2 = "There is already a relation type in the Relation Service with name ";
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.append(string);
                throw new InvalidRelationTypeException(stringBuffer.toString());
            }
        }
        catch (RelationTypeNotFoundException relationTypeNotFoundException) {
            // empty catch block
        }
        serializable = this.myRelType2ObjMap;
        synchronized (serializable) {
            this.myRelType2ObjMap.put(string, relationType);
        }
        if (relationType instanceof RelationTypeSupport) {
            ((RelationTypeSupport)relationType).setRelationServiceFlag(true);
        }
        if (this.isDebugOn()) {
            this.debug("addRelationTypeInt: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelationType getRelationType(String string) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isDebugOn()) {
            this.debug("getRelationType: entering", string);
        }
        RelationType relationType = null;
        HashMap hashMap = this.myRelType2ObjMap;
        synchronized (hashMap) {
            relationType = (RelationType)this.myRelType2ObjMap.get(string);
        }
        if (relationType == null) {
            String string3 = "No relation type created in the Relation Service with the name ";
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append(string);
            throw new RelationTypeNotFoundException(stringBuffer.toString());
        }
        if (this.isDebugOn()) {
            this.debug("getRelationType: exiting", null);
        }
        return relationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getRelation(String string) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isDebugOn()) {
            this.debug("getRelation: entering", string);
        }
        Object var2_3 = null;
        HashMap hashMap = this.myRelId2ObjMap;
        synchronized (hashMap) {
            var2_3 = this.myRelId2ObjMap.get(string);
        }
        if (var2_3 == null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "No relation associated to relation id ";
            stringBuffer.append(string3);
            stringBuffer.append(string);
            throw new RelationNotFoundException(stringBuffer.toString());
        }
        if (this.isDebugOn()) {
            this.debug("getRelation: exiting", null);
        }
        return var2_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addNewMBeanReference(ObjectName objectName, String string, String string2) throws IllegalArgumentException {
        if (objectName == null || string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isDebugOn()) {
            String string4 = new String("theObjName " + objectName.toString() + ", theRelId " + string + ", theRoleName " + string2);
            this.debug("addNewMBeanReference: entering", string4);
        }
        boolean bl = false;
        HashMap hashMap = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (hashMap) {
            HashMap<String, ArrayList<String>> hashMap2 = (HashMap<String, ArrayList<String>>)this.myRefedMBeanObjName2RelIdsMap.get(objectName);
            if (hashMap2 == null) {
                bl = true;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                hashMap2 = new HashMap<String, ArrayList<String>>();
                hashMap2.put(string, arrayList);
                this.myRefedMBeanObjName2RelIdsMap.put(objectName, hashMap2);
            } else {
                ArrayList<String> arrayList = (ArrayList<String>)hashMap2.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList.add(string2);
                    hashMap2.put(string, arrayList);
                } else {
                    arrayList.add(string2);
                }
            }
        }
        if (this.isDebugOn()) {
            this.debug("addNewMBeanReference: exiting", null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMBeanReference(ObjectName objectName, String string, String string2, boolean bl) throws IllegalArgumentException {
        if (objectName == null || string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isDebugOn()) {
            String string4 = new String("theObjName " + objectName.toString() + ", theRelId " + string + ", theRoleName " + string2 + ", theAllRolesFlg " + bl);
            this.debug("removeMBeanReference: entering", string4);
        }
        boolean bl2 = false;
        HashMap hashMap = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (hashMap) {
            int n;
            HashMap hashMap2;
            block11: {
                hashMap2 = (HashMap)this.myRefedMBeanObjName2RelIdsMap.get(objectName);
                if (hashMap2 != null) break block11;
                if (this.isDebugOn()) {
                    this.debug("removeMBeanReference: exiting", null);
                }
                boolean bl3 = true;
                return bl3;
            }
            ArrayList arrayList = new ArrayList();
            if (!bl && (n = (arrayList = (ArrayList)hashMap2.get(string)).indexOf(string2)) != -1) {
                arrayList.remove(n);
            }
            if (arrayList.isEmpty() || bl) {
                hashMap2.remove(string);
            }
            if (hashMap2.isEmpty()) {
                this.myRefedMBeanObjName2RelIdsMap.remove(objectName);
                bl2 = true;
            }
        }
        if (this.isDebugOn()) {
            this.debug("removeMBeanReference: exiting", null);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnregistrationListener(List list, List list2) throws RelationServiceNotRegisteredException {
        if (list != null && list2 != null && list.isEmpty() && list2.isEmpty()) {
            return;
        }
        if (this.isDebugOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (list != null) {
                stringBuffer.append("theNewRefList " + list.toString());
            }
            if (list2 != null) {
                stringBuffer.append(", theObsRefList" + list2.toString());
            }
            this.debug("updateUnregistrationListener: entering", stringBuffer.toString());
        }
        this.isActive();
        if (list != null || list2 != null) {
            boolean bl = false;
            if (this.myUnregNtfFilter == null) {
                this.myUnregNtfFilter = new MBeanServerNotificationFilter();
                bl = true;
            }
            MBeanServerNotificationFilter mBeanServerNotificationFilter = this.myUnregNtfFilter;
            synchronized (mBeanServerNotificationFilter) {
                ObjectName objectName;
                Object object;
                if (list != null) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        objectName = (ObjectName)object.next();
                        this.myUnregNtfFilter.enableObjectName(objectName);
                    }
                }
                if (list2 != null) {
                    object = list2.iterator();
                    while (object.hasNext()) {
                        objectName = (ObjectName)object.next();
                        this.myUnregNtfFilter.disableObjectName(objectName);
                    }
                }
                object = null;
                try {
                    object = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    // empty catch block
                }
                if (bl) {
                    try {
                        this.myMBeanServer.addNotificationListener((ObjectName)object, this, (NotificationFilter)this.myUnregNtfFilter, null);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        throw new RelationServiceNotRegisteredException(instanceNotFoundException.getMessage());
                    }
                }
            }
        }
        if (this.isDebugOn()) {
            this.debug("updateUnregistrationListener: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelationInt(boolean bl, RelationSupport relationSupport, ObjectName objectName, String string, String string2, RoleList roleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        Object object;
        Object object2;
        Object object3;
        if (string == null || string2 == null || bl && (relationSupport == null || objectName != null) || !bl && (objectName == null || relationSupport != null)) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isDebugOn()) {
            object3 = new StringBuffer("theRelBaseFlg " + bl + ", theRelId " + string + ", theRelTypeName " + string2);
            if (objectName != null) {
                ((StringBuffer)object3).append(",  theRelObjName " + objectName.toString());
            }
            if (roleList != null) {
                ((StringBuffer)object3).append(", theRoleList " + roleList.toString());
            }
            this.debug("addRelationInt: entering", ((StringBuffer)object3).toString());
        }
        this.isActive();
        try {
            object3 = this.getRelation(string);
            if (object3 != null) {
                String string4 = "There is already a relation with id ";
                StringBuffer stringBuffer = new StringBuffer(string4);
                stringBuffer.append(string);
                throw new InvalidRelationIdException(stringBuffer.toString());
            }
        }
        catch (RelationNotFoundException relationNotFoundException) {
            // empty catch block
        }
        object3 = this.getRelationType(string2);
        ArrayList arrayList = (ArrayList)((ArrayList)object3.getRoleInfos()).clone();
        if (roleList != null) {
            object2 = roleList.iterator();
            while (object2.hasNext()) {
                Role role = (Role)object2.next();
                String string5 = role.getRoleName();
                ArrayList arrayList2 = (ArrayList)role.getRoleValue();
                RoleInfo roleInfo = null;
                try {
                    roleInfo = object3.getRoleInfo(string5);
                }
                catch (RoleInfoNotFoundException roleInfoNotFoundException) {
                    throw new RoleNotFoundException(roleInfoNotFoundException.getMessage());
                }
                Integer n = this.checkRoleInt(2, string5, arrayList2, roleInfo, false);
                int n2 = n;
                if (n2 != 0) {
                    RelationService.throwRoleProblemException(n2, string5);
                }
                int n3 = arrayList.indexOf(roleInfo);
                arrayList.remove(n3);
            }
        }
        this.initialiseMissingRoles(bl, relationSupport, objectName, string, string2, arrayList);
        object2 = this.myRelId2ObjMap;
        synchronized (object2) {
            if (bl) {
                this.myRelId2ObjMap.put(string, relationSupport);
            } else {
                this.myRelId2ObjMap.put(string, objectName);
            }
        }
        HashMap hashMap = this.myRelId2RelTypeMap;
        synchronized (hashMap) {
            this.myRelId2RelTypeMap.put(string, string2);
        }
        HashMap hashMap2 = this.myRelType2RelIdsMap;
        synchronized (hashMap2) {
            object = (ArrayList<String>)this.myRelType2RelIdsMap.get(string2);
            boolean bl2 = false;
            if (object == null) {
                bl2 = true;
                object = new ArrayList<String>();
            }
            ((ArrayList)object).add(string);
            if (bl2) {
                this.myRelType2RelIdsMap.put(string2, object);
            }
        }
        object = roleList.iterator();
        while (object.hasNext()) {
            Role role = (Role)object.next();
            ArrayList arrayList3 = new ArrayList();
            try {
                this.updateRoleMap(string, role, arrayList3);
            }
            catch (RelationNotFoundException relationNotFoundException) {
                // empty catch block
            }
        }
        try {
            this.sendRelationCreationNotification(string);
        }
        catch (RelationNotFoundException relationNotFoundException) {
            // empty catch block
        }
        if (this.isDebugOn()) {
            this.debug("addRelationInt: exiting", null);
        }
    }

    private Integer checkRoleInt(int n, String string, List list, RoleInfo roleInfo, boolean bl) throws IllegalArgumentException {
        int n2;
        CharSequence charSequence;
        if (string == null || roleInfo == null || n == 2 && list == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isDebugOn()) {
            charSequence = new StringBuffer("theChkType " + n + ", theRoleName " + string + ", theRoleInfo " + roleInfo.toString() + ", theWriteChkFlg " + bl);
            if (list != null) {
                ((StringBuffer)charSequence).append(", theRoleValue " + list.toString());
            }
            this.debug("checkRoleInt: entering", ((StringBuffer)charSequence).toString());
        }
        if (!string.equals(charSequence = roleInfo.getName())) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(1);
        }
        if (n == 1) {
            boolean bl2 = roleInfo.isReadable();
            if (!bl2) {
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(2);
            }
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(0);
        }
        if (bl && (n2 = roleInfo.isWritable()) == 0) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(3);
        }
        n2 = list.size();
        boolean bl3 = roleInfo.checkMinDegree(n2);
        if (!bl3) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(4);
        }
        boolean bl4 = roleInfo.checkMaxDegree(n2);
        if (!bl4) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(5);
        }
        String string3 = roleInfo.getRefMBeanClassName();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            if (objectName == null) {
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(7);
            }
            boolean bl5 = this.myMBeanServer.isRegistered(objectName);
            if (!bl5) {
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(7);
            }
            try {
                boolean bl6 = this.myMBeanServer.isInstanceOf(objectName, string3);
                if (bl6) continue;
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(6);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                return null;
            }
        }
        if (this.isDebugOn()) {
            this.debug("checkRoleInt: exiting", null);
        }
        return new Integer(0);
    }

    private void initialiseMissingRoles(boolean bl, RelationSupport relationSupport, ObjectName objectName, String string, String string2, List list) throws IllegalArgumentException, RelationServiceNotRegisteredException, InvalidRoleValueException {
        Object object;
        if (bl && (relationSupport == null || objectName != null) || !bl && (objectName == null || relationSupport != null) || string == null || string2 == null || list == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isDebugOn()) {
            object = new StringBuffer("theRelBaseFlg " + bl + ", theRelId " + string + ", theRelTypeName " + string2 + ", theRoleInfoList " + list);
            if (objectName != null) {
                ((StringBuffer)object).append(objectName.toString());
            }
            this.debug("initialiseMissingRoles: entering", ((StringBuffer)object).toString());
        }
        this.isActive();
        object = list.iterator();
        while (object.hasNext()) {
            RoleInfo roleInfo = (RoleInfo)object.next();
            String string4 = roleInfo.getName();
            ArrayList arrayList = new ArrayList();
            Role role = new Role(string4, arrayList);
            if (bl) {
                try {
                    relationSupport.setRoleInt(role, true, this, false);
                    continue;
                }
                catch (RoleNotFoundException roleNotFoundException) {
                    throw new RuntimeException(roleNotFoundException.getMessage());
                }
                catch (RelationNotFoundException relationNotFoundException) {
                    throw new RuntimeException(relationNotFoundException.getMessage());
                }
                catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                    throw new RuntimeException(relationTypeNotFoundException.getMessage());
                }
            }
            Object[] objectArray = new Object[]{role};
            String[] stringArray = new String[]{"javax.management.relation.Role"};
            try {
                this.myMBeanServer.invoke(objectName, "setRole", objectArray, stringArray);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                if (exception instanceof InvalidRoleValueException) {
                    throw (InvalidRoleValueException)exception;
                }
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (this.isDebugOn()) {
            this.debug("initializeMissingRoles: exiting", null);
        }
    }

    static void throwRoleProblemException(int n, String string) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        int n2 = 0;
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = " does not exist in relation.";
                n2 = 1;
                break;
            }
            case 2: {
                string3 = " is not readable.";
                n2 = 1;
                break;
            }
            case 3: {
                string3 = " is not writable.";
                n2 = 1;
                break;
            }
            case 4: {
                string3 = " has a number of MBean references less than the expected minimum degree.";
                n2 = 2;
                break;
            }
            case 5: {
                string3 = " has a number of MBean references greater than the expected maximum degree.";
                n2 = 2;
                break;
            }
            case 6: {
                string3 = " has an MBean reference to an MBean not of the expected class of references for that role.";
                n2 = 2;
                break;
            }
            case 7: {
                string3 = " has a reference to null or to an MBean not registered.";
                n2 = 2;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(string3);
        String string4 = stringBuffer.toString();
        if (n2 == 1) {
            throw new RoleNotFoundException(string4);
        }
        if (n2 == 2) {
            throw new InvalidRoleValueException(string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotificationInt(int n, String string, String string2, List list, String string3, List list2, List list3) throws IllegalArgumentException, RelationNotFoundException {
        CharSequence charSequence;
        if (string == null || string2 == null || n != 3 && list != null || n == 2 && (string3 == null || list2 == null || list3 == null)) {
            String string4 = "Invalid parameter.";
            throw new IllegalArgumentException(string4);
        }
        if (this.isDebugOn()) {
            charSequence = new StringBuffer("theIntNtfType " + n + ", theMsg " + string + ", theRelId " + string2);
            if (list != null) {
                ((StringBuffer)charSequence).append(", theUnregMBeanList " + list.toString());
            }
            if (string3 != null) {
                ((StringBuffer)charSequence).append(", theRoleName " + string3);
            }
            if (list2 != null) {
                ((StringBuffer)charSequence).append(", theRoleNewValue " + list2.toString());
            }
            if (list3 != null) {
                ((StringBuffer)charSequence).append(", theOldRoleValue " + list3.toString());
            }
            this.debug("sendNotificationInt: entering", ((StringBuffer)charSequence).toString());
        }
        charSequence = null;
        HashMap hashMap = this.myRelId2RelTypeMap;
        synchronized (hashMap) {
            charSequence = (String)this.myRelId2RelTypeMap.get(string2);
        }
        ObjectName objectName = this.isRelationMBean(string2);
        String string5 = null;
        if (objectName != null) {
            switch (n) {
                case 1: {
                    string5 = "jmx.relation.creation.mbean";
                    break;
                }
                case 2: {
                    string5 = "jmx.relation.update.mbean";
                    break;
                }
                case 3: {
                    string5 = "jmx.relation.removal.mbean";
                }
            }
        } else {
            switch (n) {
                case 1: {
                    string5 = "jmx.relation.creation.basic";
                    break;
                }
                case 2: {
                    string5 = "jmx.relation.update.basic";
                    break;
                }
                case 3: {
                    string5 = "jmx.relation.removal.basic";
                }
            }
        }
        Long l = this.getNotificationSequenceNumber();
        Date date = new Date();
        long l2 = date.getTime();
        RelationNotification relationNotification = null;
        if (string5.equals("jmx.relation.creation.basic") || string5.equals("jmx.relation.creation.mbean") || string5.equals("jmx.relation.removal.basic") || string5.equals("jmx.relation.removal.mbean")) {
            relationNotification = new RelationNotification(string5, this, l, l2, string, string2, (String)charSequence, objectName, list);
        } else if (string5.equals("jmx.relation.update.basic") || string5.equals("jmx.relation.update.mbean")) {
            relationNotification = new RelationNotification(string5, this, l, l2, string, string2, (String)charSequence, objectName, string3, list2, list3);
        }
        this.sendNotification(relationNotification);
        if (this.isDebugOn()) {
            this.debug("sendNotificationInt: exiting", null);
        }
    }

    private void handleReferenceUnregistration(String string, ObjectName objectName, List list) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException, RoleNotFoundException {
        String[] stringArray;
        Object object;
        String string2;
        if (string == null || list == null || objectName == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isDebugOn()) {
            string2 = new String("theRelId " + string + ", theRoleNameList " + list.toString() + "theObjName " + objectName.toString());
            this.debug("handleReferenceUnregistration: entering", string2);
        }
        this.isActive();
        string2 = this.getRelationTypeName(string);
        Object object2 = this.getRelation(string);
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (bl) break;
            object = (String)iterator.next();
            int n = this.getRoleCardinality(string, (String)object);
            int n2 = n - 1;
            stringArray = null;
            try {
                stringArray = this.getRoleInfo(string2, (String)object);
            }
            catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                throw new RuntimeException(relationTypeNotFoundException.getMessage());
            }
            catch (RoleInfoNotFoundException roleInfoNotFoundException) {
                throw new RuntimeException(roleInfoNotFoundException.getMessage());
            }
            boolean bl2 = stringArray.checkMinDegree(n2);
            if (bl2) continue;
            bl = true;
        }
        if (bl) {
            this.removeRelation(string);
        } else {
            object = list.iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                if (object2 instanceof RelationSupport) {
                    try {
                        ((RelationSupport)object2).handleMBeanUnregistrationInt(objectName, string4, true, this);
                        continue;
                    }
                    catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                        throw new RuntimeException(relationTypeNotFoundException.getMessage());
                    }
                    catch (InvalidRoleValueException invalidRoleValueException) {
                        throw new RuntimeException(invalidRoleValueException.getMessage());
                    }
                }
                Object[] objectArray = new Object[]{objectName, string4};
                stringArray = new String[]{"javax.management.ObjectName", "java.lang.String"};
                try {
                    this.myMBeanServer.invoke((ObjectName)object2, "handleMBeanUnregistration", objectArray, stringArray);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    throw new RuntimeException(instanceNotFoundException.getMessage());
                }
                catch (ReflectionException reflectionException) {
                    throw new RuntimeException(reflectionException.getMessage());
                }
                catch (MBeanException mBeanException) {
                    Exception exception = mBeanException.getTargetException();
                    throw new RuntimeException(exception.getMessage());
                }
            }
        }
        if (this.isDebugOn()) {
            this.debug("handleReferenceUnregistration: exiting", null);
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)16384);
    }

    private void trace(String string, String string2) {
        Trace.send((int)1, (int)16384, (String)localClassName, (String)string, (String)string2);
        Trace.send((int)1, (int)16384, (String)"", (String)"", (String)"\n");
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)16384);
    }

    private void debug(String string, String string2) {
        Trace.send((int)2, (int)16384, (String)localClassName, (String)string, (String)string2);
        Trace.send((int)2, (int)16384, (String)"", (String)"", (String)"\n");
    }
}

